/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.AppEventInvoker;
import coldfusion.runtime.ApplicationEventListener;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.EventHandlerException;
import coldfusion.runtime.EventListeners;
import coldfusion.server.RuntimeService;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import coldfusion.tagext.validation.UnnamedApplicationException;
import coldfusion.vfs.VFSFileSystemOptionFactory;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class ApplicationScopeTracker {
    private static ConcurrentHashMap<String, ApplicationScope> mApplications;
    private static AppCleanUpAgent mAppCleanUpAgent;
    private static SchedulerService mScheduler;
    private static int mSweepInterVal;

    public static ApplicationScope getApplicationScope(String AppName) {
        ApplicationScope App = mApplications.get(AppName);
        if (App != null) {
            App.setIsNew(false);
        }
        return App;
    }

    public static ApplicationScope createApplication(String AppName) {
        RuntimeService runtimeSvc;
        if ((AppName == null || AppName.trim().equals("")) && (runtimeSvc = ServiceFactory.getRuntimeService()).isDisableUnnamedApplication()) {
            throw new UnnamedApplicationException();
        }
        ApplicationScope App = new ApplicationScope(AppName);
        App.setIsNew(true);
        mApplications.put(AppName, App);
        return App;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUp() {
        try {
            Object[] keys = ((ConcurrentHashMap.CollectionView)((Object)mApplications.keySet())).toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)keys[i];
                try {
                    ApplicationScope app = mApplications.get(key);
                    if (app == null || !app.expired()) continue;
                    ConcurrentHashMap<String, ApplicationScope> concurrentHashMap = mApplications;
                    synchronized (concurrentHashMap) {
                        if (app.expired()) {
                            ApplicationScopeTracker.cleanUp(app);
                        }
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            mScheduler.schedule(mAppCleanUpAgent, System.currentTimeMillis() + (long)mSweepInterVal);
        }
    }

    private static void invokeOnApplicationEnd(ApplicationScope app) {
        AppEventInvoker invoker = app.getEventInvoker();
        if (invoker == null) {
            return;
        }
        try {
            try {
                invoker.onApplicationEnd(new Object[]{app});
            }
            catch (EventHandlerException ex) {
                invoker.onError(new Object[]{ex, ex.name});
            }
            catch (Throwable te) {
                invoker.onError(new Object[]{te});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void cleanUp(ApplicationScope appScope) {
        String appName = appScope.getName();
        ApplicationScopeTracker.fireBeforeApplicationStop(appScope);
        try {
            VFSFileSystemOptionFactory.cleanRAMFileSystem(appName, false);
            GenericCacheFactory.stopCacheManager(appName);
            appScope.cleanup();
        }
        finally {
            appScope = mApplications.remove(appName);
            ApplicationScopeTracker.fireOnApplicationEnd(appScope);
        }
    }

    public static void forceCleanUp() {
        Enumeration<String> e = mApplications.keys();
        while (e.hasMoreElements()) {
            String k = e.nextElement();
            ApplicationScope app = mApplications.get(k);
            ApplicationScopeTracker.cleanUp(app);
        }
    }

    public static Enumeration getApplicationKeys() {
        return mApplications.keys();
    }

    public static void stopApplication(String appName) {
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
        if (appScope == null) {
            return;
        }
        ApplicationScopeTracker.cleanUp(appScope);
    }

    private static void fireBeforeApplicationStop(ApplicationScope appScope) {
        List<ApplicationEventListener> listeners = EventListeners.getApplicationEventListeners();
        if (listeners == null) {
            return;
        }
        for (ApplicationEventListener listener : listeners) {
            try {
                listener.beforeApplicationStop(appScope);
            }
            catch (Throwable throwable) {}
        }
        ApplicationScopeTracker.invokeOnApplicationEnd(appScope);
    }

    private static void fireOnApplicationEnd(ApplicationScope appScope) {
        List<ApplicationEventListener> listeners = EventListeners.getApplicationEventListeners();
        if (listeners == null) {
            return;
        }
        for (ApplicationEventListener listener : listeners) {
            try {
                listener.onApplicationStop(appScope);
            }
            catch (Throwable throwable) {}
        }
    }

    static {
        mSweepInterVal = 60000;
        mApplications = new ConcurrentHashMap();
        mAppCleanUpAgent = new AppCleanUpAgent();
        try {
            mScheduler = ServiceFactory.getSchedulerService();
            mScheduler.schedule(mAppCleanUpAgent, System.currentTimeMillis() + (long)mSweepInterVal);
            mScheduler.scheduleForShutDown(new AppCleanUpAgent(true));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static final class AppCleanUpAgent
    implements Runnable {
        private boolean mVMShutDown = false;

        public AppCleanUpAgent() {
        }

        public AppCleanUpAgent(boolean vmdown) {
            this.mVMShutDown = vmdown;
        }

        @Override
        public void run() {
            if (this.mVMShutDown) {
                ApplicationScopeTracker.forceCleanUp();
            } else {
                ApplicationScopeTracker.cleanUp();
            }
        }
    }

    public static class ApplicationNotFoundException
    extends ApplicationException {
        public String appName;

        public ApplicationNotFoundException(String appName) {
            this.appName = appName;
        }
    }
}

