/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.provider.SerializerProxyWrapper;
import coldfusion.runtime.util.SerializationUtil;
import coldfusion.sql.imq.imqTable;
import coldfusion.util.LruCache;
import coldfusion.util.RB;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AvroUtils {
    private static final Logger logger = CFLogs.SERVER_LOG;
    public static final String AVRO = "AVRO";
    public static final String SCHEMA_KEY = "SCHEMA";
    private static final boolean serializerTrustedCache = Boolean.parseBoolean(System.getProperty("coldfusion.serializer.trustedCache.enable", "false"));
    private static final int trustedCacheSize = Integer.parseInt(System.getProperty("coldfusion.serializer.trustedCache.size", "100"));
    private static final LruCache cache = new LruCache(trustedCacheSize){

        @Override
        protected Object fetch(Object key) {
            return AvroUtils.getSchema((String)key);
        }

        @Override
        public Object get(Object key) {
            AvroSchema schema = (AvroSchema)super.get(key);
            if (serializerTrustedCache) {
                return schema;
            }
            File schemaFile = SerializationUtil.getFile((String)key);
            if (schemaFile.exists() && schemaFile.lastModified() > schema.getGeneratedTime()) {
                super.remove(key);
                return super.get(key);
            }
            return schema;
        }
    };

    public static Object serialize(Object data, String writerSchema, String queryFormat, boolean useCustomSerialization) {
        if (writerSchema == null) {
            throw new AvroSerializeException(RB.getString(AvroUtils.class, "AVRO.NULL_SCHEMA"));
        }
        if (data instanceof List) {
            return ((List)data).stream().map(d -> AvroUtils.serializeObject(d, writerSchema, queryFormat, useCustomSerialization)).collect(Collectors.toList());
        }
        return AvroUtils.serializeObject(data, writerSchema, queryFormat, useCustomSerialization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object serializeObject(Object data, String writerSchema, String queryFormat, boolean useCustomSerialization) {
        SerializerProxyWrapper serializerProxy;
        if (useCustomSerialization && null != (serializerProxy = JSONUtils.getSerializerProxy())) {
            FusionContext context = FusionContext.getCurrent();
            Object oldData = context.getCurrentSerializedData();
            try {
                if ((oldData == null || !oldData.equals(data)) && serializerProxy.canSerialize(AVRO)) {
                    context.setCurrentSerializedData(data);
                    HashMap<String, String> additionalArgs = new HashMap<String, String>(1);
                    additionalArgs.put(SCHEMA_KEY, writerSchema);
                    Object object = serializerProxy.serialize(data, AVRO, additionalArgs);
                    return object;
                }
            }
            catch (Throwable e) {
                logger.error(e);
            }
            finally {
                context.setCurrentSerializedData(oldData);
            }
        }
        try {
            String json;
            boolean fixCase = !(data instanceof String);
            Schema schema = ((AvroSchema)cache.get(writerSchema)).getSchema();
            String string = json = fixCase ? JSONUtils.serializeJSON(data, queryFormat, false, false) : (String)data;
            if (queryFormat == "struct" && data instanceof imqTable) {
                JSONArray array = new JSONArray(json);
                ArrayList<byte[]> l = new ArrayList<byte[]>();
                for (int i = 0; i < array.length(); ++i) {
                    l.add(AvroUtils.fixCaseAndConvertToByteArray(schema, array.get(i).toString(), fixCase));
                }
                return l;
            }
            return AvroUtils.fixCaseAndConvertToByteArray(schema, json, fixCase);
        }
        catch (AvroSerializeException ex) {
            throw ex;
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new AvroSerializeException(e, e.getCause().getMessage());
            }
            throw new AvroSerializeException(e, e.getMessage());
        }
    }

    private static AvroSchema getSchema(String schemaOrFile) {
        Schema schema;
        File schemaFile = SerializationUtil.getFile(schemaOrFile);
        try {
            schema = schemaFile.exists() ? new Schema.Parser().parse(schemaFile) : new Schema.Parser().parse(schemaOrFile);
        }
        catch (Exception e) {
            logger.error(e);
            throw new AvroSerializeException(RB.getString(AvroUtils.class, "AVRO.INVALID_SCHEMA"));
        }
        return new AvroSchema(schema, System.currentTimeMillis());
    }

    private static byte[] fixCaseAndConvertToByteArray(Schema schema, String json, boolean fixCase) throws IOException {
        try {
            if (fixCase) {
                json = AvroUtils.fixKeyCaseJSON(json, schema);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return AvroUtils.toByteArray(schema, json);
    }

    private static byte[] toByteArray(Schema schema, String json) throws IOException {
        GenericDatumReader reader = new GenericDatumReader(schema);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, json);
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)output, null);
        Object datum = reader.read(null, (Decoder)decoder);
        writer.write(datum, (Encoder)encoder);
        encoder.flush();
        return output.toByteArray();
    }

    private static String fixKeyCaseJSON(String json, Schema schema) throws JSONException {
        JSONObject jsonObject = new JSONObject(json);
        AvroUtils.updateKeys(jsonObject, schema);
        return jsonObject.toString();
    }

    private static void updateKeys(JSONObject jsonObject, Schema schema) throws JSONException {
        if (jsonObject == null || schema == null || schema.getType() != Schema.Type.RECORD) {
            return;
        }
        Iterator iterator = jsonObject.keys();
        ArrayList keys = new ArrayList();
        iterator.forEachRemaining(keys::add);
        Map<String, String> keyMap = schema.getFields().stream().collect(Collectors.toMap(field -> field.name().toLowerCase(), field -> field.name()));
        for (String key : keys) {
            String actualKey = keyMap.get(key.toLowerCase());
            if (actualKey != null && !key.equals(actualKey)) {
                jsonObject.put(actualKey, jsonObject.get(key));
                jsonObject.remove(key);
            }
            if (actualKey == null || !(jsonObject.get(actualKey) instanceof JSONObject)) continue;
            AvroUtils.updateKeys((JSONObject)jsonObject.get(actualKey), schema.getField(actualKey).schema());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(Object data, String readerSchema, boolean strictMapping, boolean useCustomSerialization) {
        SerializerProxyWrapper serializerProxy;
        if (readerSchema == null) {
            throw new AvroDeserializeException(RB.getString(AvroUtils.class, "AVRO.NULL_SCHEMA"));
        }
        if (data instanceof List) {
            return ((List)data).stream().map(d -> AvroUtils.deserialize(d, readerSchema, strictMapping, useCustomSerialization)).collect(Collectors.toList());
        }
        if (useCustomSerialization && null != (serializerProxy = JSONUtils.getSerializerProxy())) {
            FusionContext context = FusionContext.getCurrent();
            Object oldData = context.getCurrentSerializedData();
            try {
                if ((null == oldData || !oldData.equals(data)) && serializerProxy.canDeSerialize(AVRO)) {
                    context.setCurrentSerializedData(data);
                    HashMap<String, String> additionalArgs = new HashMap<String, String>(1);
                    additionalArgs.put(SCHEMA_KEY, readerSchema);
                    Object object = serializerProxy.deserialize(data, AVRO, "", additionalArgs);
                    return object;
                }
            }
            catch (Throwable e) {
                logger.error(e);
            }
            finally {
                context.setCurrentSerializedData(oldData);
            }
        }
        return AvroUtils.deserialize(data, readerSchema, strictMapping);
    }

    private static Object deserialize(Object data, String readerSchema, boolean strictMapping) {
        try {
            if (!(data instanceof byte[])) {
                throw new AvroDeserializeException(RB.getString(AvroUtils.class, "AVRO.INCORRECT_DATA_TYPE"));
            }
            return JSONUtils.deserializeJSON(AvroUtils.deserializeToJSON((byte[])data, readerSchema), strictMapping, false);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new AvroDeserializeException(e, e.getCause().getMessage());
            }
            throw new AvroDeserializeException(e, e.getMessage());
        }
    }

    public static String deserializeToJSON(byte[] data, String readerSchema) throws IOException {
        boolean pretty = false;
        Schema schema = ((AvroSchema)cache.get(readerSchema)).getSchema();
        GenericDatumReader reader = new GenericDatumReader(schema);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)output, pretty);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, null);
        Object datum = reader.read(null, (Decoder)decoder);
        writer.write(datum, (Encoder)encoder);
        encoder.flush();
        output.flush();
        return new String(output.toByteArray(), "UTF-8");
    }

    public static class AvroSerializeException
    extends ApplicationException {
        public final String message;

        public AvroSerializeException(String message) {
            this.message = message;
        }

        public AvroSerializeException(Throwable e, String message) {
            super(e);
            this.message = message;
        }
    }

    static class AvroSchema {
        private Schema schema;
        private long generatedTime;

        public AvroSchema(Schema schema, long generatedTime) {
            this.schema = schema;
            this.generatedTime = generatedTime;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public long getGeneratedTime() {
            return this.generatedTime;
        }
    }

    public static class AvroDeserializeException
    extends ApplicationException {
        public final String message;

        public AvroDeserializeException(String message) {
            this.message = message;
        }

        public AvroDeserializeException(Throwable e, String message) {
            super(e);
            this.message = message;
        }
    }
}

