/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.util.IteratorEnumeration;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;

public class BufferedHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    InputStream cachedInputStream;
    public static final String BUFFER_SIZE_SYSTEM_PROPERTY = "coldfusion.request.buffersize";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int BUFFER_SIZE = BufferedHttpServletRequestWrapper.getBufferSize();
    private Map<String, String[]> cachedParameterMap = null;

    private static int getBufferSize() {
        String v = System.getProperty(BUFFER_SIZE_SYSTEM_PROPERTY, Integer.toString(8192));
        try {
            int i = Integer.valueOf(v);
            if (i <= 0) {
                throw new NumberFormatException();
            }
            return i;
        }
        catch (NumberFormatException ex) {
            return 8192;
        }
    }

    public BufferedHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.cachedInputStream = request.getInputStream();
        if (!this.cachedInputStream.markSupported()) {
            this.cachedInputStream = new BufferedInputStream(this.cachedInputStream, BUFFER_SIZE);
        }
        this.cachedInputStream.mark(1);
        if (this.cachedInputStream.read() != -1) {
            this.cachedInputStream.reset();
        }
    }

    public ServletInputStream getInputStream() {
        byte[] reqBytes = FusionContext.getCurrent().getRequestContentInternal();
        final InputStream is = reqBytes == null ? this.cachedInputStream : new ByteArrayInputStream(reqBytes);
        ServletInputStream inputStream = new ServletInputStream(){

            public int read() throws IOException {
                return is.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return is.read(b, off, len);
            }

            public int read(byte[] b) throws IOException {
                return is.read(b);
            }

            public boolean markSupported() {
                return is.markSupported();
            }

            public synchronized void reset() throws IOException {
                is.reset();
            }

            public synchronized void mark(int readlimit) {
                is.mark(readlimit);
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener arg0) {
            }
        };
        return inputStream;
    }

    public void setParameterMap(Map<String, String[]> parameterMap) {
        this.cachedParameterMap = parameterMap;
    }

    public Map<String, String[]> getParameterMap() {
        if (this.cachedParameterMap != null) {
            return this.cachedParameterMap;
        }
        return super.getParameterMap();
    }

    public String getParameter(String key) {
        if (this.cachedParameterMap != null) {
            String[] values = this.cachedParameterMap.get(key);
            if (values != null) {
                if (values.length == 0) {
                    return "";
                }
                return values[0];
            }
            return null;
        }
        return super.getParameter(key);
    }

    public Enumeration<String> getParameterNames() {
        if (this.cachedParameterMap != null) {
            return new IteratorEnumeration(this.cachedParameterMap.keySet().iterator());
        }
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (this.cachedParameterMap != null) {
            return this.cachedParameterMap.get(name);
        }
        return super.getParameterValues(name);
    }
}

