/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.DateTimeString;
import coldfusion.runtime.OleDateTime;
import coldfusion.util.DateUtils;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class CFDateTimeParser {
    private static final int MAX_NEGATIVE_HOUR_OFFSET = 12;
    private static final int MAX_POSITIVE_HOUR_OFFSET = 14;
    private static final int MAX_MINUTES = 59;
    private static final List<Integer> VALID_OFFSET_LENGTH = new ArrayList<Integer>(Arrays.asList(2, 4));
    private static final Integer cutoffYear = Integer.parseInt(System.getProperty("coldfusion.cutoffyear", "30"));
    public static final int MAX_YEAR = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.getInteger("coldfusion.date.parsing.maxyear", 292278993);
        }
    });
    private static GregorianCalendar defgc = new GregorianCalendar();

    public static OleDateTime parseDateTime(String date) {
        int closingTimeStampIndex;
        if (date.length() > 1024) {
            return null;
        }
        if (date.length() > 2 && date.charAt(0) == '{' && (closingTimeStampIndex = date.indexOf(125, 1)) != -1) {
            return CFDateTimeParser.parseTimeStamps(date.substring(1, closingTimeStampIndex));
        }
        return CFDateTimeParser._parseDateTime(new DateTimeString(date), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OleDateTime _parseDateTime(DateTimeString dts, boolean timeParsedAlready) {
        int[] twoWordDate;
        int month = 0;
        boolean week = false;
        int first = dts.readDigits();
        if (first == -1) {
            DateTimeString.Indicator indicate = dts.readIndicator();
            if (indicate == null) {
                return null;
            }
            first = indicate.getValue();
            if (indicate.isMonth()) {
                month = 1;
            } else {
                week = true;
            }
        }
        if (dts.isFinished()) {
            return null;
        }
        if (week) {
            if (!dts.moveIfDelimiter() && !dts.moveIfSpaces()) return null;
            first = dts.readDigits();
            if (first == -1) {
                first = dts.readMonth();
                if (first == -1) {
                    return null;
                }
                month = 1;
            }
            if (dts.isFinished()) {
                return null;
            }
        } else if (month == 0 && !timeParsedAlready && (dts.moveIfDelimiter(':') || dts.isCurrentAMPmStringNoSpaces())) {
            dts.skipSpaces();
            return CFDateTimeParser.parseTime(dts, new int[]{1899, 12, 30}, first, false);
        }
        if (!dts.moveIfDelimiter() && !dts.moveIfSpaces()) {
            return null;
        }
        int second = dts.readDigits();
        if (second == -1) {
            second = dts.readMonth();
            if (second == -1) {
                return null;
            }
            if (month == 1) {
                return null;
            }
            month = 2;
        }
        if (dts.isFinished()) {
            int[] twoWordDate2 = CFDateTimeParser.toDate(month, first, second, false);
            if (twoWordDate2 == null) return null;
            if (twoWordDate2[0] <= MAX_YEAR) return DateUtils.createDateTime(twoWordDate2[0], twoWordDate2[1], twoWordDate2[2], 0, 0, 0);
            return null;
        }
        if (!dts.moveIfDelimiter() && !dts.moveIfSpaces()) {
            return null;
        }
        int third = dts.readDigits();
        if (third == -1) {
            return null;
        }
        if (dts.isFinished()) {
            int[] threeWordDate = CFDateTimeParser.toDate(month, first, second, third);
            if (threeWordDate == null) return null;
            if (threeWordDate[0] <= MAX_YEAR) return DateUtils.createDateTime(threeWordDate[0], threeWordDate[1], threeWordDate[2], 0, 0, 0);
            return null;
        }
        if (timeParsedAlready) {
            return null;
        }
        if (dts.moveIfDelimiter(true) || dts.moveIfSpaces()) {
            int[] threeWordDate = CFDateTimeParser.toDate(month, first, second, third);
            if (threeWordDate == null) return null;
            return CFDateTimeParser.parseTime(dts, threeWordDate, -1, week);
        }
        if (!week || !dts.moveIfDelimiter(':') || (twoWordDate = CFDateTimeParser.toDate(month, first, second, true)) == null) return null;
        return CFDateTimeParser.parseTime(dts, twoWordDate, third, true, true);
    }

    public static OleDateTime parseTimeStamps(String date) {
        DateTimeString dts = new DateTimeString(date);
        if (dts.moveIfCurrentIgnorecase('t')) {
            if (dts.moveIfCurrentIgnorecase('s') && dts.moveIfSpaces() && dts.moveIfCurrent('\'')) {
                dts.skipSpaces();
                int year = dts.readDigits();
                if (year == -1) {
                    return null;
                }
                if (!dts.moveIfCurrent('-')) {
                    return null;
                }
                dts.skipSpaces();
                int month = dts.readDigits();
                if (month == -1 || month < 1 || month > 12 || !dts.moveIfCurrent('-')) {
                    return null;
                }
                dts.skipSpaces();
                int day = dts.readDigits();
                if (day < 1 || !dts.moveIfSpaces()) {
                    return null;
                }
                if (CFDateTimeParser.dayNotInMonth(day, month, year = CFDateTimeParser.adjust2Kyear(year))) {
                    return null;
                }
                int hour = dts.readDigits();
                if (hour == -1 || hour > 23 || !dts.moveIfCurrent(':')) {
                    return null;
                }
                dts.skipSpaces();
                int minute = dts.readDigits();
                if (minute == -1 || minute > 59 || !dts.moveIfCurrent(':')) {
                    return null;
                }
                dts.skipSpaces();
                int second = dts.readDigits();
                if (second == -1 || second > 59) {
                    return null;
                }
                int millisecond = 0;
                if (dts.moveIfCurrent('.')) {
                    millisecond = dts.readDigits();
                    if (millisecond == -1) {
                        return null;
                    }
                    millisecond = millisecond > 1000 ? 999 : (millisecond < 0 ? 0 : millisecond);
                }
                dts.skipSpaces();
                OleDateTime odt = CFDateTimeParser.parseOffset(dts, year, month, day, hour, minute, second, millisecond);
                if (!dts.moveIfCurrent('\'')) {
                    return null;
                }
                dts.skipSpaces();
                if (!dts.isFinished()) {
                    return null;
                }
                if (odt == null) {
                    odt = DateUtils.createDateTime(year, month, day, hour, minute, second);
                    odt.setTime(odt.getTime() + (long)millisecond);
                    return odt;
                }
                return odt;
            }
            if (dts.moveIfSpaces() && dts.moveIfCurrent('\'')) {
                int hour = dts.readDigits();
                if (hour == -1 || hour > 23 || !dts.moveIfCurrent(':')) {
                    return null;
                }
                dts.skipSpaces();
                int minute = dts.readDigits();
                if (minute == -1 || minute > 59 || !dts.moveIfCurrent(':')) {
                    return null;
                }
                dts.skipSpaces();
                int second = dts.readDigits();
                if (second == -1 || second > 59) {
                    return null;
                }
                int millisecond = 0;
                if (dts.moveIfCurrent('.')) {
                    millisecond = dts.readDigits();
                    if (millisecond == -1) {
                        return null;
                    }
                    if (millisecond > 1000) {
                        millisecond = 999;
                    }
                }
                dts.skipSpaces();
                OleDateTime odt = CFDateTimeParser.parseOffset(dts, 1899, 12, 30, hour, minute, second, millisecond);
                if (!dts.moveIfCurrent('\'')) {
                    return null;
                }
                dts.skipSpaces();
                if (!dts.isFinished()) {
                    return null;
                }
                if (odt == null) {
                    odt = DateUtils.createDateTime(-1, 12, 30, hour, minute, second);
                    odt.setTime(odt.getTime() + (long)millisecond);
                    return odt;
                }
                return odt;
            }
        } else if (dts.moveIfCurrentIgnorecase('d') && dts.moveIfSpaces() && dts.moveIfCurrent('\'')) {
            dts.skipSpaces();
            int year = dts.readDigits();
            if (year == -1) {
                return null;
            }
            if (!dts.moveIfCurrent('-')) {
                return null;
            }
            dts.skipSpaces();
            int month = dts.readDigits();
            if (month == -1 || month < 1 || month > 12 || !dts.moveIfCurrent('-')) {
                return null;
            }
            dts.skipSpaces();
            int day = dts.readDigits();
            if (day < 1) {
                return null;
            }
            if (CFDateTimeParser.dayNotInMonth(day, month, year = CFDateTimeParser.adjust2Kyear(year))) {
                return null;
            }
            dts.skipSpaces();
            if (!dts.moveIfCurrent('\'')) {
                return null;
            }
            dts.skipSpaces();
            if (!dts.isFinished()) {
                return null;
            }
            return DateUtils.createDateTime(year, month, day, 0, 0, 0);
        }
        return null;
    }

    private static OleDateTime parseTime(DateTimeString dts, int[] date, int hours, boolean skipLast) {
        return CFDateTimeParser.parseTime(dts, date, hours, skipLast, false);
    }

    private static OleDateTime parseTime(DateTimeString dts, int[] date, int hours, boolean skipLast, boolean yearAtEnd) {
        boolean hoursGiven = true;
        if (hours == -1) {
            hours = dts.readDigits();
            if (hours == -1) {
                return null;
            }
            hoursGiven = false;
        }
        if (hours > 23 || dts.isFinished()) {
            return null;
        }
        int minutes = 0;
        int seconds = 0;
        int msSeconds = 0;
        if (hoursGiven && !dts.isCurrentIgnorecase('a', 'p') || dts.moveIfCurrentIgnoreSpaces(':')) {
            dts.skipSpaces();
            minutes = dts.readDigits();
            if (minutes == -1 || minutes > 59) {
                return null;
            }
            seconds = 0;
            if (dts.moveIfCurrentIgnoreSpaces(':')) {
                dts.skipSpaces();
                seconds = dts.readDigits();
                if (seconds == -1 || seconds > 59) {
                    return null;
                }
                if (dts.moveIfCurrentIgnoreSpaces('.')) {
                    float temp = dts.readFloatMantissa();
                    if (temp == -1.0f) {
                        return null;
                    }
                    msSeconds = Math.round(temp * 1000.0f);
                    msSeconds = msSeconds > 1000 ? 999 : (msSeconds < 0 ? 0 : msSeconds);
                }
            }
        }
        dts.skipSpaces();
        if (dts.isFinished()) {
            return CFDateTimeParser.toDateTime(date, hours, minutes, seconds, msSeconds);
        }
        if (dts.moveIfCurrentIgnorecase('a')) {
            dts.moveIfCurrentIgnorecase('m');
            if (hours == 12) {
                hours = 0;
            }
            if (dts.isFinished()) {
                return CFDateTimeParser.toDateTime(date, hours, minutes, seconds, msSeconds);
            }
            dts.skipSpaces();
        } else if (dts.moveIfCurrentIgnorecase('p')) {
            dts.moveIfCurrentIgnorecase('m');
            if (hours < 12) {
                hours += 12;
            }
            if (dts.isFinished()) {
                return CFDateTimeParser.toDateTime(date, hours, minutes, seconds, msSeconds);
            }
            dts.skipSpaces();
        }
        int currentPosition = dts.currentPos;
        OleDateTime dateTime = CFDateTimeParser.parseOffset(dts, date[0], date[1], date[2], hours, minutes, seconds, msSeconds, yearAtEnd);
        if (dateTime != null) {
            if (dts.isFinished() || !hoursGiven || yearAtEnd & skipLast) {
                return dateTime;
            }
        } else {
            dts.currentPos = currentPosition;
        }
        if (dts.isFinished()) {
            return CFDateTimeParser.toDateTime(date, hours, minutes, seconds, msSeconds);
        }
        if (!hoursGiven) {
            if (skipLast) {
                return CFDateTimeParser.toDateTime(date, hours, minutes, seconds, msSeconds);
            }
            return null;
        }
        if (yearAtEnd) {
            dts.skipSpaces();
            int year = dts.readDigits();
            if (year != -1) {
                date[0] = CFDateTimeParser.adjust2Kyear(year);
            }
            if (skipLast) {
                return CFDateTimeParser.toDateTime(date, hours, minutes, seconds, msSeconds);
            }
        }
        if ((dateTime = CFDateTimeParser._parseDateTime(dts, true)) != null) {
            Calendar calendar = DateUtils.getDefaultCalendar();
            calendar.setTime(dateTime);
            calendar.set(11, hours);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            CFDateTimeParser.setMilliSeconds(calendar, msSeconds);
            return new OleDateTime(calendar.getTime());
        }
        return null;
    }

    private static OleDateTime parseOffset(DateTimeString dts, int year, int month, int date, int hours, int minutes, int seconds, int msSeconds) {
        return CFDateTimeParser.parseOffset(dts, year, month, date, hours, minutes, seconds, msSeconds, false);
    }

    private static OleDateTime parseOffset(DateTimeString dts, int year, int month, int date, int hours, int minutes, int seconds, int msSeconds, boolean yearAtEnd) {
        if (dts.isLast() && dts.moveIfCurrentIgnorecase('z')) {
            Calendar utcCalendar = DateUtils.getUTCCalendar();
            utcCalendar.clear();
            utcCalendar.set(year, month - 1, date, hours, minutes, seconds);
            CFDateTimeParser.setMilliSeconds(utcCalendar, msSeconds);
            return new OleDateTime(utcCalendar.getTime());
        }
        TimeZone tz = dts.readTimeZone();
        if (tz == null || tz.getID().equals("GMT")) {
            if (dts.moveIfCurrent('+')) {
                return CFDateTimeParser._parseoffset(dts, year, month, date, hours, minutes, seconds, msSeconds, true, yearAtEnd);
            }
            if (dts.moveIfCurrent('-')) {
                return CFDateTimeParser._parseoffset(dts, year, month, date, hours, minutes, seconds, msSeconds, false, yearAtEnd);
            }
            if (tz != null && dts.isFinished()) {
                year = CFDateTimeParser.adjust2Kyear(year);
                OleDateTime odt = new OleDateTime(year - 1900, month - 1, date, hours, minutes, seconds);
                if (msSeconds != 0) {
                    odt.setTime(odt.getTime() + (long)msSeconds);
                }
                return odt;
            }
        }
        if (tz != null) {
            year = CFDateTimeParser.getYearAtEnd(dts, year, yearAtEnd);
            Calendar zoneCalendar = Calendar.getInstance(tz);
            zoneCalendar.set(year, month - 1, date, hours, minutes, seconds);
            CFDateTimeParser.setMilliSeconds(zoneCalendar, msSeconds);
            return new OleDateTime(zoneCalendar.getTime());
        }
        return null;
    }

    private static OleDateTime _parseoffset(DateTimeString dts, int year, int month, int date, int hours, int minutes, int seconds, int msSeconds, boolean plus, boolean yearAtEnd) {
        int h;
        int hourLen = dts.currentPos;
        int hour = dts.readDigits();
        hourLen = dts.currentPos - hourLen;
        if (hour == -1 || !VALID_OFFSET_LENGTH.contains(hourLen)) {
            return null;
        }
        if (hourLen <= 2 && !CFDateTimeParser.isValidHourOffset(hour, plus)) {
            return null;
        }
        int minute = 0;
        if (!dts.isFinished()) {
            int minuteLen = dts.currentPos;
            if (!dts.moveIfCurrent(':')) {
                return null;
            }
            minute = dts.readDigits();
            minuteLen = dts.currentPos - minuteLen - 1;
            if (!CFDateTimeParser.isValidOffsetRange(hour, minute, plus) || minuteLen != 2) {
                return null;
            }
        } else if (hourLen > 2 && !CFDateTimeParser.isValidOffsetRange(hour = (h = hour / 100), minute = hour - h * 100, plus)) {
            return null;
        }
        year = CFDateTimeParser.getYearAtEnd(dts, year, yearAtEnd);
        Calendar utcCalendar = DateUtils.getUTCCalendar();
        utcCalendar.clear();
        utcCalendar.set(year, month - 1, date, hours, minutes, seconds);
        CFDateTimeParser.setMilliSeconds(utcCalendar, msSeconds);
        long time = utcCalendar.getTimeInMillis();
        long offset = hour * 60 * 60 * 1000 + minute * 60 * 1000;
        time = plus ? (time -= offset) : (time += offset);
        return new OleDateTime(time);
    }

    private static int getYearAtEnd(DateTimeString dts, int yearDefault, boolean yearAtEnd) {
        if (yearAtEnd) {
            dts.skipSpaces();
            int year = dts.readDigits();
            if (year != -1) {
                return CFDateTimeParser.adjust2Kyear(year);
            }
        }
        return yearDefault;
    }

    private static int[] toDate(int month, int first, int second, boolean yearKnown) {
        if (first < 1 || second < 1) {
            return null;
        }
        if (first <= 12 && month < 2) {
            int thisYear = Year.now().getValue();
            if (!CFDateTimeParser.dayNotInMonth(second, first, thisYear)) {
                if (month == 1) {
                    return new int[]{thisYear, first, second};
                }
                return null;
            }
            if (yearKnown && month == 1) {
                return new int[]{thisYear, first, second};
            }
            return new int[]{CFDateTimeParser.adjust2Kyear(second), first, 1};
        }
        if (second <= 12) {
            int thisYear = Year.now().getValue();
            if (!CFDateTimeParser.dayNotInMonth(first, second, thisYear)) {
                if (month == 2) {
                    return new int[]{thisYear, second, first};
                }
                return null;
            }
            if (yearKnown && month == 2) {
                return new int[]{thisYear, second, first};
            }
            return new int[]{CFDateTimeParser.adjust2Kyear(first), second, 1};
        }
        return null;
    }

    private static int[] toDate(int month, int first, int second, int third) {
        if (first <= 12 && first > 0) {
            third = CFDateTimeParser.adjust2Kyear(third);
            if (month == 2) {
                return new int[]{CFDateTimeParser.adjust2Kyear(third), second, first};
            }
            if (!CFDateTimeParser.dayNotInMonth(second, first, third)) {
                return new int[]{third, first, second};
            }
            return null;
        }
        if (second > 12) {
            return null;
        }
        if (month == 2) {
            int tmp = first;
            first = third;
            third = tmp;
        }
        if (!CFDateTimeParser.dayNotInMonth(third, second, CFDateTimeParser.adjust2Kyear(first))) {
            return new int[]{CFDateTimeParser.adjust2Kyear(first), second, third};
        }
        if (!CFDateTimeParser.dayNotInMonth(first, second, third = CFDateTimeParser.adjust2Kyear(third))) {
            return new int[]{third, second, first};
        }
        return null;
    }

    private static OleDateTime toDateTime(int[] date, int hours, int minutes, int seconds, int msSeconds) {
        if (msSeconds == 0) {
            return DateUtils.createDateTime(date[0], date[1], date[2], hours, minutes, seconds);
        }
        Calendar calendar = DateUtils.getDefaultCalendar();
        calendar.clear();
        calendar.set(date[0], date[1] - 1, date[2], hours, minutes, seconds);
        CFDateTimeParser.setMilliSeconds(calendar, msSeconds);
        return new OleDateTime(calendar.getTime());
    }

    private static boolean dayNotInMonth(int day, int month, int year) {
        return day < 1 || month < 1 || year < 1 || day > 31 || day > 30 && (month == 2 || month == 4 || month == 6 || month == 9 || month == 11) || day > 29 && month == 2 || day > 28 && month == 2 && !defgc.isLeapYear(year);
    }

    private static int adjust2Kyear(int year) {
        if (year >= 0 && year <= cutoffYear - 1) {
            year += 2000;
        } else if (year >= cutoffYear && year <= 99) {
            year += 1900;
        }
        return year;
    }

    private static void setMilliSeconds(Calendar calendar, int msSeconds) {
        if (msSeconds > 0) {
            if (msSeconds < 1000) {
                calendar.set(14, msSeconds);
            } else {
                calendar.add(14, msSeconds);
            }
        }
    }

    private static boolean isValidOffsetRange(int hour, int minute, boolean plus) {
        if (minute == -1 || minute > 59) {
            return false;
        }
        if (!CFDateTimeParser.isValidHourOffset(hour, plus)) {
            return false;
        }
        return (!plus || hour != 14 || minute <= 0) && (plus || hour != 12 || minute <= 0);
    }

    private static boolean isValidHourOffset(int hour, boolean plus) {
        return (!plus || hour <= 14) && (plus || hour <= 12);
    }
}

