/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import java.io.BufferedReader;
import java.io.IOException;
import org.fusesource.jansi.Ansi;

public final class CLIBridge {
    Array allArgs = new Array();
    Struct namedArgs = new Struct();
    Array unnamedArgs = new Array();
    BufferedReader reader;

    public CLIBridge() {
        try {
            FusionContext fusionContext = FusionContext.getCurrent();
            if (fusionContext != null && fusionContext.getRequest() != null) {
                this.reader = fusionContext.getRequest().getReader();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Array getArgs() {
        return this.allArgs;
    }

    public Struct getNamedArgs() {
        return this.namedArgs;
    }

    public Object getArg(int index) {
        return this.allArgs.get(index - 1);
    }

    public void addArg(String value) {
        boolean quotedArg;
        if (value == null) {
            return;
        }
        this.allArgs.add(value);
        int operatorIndex = value.indexOf("=");
        boolean bl = quotedArg = value.startsWith("'") || value.startsWith("\"");
        if (!quotedArg && operatorIndex != -1) {
            this.namedArgs.put(value.substring(0, operatorIndex), (Object)value.substring(operatorIndex + 1));
        } else {
            this.unnamedArgs.add(value);
        }
    }

    public Object getNamedArg(String key) {
        return this.namedArgs.get(key);
    }

    public Array getUnnamedArgs() {
        return this.unnamedArgs;
    }

    public Object read() {
        try {
            this.flushOutput();
            if (this.reader != null) {
                return this.reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void write(Object messageObj) {
        String message = Cast._String(messageObj);
        try {
            NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
            pageContext.getCFOutput().cfoutput(true);
            pageContext.getOut().write(message);
            pageContext.getCFOutput().cfoutput(false);
        }
        catch (IOException e) {
            ServiceFactory.getLoggingService().getLogger("coldfusion.server").error(e);
        }
    }

    public void writeln(Object messageObj) {
        String message = Cast._String(messageObj);
        try {
            NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
            pageContext.getCFOutput().cfoutput(true);
            pageContext.getOut().write(message);
            pageContext.getOut().println();
            pageContext.getCFOutput().cfoutput(false);
        }
        catch (IOException e) {
            ServiceFactory.getLoggingService().getLogger("coldfusion.server").error(e);
        }
    }

    public void writeError(String errorMessage) {
        try {
            this.flushOutput();
            System.err.println(Ansi.ansi().fg(Ansi.Color.RED).a(errorMessage).reset());
            this.flushOutput();
        }
        catch (IOException e) {
            ServiceFactory.getLoggingService().getLogger("coldfusion.server").error(e);
        }
    }

    public void exit(int status) {
        try {
            this.flushOutput();
            System.exit(status);
        }
        catch (IOException e) {
            ServiceFactory.getLoggingService().getLogger("coldfusion.server").error(e);
        }
    }

    private void flushOutput() throws IOException {
        FusionContext.getCurrent().pageContext.getOut().flush();
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }
}

