/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.Cast;
import coldfusion.runtime.ExceptionInformation;
import coldfusion.runtime.NeoException;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.Utils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;

public class CfErrorWrapper
extends RuntimeWrapper {
    private String mailTo;
    private Date date;
    private String browser;
    private String content;
    private String remoteAddress;
    private String referer;
    private String template;
    private String query;

    public CfErrorWrapper(Throwable ex, String mailTo, HttpServletRequest request, String sGenContent) {
        super(ex);
        this.mailTo = mailTo;
        this.date = new Date();
        this.browser = this.null2empty(request.getHeader("user-agent"));
        this.content = sGenContent;
        this.remoteAddress = this.null2empty(request.getRemoteAddr());
        this.referer = this.null2empty(request.getHeader("referer"));
        this.template = Utils.getServletPath(request);
        this.query = this.null2empty(Utils.getQueryString(request));
    }

    private String null2empty(String s) {
        return s != null ? s : "";
    }

    public String getDiagnostics() {
        String sDetail = null;
        if (this.getRootCause() instanceof NeoException) {
            sDetail = ((NeoException)this.getRootCause()).getDetail();
        }
        String line = "-1";
        Object tagcnxt = Cast._Map(this).get("tagContext");
        if (tagcnxt instanceof ExceptionInformation) {
            line = String.valueOf(((ExceptionInformation)tagcnxt).getLine());
        }
        LineNumberException lne = new LineNumberException(line);
        return this.getMessage() + " " + sDetail + " " + lne.getMessage();
    }

    public String getMailto() {
        return this.mailTo;
    }

    public Date getDateTime() {
        return this.date;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getGeneratedContent() {
        return this.content;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getHTTPReferer() {
        return this.referer;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getQueryString() {
        return this.query;
    }

    public static final class LineNumberException
    extends NeoException {
        private String m_lineNumber = "-1";

        LineNumberException(String lineNumber) {
            this.m_lineNumber = lineNumber;
        }

        public String getLineNumber() {
            return this.m_lineNumber;
        }
    }
}

