/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.Scope;
import coldfusion.runtime.ScopeSearchResult;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.util.Utils;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CgiScope
extends Scope {
    private static final String[] names = new String[]{"AUTH_PASSWORD", "AUTH_TYPE", "AUTH_USER", "CERT_COOKIE", "CERT_FLAGS", "CERT_ISSUER", "CERT_KEYSIZE", "CERT_SECRETKEYSIZE", "CERT_SERIALNUMBER", "CERT_SERVER_ISSUER", "CERT_SERVER_SUBJECT", "CERT_SUBJECT", "CF_TEMPLATE_PATH", "CONTENT_LENGTH", "CONTENT_TYPE", "CONTEXT_PATH", "GATEWAY_INTERFACE", "HTTP_ACCEPT", "HTTP_ACCEPT_ENCODING", "HTTP_ACCEPT_LANGUAGE", "HTTP_CONNECTION", "HTTP_COOKIE", "HTTP_HOST", "HTTP_USER_AGENT", "HTTP_REFERER", "HTTP_URL", "HTTPS", "HTTPS_KEYSIZE", "HTTPS_SECRETKEYSIZE", "HTTPS_SERVER_ISSUER", "HTTPS_SERVER_SUBJECT", "LOCAL_ADDR", "PATH_INFO", "PATH_TRANSLATED", "QUERY_STRING", "REMOTE_ADDR", "REMOTE_HOST", "REMOTE_USER", "REQUEST_METHOD", "SCRIPT_NAME", "SERVER_NAME", "SERVER_PORT", "SERVER_PORT_SECURE", "SERVER_PROTOCOL", "SERVER_SOFTWARE", "WEB_SERVER_API"};
    private static Map cgivars;
    private static String serverInfo;
    private static boolean isJRun;
    private static String ALL_HTTP_BEGIN;
    private static String COLON;
    private static String SPACE;
    private static String LINE_FEED;
    private static final String DUMMY_DATA = "xxxxxxxx";

    @Override
    protected void bindName(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void bindName_Final(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void unbindName(String name) {
        throw new UnsupportedOperationException();
    }

    private Object resolve(String name) {
        FusionContext fc = FusionContext.getCurrent();
        if (fc == null) {
            return null;
        }
        HttpServletRequest request = fc.getRequest();
        ServletContext application = fc.getServletContext();
        Object ret = null;
        if (name.indexOf(95) > 0) {
            if (name.equalsIgnoreCase("SCRIPT_NAME")) {
                String ctxPath = Utils.getContextPath(request);
                String srvltPath = Utils.getServletPath(request);
                if (fc.isSchedulerEvent() && new File(ctxPath).exists()) {
                    ctxPath = "";
                }
                ret = ctxPath + srvltPath;
            }
            if (name.equalsIgnoreCase("SERVER_NAME")) {
                ret = request.getServerName();
            }
            if (name.equalsIgnoreCase("SERVER_PORT")) {
                ret = String.valueOf(request.getLocalPort());
            }
            if (name.equalsIgnoreCase("REMOTE_ADDR")) {
                ret = ServiceFactory.isFiddleServiceEnabled() ? DUMMY_DATA : request.getRemoteAddr();
            }
            if (name.equalsIgnoreCase("LOCAL_ADDR")) {
                ret = ServiceFactory.isFiddleServiceEnabled() ? DUMMY_DATA : request.getLocalAddr();
            }
            if (name.equalsIgnoreCase("REMOTE_HOST")) {
                ret = ServiceFactory.isFiddleServiceEnabled() ? DUMMY_DATA : request.getRemoteHost();
            }
            if (name.equalsIgnoreCase("QUERY_STRING")) {
                ret = Utils.getQueryString(request);
            }
            if (name.equalsIgnoreCase("REQUEST_METHOD")) {
                ret = request.getMethod();
            }
            if (name.equalsIgnoreCase("REQUEST_URI")) {
                ret = Utils.getRequestURI(request);
            }
            if (name.equalsIgnoreCase("SERVER_PROTOCOL")) {
                ret = request.getProtocol();
            }
            if (name.equalsIgnoreCase("PATH_INFO")) {
                ret = Utils.getPathInfo(request);
            }
            if (name.equalsIgnoreCase("PATH_TRANSLATED")) {
                if (fc.isSchedulerEvent() && new File(request.getServletPath()).exists()) {
                    return request.getServletPath();
                }
                ret = application.getRealPath(Utils.getServletPath(request));
            }
            if (name.equalsIgnoreCase("REMOTE_USER")) {
                ret = request.getRemoteUser();
            }
            if (name.equalsIgnoreCase("AUTH_TYPE")) {
                ret = request.getAuthType();
            }
            if (name.equalsIgnoreCase("SERVER_PORT_SECURE")) {
                Object object = ret = request.isSecure() ? "1" : "0";
            }
            if (name.equalsIgnoreCase("CF_TEMPLATE_PATH")) {
                if (fc.isSchedulerEvent() && new File(request.getServletPath()).exists()) {
                    return request.getServletPath();
                }
                ret = application.getRealPath(Utils.getServletPath(request));
            }
            if (name.equalsIgnoreCase("CONTEXT_PATH")) {
                ret = Utils.getContextPath(request);
            }
            if (name.equalsIgnoreCase("HTTP_IF_MODIFIED_SINCE")) {
                name = "LAST_MODIFIED";
            }
            if ((name.equalsIgnoreCase("CERT_COOKIE") || name.equalsIgnoreCase("CERT_FLAGS") || name.equalsIgnoreCase("CERT_CERT_ISSUER") || name.equalsIgnoreCase("CERT_SUBJECT") || name.equalsIgnoreCase("HTTPS_KEYSIZE") || name.equalsIgnoreCase("HTTPS_SECRETKEYSIZE") || name.equalsIgnoreCase("HTTPS_SERVER_ISSUER") || name.equalsIgnoreCase("HTTPS_SERVER_SUBJECT") || name.equalsIgnoreCase("GATEWAY_INTERFACE") || name.equalsIgnoreCase("HTTP_URL")) && SystemInfo.isStandalone()) {
                ret = (String)request.getAttribute(name);
            }
            if (name.equalsIgnoreCase("SERVER_SOFTWARE") && SystemInfo.isStandalone()) {
                ret = ServiceFactory.isFiddleServiceEnabled() ? DUMMY_DATA : (String)request.getAttribute(name);
            }
            if (name.equalsIgnoreCase("AUTH_USER") && SystemInfo.isStandalone()) {
                ret = request.getRemoteUser();
            }
            if (name.equalsIgnoreCase("CERT_KEYSIZE") && SystemInfo.isStandalone()) {
                ret = (String)request.getAttribute("HTTPS_KEYSIZE");
            }
            if (name.equalsIgnoreCase("CERT_SECRETKEYSIZE") && SystemInfo.isStandalone()) {
                ret = (String)request.getAttribute("HTTPS_SECRETKEYSIZE");
            }
            if (name.equalsIgnoreCase("CERT_SERVER_ISSUER") && SystemInfo.isStandalone()) {
                ret = (String)request.getAttribute("HTTPS_SERVER_ISSUER");
            }
            if (name.equalsIgnoreCase("CERT_SERVER_SUBJECT") && SystemInfo.isStandalone()) {
                ret = (String)request.getAttribute("HTTPS_SERVER_SUBJECT");
            }
            if (name.equalsIgnoreCase("ALL_HTTP") && SystemInfo.isStandalone()) {
                StringBuilder all_headers = new StringBuilder();
                Enumeration e = request.getHeaderNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    all_headers.append(ALL_HTTP_BEGIN);
                    all_headers.append(key.toUpperCase());
                    all_headers.append(COLON);
                    all_headers.append(request.getHeader(key));
                    all_headers.append(LINE_FEED);
                }
                ret = all_headers.toString();
            }
        }
        if (name.equalsIgnoreCase("HTTPS")) {
            Object object = ret = request.isSecure() ? "on" : "off";
        }
        if (ret != null) {
            List sciptProtect = fc.getScriptProtect();
            if (sciptProtect != null && sciptProtect.contains("CGI")) {
                ret = ServiceFactory.getSecurityService().crossSiteProtectString((String)ret);
            }
            return ret;
        }
        Object value = request.getHeader(name);
        if (value == null) {
            value = (String)request.getAttribute(name);
        }
        if (value != null) {
            value = ServiceFactory.getSecurityService().crossSiteProtectString((String)value);
            return value;
        }
        if (serverInfo == null) {
            serverInfo = application.getServerInfo();
            boolean bl = isJRun = serverInfo.indexOf("JRun") >= 0;
        }
        if (isJRun) {
            return null;
        }
        if (name.indexOf(95) != -1 && (value = request.getHeader(name.replace('_', '-'))) != null) {
            return value;
        }
        if (name.length() >= 5 && name.substring(0, 5).equalsIgnoreCase("HTTP_")) {
            String sname = name.substring(5);
            value = request.getHeader(sname);
            if (sname.equalsIgnoreCase("HOST") && value == null) {
                value = request.getServerName() + ":" + request.getServerPort();
            }
            if (value == null && sname.indexOf(95) != -1) {
                value = request.getHeader(sname.replace('_', '-'));
            }
        }
        return value;
    }

    @Override
    protected Object resolveName(String name) {
        Object o = this.resolve(name);
        return o != null ? o : "";
    }

    @Override
    public Object getCanonicalKey(Object key) {
        return this.resolveName((String)key);
    }

    @Override
    protected boolean containsName(String name) {
        return cgivars.containsKey(name.toUpperCase()) || this.resolve(name) != null;
    }

    @Override
    protected Iterator getNames() {
        return cgivars.keySet().iterator();
    }

    @Override
    public int size() {
        return names.length;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.cloneAsStruct();
    }

    @Override
    public void search(ScopeSearchResult searcher) {
        String flatKey = searcher.getCanonicalUnifiedKey();
        if (this.containsName(flatKey)) {
            searcher.setFound(true);
            searcher.setResult(this.get(flatKey));
        } else {
            searcher.setFound(false);
        }
    }

    @Override
    public void clear() {
    }

    public void clearVariables() {
    }

    static {
        isJRun = false;
        ALL_HTTP_BEGIN = "HTTP_";
        COLON = ":";
        SPACE = " ";
        LINE_FEED = "\n";
        cgivars = new HashMap(names.length);
        for (int i = 0; i < names.length; ++i) {
            cgivars.put(names[i], "");
        }
    }
}

