/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;

public class CharBuffer
extends CharArrayWriter {
    public CharBuffer(int nBufferSize) {
        super(nBufferSize);
    }

    public void replace(int nStart, int nLen, String str) {
        this.count = nStart;
        this.write(str, 0, nLen);
    }

    public void replace(int nStart, String str) {
        this.replace(nStart, str.length(), str);
    }

    public void replace(int nStart, int nOffset, int nLen, char[] s) {
        this.count = nStart;
        this.write(s, nOffset, nLen);
    }

    public void setCharAt(int nLoc, char c) {
        this.count = nLoc;
        this.write(c);
    }

    public char getCharAt(int nLoc) {
        return this.buf[nLoc];
    }

    public String substring(int nStart, int nEnd) {
        return new String(this.buf, nStart, nEnd - nStart);
    }

    public void setCount(int nNewCount) {
        this.count = nNewCount;
    }

    public int findStringNoCase(String searchText) {
        return this.findStringNoCase(searchText, 0);
    }

    public int findStringNoCase(String searchText, int pos) {
        int searchLen = searchText.length();
        for (int i = pos; i <= this.count - searchLen; ++i) {
            int q = i;
            while (q - i < searchLen && Character.toLowerCase(this.buf[q]) == Character.toLowerCase(searchText.charAt(q - i))) {
                if (q - i + 1 == searchLen) {
                    return i;
                }
                ++q;
            }
        }
        return -1;
    }

    public void writeTo(Writer out, int nStart, int nEnd) throws IOException {
        out.write(this.buf, nStart, nEnd - nStart);
    }

    public void deleteBuffer() {
        this.buf = null;
    }
}

