/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.log.CFLogs;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.serverless.InMemoryFile;
import coldfusion.serverless.InMemoryInputStream;
import coldfusion.serverless.InMemoryOutputStream;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.FileLock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

class ClientIDHelper {
    private String mPath = null;
    private Properties mClientProp = new Properties();
    private int mNextIDBlock = 0;
    private int mID = 0;
    private boolean isFileLock = false;
    private static String CLIENT_PROPERTIES = "client.properties";
    private static String PROPERTY_NAME = "LastID";
    private static int BLOCK_SIZE = 100;
    private InMemoryFile imf = null;

    public ClientIDHelper() {
        RuntimeService runtime = ServiceFactory.getRuntimeService();
        this.mPath = runtime.getRootDir() + File.separatorChar + "lib";
        this.isFileLock = runtime.isFileLockEnabled();
    }

    private synchronized FileInputStream getInputStream() throws IOException {
        File file = new File(this.mPath, CLIENT_PROPERTIES);
        if (!file.exists()) {
            CFLogs.SERVER_LOG.info("Initialize " + CLIENT_PROPERTIES + " file");
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            this.mClientProp.setProperty(PROPERTY_NAME, "0");
            this.mClientProp.store(fos, "client id file");
            fos.close();
        }
        return new FileInputStream(file);
    }

    private synchronized InMemoryInputStream getInMemoryInputStream() {
        if (this.imf == null) {
            InMemoryFile imf;
            File file = new File(this.mPath, CLIENT_PROPERTIES);
            CFLogs.SERVER_LOG.info("Initialize " + CLIENT_PROPERTIES + " file");
            this.imf = imf = new InMemoryFile(file.getPath(), file);
            InMemoryOutputStream os = new InMemoryOutputStream(this.imf);
            this.mClientProp.setProperty(PROPERTY_NAME, "0");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                this.mClientProp.store(bos, null);
                os.write(bos.toByteArray());
                bos.close();
                os.close();
            }
            catch (IOException e) {
                CFLogs.SERVER_LOG.error("Error creating " + CLIENT_PROPERTIES + " file");
            }
        }
        return new InMemoryInputStream(this.imf);
    }

    private synchronized void storeClientID(int id) throws IOException {
        File file = new File(this.mPath, CLIENT_PROPERTIES);
        if (!ServerlessUtil.isLambdaEnv()) {
            FileOutputStream fos = new FileOutputStream(file);
            this.mClientProp.setProperty(PROPERTY_NAME, Long.toString(id));
            this.mClientProp.store(fos, "ClientID Sequence");
            fos.close();
        } else {
            if (this.imf == null) {
                this.imf = new InMemoryFile(this.mPath, file);
            }
            InMemoryOutputStream ios = new InMemoryOutputStream(this.imf);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.mClientProp.store(bos, "ClientID Sequence");
            ios.write(bos.toByteArray());
            bos.close();
            ios.close();
        }
    }

    private synchronized void GetIDBlockFromFile() throws IOException {
        if (!ServerlessUtil.isLambdaEnv()) {
            FileInputStream fis = this.getInputStream();
            this.mClientProp.clear();
            this.mClientProp.load(fis);
            fis.close();
        } else {
            InMemoryInputStream is = this.getInMemoryInputStream();
            byte[] bytes = new byte[]{};
            if (is != null) {
                bytes = is.readBytes();
            }
            this.mClientProp.clear();
            this.mClientProp.load(new ByteArrayInputStream(bytes));
            is.close();
        }
        String result = this.mClientProp.getProperty(PROPERTY_NAME);
        try {
            this.mID = Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            String msg = "ClientIDHelper.GetIDBlockFromFile() error: " + CLIENT_PROPERTIES + " file exists but has zero length.";
            CFLogs.SERVER_LOG.error(msg);
            this.mID = this.mNextIDBlock;
        }
        if (this.mID > Integer.MAX_VALUE - BLOCK_SIZE) {
            this.mID = 0;
        }
        this.mNextIDBlock = this.mID + BLOCK_SIZE;
        this.storeClientID(this.mNextIDBlock);
    }

    public synchronized int GetClientId() {
        try {
            if (this.mID >= this.mNextIDBlock) {
                this.GetIDBlockFromFile();
            }
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error("GetClientID: " + e);
        }
        return this.mID++;
    }

    public void save() {
        try {
            if (!this.isFileLock) {
                this.storeClientID(this.mID);
            } else {
                this.storeClientIDWithLock(this.mID);
            }
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error("GetClientID: " + e);
        }
    }

    public void storeClientIDWithLock(int id) throws IOException {
        FileLock fileLock = new FileLock(this.mPath, CLIENT_PROPERTIES);
        try {
            fileLock.obtain();
            this.storeClientID(id);
        }
        finally {
            fileLock.release();
        }
    }
}

