/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.AbstractScope;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ClientScopeInvalidDataTypeException;
import coldfusion.runtime.ClientScopeKey;
import coldfusion.runtime.FlatScope;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.UDFMethod;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class ClientScope
extends AbstractScope
implements FlatScope {
    private ClientScopeKey mKey;
    private Hashtable mClientVars;
    private Properties mPersistSettings = null;
    private boolean mIsNew = false;
    private boolean mIsClientIdFromUrl = false;
    private String domain = null;
    private int refCount = 0;
    private static ThreadLocal scopeTL = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private static HashSet ReservedVariableNames = new HashSet();

    public ClientScope(NeoPageContext PageContext2, ClientScopeKey key, Hashtable table, Properties PersistSettings) {
        this.mKey = key;
        this.mClientVars = table;
        this.mPersistSettings = PersistSettings;
    }

    public ClientScope(NeoPageContext PageContext2, ClientScopeKey key, Hashtable table) {
        this.mKey = key;
        this.mClientVars = table;
    }

    public ClientScopeKey getKey() {
        return this.mKey;
    }

    public boolean isNew() {
        return this.mIsNew;
    }

    public void setIsNew(boolean status) {
        this.mIsNew = status;
    }

    public boolean isClientIdFromUrl() {
        return this.mIsClientIdFromUrl;
    }

    public void setIsClientIdFromUrl(boolean status) {
        this.mIsClientIdFromUrl = status;
    }

    @Override
    protected void unbind(String name) {
        this.mClientVars.remove(name);
        if (this.isClientVariable(name)) {
            scopeTL.set(Boolean.TRUE);
        }
    }

    @Override
    public void bindAsScaler(Object[] args, Object value) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            String key = (String)args[i];
            buf.append(key);
            if (key.endsWith(".") || i == args.length - 1) continue;
            buf.append(".");
        }
        this.bind(buf.toString().toLowerCase(), value);
    }

    @Override
    protected void bind(String name, Object value) {
        try {
            if (!(value instanceof UDFMethod)) {
                Cast._String(value);
            }
        }
        catch (Exception e) {
            throw new ClientScopeInvalidDataTypeException(name, e);
        }
        this.mClientVars.put(name, value);
        if (this.isClientVariable(name)) {
            scopeTL.set(Boolean.TRUE);
        }
    }

    @Override
    protected void bind_Final(String name, Object value) {
        this.bind(name, value);
    }

    private boolean isClientVariable(String name) {
        return !ReservedVariableNames.contains(name);
    }

    @Override
    protected Object resolve(String name) {
        return this.mClientVars.get(name);
    }

    @Override
    public Iterator getNames() {
        return this.mClientVars.keySet().iterator();
    }

    public void UpdateGlobals() {
        int HitCount = Cast._int(this.mClientVars.get("hitcount"));
        Integer UpdatedHitCount = new Integer(HitCount + 1);
        this.mClientVars.put("hitcount", UpdatedHitCount);
        this.mClientVars.put("lastvisit", new OleDateTime(new Date()));
    }

    public Hashtable getClientVars() {
        Hashtable ClientApplicationVars = new Hashtable();
        ClientApplicationVars.putAll(this.mClientVars);
        for (String key : ReservedVariableNames) {
            ClientApplicationVars.remove(key);
        }
        return ClientApplicationVars;
    }

    public Hashtable getGlobalVars() {
        Hashtable globals = new Hashtable();
        for (String key : ReservedVariableNames) {
            Object o = this.mClientVars.get(key);
            if (o == null) continue;
            globals.put(key, o);
        }
        return globals;
    }

    public void setPersistSettings(Properties PersistSettings) {
        this.mPersistSettings = PersistSettings;
    }

    public Properties getPersistSettings() {
        return this.mPersistSettings;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.cloneAsStruct();
    }

    public void setUseDomainCookies(String domain) {
        this.domain = domain;
    }

    public String getDomainForCookies() {
        return this.domain;
    }

    public boolean isDirty() {
        Object obj = scopeTL.get();
        if (obj == null) {
            return false;
        }
        return (Boolean)obj;
    }

    protected void markDirty() {
        scopeTL.set(Boolean.TRUE);
    }

    public synchronized void referenced() {
        ++this.refCount;
        scopeTL.set(Boolean.FALSE);
    }

    public synchronized void dereferenced() {
        --this.refCount;
        scopeTL.set(null);
    }

    public int getRefCount() {
        return this.refCount;
    }

    static {
        ReservedVariableNames.add("cfid");
        ReservedVariableNames.add("cftoken");
        ReservedVariableNames.add("urltoken");
        ReservedVariableNames.add("hitcount");
        ReservedVariableNames.add("timecreated");
        ReservedVariableNames.add("lastvisit");
    }
}

