/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.ClientScope;
import coldfusion.runtime.ClientScopeKey;
import coldfusion.runtime.ClientScopeKeyWrapper;
import coldfusion.runtime.ClientScopeService;
import coldfusion.runtime.ClientScopeServiceBase;
import coldfusion.runtime.LockManager;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.PersistenceFactory;
import coldfusion.runtime.PersistenceHelperInterface;
import coldfusion.runtime.RegistryHelper;
import coldfusion.runtime.RegistryTagInternal;
import coldfusion.runtime.RequestMonitor;
import coldfusion.server.ConfigMap;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.DataSrcImpl;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.lang.RegistryException;
import coldfusion.util.UUIDUtils;
import java.io.File;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public final class ClientScopeServiceImpl
extends ClientScopeServiceBase
implements ClientScopeService {
    private static SecureRandom _rand = new SecureRandom();
    private Hashtable mClientScopeMapByRequest = null;
    private File mFile = null;
    private ConfigMap mClientStores = null;
    private ConfigMap mClientSettings = null;
    private PersistenceFactory mFactory = null;
    private ClientScopePurger mPurger = null;
    private ClientScopeCleanUpThread mCleanupThread = null;
    Logger logger = CFLogs.SERVER_LOG;
    private Map sharedClientScopeMap;
    private static int DEFAULT_INTERVAL = 4020000;
    private long PurgeInterval = DEFAULT_INTERVAL;
    private static int TwentyFourHours = 86400000;
    private static int FIVE_MINUTES;
    private static int CS_REMOVAL_THREAD_INTERVAL;
    private static String REGISTRY_STORAGE_STR;
    private static int BatchSize;

    public ClientScopeServiceImpl(File file) {
        this.mClientScopeMapByRequest = new Hashtable();
        this.mFile = file;
        this.sharedClientScopeMap = new ConcurrentHashMap();
        this.setEnableWatch(true);
        this.setWatchFile(this.mFile);
    }

    @Override
    public Map getClientstores() {
        return this.mClientStores;
    }

    @Override
    public Map getSettings() {
        return this.mClientSettings;
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this.mFile);
            this.mClientStores = (ConfigMap)v.elementAt(0);
            this.mClientSettings = (ConfigMap)v.elementAt(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException(ex);
        }
        this.mClientStores.init(this, "client_stores");
        this.initMap(this.mClientStores, "client_stores");
        this.mClientSettings.init(this, "client_settings");
        this.mClientStores.setConfigMapListener(this);
        this.mClientSettings.setConfigMapListener(this);
        this.mFactory = new PersistenceFactory(this.mClientSettings);
        this.createPurger();
        this.createCSCleanUpThread();
    }

    private void createCSCleanUpThread() {
        SchedulerService s = ServiceFactory.getSchedulerService();
        if (this.mCleanupThread != null) {
            s.cancel(this.mCleanupThread);
        }
        this.mCleanupThread = new ClientScopeCleanUpThread(this);
        s.schedule(this.mCleanupThread, System.currentTimeMillis() + (long)CS_REMOVAL_THREAD_INTERVAL);
    }

    private void createPurger() {
        String pi = (String)this.mClientSettings.get("purge_interval");
        if (pi != null) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ClientScoptServiceImpl.load():purgeInterval - " + pi);
                }
                int sep = pi.indexOf(58);
                String hours = pi.substring(0, sep);
                String minutes = pi.substring(sep + 1, pi.length());
                int min = Integer.parseInt(minutes);
                long hrs = Integer.parseInt(hours);
                long total = hrs * 60L * 60L * 1000L + (long)(min * 60 * 1000);
                if (total < (long)FIVE_MINUTES) {
                    this.logger.warn("Using default Client Variable Purge Interval of 1 hour 7 minutes, interval supplied is too short: " + min + " minutes.");
                    total = DEFAULT_INTERVAL;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ClientScoptServiceImpl.load():purgeInterval/millis - " + total);
                }
                this.PurgeInterval = total;
            }
            catch (Throwable t) {
                this.logger.warn("Using default Client Variable Purge Interval of 1 hour 7 minutes, interval supplied cannot be used: " + pi, t);
            }
        }
        SchedulerService s = ServiceFactory.getSchedulerService();
        if (this.mPurger != null) {
            s.cancel(this.mPurger);
        }
        this.mPurger = new ClientScopePurger(this);
        s.schedule(this.mPurger, System.currentTimeMillis() + this.PurgeInterval);
    }

    @Override
    public String GetDefaultDSN() {
        return (String)this.mClientSettings.get("default");
    }

    @Override
    public boolean IsValidDSN(String dsn) {
        Enumeration e = this.mClientStores.elements();
        boolean rc = false;
        while (e.hasMoreElements()) {
            ConfigMap map = (ConfigMap)e.nextElement();
            String clientdsn = (String)map.get("name");
            if (!clientdsn.equalsIgnoreCase(dsn)) continue;
            rc = true;
            break;
        }
        return rc;
    }

    @Override
    public void store() throws ServiceException {
        super.store();
        this.createPurger();
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.addElement(this.mClientStores);
        v.addElement(this.mClientSettings);
        this.serialize(v, this.mFile);
    }

    @Override
    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    @Override
    public void store(Object key, Object value, Object oldValue, boolean broadcast) throws ServiceException {
        super.store();
        this.createPurger();
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.addElement(this.mClientStores);
        v.addElement(this.mClientSettings);
        this.serialize(v, this.mFile, broadcast, key, value, oldValue);
    }

    private synchronized Map getPerThreadClientScopes() {
        FusionContext context = FusionContext.getCurrent();
        Hashtable t = (Hashtable)this.mClientScopeMapByRequest.get(context);
        if (t == null) {
            t = new Hashtable();
            this.mClientScopeMapByRequest.put(context, t);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientScope GetClientScope(NeoPageContext pageContext, ClientScopeKey key, Properties PersistSettings, String newCFID, String newCFToken) {
        Map PerRequestClientScopeMap = this.getPerThreadClientScopes();
        ClientScope clientScope = (ClientScope)PerRequestClientScopeMap.get(key);
        if (clientScope == null) {
            clientScope = (ClientScope)this.sharedClientScopeMap.get(key);
        }
        if (clientScope == null) {
            String lockName = key.hashCode() + "ClientScopeService";
            boolean lockObtained = false;
            try {
                LockManager.get().requestNamedLock(lockName, false, this.getLockTimeOut());
                lockObtained = true;
                clientScope = (ClientScope)this.sharedClientScopeMap.get(key);
                if (clientScope == null) {
                    PersistenceHelperInterface Helper = this.mFactory.getPersistentHelper(PersistSettings);
                    clientScope = Helper.Get(pageContext, key);
                    clientScope.setPersistSettings(PersistSettings);
                }
            }
            catch (InterruptedException e) {
                this.mLogger.warn("Could not obtain the lock for client scope. The lock obtained on it might not have been released.");
            }
            finally {
                if (lockObtained) {
                    LockManager.get().releaseNamedLock(lockName, false);
                }
            }
        }
        ClientScope clientScope2 = clientScope;
        synchronized (clientScope2) {
            if (newCFID != null && newCFToken != null) {
                this.sharedClientScopeMap.remove(key);
                key.mCFID = newCFID;
                key.mCFToken = newCFToken;
            }
            clientScope.referenced();
            this.sharedClientScopeMap.put(key, clientScope);
        }
        PerRequestClientScopeMap.put(key, clientScope);
        return clientScope;
    }

    private long getLockTimeOut() {
        long requestTimeout = RequestMonitor.getRequestTimeout();
        requestTimeout = requestTimeout == 0L ? 120L : requestTimeout;
        return requestTimeout * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void PersistClientVariablesForRequest() {
        FusionContext context = FusionContext.getCurrent();
        Hashtable table = (Hashtable)this.mClientScopeMapByRequest.get(context);
        if (table != null) {
            try {
                Enumeration ie = table.elements();
                while (ie.hasMoreElements()) {
                    ClientScope scope = (ClientScope)ie.nextElement();
                    boolean globalUpdateDisabled = this.isGlobalUpdateDisabled(scope);
                    try {
                        if (globalUpdateDisabled && !scope.isDirty()) continue;
                        scope.UpdateGlobals();
                        this.PersistClientVariables(context.pageContext, scope, globalUpdateDisabled);
                    }
                    finally {
                        ClientScope clientScope = scope;
                        synchronized (clientScope) {
                            scope.dereferenced();
                            if (scope.getRefCount() == 0) {
                                this.sharedClientScopeMap.remove(scope.getKey());
                            }
                        }
                    }
                }
            }
            finally {
                this.mClientScopeMapByRequest.remove(context);
            }
        }
    }

    private void PersistClientVariables(NeoPageContext pageContext, ClientScope clientScope, boolean globalUpdateDisabled) {
        Properties settings = clientScope.getPersistSettings();
        PersistenceHelperInterface Helper = this.mFactory.getPersistentHelper(settings);
        Helper.Store(pageContext, clientScope, globalUpdateDisabled);
    }

    @Override
    public void removeRenewedClientStores() {
        if (!removableClientScopeKeys.isEmpty()) {
            this.mLogger.debug("Run Client Storage Clean up thread for the renewed Client Stores due to Session rotation.");
            HashMap<String, LinkedList> jdbcStorageCSMap = new HashMap<String, LinkedList>();
            LinkedList<ClientScopeKey> toRemoveRegistryList = new LinkedList<ClientScopeKey>();
            ListIterator listIterator = removableClientScopeKeys.listIterator();
            while (listIterator.hasNext()) {
                ClientScopeKeyWrapper removableCSKey = (ClientScopeKeyWrapper)listIterator.next();
                if (System.currentTimeMillis() < removableCSKey.getTimeToLive()) continue;
                String storage = removableCSKey.getClientStorage();
                if (!storage.equalsIgnoreCase("cookie")) {
                    if (storage.equalsIgnoreCase("registry")) {
                        toRemoveRegistryList.add(removableCSKey.getClientScopeKey());
                    } else {
                        LinkedList listForDSN = jdbcStorageCSMap.containsKey(storage) ? (LinkedList)jdbcStorageCSMap.get(storage) : new LinkedList();
                        listForDSN.add(removableCSKey.getClientScopeKey());
                        jdbcStorageCSMap.put(storage, listForDSN);
                    }
                }
                listIterator.remove();
            }
            PersistenceHelperInterface helper = null;
            if (!toRemoveRegistryList.isEmpty()) {
                helper = this.mFactory.getPersistentHelper(REGISTRY_STORAGE_STR);
                helper.remove(toRemoveRegistryList);
                toRemoveRegistryList = null;
            }
            if (!jdbcStorageCSMap.isEmpty()) {
                Set dsnNames = jdbcStorageCSMap.keySet();
                for (String dsnName : dsnNames) {
                    ConfigMap clientStoreMetadata;
                    String useClientVarPurgeFlagForCleanUp = System.getProperty("useClientVarPurgeFlagForCleanUp");
                    if (useClientVarPurgeFlagForCleanUp != null && Boolean.valueOf(useClientVarPurgeFlagForCleanUp).booleanValue() && (clientStoreMetadata = (ConfigMap)this.mClientStores.get(dsnName)) != null && !((Boolean)clientStoreMetadata.get("purge")).booleanValue()) continue;
                    helper = this.mFactory.getPersistentHelper(dsnName);
                    helper.remove((LinkedList)jdbcStorageCSMap.get(dsnName));
                    jdbcStorageCSMap.remove(dsnName);
                }
                jdbcStorageCSMap = null;
            }
        }
        SchedulerService s = ServiceFactory.getSchedulerService();
        s.schedule(this.mCleanupThread, System.currentTimeMillis() + (long)CS_REMOVAL_THREAD_INTERVAL);
    }

    @Override
    public void UpdateGlobals(NeoPageContext pageContext, ClientScope clientScope) {
        if (!this.isGlobalUpdateDisabled(clientScope)) {
            clientScope.UpdateGlobals();
        }
    }

    private boolean isGlobalUpdateDisabled(ClientScope clientScope) {
        String DefaultStorage = (String)this.mClientSettings.get("default");
        Properties settings = clientScope.getPersistSettings();
        String storage = settings.getProperty("clientstorage", DefaultStorage);
        Enumeration e = this.mClientStores.elements();
        Boolean rc = Boolean.FALSE;
        while (e.hasMoreElements()) {
            ConfigMap map = (ConfigMap)e.nextElement();
            String clientdsn = (String)map.get("name");
            if (!clientdsn.equalsIgnoreCase(storage)) continue;
            rc = (Boolean)map.get("disable_globals");
            break;
        }
        return rc;
    }

    private void DeleteClient(String key) {
        RegistryTagInternal tag = new RegistryTagInternal();
        tag.setAction("delete");
        tag.setType("any");
        tag.setBranch(key);
        try {
            tag.doStartTag();
        }
        catch (RegistryException registryException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Date CheckClient(String key) {
        Date lastVisit = null;
        RegistryTagInternal tag = new RegistryTagInternal();
        tag.setAction("getall");
        tag.setType("string");
        tag.setBranch(key);
        tag.setName("_ClientValue");
        try {
            tag.doStartTag();
        }
        catch (RegistryException re) {
            this.mLogger.info(re.getMessage());
        }
        catch (Exception e) {
            this.mLogger.info(e.getMessage());
        }
        QueryTable table = (QueryTable)tag.getVariable("_ClientValue");
        if (table != null) {
            while (table.next()) {
                String entry = table.getString("entry").toLowerCase();
                String value = table.getString("value");
                if (!entry.equalsIgnoreCase("lastvisit")) continue;
                try {
                    lastVisit = CFPage.ParseDateTime(value);
                }
                catch (Exception exception) {}
                break;
            }
        }
        return lastVisit;
    }

    private void PurgeRegistry() {
        Enumeration e = this.mClientStores.elements();
        Number timeout = null;
        Boolean purge = Boolean.FALSE;
        Date now = new Date();
        while (e.hasMoreElements()) {
            ConfigMap map = (ConfigMap)e.nextElement();
            String clientdsn = (String)map.get("name");
            if (!clientdsn.equalsIgnoreCase("registry")) continue;
            timeout = (Number)map.get("timeout");
            purge = (Boolean)map.get("purge");
            break;
        }
        if (!purge.booleanValue()) {
            return;
        }
        if (timeout == null) {
            this.mLogger.info("Error: Registry client variable [timeout] value set to null.");
            return;
        }
        double timespan = timeout.doubleValue() * (double)TwentyFourHours;
        boolean BranchExist = true;
        RegistryTagInternal tag = new RegistryTagInternal();
        try {
            tag.setAction("getall");
            tag.setBranch(RegistryHelper.CLIENTS_ROOT);
            tag.setType("key");
            tag.setName("_ClientKeys");
            tag.setStartrow("0");
            tag.setMaxrows(Integer.toString(BatchSize));
            tag.doStartTag();
        }
        catch (RegistryException re) {
            BranchExist = false;
        }
        catch (Exception ex) {
            this.mLogger.info(ex.getMessage());
        }
        if (!BranchExist) {
            return;
        }
        String marker = null;
        block7: while (true) {
            try {
                while (true) {
                    QueryTable table;
                    if ((table = (QueryTable)tag.getVariable("_ClientKeys")) != null) {
                        int rowcount = table.getRowCount();
                        if (rowcount == 0) break block7;
                        if (marker != null) {
                            String MarkerKey = RegistryHelper.CLIENTS_ROOT + "\\" + marker;
                            Date lastVisit = this.CheckClient(MarkerKey);
                            if (lastVisit != null) {
                                if ((double)(now.getTime() - lastVisit.getTime()) > timespan) {
                                    this.DeleteClient(MarkerKey);
                                }
                            } else {
                                this.DeleteClient(MarkerKey);
                            }
                        }
                        if (rowcount == BatchSize) {
                            table.last();
                            marker = table.getString("entry").toLowerCase();
                            table.beforeFirst();
                        } else {
                            marker = null;
                        }
                        while (table.next()) {
                            String entry = table.getString("entry").toLowerCase();
                            if (marker != null && marker.equals(entry)) break;
                            String key = RegistryHelper.CLIENTS_ROOT + "\\" + entry;
                            Date lastVisit = this.CheckClient(key);
                            if (lastVisit != null) {
                                if (!((double)(now.getTime() - lastVisit.getTime()) > timespan)) continue;
                                this.DeleteClient(key);
                                continue;
                            }
                            this.DeleteClient(key);
                        }
                    }
                    if (marker == null) break block7;
                    tag.setAction("getall");
                    tag.setBranch(RegistryHelper.CLIENTS_ROOT);
                    tag.setType("key");
                    tag.setName("_ClientKeys");
                    tag.setMaxrows(Integer.toString(BatchSize));
                    tag.setGetAllStartKeyStr(marker);
                    tag.doStartTag();
                }
            }
            catch (RegistryException table) {
                continue;
            }
            catch (Exception ex) {
                this.mLogger.info(ex.getMessage());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void PurgeExpiredClients() {
        this.PurgeRegistry();
        Enumeration e = this.mClientStores.elements();
        Date now = new Date();
        while (e.hasMoreElements()) {
            ConfigMap map = (ConfigMap)e.nextElement();
            String clientdsn = (String)map.get("name");
            String type = (String)map.get("type");
            if (!type.equalsIgnoreCase("jdbc")) continue;
            Number timeout = (Number)map.get("timeout");
            Boolean purge = (Boolean)map.get("purge");
            if (!purge.booleanValue()) continue;
            if (timeout == null) {
                this.mLogger.info("Error: Database client variable [timeout] value null for datasource " + clientdsn);
                continue;
            }
            long timespan = timeout.longValue() * 24L * 60L * 60L * 1000L;
            Connection dbConnection = null;
            boolean trans_supported = true;
            try {
                DataSrcImpl ds = DataSrcImpl.getSqlProxy();
                ds.setDatasrc(clientdsn);
                ds.validate();
                dbConnection = ds.getConnection();
                trans_supported = dbConnection.getMetaData().supportsTransactions();
                if (trans_supported) {
                    dbConnection.setAutoCommit(false);
                }
                Timestamp t = new Timestamp(now.getTime() - timespan);
                String Sql = "delete FROM CDATA WHERE cfid in (SELECT cfid from CGLOBAL where CGLOBAL.lvisit < ?)";
                PreparedStatement ps = dbConnection.prepareStatement(Sql);
                ps.setTimestamp(1, t);
                ps.executeUpdate();
                ps.close();
                Sql = "delete FROM CGLOBAL WHERE CGLOBAL.lvisit < ?";
                ps = dbConnection.prepareStatement(Sql);
                ps.setTimestamp(1, t);
                ps.executeUpdate();
                ps.close();
                if (!trans_supported) continue;
                dbConnection.commit();
            }
            catch (Exception ex) {
                try {
                    if (!trans_supported) continue;
                    dbConnection.rollback();
                }
                catch (Exception exception) {}
                continue;
                finally {
                    this.mLogger.warn(ex.getMessage());
                }
            }
            finally {
                try {
                    dbConnection.close();
                }
                catch (Throwable ex) {
                    this.mLogger.warn("DSN[" + clientdsn + "] - message is " + ex.getMessage());
                }
            }
        }
        SchedulerService s = ServiceFactory.getSchedulerService();
        s.schedule(this.mPurger, System.currentTimeMillis() + this.PurgeInterval);
    }

    private String GetEightDigitRandom() {
        int num = _rand.nextInt(90000000);
        return Integer.toString(num += 10000000);
    }

    private String GetSixteenDigitRandom() {
        long num = _rand.nextLong();
        return Long.toHexString(num);
    }

    @Override
    public String GetCFTOKEN() {
        Boolean UUIDToken = (Boolean)this.mClientSettings.get("uuidtoken");
        if (UUIDToken.booleanValue()) {
            return this.GetSixteenDigitRandom() + "-" + UUIDUtils.createUUID(true);
        }
        return this.GetEightDigitRandom();
    }

    @Override
    public boolean isUUIDEnabled() {
        return (Boolean)this.mClientSettings.get("uuidtoken");
    }

    @Override
    public void setUUIDEnabled(boolean flag) {
        this.mClientSettings.put("uuidtoken", (Object)flag);
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("client_stores.keys", "");
            this.rb.put("client_stores.types", "");
            this.rb.put("client_stores.formats", "coldfusion.server.MapFormatter");
            this.rb.put("client_stores.value", "client_store");
            this.rb.put("client_store.keys", "name,type,description,dsn,timeout,disable_globals,purge");
            this.rb.put("client_store.types", "");
            this.rb.put("client_store.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter");
            this.rb.put("client_settings.keys", "default,uuidtoken,purge_interval");
            this.rb.put("client_settings.types", "");
            this.rb.put("client_settings.formats", "coldfusion.server.StringFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.StringFormatter");
        }
        return this.rb;
    }

    static {
        CS_REMOVAL_THREAD_INTERVAL = FIVE_MINUTES = 300000;
        REGISTRY_STORAGE_STR = "registry";
        BatchSize = 5000;
    }

    final class ClientScopePurger
    implements Runnable {
        private ClientScopeService service = null;

        public ClientScopePurger(ClientScopeService service) {
            this.service = service;
        }

        @Override
        public void run() {
            ClientScopeServiceImpl.this.mLogger.info("Run Client Storage Purge");
            this.service.PurgeExpiredClients();
        }
    }

    final class ClientScopeCleanUpThread
    implements Runnable {
        private ClientScopeService service = null;

        public ClientScopeCleanUpThread(ClientScopeService service) {
            this.service = service;
        }

        @Override
        public void run() {
            this.service.removeRenewedClientStores();
        }
    }
}

