/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CloneableMap;
import coldfusion.runtime.Copyable;
import coldfusion.runtime.ExpressionException;
import coldfusion.sql.QueryTable;
import coldfusion.util.RuntimeWrapper;
import com.allaire.cfx.Query;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;

public class Cloner {
    private static Method findCloneMethod(Object obj) throws NoSuchMethodException {
        Class[] argTypes = new Class[]{};
        return obj.getClass().getMethod("clone", argTypes);
    }

    private static Object callCloneMethod(Method method) throws Throwable {
        try {
            Object[] args = new Object[]{};
            return method.invoke((Object)"clone", args);
        }
        catch (InvocationTargetException wrapper) {
            try {
                throw wrapper.getTargetException();
            }
            catch (Exception ex) {
                throw ex;
            }
            catch (Error ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RuntimeWrapper(ex);
            }
        }
    }

    public static Object clone(Cloneable obj) throws Throwable {
        if (obj instanceof CloneableMap) {
            return (Map)((CloneableMap)obj).clone();
        }
        if (obj instanceof HashMap) {
            return ((HashMap)obj).clone();
        }
        if (obj instanceof Hashtable) {
            return ((Hashtable)obj).clone();
        }
        if (obj instanceof ArrayList) {
            return ((ArrayList)obj).clone();
        }
        if (obj instanceof LinkedList) {
            return ((LinkedList)obj).clone();
        }
        if (obj instanceof Vector) {
            return ((Vector)obj).clone();
        }
        Method m = Cloner.findCloneMethod(obj);
        return Cloner.callCloneMethod(m);
    }

    public static Object clone(Object obj) throws CloneNotSupportedException {
        if (Objects.isNull(obj)) {
            return obj;
        }
        if (obj instanceof Copyable) {
            return ((Copyable)obj).clone();
        }
        if (obj instanceof Throwable) {
            return Cast._Map(obj);
        }
        if (obj.getClass().isArray()) {
            return Cloner.getJavaArrayClone(obj);
        }
        if (CFPage.IsQuery(obj)) {
            return Cloner.handleQueryObjects(obj);
        }
        return obj;
    }

    private static QueryTable handleQueryObjects(Object obj) {
        try {
            if (obj instanceof QueryTable) {
                return ((QueryTable)obj).getShallowCopy();
            }
            return new QueryTable((Query)obj);
        }
        catch (Exception e) {
            throw new UnableToCloneException(e);
        }
    }

    private static Object getJavaArrayClone(Object obj) {
        int len = Array.getLength(obj);
        Object clonedObject = Array.newInstance(obj.getClass().getComponentType(), len);
        System.arraycopy(obj, 0, clonedObject, 0, len);
        return clonedObject;
    }

    public static class UnableToCloneException
    extends ExpressionException {
        public UnableToCloneException(Throwable throwable) {
            super(throwable);
        }
    }
}

