/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.CFClosureDummyComponent;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.ClosureLocalScope;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.VariableScope;

public abstract class Closure
extends UDFMethod {
    private final String ANONYMOUS_CLOSURE_PREFIX = "_CF_ANONYMOUSCLOSURE_";
    protected LocalScope functionScope;
    protected VariableScope varScope;
    protected NeoPageContext pageContext;
    protected CFPage invokePage;

    public Closure() {
        FusionContext fusionContext = FusionContext.getCurrent();
        NeoPageContext npg = fusionContext.pageContext;
        this.varScope = npg.getVariableScope();
        this.invokePage = new CFClosureDummyComponent(npg.page);
        this.invokePage.initialize(npg.getTopPageContext(), null);
        this.pageContext = this.invokePage.pageContext;
        this.functionScope = npg.getActiveFunctionLocalScope();
        if (this.varScope != null) {
            this.pageContext.setVariableScope(this.varScope);
        }
    }

    public boolean isAnonymousClosure() {
        return this.getName().startsWith("_CF_ANONYMOUSCLOSURE_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(FusionContext context) throws Throwable {
        LocalScope localScope;
        if (context.isParallelCall()) {
            LocalScope localScope2;
            NeoPageContext threadLocalPageContext = context.pageContext;
            threadLocalPageContext.setFusionContext(context);
            if (this.superScope != null) {
                threadLocalPageContext.pushSuperScope(this.superScope);
            }
            String oldPagePath = context.getPagePath();
            context.setPagePath(this.getPagePath());
            NeoPageContext oldPageContext = context.pageContext;
            context.pageContext = threadLocalPageContext;
            if (this.functionScope != null) {
                localScope2 = new ClosureLocalScope(this.functionScope);
                threadLocalPageContext.pushNewFunctionLocalScope(localScope2);
            } else {
                localScope2 = threadLocalPageContext.pushNewFunctionLocalScope();
            }
            CFPage parentPageClone = null;
            try {
                ArgumentCollection args = context.args;
                parentPageClone = (CFPage)this.invokePage._clone();
                parentPageClone.pageContext = threadLocalPageContext;
                context.returnValue = this.runFunction(localScope2, context.instance, parentPageClone, args);
            }
            finally {
                this.restoreFusionContext(context, oldPagePath, oldPageContext);
                if (parentPageClone != null) {
                    parentPageClone.releaseTags(true);
                }
            }
        }
        this.pageContext.initializeWith(context.pageContext);
        if (this.iscfthread) {
            localScope = this.pageContext.setupThreadLocalScope();
        } else if (this.functionScope != null) {
            localScope = new ClosureLocalScope(this.functionScope);
            this.pageContext.pushNewFunctionLocalScope(localScope);
        } else {
            localScope = this.pageContext.pushNewFunctionLocalScope();
        }
        this.pageContext.setFusionContext(context);
        if (this.superScope != null) {
            this.pageContext.pushSuperScope(this.superScope);
        }
        String oldPagePath = context.getPagePath();
        context.setPagePath(this.getPagePath());
        NeoPageContext oldPageContext = context.pageContext;
        context.pageContext = this.pageContext;
        boolean releaseTags = false;
        try {
            ArgumentCollection args = context.args;
            releaseTags = true;
            context.returnValue = this.runFunction(localScope, context.instance, this.invokePage, args);
        }
        finally {
            this.restoreFusionContext(context, oldPagePath, oldPageContext);
            if (releaseTags && this.invokePage != null) {
                this.invokePage.releaseTags(true);
            }
        }
    }

    private void restoreFusionContext(FusionContext context, String oldPagePath, NeoPageContext oldPageContext) {
        RequestMonitorData rmd;
        if (Configuration.INSTANCE.isCodeProfilerOn() && Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled() && (rmd = RequestMonitorData.getCurrent()) != null) {
            rmd.removeVariableStat("THIS", 0);
            rmd.removeVariableStat("ARGUMENTS", 0);
        }
        context.setPagePath(oldPagePath);
        this.pageContext.popFunctionLocalScope();
        if (this.superScope != null) {
            this.pageContext.popSuperScope();
        }
        context.pageContext = oldPageContext;
    }

    private void copyFunctionAgrumentToClosureLocalScope(LocalScope localScope, ArgumentCollection arguments) {
        if (arguments == null) {
            return;
        }
        for (Object key : arguments.keySet()) {
            localScope.put(key, arguments.get(key));
        }
    }
}

