/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.cfc.ComponentProxyFactory;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.ComponentTemplateProxyCacheType;
import coldfusion.runtime.HashMapBasedComponentProxyCache;
import coldfusion.runtime.InterfaceRuntimeExceptions;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.SoftCacheBasedComponentProxyCache;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.server.ServiceFactory;
import coldfusion.util.Utils;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;

public class ComponentTemplateProxyCache {
    private ComponentTemplateProxyCacheType proxyCache;
    private static ComponentTemplateProxyCache theInstance = new ComponentTemplateProxyCache();

    private ComponentTemplateProxyCache() {
        String proxyType = System.getProperty("IProxyCacheType");
        this.proxyCache = proxyType != null && proxyType.equals("2") ? new HashMapBasedComponentProxyCache() : new SoftCacheBasedComponentProxyCache();
    }

    public static ComponentTemplateProxyCache getInstance() {
        return theInstance;
    }

    private String getSiteNamePrefixedKey(String path) {
        Object prefixedPath = path;
        FusionContext.getCurrent();
        String siteName = FusionContext.getSiteName();
        if (siteName != null) {
            siteName = siteName.trim();
            prefixedPath = siteName + path;
        }
        return prefixedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateProxy getTemplateProxyFromChildPath(TemplateProxy childProxy, String parent, String childFullName, NeoPageContext pageContext, HashSet parentClasses) throws Throwable {
        HashMap tmpObj;
        TemplateProxy proxy = null;
        String parentKey = this.getSiteNamePrefixedKey(parent);
        if (parentClasses == null) {
            parentClasses = new HashSet();
        }
        if ((tmpObj = this.proxyCache.get(parentKey)) != null) {
            HashMap info = tmpObj;
            if (ServiceFactory.getRuntimeService().isTrustedCache()) {
                proxy = this.proxyCache.getProxyFromInfoMap(info);
            } else {
                long creationTime = 0L;
                HashMap hashMap = info;
                synchronized (hashMap) {
                    creationTime = (Long)info.get("CreationTime");
                }
                long fileLastModified = TemplateClassLoader.getLastModifiedTime(this.proxyCache.getProxyFromInfoMap((HashMap)info).page.getPagePath());
                if (fileLastModified <= creationTime) {
                    proxy = this.proxyCache.getProxyFromInfoMap(info);
                }
            }
        }
        if (proxy == null) {
            File resolvedChildFile = new File(childProxy.page.getPagePath());
            Object[] superInfo = null;
            try {
                superInfo = TemplateProxyFactory.resolveSuperPath(resolvedChildFile, parent, childFullName, pageContext);
            }
            catch (TemplateProxyFactory.InvalidComponentNameException e) {
                InterfaceRuntimeExceptions.throwInvalidSuperNameException(parent, childFullName);
            }
            File superFile = (File)superInfo[0];
            String superName = superInfo[1] == null ? parent : (String)superInfo[1];
            proxy = TemplateProxyFactory.resolveName(proxy, FusionContext.getCurrent().pageContext, Utils.getCanonicalFile(superFile.getPath()), superName, true, null, null, false);
            long creationTime = Calendar.getInstance().getTime().getTime();
            this.setTemplateProxy(parentKey, proxy, creationTime);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateProxy getTemplateProxyFromPath(String componentPath, NeoPageContext pageContext, HashSet parentClasses) throws Throwable {
        HashMap tmpObj;
        TemplateProxy proxy = null;
        String compKey = this.getSiteNamePrefixedKey(componentPath);
        if (parentClasses == null) {
            parentClasses = new HashSet();
        }
        if ((tmpObj = this.proxyCache.get(compKey)) != null) {
            HashMap info = tmpObj;
            if (ServiceFactory.getRuntimeService().isTrustedCache()) {
                proxy = this.proxyCache.getProxyFromInfoMap(info);
            } else {
                long creationTime = 0L;
                HashMap hashMap = info;
                synchronized (hashMap) {
                    creationTime = (Long)info.get("CreationTime");
                }
                long fileLastModified = TemplateClassLoader.getLastModifiedTime(this.proxyCache.getProxyFromInfoMap((HashMap)info).page.getPagePath());
                if (fileLastModified <= creationTime) {
                    proxy = this.proxyCache.getProxyFromInfoMap(info);
                }
            }
        }
        if (proxy == null) {
            String importList = null;
            FusionContext context = FusionContext.getCurrent();
            if (context.parent != null) {
                importList = context.parent.importList;
            }
            Object[] objects = TemplateProxyFactory.getTemplateFileHelper(componentPath, pageContext, importList);
            File cfcFile = (File)objects[0];
            String fullName = (String)objects[1];
            proxy = TemplateProxyFactory.resolveName(null, FusionContext.getCurrent().pageContext, cfcFile, fullName, true, null, null, false);
            long creationTime = Calendar.getInstance().getTime().getTime();
            this.setTemplateProxy(compKey, proxy, creationTime);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasComponentChanged(String componentPath, NeoPageContext pageContext, HashSet parentClasses) throws Throwable {
        HashMap tmpObj;
        boolean hasChanged = false;
        TemplateProxy proxy = null;
        if (parentClasses == null) {
            parentClasses = new HashSet();
        }
        if ((tmpObj = this.proxyCache.get(componentPath)) != null) {
            HashMap info = tmpObj;
            if (ServiceFactory.getRuntimeService().isTrustedCache()) {
                hasChanged = false;
            } else {
                long creationTime = 0L;
                HashMap hashMap = info;
                synchronized (hashMap) {
                    creationTime = (Long)info.get("CreationTime");
                }
                long fileLastModified = TemplateClassLoader.getLastModifiedTime(this.proxyCache.getProxyFromInfoMap((HashMap)info).page.getPagePath());
                if (fileLastModified <= creationTime) {
                    hasChanged = false;
                    proxy = this.proxyCache.getProxyFromInfoMap(info);
                }
            }
        }
        if (proxy == null) {
            proxy = (TemplateProxy)ComponentProxyFactory.getProxy(componentPath, FusionContext.getCurrent().pageContext, null, null, false, false, false);
            long creationTime = Calendar.getInstance().getTime().getTime();
            this.setTemplateProxy(componentPath, proxy, creationTime);
            hasChanged = true;
        }
        return hasChanged;
    }

    public TemplateProxy setTemplateProxy(String filePath, TemplateProxy proxy, long creationTime) {
        proxy.setProxyCreationTime(0L);
        HashMap<String, Serializable> info = new HashMap<String, Serializable>();
        info.put("proxy", proxy);
        info.put("CreationTime", Long.valueOf(creationTime));
        this.proxyCache.put(filePath, info);
        return proxy;
    }
}

