/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.CFCookie;
import coldfusion.runtime.ClientScope;
import coldfusion.runtime.ClientScopeKey;
import coldfusion.runtime.ClientUtil;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.PersistenceHelperInterface;
import coldfusion.tagext.net.CookieTag;
import coldfusion.util.URLDecoder;
import coldfusion.util.URLEncoder;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;

final class CookieHelper
implements PersistenceHelperInterface {
    private static String DataCookiePrefix = "CFCLIENT_";
    static String GlobalCookie = "CFGLOBALS";

    CookieHelper() {
    }

    @Override
    public ClientScope Get(NeoPageContext pageContext, ClientScopeKey key) {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        Cookie[] cookies = request.getCookies();
        String cookieName = this.GetCookieName(key.mApplicationName);
        String clientVarStr = null;
        String globalVarStr = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (cookie.getName().equalsIgnoreCase(cookieName)) {
                    try {
                        clientVarStr = URLDecoder.decode(cookie.getValue());
                    }
                    catch (IllegalArgumentException e) {
                        clientVarStr = cookie.getValue();
                    }
                }
                if (!cookie.getName().equalsIgnoreCase(GlobalCookie)) continue;
                try {
                    globalVarStr = URLDecoder.decode(cookie.getValue());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    globalVarStr = cookie.getValue();
                }
            }
        }
        Hashtable clientData = ClientUtil.UnPack(clientVarStr);
        Hashtable clientGlobal = ClientUtil.UnPack(globalVarStr);
        if (clientGlobal.size() < 5) {
            Date now = new Date();
            clientGlobal.put("timecreated", now);
            clientGlobal.put("lastvisit", now);
            clientGlobal.put("hitcount", new Integer(1));
            clientGlobal.put("cfid", key.mCFID);
            clientGlobal.put("cftoken", key.mCFToken);
        }
        clientData.putAll(clientGlobal);
        ClientScope retval = new ClientScope(pageContext, key, clientData);
        retval.setIsNew(clientVarStr == null && globalVarStr == null);
        return retval;
    }

    private String GetCookieName(String ApplicationName) {
        StringBuilder strbuf = new StringBuilder(ApplicationName);
        int length = strbuf.length();
        for (int i = 0; i < length; ++i) {
            if (strbuf.charAt(i) != ' ') continue;
            strbuf.setCharAt(i, '_');
        }
        strbuf.insert(0, DataCookiePrefix);
        return strbuf.toString();
    }

    @Override
    public final void Store(NeoPageContext pageContext, ClientScope clientScope, boolean globalUpdateDisabled) {
        Hashtable clientVars = clientScope.getClientVars();
        Hashtable globalVars = clientScope.getGlobalVars();
        String clientStr = ClientUtil.Pack(clientVars);
        String globalStr = ClientUtil.Pack(globalVars);
        ClientScopeKey key = clientScope.getKey();
        String domain = clientScope.getDomainForCookies();
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        Object path = ((HttpServletRequest)pageContext.getRequest()).getContextPath();
        if (((String)path).equals("") || !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if (clientScope.isDirty()) {
            CFCookie ClientDataCookie = new CFCookie(this.GetCookieName(key.mApplicationName).toUpperCase(), URLEncoder.encode(clientStr));
            if (domain != null) {
                ClientDataCookie.setDomain(domain);
            }
            ClientDataCookie.setPath((String)path);
            ClientDataCookie.setMaxAge(CookieTag.Max_Cookie_Age);
            pageContext.setAttribute("COOKIE." + ClientDataCookie.getName(), (Object)ClientDataCookie);
        }
        if (!globalUpdateDisabled || clientScope.isDirty()) {
            CFCookie ClientGlobalCookie = new CFCookie(GlobalCookie, URLEncoder.encode(globalStr), domain);
            ClientGlobalCookie.setPath((String)path);
            ClientGlobalCookie.setMaxAge(CookieTag.Max_Cookie_Age);
            pageContext.setAttribute("COOKIE." + ClientGlobalCookie.getName(), (Object)ClientGlobalCookie);
        }
    }

    @Override
    public void remove(LinkedList<ClientScopeKey> clientScopeKey) {
    }
}

