/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.NeoException;
import coldfusion.runtime.Struct;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class DatabaseException
extends NeoException {
    private static final long serialVersionUID = 1L;
    protected String datasource;
    protected String sql;
    protected ArrayList<Struct> exceptions;
    protected int nativeerrorcode = 0;
    protected String sqlstate = "n/a";

    public DatabaseException() {
    }

    public DatabaseException(Throwable e) {
        super(e);
        if (e instanceof SQLException) {
            this.nativeerrorcode = ((SQLException)e).getErrorCode();
            this.sqlstate = ((SQLException)e).getSQLState();
            this.exceptions = new ArrayList();
            for (SQLException ex = (SQLException)e; ex != null; ex = ex.getNextException()) {
                Struct excep = new Struct();
                excep.put("class", (Object)ex.getClass().getName());
                excep.put("message", (Object)ex.getMessage());
                for (Throwable t = ex.getCause(); t != null; t = t.getCause()) {
                    ArrayList<Throwable> causes = new ArrayList<Throwable>();
                    causes.add(t);
                    excep.put("causes", (Object)causes);
                }
                this.exceptions.add(excep);
            }
        }
    }

    public DatabaseException(String datasource, String sql, Throwable e) {
        this(e);
        this.datasource = datasource;
        this.sql = sql;
    }

    public int getNativeErrorCode() {
        return this.nativeerrorcode;
    }

    public String getErrorCode() {
        return this.getSQLState();
    }

    public String getSQLState() {
        if (this.sqlstate == null) {
            return "n/a";
        }
        return this.sqlstate;
    }

    public String getDataSource() {
        return this.datasource;
    }

    public String getSql() {
        return this.sql;
    }

    public ArrayList<Struct> getExceptions() {
        return this.exceptions;
    }
}

