/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import java.time.DayOfWeek;
import java.time.Month;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Stream;

public class DateTimeString {
    private final String str;
    final int length;
    int currentPos;
    private static final String[] months;
    private static final String[] days;
    private static final Map<String, Integer> monthsMap;
    private static final Map<String, Integer> daysMap;
    private static final Map<String, String> psuedoTimeZoneNames;

    public DateTimeString(String str) {
        this.str = str;
        this.length = str.length();
    }

    public char getCurrent() {
        return this.str.charAt(this.currentPos);
    }

    public boolean moveIfSpaces() {
        int temp = this.currentPos;
        while (this.isCurrentASpace()) {
            ++this.currentPos;
        }
        return temp != this.currentPos;
    }

    public boolean moveIfCurrent(char c) {
        if (this.isCurrent(c)) {
            ++this.currentPos;
            return true;
        }
        return false;
    }

    public boolean moveIfCurrentIgnoreSpaces(char c) {
        int temp = this.currentPos;
        while (this.currentPos < this.length && Character.isWhitespace(this.getCurrent())) {
            ++this.currentPos;
        }
        if (this.isCurrent(c)) {
            ++this.currentPos;
            return true;
        }
        this.currentPos = temp;
        return false;
    }

    public boolean moveIfDelimiter() {
        return this.moveIfDelimiter(false);
    }

    public boolean moveIfDelimiter(boolean includeT) {
        char c;
        int temp = this.currentPos;
        while (this.currentPos < this.length && Character.isWhitespace(this.str.charAt(this.currentPos))) {
            ++this.currentPos;
        }
        if (this.currentPos < this.length && ((c = this.getCurrent()) == '-' || c == '/' || c == ',' || c == '.' || includeT && (c == 'T' || c == 't'))) {
            ++this.currentPos;
            while (this.currentPos < this.length && Character.isWhitespace(this.str.charAt(this.currentPos))) {
                ++this.currentPos;
            }
            return true;
        }
        this.currentPos = temp;
        return false;
    }

    public boolean moveIfDelimiter(char c) {
        int temp = this.currentPos;
        while (this.currentPos < this.length && Character.isWhitespace(this.str.charAt(this.currentPos))) {
            ++this.currentPos;
        }
        if (this.isCurrentIgnorecase(c)) {
            ++this.currentPos;
            while (this.currentPos < this.length && Character.isWhitespace(this.str.charAt(this.currentPos))) {
                ++this.currentPos;
            }
            return true;
        }
        this.currentPos = temp;
        return false;
    }

    public boolean moveIfAnyCurrent(char[] c) {
        if (this.isCurrentOfAny(c)) {
            ++this.currentPos;
            return true;
        }
        return false;
    }

    public boolean moveIfCurrentIgnorecase(char c) {
        if (this.isCurrentIgnorecase(c)) {
            ++this.currentPos;
            return true;
        }
        return false;
    }

    public boolean moveIfNext(char c) {
        if (this.isNext(c)) {
            ++this.currentPos;
            return true;
        }
        return false;
    }

    public boolean moveIfNextIgnorecase(char c) {
        if (this.isNextIgnorecase(c)) {
            ++this.currentPos;
            return true;
        }
        return false;
    }

    public boolean isCurrent(char c) {
        return this.length > this.currentPos && this.str.charAt(this.currentPos) == c;
    }

    public boolean isCurrentOfAny(char[] c) {
        for (char ch : c) {
            boolean result;
            boolean bl = result = this.length > this.currentPos && this.str.charAt(this.currentPos) == ch;
            if (!result) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrentIgnorecase(char c) {
        return this.length > this.currentPos && Character.toLowerCase(this.str.charAt(this.currentPos)) == c;
    }

    public boolean isCurrentIgnorecase(char a, char b) {
        if (this.length > this.currentPos) {
            char c = Character.toLowerCase(this.str.charAt(this.currentPos));
            return c == a || c == b;
        }
        return false;
    }

    public boolean isCurrentASpace() {
        return this.length > this.currentPos && Character.isWhitespace(this.str.charAt(this.currentPos));
    }

    public boolean isNext(char c) {
        return this.length > this.currentPos + 1 && this.str.charAt(this.currentPos + 1) == c;
    }

    public boolean isNextIgnorecase(char c) {
        return this.length > this.currentPos + 1 && Character.toLowerCase(this.str.charAt(this.currentPos + 1)) == c;
    }

    public boolean isNextASpace() {
        return this.length > this.currentPos + 1 && Character.isWhitespace(this.str.charAt(this.currentPos + 1));
    }

    public boolean isCurrentAMPmStringNoSpaces() {
        int temp = this.currentPos;
        while (this.currentPos < this.length && Character.isWhitespace(this.str.charAt(this.currentPos))) {
            ++this.currentPos;
        }
        boolean result = false;
        if (this.isCurrentIgnorecase('a', 'p')) {
            result = this.currentPos == this.length - 1 || Character.toLowerCase(this.str.charAt(this.currentPos + 1)) == 'm' || Character.isWhitespace(this.str.charAt(this.currentPos + 1));
        }
        this.currentPos = temp;
        return result;
    }

    public char charAt(int position) {
        return this.str.charAt(position);
    }

    public void move(int steps) {
        this.currentPos += steps;
    }

    public void next() {
        ++this.currentPos;
    }

    public boolean isNext() {
        return this.currentPos + 1 == this.length;
    }

    public void skipSpaces() {
        while (this.currentPos < this.length && Character.isWhitespace(this.str.charAt(this.currentPos))) {
            ++this.currentPos;
        }
    }

    public boolean isLast(char c) {
        return this.str.charAt(this.length - 1) == c;
    }

    public boolean isLast() {
        return this.currentPos == this.length - 1;
    }

    public boolean isFinished() {
        return this.currentPos >= this.length;
    }

    public int length() {
        return this.length;
    }

    public int remainingLength() {
        return this.currentPos - this.length;
    }

    public int readDigits() {
        int temp = this.currentPos;
        while (this.currentPos < this.length && this.isDigit(this.str.charAt(this.currentPos))) {
            ++this.currentPos;
        }
        if (temp != this.currentPos) {
            try {
                return Integer.valueOf(this.str.substring(temp, this.currentPos));
            }
            catch (NumberFormatException numberFormatException) {
                this.currentPos = temp;
            }
        }
        return -1;
    }

    public float readFloatMantissa() {
        int temp = this.currentPos;
        while (this.currentPos < this.length && this.isDigit(this.str.charAt(this.currentPos))) {
            ++this.currentPos;
        }
        if (temp != this.currentPos) {
            try {
                return Float.valueOf("." + this.str.substring(temp, this.currentPos)).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                this.currentPos = temp;
            }
        }
        return -1.0f;
    }

    public Indicator readIndicator() {
        int temp = this.currentPos;
        while (this.currentPos < this.length && this.isAlphabet(this.str.charAt(this.currentPos))) {
            ++this.currentPos;
        }
        if (temp != this.currentPos) {
            String s = this.str.substring(temp, this.currentPos).toUpperCase();
            Integer value = monthsMap.get(s);
            if (value != null) {
                return new Indicator(1, value);
            }
            value = daysMap.get(s);
            if (value != null) {
                return new Indicator(2, value);
            }
            this.currentPos = temp;
        }
        return null;
    }

    public int readDayOfWeek() {
        return this.readString(daysMap);
    }

    public int readMonth() {
        return this.readString(monthsMap);
    }

    public TimeZone readTimeZone() {
        if (this.currentPos + 2 < this.length && this.isAlphabet(this.str.charAt(this.currentPos)) && this.isAlphabet(this.str.charAt(this.currentPos + 1)) && this.isAlphabet(this.str.charAt(this.currentPos + 2))) {
            String timeZoneStr = this.str.substring(this.currentPos, this.currentPos + 3).toUpperCase();
            TimeZone timeZone = DateTimeString.getTimeZone(timeZoneStr);
            if (timeZone == null && (timeZoneStr = psuedoTimeZoneNames.get(timeZoneStr)) != null) {
                timeZone = TimeZone.getTimeZone(timeZoneStr);
            }
            if (timeZone != null) {
                this.currentPos += 3;
                return timeZone;
            }
        }
        return null;
    }

    private static TimeZone getTimeZone(String timeZoneStr) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneStr);
        if (!timeZone.getID().equalsIgnoreCase(timeZoneStr)) {
            return null;
        }
        return timeZone;
    }

    private int readString(Map<String, Integer> map) {
        int temp = this.currentPos;
        while (this.currentPos < this.length && this.isAlphabet(this.str.charAt(this.currentPos))) {
            ++this.currentPos;
        }
        if (temp != this.currentPos) {
            Integer value = map.get(this.str.substring(temp, this.currentPos).toUpperCase());
            if (value != null) {
                return value;
            }
            this.currentPos = temp;
        }
        return -1;
    }

    private boolean isAlphabet(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static {
        int i;
        months = (String[])Stream.of(Month.values()).map(month -> month.name()).toArray(String[]::new);
        days = (String[])Stream.of(DayOfWeek.values()).map(day -> day.name()).toArray(String[]::new);
        monthsMap = new HashMap<String, Integer>();
        daysMap = new HashMap<String, Integer>();
        psuedoTimeZoneNames = new HashMap<String, String>();
        for (i = 0; i < months.length; ++i) {
            for (int j = months[i].length() - 1; j >= 2; --j) {
                monthsMap.put(months[i].substring(0, j + 1), i + 1);
            }
        }
        for (i = 0; i < days.length; ++i) {
            daysMap.put(days[i], i + 1);
            daysMap.put(days[i].substring(0, 3), i + 1);
        }
        psuedoTimeZoneNames.put("PDT", "PST");
    }

    public static class Indicator {
        private static final int MONTH = 1;
        private static final int DAYOFWEEK = 2;
        final int indicator;
        final int value;

        Indicator(int indicator, int value) {
            this.indicator = indicator;
            this.value = value;
        }

        public boolean isMonth() {
            return this.indicator == 1;
        }

        public boolean isDayOfWeek() {
            return this.indicator == 2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

