/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CaseSensitiveStruct;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.UndefinedElementException;
import coldfusion.runtime.VariableScope;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Key;
import coldfusion.util.RuntimeWrapper;
import java.util.Map;

public final class DotResolver {
    public static final int NOTFOUND = 0;
    public static final int FOUNDPART = 1;
    public static final int FOUNDALL = 2;

    private static final Object resolve(Object container, String key) {
        return DotResolver.resolve(container, key, false);
    }

    private static final Object resolve(Object container, String key, boolean preserveNull) {
        Object result = null;
        if (container instanceof Map) {
            result = ((Map)container).get(key);
            if (result == null && preserveNull && FusionContext.isPreserveNullValues() && !((Map)container).containsKey(key)) {
                throw new UndefinedElementException(container, key);
            }
        } else {
            try {
                result = CfJspPage._arrayGetAt(container, key);
            }
            catch (IllegalAccessException illegalAccessEx) {
                throw new RuntimeWrapper(illegalAccessEx);
            }
        }
        return result;
    }

    public static final Object resolve(Map stem, String[] keys, int keyStartPos) {
        return DotResolver.resolve(stem, keys, keyStartPos, false);
    }

    public static final Object resolve(Map stem, String[] keys, int keyStartPos, boolean preserveNull) {
        Object obj = DotResolver.resolve((Object)stem, keys[keyStartPos], preserveNull);
        if (keys.length - keyStartPos == 1) {
            return obj;
        }
        if (obj == null || CfJspPage.isNotMap(obj)) {
            keys[keyStartPos + 1] = keys[keyStartPos] + "." + keys[keyStartPos + 1];
            return DotResolver.resolve(stem, keys, keyStartPos + 1, preserveNull);
        }
        return DotResolver.resolve(Cast._Map(obj), keys, keyStartPos + 1, preserveNull);
    }

    public static final boolean isSplitNameKeyDefined(Map stem, String[] keys, int keyStartPos) {
        Object obj = DotResolver.resolve((Object)stem, keys[keyStartPos], false);
        if (keys.length - keyStartPos == 1) {
            return stem.containsKey(keys[keyStartPos]);
        }
        if (obj == null || CfJspPage.isNotMap(obj)) {
            keys[keyStartPos + 1] = keys[keyStartPos] + "." + keys[keyStartPos + 1];
            return DotResolver.isSplitNameKeyDefined(stem, keys, keyStartPos + 1);
        }
        return DotResolver.isSplitNameKeyDefined(Cast._Map(obj), keys, keyStartPos + 1);
    }

    public static final Object resolveSplitNameInMap(Map stem, String[] keys) {
        return DotResolver.resolveSplitNameInMap(stem, keys, false);
    }

    public static final Object resolveSplitNameInMap(Map stem, String[] keys, boolean isSafe) {
        Object result;
        Boolean preserveNullValues = null;
        if (!isSafe) {
            preserveNullValues = FusionContext.isPreserveNullValues();
        }
        if ((result = DotResolver.resolve(stem, keys, 0, isSafe ? false : preserveNullValues)) == null) {
            if (isSafe) {
                if (keys.length > 1) {
                    String[] keysMinusLastKey = new String[keys.length - 1];
                    System.arraycopy(keys, 0, keysMinusLastKey, 0, keys.length - 1);
                    result = DotResolver.resolve(stem, keysMinusLastKey, 0);
                    if (result != null) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (preserveNullValues != null && !preserveNullValues.booleanValue() || !FusionContext.isPreserveNullValues()) {
                UndefinedElementException uex = new UndefinedElementException((Object)stem, keys);
                throw uex;
            }
        }
        return result;
    }

    public static String[] revertKeys(String[] keys, int keyStartPos) {
        for (int i = keyStartPos; i < keys.length; ++i) {
            int lastDotPos = keys[i].lastIndexOf(46);
            if (lastDotPos == -1) continue;
            keys[i] = keys[i].substring(lastDotPos + 1);
        }
        return keys;
    }

    private static Object structify(Map stem, String[] keys, int keyStartPos) {
        for (int i = keyStartPos; i < keys.length; ++i) {
            Struct newStem = new Struct();
            stem.put(keys[i], newStem);
            stem = newStem;
        }
        return stem;
    }

    public static Object LhsResolve(Map stem, String[] keys, int keyStartPos, boolean preserveCase) {
        return DotResolver.LhsResolveRec(stem, keys, keyStartPos, keyStartPos, preserveCase);
    }

    private static Object LhsResolveComponent(Map stem, String name) {
        TemplateProxy obj;
        block4: {
            obj = null;
            if (stem instanceof TemplateProxy) {
                try {
                    Object[] props;
                    TemplateProxy tp = (TemplateProxy)stem;
                    AttributeCollection meta = (AttributeCollection)tp.getMetadata();
                    if (meta == null || (props = (Object[])meta.get(Key.PROPERTIES)) == null) break block4;
                    for (int i = 0; i < props.length; ++i) {
                        AttributeCollection ac = (AttributeCollection)props[i];
                        String pname = (String)ac.get(Key.NAME);
                        if (!pname.equalsIgnoreCase(name)) continue;
                        String type = (String)ac.get(Key.TYPE);
                        obj = TemplateProxyFactory.resolveName(type, tp.page.pageContext);
                        break;
                    }
                }
                catch (Throwable e) {
                    obj = null;
                }
            }
        }
        return obj;
    }

    private static Object LhsResolveRec(Map stem, String[] keys, int keyStartPos, int startStructAt, boolean preserveCase) {
        Object obj = DotResolver.resolve(stem, keys[keyStartPos]);
        if (keys.length - keyStartPos == 1) {
            if (obj == null && keys[keyStartPos].indexOf(".") == -1) {
                obj = DotResolver.LhsResolveComponent(stem, keys[keyStartPos]);
                if (obj == null) {
                    obj = stem instanceof CaseSensitiveStruct ? new CaseSensitiveStruct() : new Struct();
                }
                if (!preserveCase && obj instanceof CaseInsensitiveMap) {
                    stem.put(keys[keyStartPos].toUpperCase(), obj);
                } else {
                    stem.put(keys[keyStartPos], obj);
                }
            }
            return obj;
        }
        if (obj == null || CfJspPage.isNotMap(obj)) {
            keys[keyStartPos + 1] = keys[keyStartPos] + "." + keys[keyStartPos + 1];
            obj = DotResolver.LhsResolveRec(stem, keys, keyStartPos + 1, startStructAt, preserveCase);
        } else {
            stem = Cast._Map(obj);
            startStructAt = keyStartPos + 1;
            obj = DotResolver.LhsResolveRec(stem, keys, keyStartPos + 1, startStructAt, preserveCase);
        }
        if (obj == null && keyStartPos == startStructAt) {
            keys = DotResolver.revertKeys(keys, keyStartPos);
            obj = DotResolver.structify(stem, keys, keyStartPos);
        }
        return obj;
    }

    public static String[] split(String dottedName) {
        return DotResolver.splitStartingAt(dottedName, 0);
    }

    public static String[] splitStartingAt(String dottedName, int startPos) {
        int dotPos1;
        int dotcount = 0;
        for (dotPos1 = startPos; dotPos1 < dottedName.length(); ++dotPos1) {
            if (dottedName.charAt(dotPos1) != '.') continue;
            ++dotcount;
        }
        int returnLength = dotcount + 1;
        String[] keys = new String[returnLength];
        dotPos1 = startPos;
        int dotPos2 = 0;
        int count = 0;
        while ((dotPos2 = dottedName.indexOf(46, dotPos1)) != -1) {
            keys[count++] = dottedName.substring(dotPos1, dotPos2);
            dotPos1 = dotPos2 + 1;
        }
        keys[count] = dottedName.substring(dotPos1);
        return keys;
    }

    public static Object resolve(VariableScope varScope, String dottedName) {
        String[] array = DotResolver.split(dottedName);
        String stemName = array[0];
        Object stem = varScope.get(stemName);
        int len = array.length;
        if (len == 1 || stem == null) {
            return stem;
        }
        return DotResolver.resolve(Cast._Map(stem), array, 1);
    }

    private static final int containsKey(Map stem, String[] keys, int keyStartPos) {
        if (keys.length - keyStartPos == 1) {
            if (stem.containsKey(keys[keyStartPos])) {
                return 2;
            }
            return 0;
        }
        Object obj = stem.get(keys[keyStartPos]);
        if (obj == null || CfJspPage.isNotMap(obj)) {
            keys[keyStartPos + 1] = keys[keyStartPos] + "." + keys[keyStartPos + 1];
            int foundother = DotResolver.containsKey(stem, keys, keyStartPos + 1);
            if (obj != null && foundother == 0) {
                return 1;
            }
            return foundother;
        }
        int foundRest = DotResolver.containsKey(Cast._Map(obj), keys, keyStartPos + 1);
        if (foundRest == 2) {
            return 2;
        }
        return 1;
    }

    public static final int containsKey(Map stem, String[] keys) {
        return DotResolver.containsKey(stem, keys, 0);
    }
}

