/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.CustomException;
import coldfusion.runtime.DatabaseException;
import coldfusion.runtime.ExceptionInformation;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.LockException;
import coldfusion.runtime.MissingIncludeException;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.StructBean;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;

public class ExceptionScope
extends StructBean {
    Throwable ex;
    private static Set m_Entries = new HashSet();
    private static Set m_DontShow = new HashSet();

    public ExceptionScope(Throwable ex, Locale l) {
        super(ex);
        this.ex = ex;
        if (ex instanceof NeoException) {
            ((NeoException)ex).setLocale(l);
        }
    }

    public ExceptionScope(Throwable ex) {
        super(ex);
        this.ex = ex;
    }

    @Override
    public Object put(Object key, Object value) {
        return null;
    }

    @Override
    public boolean containsName(String name) {
        return this.get(name) != null;
    }

    @Override
    public Object get(Object key) {
        String name = key.toString();
        Object result = null;
        if ("message".equalsIgnoreCase(name)) {
            result = this.ex.getLocalizedMessage();
            if (result == null && (result = this.ex.getMessage()) == null) {
                result = "";
            }
        } else if ("stacktrace".equalsIgnoreCase(name)) {
            StringWriter sw = new StringWriter();
            this.ex.printStackTrace(new PrintWriter(sw));
            result = sw.toString();
        }
        if (result == null) {
            result = super.get(name);
        }
        if (result == null) {
            if ("type".equalsIgnoreCase(name)) {
                result = this.ex instanceof NeoException ? ((NeoException)this.ex).getType() : (this.ex instanceof AccessControlException ? "Security" : this.ex.getClass().getName());
            } else if ("message".equalsIgnoreCase(name)) {
                result = this.ex.getLocalizedMessage();
                if (result == null && (result = this.ex.getMessage()) == null) {
                    result = "";
                }
            } else if ("detail".equalsIgnoreCase(name)) {
                result = this.ex instanceof NeoException ? ((NeoException)this.ex).getDetail() : "";
            } else if ("tagcontext".equalsIgnoreCase(name)) {
                result = new ExceptionInformation(this.ex);
            } else if ("nativeerrorcode".equalsIgnoreCase(name)) {
                if (this.ex instanceof DatabaseException) {
                    result = new Integer(((DatabaseException)this.ex).nativeerrorcode);
                }
            } else if ("sqlstate".equalsIgnoreCase(name)) {
                if (this.ex instanceof DatabaseException && (result = ((DatabaseException)this.ex).getSQLState()) == null) {
                    result = "n/a";
                }
            } else if ("errnumber".equalsIgnoreCase(name)) {
                if (this.ex instanceof ExpressionException && (result = String.valueOf(((ExpressionException)this.ex).getErrNumber())) == null) {
                    result = "";
                }
            } else if ("missingfilename".equalsIgnoreCase(name)) {
                if (this.ex instanceof MissingIncludeException && (result = ((MissingIncludeException)this.ex).getMissingFileName()) == null) {
                    result = "";
                }
            } else if ("lockname".equalsIgnoreCase(name)) {
                if (this.ex instanceof LockException && (result = ((LockException)this.ex).getLockName()) == null) {
                    result = "";
                }
            } else if ("lockoperation".equalsIgnoreCase(name)) {
                if (this.ex instanceof LockException && (result = ((LockException)this.ex).getLockOperation()) == null) {
                    result = "";
                }
            } else if ("errorcode".equalsIgnoreCase(name)) {
                if (this.ex instanceof CustomException) {
                    result = String.valueOf(((CustomException)this.ex).getErrorCode());
                    if (result == null) {
                        result = "";
                    }
                } else {
                    result = this.ex instanceof DatabaseException ? ((DatabaseException)this.ex).getSQLState() : "";
                }
            } else if ("extendedinfo".equalsIgnoreCase(name)) {
                if (this.ex instanceof CustomException) {
                    result = ((CustomException)this.ex).getExtendedInfo();
                    if (result == null) {
                        result = "";
                    }
                } else {
                    result = "";
                }
            } else if ("exceptions".equalsIgnoreCase(name)) {
                result = this.ex instanceof DatabaseException ? ((DatabaseException)this.ex).getExceptions() : "";
            }
        }
        return result;
    }

    @Override
    public Iterator getNames() {
        return new ExceptionIterator(super.getNames());
    }

    static {
        m_Entries.add("TagContext");
        m_Entries.add("Type");
        m_DontShow.add("localizedmessage");
    }

    private class ExceptionIterator
    implements Iterator {
        private Iterator beanIter;
        private Iterator entryIter;

        ExceptionIterator(Iterator beanIter) {
            this.beanIter = beanIter;
            this.entryIter = m_Entries.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.beanIter.hasNext()) {
                return true;
            }
            return this.entryIter.hasNext();
        }

        public Object next() {
            if (this.beanIter.hasNext()) {
                String sName;
                Object temp = this.beanIter.next();
                if (temp != null && temp instanceof String && (m_DontShow.contains(sName = ((String)temp).toLowerCase()) || ExceptionScope.this.get(sName) == null || m_Entries.contains(temp))) {
                    return this.next();
                }
                return temp;
            }
            if (this.entryIter.hasNext()) {
                return this.entryIter.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }
}

