/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.monitor.memory.MemoryTrackable;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayConstructorDimensionException;
import coldfusion.runtime.ArrayInvalidTypeInsertException;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.ArrayWrapper;
import coldfusion.runtime.CFComparable;
import coldfusion.runtime.Copyable;
import coldfusion.runtime.EmptyArrayPopException;
import coldfusion.runtime.EmptyArrayShiftException;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TypedArrayValidationResult;
import coldfusion.runtime.TypedCollectionUtil;
import coldfusion.runtime.util.TemplateProxyUtil;
import coldfusion.sql.QueryColumn;
import coldfusion.sql.Table;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.RB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class FastArray
extends ArrayList
implements MemoryTrackable,
CFComparable,
Copyable {
    protected int dimension;
    protected transient MemoryTrackerProxy mtProxy;
    protected String typeName;
    public Map metadata;

    public FastArray() {
        this.dimension = 1;
    }

    public FastArray(int d) {
        this(d, 10);
    }

    public FastArray(int d, int initialcapacity) {
        super(initialcapacity);
        if (d < 1 || d > 3) {
            throw new ArrayConstructorDimensionException(d);
        }
        this.dimension = d;
    }

    public FastArray(int d, String t) {
        this(d, t, 10);
    }

    public FastArray(int d, String type, int initialcapacity) {
        super(initialcapacity);
        if (d < 1 || d > 3) {
            throw new ArrayConstructorDimensionException(d);
        }
        this.dimension = d;
        this.typeName = type;
        TypedArrayValidationResult res = TypedCollectionUtil.isValidDataType(type);
        if (!res.isValid()) {
            throw new TypedCollectionUtil.TypedArrayInvalidDataTypeException(type);
        }
        if (res.isCFComponent()) {
            this.typeName = res.getCfcFullyQualiFiedName();
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    @Override
    public int getScopeType() {
        return -1;
    }

    @Override
    public MemoryTrackerProxy getMemoryTrackerProxy() {
        return this.mtProxy;
    }

    @Override
    public synchronized void setMemoryTrackerProxy(MemoryTrackerProxy mtp) {
        this.mtProxy = mtp;
    }

    @Override
    public Iterator valuesIterator() {
        return this.iterator();
    }

    @Override
    public boolean objectEquals(Object o, IdentityHashMap<Object, Map> cirRefMap) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (!(o1 == null ? o2 != null : (o1 instanceof CFComparable ? !((CFComparable)o1).objectEquals(o2, cirRefMap) : !o1.equals(o2)))) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public boolean add(Object o) {
        o = this.cast(o);
        boolean ret = super.add(o);
        if (this.mtProxy != null) {
            this.mtProxy.onAddObject(o);
        }
        return ret;
    }

    public int push(Object o) {
        o = this.cast(o);
        boolean ret = super.add(o);
        if (this.mtProxy != null) {
            this.mtProxy.onAddObject(o);
        }
        return this.size();
    }

    private void validateCollection(Collection c) {
        if (this.typeName != null && !this.typeName.isEmpty() && c != null) {
            if (c instanceof QueryColumn) {
                String colTypeName;
                if ("any".equalsIgnoreCase(this.typeName)) {
                    return;
                }
                Table table = ((QueryColumn)c).getParentTable();
                if (table.getMeta() != null && !TypedCollectionUtil.checkForQueryColumnType(colTypeName = table.getMeta().getColumnTypeName(1), this.typeName)) {
                    throw new ArrayInvalidTypeInsertException(c, this.typeName, TypedCollectionUtil.getObjectType(c));
                }
            } else {
                for (Object valObj : c) {
                    this.cast(valObj);
                }
            }
        }
    }

    public void validateElementType(Object o) {
        this.cast(o);
    }

    private Object cast(Object o) {
        if (this.dimension > 1 && this.typeName != null && !this.typeName.isEmpty()) {
            if (o == null || o instanceof Array) {
                return o;
            }
        } else {
            if (o != null && o instanceof Array && this.dimension == ((Array)o).dimension && this.typeName != null && this.typeName.equals(((Array)o).typeName)) {
                return o;
            }
            if (this.typeName != null && !this.typeName.isEmpty()) {
                if (o == null) {
                    return o;
                }
                Object obj = TypedCollectionUtil.castToDeclaredType(o, this.typeName);
                if (obj == null) {
                    Object objVal = o;
                    if (o instanceof TemplateProxy) {
                        objVal = TemplateProxyUtil.getLastWord(TemplateProxyUtil.getComponentFullName(((TemplateProxy)o).page));
                    }
                    throw new ArrayInvalidTypeInsertException(objVal, this.typeName, TypedCollectionUtil.getObjectType(o));
                }
                return obj;
            }
        }
        return o;
    }

    @Override
    public boolean addAll(Collection c) {
        this.validateCollection(c);
        boolean ret = super.addAll(c);
        if (this.mtProxy != null) {
            this.mtProxy.onAddCollection(c);
        }
        return ret;
    }

    @Override
    public boolean addAll(int i, Collection c) {
        this.validateCollection(c);
        boolean ret = super.addAll(i, c);
        if (this.mtProxy != null) {
            this.mtProxy.onAddCollection(c);
        }
        return ret;
    }

    public void addElement(Object o) {
        o = this.cast(o);
        super.add(o);
        if (this.mtProxy != null) {
            this.mtProxy.onAddObject(o);
        }
    }

    public void insertElementAt(Object o, int i) {
        o = this.cast(o);
        super.add(i, o);
        if (this.mtProxy != null) {
            this.mtProxy.onAddObject(o);
        }
    }

    @Override
    public Object remove(int i) {
        Object o = super.remove(i);
        if (o != null && this.mtProxy != null) {
            this.mtProxy.onRemoveObject(o);
        }
        return o;
    }

    public Object pop() {
        int currentSize = this.size();
        if (currentSize == 0) {
            throw new EmptyArrayPopException();
        }
        Object o = super.remove(currentSize - 1);
        if (o != null && this.mtProxy != null) {
            this.mtProxy.onRemoveObject(o);
        }
        return o;
    }

    public int unshift(Object o) {
        this.insertElementAt(o, 0);
        return this.size();
    }

    public Object shift() {
        if (this.size() == 0) {
            throw new EmptyArrayShiftException();
        }
        return this.remove(0);
    }

    public List splice(int index, int howMany, List replacements) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        int arrSize = this.size();
        int startIndex = 0;
        if (index < 0) {
            startIndex = Math.abs(index) > arrSize ? 1 : arrSize + index + 1;
        } else if (index == 0) {
            startIndex = 1;
        } else {
            int n = startIndex = index > arrSize ? arrSize + 1 : index;
        }
        if (howMany < 0) {
            howMany = 0;
        }
        int removalCount = 0;
        boolean needsRemoval = howMany > 0;
        int replacementSize = replacements.size();
        boolean hasReplacement = replacementSize > 0;
        int replacementCount = 1;
        int n = howMany = startIndex + howMany - 1 > arrSize ? arrSize - startIndex + 1 : howMany;
        if (replacementSize == 0) {
            int arrIndex = startIndex - 1;
            while (removalCount < howMany) {
                if (!needsRemoval || arrIndex >= arrSize || removalCount >= howMany) continue;
                resultList.add(this.remove(arrIndex));
                ++removalCount;
            }
        } else {
            int arrIndex = startIndex - 1;
            while (!(replacementCount > replacementSize && removalCount >= howMany || arrIndex >= arrSize && replacementCount > replacementSize)) {
                if (needsRemoval && arrIndex < arrSize && removalCount < howMany) {
                    resultList.add(this.remove(arrIndex));
                    ++removalCount;
                }
                if (!hasReplacement || replacementCount > replacementSize) continue;
                this.add(arrIndex, replacements.get(replacementCount - 1));
                ++replacementCount;
                ++arrIndex;
            }
        }
        return resultList;
    }

    public void removeAllElements() {
        super.clear();
        if (this.mtProxy != null) {
            this.mtProxy.resetMemory();
        }
    }

    public void removeElementAt(int i) {
        Object o = this.get(i);
        super.remove(i);
        if (this.mtProxy != null) {
            this.mtProxy.onRemoveObject(o);
        }
    }

    void setSize(int size) {
        this.ensureCapacity(size);
        while (this.size() < size) {
            this.add((Object)null);
        }
    }

    @Override
    public Object set(int i, Object newVal) {
        newVal = this.cast(newVal);
        Object oldVal = super.set(i, newVal);
        if (this.mtProxy != null) {
            this.mtProxy.onReplace(newVal, oldVal);
        }
        return oldVal;
    }

    public void setElementAt(Object newVal, int i) {
        newVal = this.cast(newVal);
        Object oldVal = this.get(i);
        super.set(i, newVal);
        if (this.mtProxy != null) {
            this.mtProxy.onReplace(newVal, oldVal);
        }
    }

    public Object writeReplace() {
        ArrayWrapper arrayWrapper = new ArrayWrapper();
        arrayWrapper.setDimension(this.dimension);
        ArrayList v = new ArrayList(this);
        arrayWrapper.setValueList(v);
        arrayWrapper.setTypeName(this.typeName);
        return arrayWrapper;
    }

    public final Map getMetaData() {
        Map copy = this.getAdditionalMetadata();
        if (this.metadata != null) {
            if (copy == null) {
                copy = new CaseInsensitiveMap();
            }
            copy.putAll(this.metadata);
        }
        return copy;
    }

    public Map setMetaData(Map metadata) {
        this.metadata = metadata;
        Map copy = this.getAdditionalMetadata();
        if (copy == null) {
            copy = new CaseInsensitiveMap();
        }
        copy.putAll(metadata);
        return copy;
    }

    protected Map getAdditionalMetadata() {
        CaseInsensitiveMap additionalMetadata = new CaseInsensitiveMap();
        additionalMetadata.put(RB.getString(this, "Array.Type"), RB.getString(this, "Array.Type.Unsync"));
        additionalMetadata.put(RB.getString(this, "Array.Dimensions"), this.dimension);
        ArrayUtil.populateDataTypeInfo(additionalMetadata, this.typeName);
        return additionalMetadata;
    }
}

