/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.ApplicationException;
import coldfusion.util.UUIDUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class FormCache {
    private static final long cleanUpInterval = 120000L;
    private static final long cacheLifeSpan = 180000L;
    private static FormCache FormCacheInstance = new FormCache();
    private HashMap cache = new HashMap();
    protected Thread listenerThread = null;

    private FormCache() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                FormCache.this.cleanup();
            }
        };
        this.listenerThread = new Thread(r);
        this.listenerThread.start();
    }

    public static FormCache getFormCacheInstance() {
        return FormCacheInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(Object o, Long timeout) {
        String id = UUIDUtils.createUUID(true);
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dtstamp", new Long(new Date().getTime()));
            map.put("timeout", timeout);
            map.put("data", o);
            this.cache.put(id, map);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(String id) {
        HashMap object;
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            object = (HashMap)this.cache.get(id);
            if (object == null) {
                if (id.equals("0")) {
                    return new HashMap();
                }
                throw new DataExpiredException();
            }
            long timeout = (Long)object.get("timeout");
            long dt = (Long)object.get("dtstamp");
            long currentDtStamp = new Date().getTime();
            if (timeout == 0L || dt + timeout < currentDtStamp) {
                object = (HashMap)this.cache.remove(id);
            }
        }
        return object.get("data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        while (true) {
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                Iterator itr = this.cache.keySet().iterator();
                ArrayList keyList = new ArrayList(this.cache.size());
                long currentDtStamp = new Date().getTime();
                while (itr.hasNext()) {
                    long timeout;
                    Object key = itr.next();
                    HashMap item = (HashMap)this.cache.get(key);
                    long dt = (Long)item.get("dtstamp");
                    if (dt + (timeout = item.get("timeout") != null || (Long)item.get("timeout") == 0L ? (Long)item.get("timeout") : 180000L) >= currentDtStamp) continue;
                    keyList.add(key);
                }
                for (int i = 0; i < keyList.size(); ++i) {
                    this.cache.remove(keyList.get(i));
                }
            }
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static class DataExpiredException
    extends ApplicationException {
    }
}

