/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFComponent;
import coldfusion.runtime.CFDummyComponent;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.ImplicitUDFMethod;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.VariableScope;
import coldfusion.util.Key;
import java.util.Map;

public class ImplicitGetter
extends ImplicitUDFMethod {
    private String propertyName;
    private String pagePath;
    private String name;
    private AttributeCollection metadata;
    private final Object[] emptyArr = new Object[0];

    public ImplicitGetter(String propertyName, String type, String pagePath) {
        this.propertyName = propertyName;
        this.pagePath = pagePath;
        this.name = "GET" + propertyName.toUpperCase();
        this.metadata = new AttributeCollection();
        this.metadata.put(Key.NAME, (Object)this.name);
        this.metadata.put(Key.PARAMETERS, (Object)this.emptyArr);
        if (type == null || type.length() == 0) {
            type = "any";
        }
        this.metadata.put("returntype", (Object)type);
        this.metadata.put("access", (Object)"public");
        this.returnType = type;
        this.init();
    }

    @Override
    public Object invoke(Object instance, String calledName, Object parent, Object[] args) throws Throwable {
        return this.runFunction(instance, (CFPage)parent);
    }

    @Override
    public Object invoke(Object instance, String calledName, Object parent, Map namedArgs) throws Throwable {
        return this.runFunction(instance, (CFPage)parent);
    }

    @Override
    protected Object runFunction(Object instance, CFPage parent, ArgumentCollection args) {
        return this.runFunction(instance, parent);
    }

    protected Object runFunction(Object instance, CFPage parent) {
        TemplateProxy cfc = (TemplateProxy)instance;
        VariableScope varScope = cfc != null ? cfc.getVariableScope() : parent.pageContext.getVariableScope();
        Object result = varScope.get(this.propertyName);
        if (result == null) {
            CfJspPage currentPage = null;
            VariableScope vScope = null;
            if (cfc != null) {
                currentPage = cfc.page;
                vScope = cfc.getVariableScope();
            } else if (parent != null && parent instanceof CFDummyComponent) {
                currentPage = ((CFDummyComponent)parent).getActualpage();
                vScope = varScope;
            }
            if (currentPage == null && parent != null) {
                CfJspPage page = parent;
                while (page != null && !this.getPagePath().equalsIgnoreCase(page.getPagePath())) {
                    page = page.parentPage;
                }
                if (page != null) {
                    currentPage = page;
                    vScope = varScope;
                }
            }
            while (currentPage != null && (result = this.getDefaultValue(this.propertyName, currentPage.getMetadata(), vScope, currentPage)) == null) {
                currentPage = currentPage.parentPage;
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected String[] getParamList() {
        return new String[0];
    }

    @Override
    public Object getMetadata() {
        return this.metadata;
    }

    @Override
    public String getPagePath() {
        return this.pagePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDefaultValue(String propertyName, Object metadata, VariableScope variableScope, CfJspPage page) {
        Object[] props;
        if (metadata != null && (props = (Object[])((AttributeCollection)metadata).get(Key.PROPERTIES)) != null) {
            for (int i = 0; i < props.length; ++i) {
                AttributeCollection property = (AttributeCollection)props[i];
                String propName = (String)property.get(Key.NAME);
                if (!propName.equalsIgnoreCase(propertyName)) continue;
                Object defaultVal = property.get(Key.DEFAULT);
                if (defaultVal == null) break;
                if (defaultVal instanceof String && defaultVal.equals("$DYNAMIC_EXPR$")) {
                    page.pageContext.pushSuperScope(this.superScope);
                    try {
                        defaultVal = ((CFComponent)page).getPropertyDefault(propName);
                    }
                    finally {
                        page.pageContext.popSuperScope();
                    }
                }
                variableScope.bind(propName, defaultVal);
                break;
            }
        }
        return variableScope.get(propertyName);
    }
}

