/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.compiler.ASTliteral;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.Array;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFBigDecimal;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFComparable;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.CaseSensitiveStruct;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExceptionScope;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.IllegalDateArgumentException;
import coldfusion.runtime.InvalidSerializerException;
import coldfusion.runtime.MetadataUtils;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructBean;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.XMLizerUtils;
import coldfusion.runtime.provider.SerializerProxyWrapper;
import coldfusion.runtime.xml.DocumentQueryBeanAdapter;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.sql.QueryTable;
import coldfusion.sql.imq.Row;
import coldfusion.sql.imq.imqTable;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.DateUtils;
import coldfusion.util.Key;
import coldfusion.util.RB;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.rpc.DocumentQueryBean;
import coldfusion.xml.rpc.QueryBean;
import java.io.File;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.w3c.dom.Document;

public class JSONUtils {
    private static final String ITEMS = "items";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String IGNORE = "ignore";
    private static final String KEYS = "keys";
    private static final String STRING = "string";
    private static final String NUMERIC = "numeric";
    private static final String INTEGER = "integer";
    private static final String BOOLEAN = "boolean";
    private static final String DATE = "date";
    private static final Set<String> primitiveMetadataKeyTypes = new HashSet<String>(Arrays.asList("string", "boolean", "numeric", "integer", "date"));
    public static final char OPEN_OBJECT = '{';
    public static final char CLOSE_OBJECT = '}';
    public static final char OPEN_ARRAY = '[';
    public static final char CLOSE_ARRAY = ']';
    public static final char ELEMENT_SEP = ',';
    public static final char KEYVAL_SEP = ':';
    public static final char OPEN_STRING = '\"';
    public static final char CLOSE_STRING = '\"';
    public static final char ESCAPE = '\\';
    public static final String NULL = "null";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String QUERY_COLUMNS_STR = "COLUMNS";
    public static final String QUERY_ROWCOUNT_STR = "ROWCOUNT";
    public static final String QUERY_DATA_STR = "DATA";
    public static final String QUERY_COLUMNS = "\"COLUMNS\"";
    public static final String QUERY_ROWCOUNT = "\"ROWCOUNT\"";
    public static final String QUERY_DATA = "\"DATA\"";
    public static final String ROW_QUERY_FORMAT = "row";
    public static final String DEFAULY_QUERY_FORMAT = "row";
    public static final String COLUMN_QUERY_FORMAT = "column";
    public static final String STRUCT_QUERY_FORMAT = "struct";
    public static final String JS_DATE_FORMAT = "MMMMM, dd yyyy HH:mm:ss";
    private static final Logger logger = CFLogs.SERVER_LOG;
    private static Map<Integer, String> SPECIAL_CHAR_MAP;
    private static final boolean numberAsDouble;
    private static final String CASESENSITIVESTRUCT = "CaseSensitiveStruct";

    public static String serializeJSON(Object o) {
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
        String format = appScope == null ? "row" : appScope.getApplicationSettings().getSerializeQueryFormat();
        return JSONUtils.serializeJSON(o, format);
    }

    public static String serializeJSON(Object o, Object queryFormat) {
        boolean isSecure = false;
        FusionContext fc = FusionContext.getCurrent();
        if (fc != null && fc.isSecureJSON()) {
            isSecure = true;
        }
        return JSONUtils.serializeJSON(o, queryFormat, isSecure, true);
    }

    public static String serializeJSON(Object o, Object queryFormat, boolean secure) {
        return JSONUtils.serializeJSON(o, queryFormat, secure, true);
    }

    public static String serializeJSON(Object o, Object queryFormat, boolean secure, boolean useCustomSerializer) {
        return JSONUtils.serializeJSON(o, queryFormat, secure, useCustomSerializer, false);
    }

    public static String serializeJSON(Object o, Object queryFormat, boolean secure, boolean useCustomSerializer, boolean serializeTemplateProxyMetadata) {
        SerializerProxyWrapper serializerProxy = JSONUtils.getSerializerProxy();
        if (null == serializerProxy) {
            useCustomSerializer = false;
        }
        StringBuilder json = new StringBuilder();
        if (secure) {
            json.append(FusionContext.getCurrent().getSecureJSONPrefix());
        }
        SerializerState ss = new SerializerState();
        ss.serializeQueryAs = JSONUtils.resolveQueryFormat(queryFormat);
        ss.serializeTemplateProxyMetadata = serializeTemplateProxyMetadata;
        JSONUtils.serializeJSONBase(o, json, ss, null, useCustomSerializer);
        return json.toString();
    }

    private static String resolveQueryFormat(Object serializeQueryAs) {
        String queryAs = "row";
        if (serializeQueryAs instanceof Boolean) {
            boolean serializeQueryByColumns = (Boolean)serializeQueryAs;
            return serializeQueryByColumns ? COLUMN_QUERY_FORMAT : "row";
        }
        if (serializeQueryAs instanceof CFBoolean) {
            CFBoolean serializeQueryByColumns = (CFBoolean)serializeQueryAs;
            return serializeQueryByColumns.value ? COLUMN_QUERY_FORMAT : "row";
        }
        if (serializeQueryAs instanceof String) {
            queryAs = (String)serializeQueryAs;
            Boolean serializeQueryByColumns = Cast._boolean(queryAs, false);
            if (serializeQueryByColumns != null) {
                return serializeQueryByColumns != false ? COLUMN_QUERY_FORMAT : "row";
            }
            if (!(queryAs.equalsIgnoreCase("row") || queryAs.equalsIgnoreCase(COLUMN_QUERY_FORMAT) || queryAs.equalsIgnoreCase(STRUCT_QUERY_FORMAT))) {
                throw new InvalidSerializeQueryTypeException();
            }
            return queryAs;
        }
        throw new InvalidSerializeQueryObjectException();
    }

    public static Object caseSensitiveDeserializeJSON(String jsonObj) {
        return JSONUtils.deserializeJSON(jsonObj, true, true, false, true);
    }

    public static Object deserializeJSON(Object jsonObj) {
        return JSONUtils.deserializeJSON(jsonObj, true);
    }

    public static Object deserializeJSON(Object jsonObj, Object strictTypes) {
        return JSONUtils.deserializeJSON(jsonObj, strictTypes, true);
    }

    public static Object deserializeJSON(Object jsonObj, Object strictTypes, boolean useCustomSerializer) {
        return JSONUtils.deserializeJSON(jsonObj, strictTypes, useCustomSerializer, false);
    }

    public static Object deserializeJSON(Object jsonObj, Object strictTypes, boolean useCustomSerializer, boolean deserializeToTemplateProxy) {
        return JSONUtils.deserializeJSON(jsonObj, strictTypes, useCustomSerializer, false, false);
    }

    public static Object deserializeJSON(Object jsonObj, Object strictTypes, boolean useCustomSerializer, boolean deserializeToTemplateProxy, boolean preserveCaseSensitive) {
        Object o;
        boolean strictTypeVal;
        FusionContext fc;
        SerializerProxyWrapper serializerProxy;
        String json;
        try {
            json = Cast._String(jsonObj).trim();
        }
        catch (Exception ex) {
            throw new JSONParseInvalidTypeException();
        }
        if (useCustomSerializer && null != (serializerProxy = JSONUtils.getSerializerProxy())) {
            Object currentSerializedData = FusionContext.getCurrent().getCurrentSerializedData();
            try {
                if ((null == currentSerializedData || null != currentSerializedData && !currentSerializedData.equals(jsonObj)) && serializerProxy.canDeSerialize("JSON")) {
                    return serializerProxy.deserialize(json, "JSON", "");
                }
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
        if ((fc = FusionContext.getCurrent()) != null && fc.isSecureJSON() && json.startsWith(fc.getSecureJSONPrefix())) {
            json = json.substring(fc.getSecureJSONPrefix().length());
        }
        boolean toQuery = false;
        if (strictTypes instanceof String && ((String)strictTypes).equalsIgnoreCase("query")) {
            strictTypeVal = false;
            toQuery = true;
        } else {
            strictTypeVal = Cast._boolean(strictTypes);
        }
        ParserState state = new ParserState(json, true, strictTypeVal, deserializeToTemplateProxy, preserveCaseSensitive);
        if (toQuery) {
            state.convertToQuery = true;
        }
        try {
            o = JSONUtils.parseJSON(state);
        }
        catch (JSONParseException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.error("Error parsing JSON string", t);
            throw new JSONParseException(state, t);
        }
        return o;
    }

    public static boolean isJSON(Object o) {
        boolean isValid;
        String s;
        try {
            s = Cast._String(o).trim();
        }
        catch (Exception ex) {
            return false;
        }
        if (s.length() == 0) {
            return false;
        }
        FusionContext fc = FusionContext.getCurrent();
        if (fc != null && fc.isSecureJSON() && s.startsWith(fc.getSecureJSONPrefix())) {
            s = s.substring(fc.getSecureJSONPrefix().length());
        }
        ParserState state = new ParserState(s, false, true);
        try {
            JSONUtils.parseJSON(state);
            isValid = true;
        }
        catch (JSONParseException jsonEx) {
            isValid = false;
        }
        catch (Throwable t) {
            logger.error("Error parsing JSON string", t);
            throw new JSONParseException(state, t);
        }
        return isValid;
    }

    private static void serializeJSONBase(Object o, StringBuilder json, SerializerState ss, List cfcSerialized, boolean useCustomSerializer) {
        if (JSONUtils.serializeUsingCustomSerializer(o, json, ss, cfcSerialized, useCustomSerializer)) {
            return;
        }
        if (o instanceof Throwable) {
            o = new ExceptionScope((Throwable)o);
        }
        if (o == null) {
            json.append(NULL);
        } else if (o instanceof String) {
            String s = (String)o;
            if (ASTliteral.PRESERVE_LITERAL_TYPES || !JSONUtils.checkStringAsBoolean(s, json) && !JSONUtils.checkStringAsNumber(s, json)) {
                json.append('\"').append(JSONUtils.escape(s)).append('\"');
            }
        } else if (o instanceof Character) {
            json.append('\"').append(o.toString()).append('\"');
        } else if (o instanceof Number) {
            json.append(o.toString());
        } else if (o instanceof Boolean) {
            json.append(o.toString());
        } else if (o instanceof CFBoolean) {
            json.append(o.toString());
        } else if (o.getClass().isArray()) {
            JSONUtils.serializeArrayToJSON(o, json, ss, cfcSerialized, useCustomSerializer);
        } else if (o instanceof TemplateProxy) {
            JSONUtils.serializeJSONProxy((TemplateProxy)o, json, ss, cfcSerialized, useCustomSerializer);
        } else if (o instanceof Map) {
            JSONUtils.serializeJSONMap((Map)o, json, ss, cfcSerialized, useCustomSerializer);
        } else if (o instanceof List) {
            JSONUtils.serializeJSONList((List)o, json, ss, cfcSerialized, useCustomSerializer);
        } else if (o instanceof imqTable) {
            imqTable table = (imqTable)o;
            if (ss.serializeQueryAs.equalsIgnoreCase(COLUMN_QUERY_FORMAT)) {
                JSONUtils.serializeQueryByColumns(table, json, ss, cfcSerialized, useCustomSerializer);
            } else if (ss.serializeQueryAs.equalsIgnoreCase(STRUCT_QUERY_FORMAT)) {
                JSONUtils.serializeQueryByStruct(table, json, ss, cfcSerialized, useCustomSerializer);
            } else {
                JSONUtils.serializeQueryByRows(table, json, ss, cfcSerialized, useCustomSerializer);
            }
        } else if (o instanceof QueryBean) {
            QueryBean table = (QueryBean)o;
            JSONUtils.serializeQueryByRows(table, json, ss, cfcSerialized, useCustomSerializer);
        } else if (o instanceof DocumentQueryBean) {
            DocumentQueryBeanAdapter table = new DocumentQueryBeanAdapter((DocumentQueryBean)o);
            JSONUtils.serializeQueryByRows(table, json, ss, cfcSerialized, useCustomSerializer);
        } else if (o instanceof Date) {
            SimpleDateFormat formatter = ss.getDateFormatter();
            if (o instanceof OleDateTime) {
                formatter.setTimeZone(((OleDateTime)o).getCalendar().getTimeZone());
            }
            String formattedDate = formatter.format((Date)o);
            JSONUtils.serializeJSONBase(formattedDate, json, ss, cfcSerialized, useCustomSerializer);
        } else if (o instanceof Calendar) {
            SimpleDateFormat formatter = ss.getDateFormatter();
            formatter.setTimeZone(((Calendar)o).getTimeZone());
            String formattedDate = formatter.format(((Calendar)o).getTime());
            JSONUtils.serializeJSONBase(formattedDate, json, ss, cfcSerialized, useCustomSerializer);
        } else if (o instanceof XmlNodeList) {
            JSONUtils.serializeJSONBase(o.toString(), json, ss, cfcSerialized, useCustomSerializer);
        } else if (o instanceof Document) {
            try {
                JSONUtils.serializeJSONBase(XMLizerUtils.serializeXML(o, false), json, ss, cfcSerialized, useCustomSerializer);
            }
            catch (SerializationException e) {
                throw new RuntimeException(e);
            }
        } else if (o instanceof Key) {
            json.append('\"').append(JSONUtils.escape(o.toString())).append('\"');
        } else {
            StructBean sb = new StructBean(o);
            JSONUtils.serializeJSONMap(sb, json, ss, cfcSerialized, useCustomSerializer);
        }
    }

    private static void serializeJSONList(List list, StringBuilder json, SerializerState ss, List cfcSerialized, boolean useCustomSerializer) {
        int listSize = list.size();
        json.append('[');
        Object ssArrayItemType = ss.popArrayMetadata();
        if (ssArrayItemType instanceof Map) {
            ssArrayItemType = JSONUtils.getArrayPropertyType((Map)ssArrayItemType);
        }
        Object arrayItemMetadata = ssArrayItemType != null ? ssArrayItemType : (list instanceof Array ? JSONUtils.getArrayPropertyType(((Array)list).metadata) : null);
        for (int i = 0; i < listSize; ++i) {
            Object value = list.get(i);
            if (i != 0) {
                json.append(',');
            }
            if (value instanceof TemplateProxy && cfcSerialized != null) {
                JSONUtils.serializeJSONBase(value, json, ss, new ArrayList(cfcSerialized), useCustomSerializer);
                continue;
            }
            Object type = JSONUtils.getArrayItemPropertyType(arrayItemMetadata, i);
            if (type instanceof String) {
                String propertyType = (String)type;
                if (propertyType.equalsIgnoreCase(STRING) && !(value instanceof List) && !(value instanceof Map)) {
                    json.append('\"').append(JSONUtils.escape(String.valueOf(value))).append('\"');
                    continue;
                }
                if (propertyType.equalsIgnoreCase(NUMERIC) && value instanceof String) {
                    value = Double.parseDouble((String)value);
                    json.append(value.toString());
                    continue;
                }
                if (propertyType.equalsIgnoreCase(INTEGER) && value instanceof String) {
                    value = Double.valueOf(Double.parseDouble((String)value)).intValue();
                    json.append(value.toString());
                    continue;
                }
                if (propertyType.equalsIgnoreCase(BOOLEAN) && value instanceof String) {
                    if (JSONUtils.checkStringAsBoolean((String)value, json)) continue;
                    throw new IllegalBooleanValueException((String)value);
                }
                if (propertyType.equalsIgnoreCase(DATE) && value instanceof String) {
                    value = DateUtils.parseDateTime((String)value);
                }
            }
            if (value instanceof List) {
                if (type instanceof Map || type instanceof String && primitiveMetadataKeyTypes.contains((String)type)) {
                    ss.pushArrayMetadata(type);
                }
                JSONUtils.serializeJSONList((List)value, json, ss, cfcSerialized, useCustomSerializer);
                continue;
            }
            if (value instanceof Map && type instanceof Map) {
                ss.pushStructMetadata((Map)type);
                JSONUtils.serializeJSONMap((Map)value, json, ss, cfcSerialized, useCustomSerializer);
                continue;
            }
            JSONUtils.serializeJSONBase(value, json, ss, cfcSerialized, useCustomSerializer);
        }
        json.append(']');
    }

    private static void serializeJSONMap(Map map, StringBuilder json, SerializerState ss, List cfcSerialized, boolean useCustomSerializer) {
        json.append('{');
        boolean first = true;
        Iterator entries = map.entrySet().iterator();
        Map metadata = JSONUtils.getStructMetadata(ss, map);
        while (entries.hasNext()) {
            String key;
            Map.Entry entry = entries.next();
            String jsonKey = key = entry.getKey().toString();
            Object keyMetadata = JSONUtils.getStructKeyMetadata(key, metadata);
            if (keyMetadata instanceof Map) {
                Map keyMetadataMap = (Map)keyMetadata;
                boolean ignore = JSONUtils.isIgnoreProperty(keyMetadataMap);
                if (ignore) continue;
                jsonKey = JSONUtils.getStructKey(keyMetadataMap, key);
            }
            Object value = entry.getValue();
            if (!first) {
                json.append(',');
            } else {
                first = false;
            }
            json.append('\"').append(JSONUtils.escape(jsonKey)).append('\"').append(':');
            try {
                if (value instanceof TemplateProxy && cfcSerialized != null) {
                    JSONUtils.serializeJSONBase(value, json, ss, new ArrayList(cfcSerialized), useCustomSerializer);
                    continue;
                }
                String propertyType = JSONUtils.getStructPropertyType(keyMetadata);
                if (propertyType != null) {
                    if (propertyType.equalsIgnoreCase(STRING) && !(value instanceof List) && !(value instanceof Map)) {
                        json.append('\"').append(JSONUtils.escape(String.valueOf(value))).append('\"');
                        continue;
                    }
                    if (propertyType.equalsIgnoreCase(NUMERIC) && value instanceof String) {
                        value = Double.parseDouble((String)value);
                        json.append(value.toString());
                        continue;
                    }
                    if (propertyType.equalsIgnoreCase(INTEGER) && value instanceof String) {
                        value = Double.valueOf(Double.parseDouble((String)value)).intValue();
                        json.append(value.toString());
                        continue;
                    }
                    if (propertyType.equalsIgnoreCase(BOOLEAN) && value instanceof String) {
                        if (JSONUtils.checkStringAsBoolean((String)value, json)) continue;
                        throw new IllegalBooleanValueException((String)value);
                    }
                    if (propertyType.equalsIgnoreCase(DATE) && value instanceof String) {
                        value = DateUtils.parseDateTime((String)value);
                    }
                }
                if (keyMetadata instanceof Map) {
                    Map innerStructMetadata;
                    if (value instanceof List) {
                        Object arrayItemType = JSONUtils.getArrayPropertyType((Map)keyMetadata);
                        if (arrayItemType != null) {
                            ss.pushArrayMetadata(keyMetadata);
                            JSONUtils.serializeJSONList((List)value, json, ss, cfcSerialized, useCustomSerializer);
                            continue;
                        }
                    } else if (value instanceof Map && (innerStructMetadata = JSONUtils.getInnerStructMetadata((Map)keyMetadata)) != null) {
                        ss.pushStructMetadata(innerStructMetadata);
                        JSONUtils.serializeJSONMap((Map)value, json, ss, cfcSerialized, useCustomSerializer);
                        continue;
                    }
                }
                JSONUtils.serializeJSONBase(value, json, ss, cfcSerialized, useCustomSerializer);
            }
            catch (IllegalDateArgumentException | IllegalBooleanValueException | NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                if (map instanceof StructBean) {
                    throw new JSONSerializeComplexJavaException(e);
                }
                if (e instanceof JSONSerializeBinaryException) {
                    throw (JSONSerializeBinaryException)e;
                }
                if (e instanceof NeoException) {
                    throw e;
                }
                json.append("");
            }
            catch (StackOverflowError e) {
                throw new JSONCyclicObjectException(e);
            }
        }
        json.append('}');
    }

    private static Map getStructMetadata(SerializerState ss, Map map) {
        ApplicationScope appScope;
        Map metadata = ss.popStructMetadata();
        if (metadata == null && (metadata = map instanceof Struct ? ((Struct)map).metadata : (map instanceof CaseSensitiveStruct ? ((CaseSensitiveStruct)map).metadata : null)) == null && FusionContext.getCurrent() != null && (appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName())) != null) {
            metadata = appScope.getApplicationSettings().getStructMetadata();
        }
        return metadata;
    }

    private static Object getStructKeyMetadata(String key, Map metadata) {
        if (metadata != null) {
            return metadata.get(key);
        }
        return null;
    }

    private static String getStructPropertyType(Object metadata) {
        Object type;
        if (metadata instanceof String) {
            return (String)metadata;
        }
        if (metadata instanceof Map && (type = ((Map)metadata).get(TYPE)) instanceof String && !((String)type).trim().isEmpty()) {
            return (String)type;
        }
        return null;
    }

    private static Object getArrayItemPropertyType(Object metadata, int index) {
        List itemsMD;
        if (metadata instanceof String) {
            return (String)metadata;
        }
        if (metadata instanceof List && index < (itemsMD = (List)metadata).size()) {
            return itemsMD.get(index);
        }
        return null;
    }

    private static Object getArrayPropertyType(Map metadata) {
        if (metadata != null) {
            Object type = metadata.get(ITEMS);
            if (type instanceof String && !((String)type).trim().isEmpty()) {
                return (String)type;
            }
            if (type instanceof List) {
                return (List)type;
            }
        }
        return null;
    }

    private static boolean isIgnoreProperty(Map keyMetadata) {
        Object ignore = keyMetadata.get(IGNORE);
        if (ignore != null) {
            return Cast._boolean(ignore);
        }
        return false;
    }

    private static String getStructKey(Map keyMetadata, String defaultKey) {
        Object name = keyMetadata.get(NAME);
        if (name instanceof String && !((String)name).trim().isEmpty()) {
            return (String)name;
        }
        return defaultKey;
    }

    private static Map getInnerStructMetadata(Map keyMetadata) {
        Object object = keyMetadata.get(KEYS);
        if (object instanceof Map) {
            return (Map)object;
        }
        return null;
    }

    private static String getSafeJSVarName(String varName) {
        StringBuilder buf = new StringBuilder(20);
        char[] c = varName.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            char ch = c[i];
            if (Character.isJavaIdentifierPart(ch)) {
                buf.append(ch);
                continue;
            }
            buf.append("_");
        }
        return buf.toString();
    }

    public static String getJSFileName(File pageFile) {
        String fileName = pageFile.getName();
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            fileName = fileName.substring(0, index);
        }
        fileName = JSONUtils.getSafeJSVarName(fileName);
        StringBuffer buf = new StringBuffer(fileName.length() + 20);
        buf.append("js");
        buf.append(fileName);
        int hc = pageFile.hashCode();
        if (hc < 0) {
            hc ^= 0xFFFFFFFF;
        }
        buf.append(hc);
        return buf.toString();
    }

    private static void serializeJSONProxy(TemplateProxy cfc, StringBuilder json, SerializerState ss, List cfcSerialized, boolean useCustomSerializer) {
        boolean persistent;
        if (cfcSerialized == null) {
            cfcSerialized = new ArrayList<String>(5);
        }
        AttributeCollection CFCMetaData = (AttributeCollection)cfc.getRuntimeMetadata();
        String persistentStr = (String)CFCMetaData.get("PERSISTENT");
        Object[] props = (Object[])CFCMetaData.get(Key.PROPERTIES);
        HashMap<String, String> columnVsDataType = new HashMap<String, String>();
        if (props != null && props.length > 0) {
            for (int i = 0; i < props.length; ++i) {
                AttributeCollection attr = (AttributeCollection)props[i];
                String name = (String)attr.get(Key.NAME);
                String type = (String)attr.get("TYPE");
                if (type == null) continue;
                columnVsDataType.put(name.toUpperCase(), type);
            }
        }
        boolean bl = persistent = persistentStr != null && (persistentStr.equalsIgnoreCase(TRUE) || persistentStr.equalsIgnoreCase("yes"));
        if (persistent) {
            int cfcIndex = cfcSerialized.indexOf(cfc.getCfcFullyQualifiedName());
            if (cfcIndex > -1 && cfcIndex < cfcSerialized.size() - 1) {
                json.append('{').append('}');
                return;
            }
            cfcSerialized.add(cfc.getCfcFullyQualifiedName());
        }
        Map<String, Object> map = JSONUtils.getCFCDataAsMap(cfc);
        boolean first = true;
        json.append('{');
        if (ss.serializeTemplateProxyMetadata) {
            json.append('\"').append("_metadata").append('\"').append(':');
            json.append('{');
            json.append('\"').append(NAME).append('\"').append(':');
            String path = JSONUtils.getJSFileName(new File((String)((Map)cfc.getMetadata()).get("PATH")));
            json.append('\"').append(JSONUtils.escape(path)).append('\"');
            json.append(',');
            json.append('\"').append("classname").append('\"').append(':');
            StringBuilder cfcPathBuffer = new StringBuilder();
            String contextPath = FusionContext.getCurrent().getRequest().getContextPath();
            if (contextPath != null && contextPath.length() > 0) {
                cfcPathBuffer.append(contextPath);
            }
            String fullName = (String)((Map)cfc.getMetadata()).get("FULLNAME");
            cfcPathBuffer.append("/").append(fullName.replace(".", "/")).append(".cfc");
            String name = cfcPathBuffer.toString();
            json.append('\"').append(JSONUtils.escape(name)).append('\"');
            json.append('}');
            json.append(',');
            json.append('\"').append("_variables").append('\"').append(':');
            json.append('{');
        }
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (!first) {
                json.append(',');
            }
            json.append('\"').append(JSONUtils.escape(key)).append('\"').append(':');
            if (value instanceof TemplateProxy && cfcSerialized != null) {
                first = false;
                JSONUtils.serializeJSONBase(value, json, ss, new ArrayList(cfcSerialized), useCustomSerializer);
                continue;
            }
            String propertyType = (String)columnVsDataType.get(key.toUpperCase());
            first = false;
            if (propertyType != null) {
                if (propertyType.equalsIgnoreCase(STRING) || propertyType.equalsIgnoreCase("guid") || propertyType.equalsIgnoreCase("uuid")) {
                    json.append('\"').append(JSONUtils.escape(String.valueOf(value))).append('\"');
                    continue;
                }
                if (propertyType.equalsIgnoreCase(NUMERIC) && value instanceof String) {
                    if (((String)value).isEmpty()) {
                        throw new NumberFormatException(RB.getString(JSONUtils.class, "JSON.EMPTY_STRING_TO_NUMERIC"));
                    }
                    String val_String = (String)value;
                    BigDecimal numeric = new BigDecimal(val_String);
                    for (int i = 0; i < val_String.length(); ++i) {
                        char ch = val_String.charAt(i);
                        if (ch != 'E' && ch != 'e') continue;
                        double d = numeric.doubleValue();
                        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) break;
                        value = d;
                        break;
                    }
                    json.append(value.toString());
                    continue;
                }
                if (propertyType.equalsIgnoreCase(BOOLEAN) && value instanceof String) {
                    if (JSONUtils.checkStringAsBoolean((String)value, json)) {
                        continue;
                    }
                } else if (propertyType.equalsIgnoreCase(DATE) && value instanceof String) {
                    value = DateUtils.parseDateTime((String)value);
                }
            }
            JSONUtils.serializeJSONBase(value, json, ss, cfcSerialized, useCustomSerializer);
        }
        if (ss.serializeTemplateProxyMetadata) {
            json.append('}');
        }
        json.append('}');
    }

    public static Map<String, Object> getCFCDataAsMap(TemplateProxy cfc) {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        AttributeCollection CFCMetaData = (AttributeCollection)cfc.getMetadata();
        for (Map.Entry entry : cfc.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof UDFMethod) continue;
            map.put(entry.getKey().toString(), value);
        }
        MetadataUtils.getAllProperties(CFCMetaData);
        Map properties = (Map)CFCMetaData.get(Key.PROPERTY_STRUCT);
        if (properties != null) {
            for (Object o : properties.keySet()) {
                String name;
                String propertyName = (String)o;
                AttributeCollection prop = (AttributeCollection)properties.get(propertyName);
                if (!prop.containsKey("NAME") || map.containsKey(name = (String)prop.get("NAME"))) continue;
                Object val = null;
                boolean remoteFetch = JSONUtils.isRemotingFetch(CFCMetaData, prop);
                if (!remoteFetch) continue;
                UDFMethod getter = JSONUtils.findGetMethod(cfc, name);
                if (getter != null) {
                    try {
                        val = getter.invoke((Object)cfc, "GET" + name.toUpperCase(), (Object)cfc.page, new Object[0]);
                    }
                    catch (NeoException ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException(ex);
                    }
                } else {
                    String getterProp = (String)prop.get("GETTER");
                    if (getterProp == null || getterProp.equalsIgnoreCase(TRUE) || getterProp.equalsIgnoreCase("yes")) {
                        val = cfc.page.pageContext.getVariableScope().get(name);
                    }
                    if (val instanceof UDFMethod) {
                        val = null;
                    }
                }
                if (val == null) continue;
                map.put(name, val);
            }
        }
        return map;
    }

    private static boolean isRemotingFetch(AttributeCollection CFCMetaData, AttributeCollection prop) {
        String persistentStr = (String)CFCMetaData.get("PERSISTENT");
        boolean persistent = persistentStr != null && (persistentStr.equalsIgnoreCase(TRUE) || persistentStr.equalsIgnoreCase("yes"));
        Boolean rFetchBoolean = Boolean.TRUE;
        if (persistent) {
            String rFetch = (String)prop.get("remotingFetch");
            if (rFetch != null) {
                rFetchBoolean = Cast._boolean(rFetch, false);
                if (rFetchBoolean == null) {
                    rFetchBoolean = Boolean.FALSE;
                }
            } else {
                String fieldType = (String)prop.get("fieldType");
                if (fieldType != null && (fieldType.equalsIgnoreCase("one-to-many") || fieldType.equalsIgnoreCase("one-to-one") || fieldType.equalsIgnoreCase("many-to-one") || fieldType.equalsIgnoreCase("many-to-many"))) {
                    rFetchBoolean = Boolean.FALSE;
                }
            }
        }
        return rFetchBoolean;
    }

    private static void serializeArrayToJSON(Object o, StringBuilder json, SerializerState ss, List cfcSerialized, boolean useCustomSerializer) {
        Class<?> componentClass = o.getClass().getComponentType();
        if (componentClass.isPrimitive()) {
            if (componentClass == Character.TYPE) {
                JSONUtils.serializeJSONBase(new String((char[])o), json, ss, cfcSerialized, useCustomSerializer);
            } else {
                if (componentClass == Byte.TYPE) {
                    throw new JSONSerializeBinaryException();
                }
                json.append('[');
                for (int i = 0; i < java.lang.reflect.Array.getLength(o); ++i) {
                    Object value = java.lang.reflect.Array.get(o, i);
                    if (i != 0) {
                        json.append(',');
                    }
                    json.append(value);
                }
                json.append(']');
            }
        } else {
            Object[] oArr = (Object[])o;
            json.append('[');
            for (int i = 0; i < oArr.length; ++i) {
                if (i != 0) {
                    json.append(',');
                }
                JSONUtils.serializeJSONBase(oArr[i], json, ss, cfcSerialized, useCustomSerializer);
            }
            json.append(']');
        }
    }

    private static UDFMethod findGetMethod(TemplateProxy cfc, String property) {
        return cfc.resolveMethod("GET" + property.toUpperCase(), false);
    }

    private static void serializeQueryByColumns(imqTable table, StringBuilder json, SerializerState ss, List cfcSerialized, boolean useCustomSerializer) {
        int i;
        boolean preserveColumnCase;
        json.append('{');
        int rowCount = table.getRowCount();
        json.append(QUERY_ROWCOUNT).append(':').append(rowCount).append(',');
        String[] colNames = table.getMeta().getColumnLabels();
        int colCount = colNames.length;
        StringBuilder[] serializedColData = new StringBuilder[colCount];
        json.append(QUERY_COLUMNS).append(':');
        json.append('[');
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
        boolean bl = preserveColumnCase = appScope == null ? false : appScope.getApplicationSettings().getPreserveCaseForQueryColumn();
        if (!preserveColumnCase) {
            for (i = 0; i < colNames.length; ++i) {
                colNames[i] = colNames[i].toUpperCase();
            }
        }
        for (i = 0; i < colCount; ++i) {
            if (i != 0) {
                json.append(',');
            }
            json.append('\"').append(colNames[i]).append('\"');
            serializedColData[i] = new StringBuilder();
        }
        json.append(']');
        json.append(',');
        json.append(QUERY_DATA).append(':').append('{');
        for (i = 0; i < rowCount; ++i) {
            Row row = table.getRow(i);
            for (int j = 0; j < colCount; ++j) {
                if (i != 0) {
                    serializedColData[j].append(',');
                }
                Object colData = row.getColumn(j);
                if (!useCustomSerializer && colData instanceof String) {
                    serializedColData[j].append('\"').append(JSONUtils.escape((String)colData)).append('\"');
                    continue;
                }
                JSONUtils.serializeJSONBase(colData, serializedColData[j], ss, cfcSerialized, useCustomSerializer);
            }
        }
        for (i = 0; i < colCount; ++i) {
            if (i != 0) {
                json.append(',');
            }
            json.append('\"').append(colNames[i].toUpperCase()).append('\"').append(':').append('[').append((CharSequence)serializedColData[i]).append(']');
        }
        json.append('}');
        json.append('}');
    }

    private static void serializeQueryByRows(imqTable table, StringBuilder json, SerializerState ss, List cfcSerialized, boolean useCustomSerializer) {
        int i;
        boolean preserveColumnCase;
        json.append('{');
        String[] colNames = table.getMeta().getColumnLabels();
        int colCount = colNames.length;
        json.append(QUERY_COLUMNS).append(':');
        json.append('[');
        ApplicationScope appScope = null;
        if (FusionContext.getCurrent() != null) {
            appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
        }
        boolean bl = preserveColumnCase = appScope == null ? false : appScope.getApplicationSettings().getPreserveCaseForQueryColumn();
        if (!preserveColumnCase) {
            for (i = 0; i < colNames.length; ++i) {
                colNames[i] = colNames[i].toUpperCase();
            }
        }
        for (i = 0; i < colCount; ++i) {
            if (i != 0) {
                json.append(',');
            }
            json.append('\"').append(colNames[i]).append('\"');
        }
        json.append(']');
        json.append(',');
        json.append(QUERY_DATA).append(':');
        int rowCount = table.getRowCount();
        json.append('[');
        for (int i2 = 0; i2 < rowCount; ++i2) {
            Row row = table.getRow(i2);
            if (i2 != 0) {
                json.append(',');
            }
            json.append('[');
            for (int j = 0; j < colCount; ++j) {
                if (j != 0) {
                    json.append(',');
                }
                Object colData = row.getColumn(j);
                if (!useCustomSerializer && colData instanceof String) {
                    json.append('\"').append(JSONUtils.escape((String)colData)).append('\"');
                    continue;
                }
                JSONUtils.serializeJSONBase(colData, json, ss, cfcSerialized, useCustomSerializer);
            }
            json.append(']');
        }
        json.append(']');
        json.append('}');
    }

    private static void serializeQueryByRows(QueryBean table, StringBuilder json, SerializerState ss, List cfcSerialized, boolean useCustomSerializer) {
        int i;
        boolean preserveColumnCase;
        json.append('{');
        String[] colNames = table.getColumnList();
        int colCount = colNames.length;
        json.append(QUERY_COLUMNS).append(':');
        json.append('[');
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
        boolean bl = preserveColumnCase = appScope == null ? false : appScope.getApplicationSettings().getPreserveCaseForQueryColumn();
        if (!preserveColumnCase) {
            for (i = 0; i < colCount; ++i) {
                colNames[i] = colNames[i].toUpperCase();
            }
        }
        for (i = 0; i < colCount; ++i) {
            if (i != 0) {
                json.append(',');
            }
            json.append('\"').append(colNames[i]).append('\"');
        }
        json.append(']');
        json.append(',');
        json.append(QUERY_DATA).append(':');
        Object[][] data = table.getData();
        int rowCount = data.length;
        json.append('[');
        for (int i2 = 0; i2 < rowCount; ++i2) {
            if (i2 != 0) {
                json.append(',');
            }
            json.append('[');
            for (int j = 0; j < colCount; ++j) {
                if (j != 0) {
                    json.append(',');
                }
                Object colData = data[i2][j];
                if (!useCustomSerializer && colData instanceof String) {
                    json.append('\"').append(JSONUtils.escape((String)colData)).append('\"');
                    continue;
                }
                JSONUtils.serializeJSONBase(colData, json, ss, cfcSerialized, useCustomSerializer);
            }
            json.append(']');
        }
        json.append(']');
        json.append('}');
    }

    private static void serializeQueryByStruct(imqTable table, StringBuilder json, SerializerState ss, List cfcSerialized, boolean useCustomSerializer) {
        int i;
        boolean preserveColumnCase;
        json.append('[');
        String[] colNames = table.getMeta().getColumnLabels();
        int colCount = colNames.length;
        int rowCount = table.getRowCount();
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
        boolean bl = preserveColumnCase = appScope == null ? false : appScope.getApplicationSettings().getPreserveCaseForQueryColumn();
        if (!preserveColumnCase) {
            for (i = 0; i < colCount; ++i) {
                colNames[i] = colNames[i].toUpperCase();
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Row row = table.getRow(i);
            if (i != 0) {
                json.append(',');
            }
            json.append('{');
            for (int j = 0; j < colCount; ++j) {
                if (j != 0) {
                    json.append(',');
                }
                Object colData = row.getColumn(j);
                json.append('\"').append(colNames[j]).append('\"').append(':');
                if (colData instanceof String) {
                    json.append('\"').append(JSONUtils.escape((String)colData)).append('\"');
                    continue;
                }
                JSONUtils.serializeJSONBase(colData, json, ss, cfcSerialized, useCustomSerializer);
            }
            json.append('}');
        }
        json.append(']');
    }

    public static boolean checkStringAsBoolean(String s, StringBuilder json) {
        if (s.trim().length() == 0) {
            return false;
        }
        switch (s.charAt(0)) {
            case 'Y': 
            case 'y': {
                if (!s.equalsIgnoreCase("yes")) break;
                json.append(TRUE);
                return true;
            }
            case 'N': 
            case 'n': {
                if (!s.equalsIgnoreCase("no")) break;
                json.append(FALSE);
                return true;
            }
            case 'T': 
            case 't': {
                if (!s.equalsIgnoreCase(TRUE)) break;
                json.append(TRUE);
                return true;
            }
            case 'F': 
            case 'f': {
                if (!s.equalsIgnoreCase(FALSE)) break;
                json.append(FALSE);
                return true;
            }
        }
        return false;
    }

    public static boolean checkStringAsNumber(String s, StringBuilder json) {
        if (s.trim().length() == 0) {
            return false;
        }
        switch (s.charAt(0)) {
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                try {
                    if (s.trim().charAt(s.trim().length() - 1) == '.') {
                        return false;
                    }
                    double d = CFDouble.parseDouble((String)s.trim());
                    if (numberAsDouble || s.charAt(0) == '.') {
                        if (Double.isInfinite(d)) {
                            throw new Cast.NumberConversionException(s);
                        }
                        json.append(d);
                    } else if (!(s.length() <= 1 || !s.startsWith("0") && !s.startsWith("+") && !s.startsWith("-0") || d < 1.0 && d >= -1.0 && s.contains(".") && !s.contains("00.") || numberAsDouble)) {
                        json.append('\"').append(s).append('\"');
                    } else {
                        json.append(s);
                    }
                    return true;
                }
                catch (RuntimeException ex) {
                    return false;
                }
            }
        }
        return false;
    }

    private static Object parseJSON(ParserState state) {
        Object cfml = JSONUtils.parseObject(state);
        if (!state.isComplete()) {
            throw new JSONParseException(state);
        }
        return cfml;
    }

    private static Object parseObject(ParserState state) {
        Object cfml;
        JSONUtils.walkWhitespace(state);
        switch (state.currentChar()) {
            case '{': {
                cfml = JSONUtils.parseStruct(state);
                FusionContext fc = FusionContext.getCurrent();
                Map cfmlStruct = (Map)cfml;
                if (fc != null && state.deserializeToTemplateProxy && cfmlStruct != null && cfmlStruct.get("_metadata") != null) {
                    cfml = JSONUtils.convertToTemplateProxy(cfmlStruct);
                    break;
                }
                if (cfml == null || state.strictTypes) break;
                cfml = JSONUtils.convertToQuery(cfmlStruct);
                break;
            }
            case '[': {
                cfml = JSONUtils.parseArray(state);
                if (!state.convertToQuery) break;
                cfml = JSONUtils.convertToQuery((Array)cfml, state.preserveCaseSensitive);
                break;
            }
            case '\"': {
                cfml = JSONUtils.parseString(state);
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                cfml = JSONUtils.parseNumber(state, true);
                break;
            }
            case '-': {
                cfml = JSONUtils.parseNumber(state, false);
                break;
            }
            case 't': {
                cfml = JSONUtils.parseBoolean(state, true);
                break;
            }
            case 'f': {
                cfml = JSONUtils.parseBoolean(state, false);
                break;
            }
            case 'n': {
                cfml = JSONUtils.parseNull(state);
                break;
            }
            default: {
                throw new JSONParseException(state);
            }
        }
        return cfml;
    }

    private static void walkWhitespace(ParserState state) {
        boolean isWhitespace = true;
        block3: while (!state.isComplete() && isWhitespace) {
            switch (state.json[state.offset]) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    state.incrementOffset();
                    continue block3;
                }
            }
            isWhitespace = false;
        }
    }

    private static Map parseStruct(ParserState state) {
        CFComparable struct = null;
        if (state.construct) {
            struct = state.preserveCaseSensitive && !state.convertToQuery ? new CaseSensitiveStruct() : new Struct();
        }
        state.incrementOffset();
        boolean done = false;
        JSONUtils.walkWhitespace(state);
        if (state.currentChar() == '}') {
            done = true;
        }
        block4: while (!done) {
            if (state.currentChar() != '\"') {
                throw new JSONParseInvalidCharException(state, '\"');
            }
            String key = JSONUtils.parseString(state);
            JSONUtils.walkWhitespace(state);
            if (state.currentChar() != ':') {
                throw new JSONParseInvalidCharException(state, ':');
            }
            state.incrementOffset();
            Object value = JSONUtils.parseObject(state);
            if (state.construct) {
                struct.put(key, value);
            }
            JSONUtils.walkWhitespace(state);
            switch (state.currentChar()) {
                case ',': {
                    state.incrementOffset();
                    JSONUtils.walkWhitespace(state);
                    continue block4;
                }
                case '}': {
                    done = true;
                    continue block4;
                }
            }
            throw new JSONParseInvalidCharsException(state, ',', '}');
        }
        state.incrementOffset(false);
        return struct;
    }

    private static Array parseArray(ParserState state) {
        Array array = null;
        if (state.construct) {
            array = new Array();
        }
        state.incrementOffset();
        boolean done = false;
        JSONUtils.walkWhitespace(state);
        if (state.currentChar() == ']') {
            done = true;
        }
        block4: while (!done) {
            Object value = JSONUtils.parseObject(state);
            if (state.construct) {
                array.add(value);
            }
            JSONUtils.walkWhitespace(state);
            switch (state.currentChar()) {
                case ',': {
                    state.incrementOffset();
                    JSONUtils.walkWhitespace(state);
                    continue block4;
                }
                case ']': {
                    done = true;
                    continue block4;
                }
            }
            throw new JSONParseInvalidCharsException(state, ',', ']');
        }
        state.incrementOffset(false);
        return array;
    }

    private static String parseString(ParserState state) {
        state.incrementOffset();
        int stringStartIndex = state.offset;
        StringBuilder s = null;
        if (state.construct) {
            s = new StringBuilder();
        }
        while (state.currentChar() != '\"') {
            if (state.json[state.offset] == '\\') {
                if (state.construct) {
                    s.append(state.json, stringStartIndex, state.offset - stringStartIndex);
                }
                state.incrementOffset();
                switch (state.json[state.offset]) {
                    case '\'': {
                        if (!state.construct) break;
                        s.append('\'');
                        break;
                    }
                    case '\"': {
                        if (!state.construct) break;
                        s.append('\"');
                        break;
                    }
                    case '\\': {
                        if (!state.construct) break;
                        s.append('\\');
                        break;
                    }
                    case '/': {
                        if (!state.construct) break;
                        s.append('/');
                        break;
                    }
                    case 'b': {
                        if (!state.construct) break;
                        s.append('\b');
                        break;
                    }
                    case 'f': {
                        if (!state.construct) break;
                        s.append('\f');
                        break;
                    }
                    case 'n': {
                        if (!state.construct) break;
                        s.append('\n');
                        break;
                    }
                    case 'r': {
                        if (!state.construct) break;
                        s.append('\r');
                        break;
                    }
                    case 't': {
                        if (!state.construct) break;
                        s.append('\t');
                        break;
                    }
                    case 'u': {
                        char c;
                        state.incrementOffset();
                        try {
                            byte b1 = (byte)Integer.parseInt(new String(state.json, state.offset, 2), 16);
                            byte b2 = (byte)Integer.parseInt(new String(state.json, state.offset + 2, 2), 16);
                            ByteBuffer bb = state.getByteBuffer();
                            bb.put(b1).put(b2);
                            c = bb.getChar(0);
                        }
                        catch (Throwable t) {
                            throw new JSONParseInvalidUnicodeSequenceException(state, t);
                        }
                        if (state.construct) {
                            s.append(c);
                        }
                        state.incrementOffset(3);
                        break;
                    }
                    default: {
                        throw new JSONParseException(state);
                    }
                }
                stringStartIndex = state.offset + 1;
            }
            state.incrementOffset();
        }
        String str = null;
        if (state.construct) {
            int stringLength = state.offset - stringStartIndex;
            if (stringLength > 0) {
                s.append(state.json, stringStartIndex, stringLength);
            }
            str = s.toString();
        }
        state.incrementOffset(false);
        return str;
    }

    private static Number parseNumber(ParserState state, boolean foundNumber) {
        char c;
        int numberStartIndex = state.offset;
        boolean isNumber = true;
        boolean foundE = false;
        boolean foundDecimal = false;
        state.incrementOffset(false);
        while (isNumber && !state.isComplete()) {
            switch (state.currentChar()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    foundNumber = true;
                    break;
                }
                case '.': {
                    if (foundDecimal || foundE) {
                        throw new JSONParseException(state);
                    }
                    foundDecimal = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (foundE || !foundNumber) {
                        throw new JSONParseException(state);
                    }
                    foundE = true;
                    if (state.previousChar() == '.') {
                        throw new JSONParseException(state);
                    }
                    if (state.nextChar() != '+' && state.nextChar() != '-') break;
                    state.incrementOffset();
                    break;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ']': 
                case '}': {
                    isNumber = false;
                    break;
                }
                default: {
                    throw new JSONParseException(state);
                }
            }
            if (!isNumber) continue;
            state.incrementOffset(false);
        }
        if (!foundNumber) {
            throw new JSONParseException(state);
        }
        if (foundDecimal && (c = state.previousChar()) == '.') {
            throw new JSONParseException(state);
        }
        Double d = null;
        Integer i = null;
        if (state.construct) {
            String numberStr = new String(state.json, numberStartIndex, state.offset - numberStartIndex);
            if (!(foundDecimal || foundE || numberAsDouble)) {
                try {
                    i = Integer.valueOf(numberStr);
                    return i;
                }
                catch (Exception e) {
                    try {
                        long l = Long.valueOf(numberStr);
                        return l;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (Double.isInfinite(d = Double.valueOf(numberStr))) {
                return new CFBigDecimal(numberStr);
            }
        }
        return d;
    }

    private static Boolean parseBoolean(ParserState state, boolean expected) {
        String compareTo = expected ? TRUE : FALSE;
        for (int i = 1; i < compareTo.length(); ++i) {
            state.incrementOffset();
            if (state.currentChar() == compareTo.charAt(i)) continue;
            throw new JSONParseException(state);
        }
        state.incrementOffset(false);
        Boolean b = expected ? Boolean.TRUE : Boolean.FALSE;
        return b;
    }

    private static String parseNull(ParserState state) {
        for (int i = 1; i < NULL.length(); ++i) {
            state.incrementOffset();
            if (state.currentChar() == NULL.charAt(i)) continue;
            throw new JSONParseException(state);
        }
        state.incrementOffset(false);
        return null;
    }

    private static String escape(String s) {
        int i;
        StringBuilder escaped = new StringBuilder();
        char[] chars = s.toCharArray();
        int unescapeIdx = 0;
        for (i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\"': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('\"');
                    break;
                }
                case '\\': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('\\');
                    break;
                }
                case '\b': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('b');
                    break;
                }
                case '\f': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('f');
                    break;
                }
                case '\n': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('n');
                    break;
                }
                case '\r': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('r');
                    break;
                }
                case '\t': {
                    escaped.append(chars, unescapeIdx, i - unescapeIdx);
                    unescapeIdx = i + 1;
                    escaped.append('\\').append('t');
                    break;
                }
            }
            char c = chars[i];
            String specialCharVal = SPECIAL_CHAR_MAP.get(c);
            if (specialCharVal == null) continue;
            escaped.append(chars, unescapeIdx, i - unescapeIdx);
            escaped.append(specialCharVal);
            unescapeIdx = i + 1;
        }
        if (unescapeIdx <= i) {
            escaped.append(chars, unescapeIdx, chars.length - unescapeIdx);
        }
        return escaped.toString();
    }

    private static boolean isUnicodeChar(char[] chars, int startIndex) {
        for (int j = 1; j < 5; ++j) {
            char c = chars[startIndex + j];
            if (c > '/' && c < ':' || c > '@' && c < 'G' || c > '`' && c < 'g') continue;
            return false;
        }
        return true;
    }

    private static Map convertToTemplateProxy(Map s) {
        Map ret = s;
        try {
            Object metadata = s.get("_metadata");
            FusionContext context = FusionContext.getCurrent();
            if (metadata != null) {
                Map vars;
                String serverClass = (String)((Map)metadata).get("classname");
                String contextPath = context.getRequest().getContextPath();
                if (!serverClass.startsWith("/")) {
                    serverClass = serverClass.substring(serverClass.indexOf("//") + 2);
                    serverClass = serverClass.substring(serverClass.indexOf("/") + 1);
                }
                if (contextPath != null && !"".equals(contextPath) && serverClass.startsWith(contextPath)) {
                    serverClass = serverClass.substring(contextPath.length());
                }
                File pageFile = new File(context.getRealPath(serverClass, true));
                TemplateProxy tp = TemplateProxyFactory.resolveFile(context.pageContext, pageFile);
                Object varObj = s.get("_variables");
                Map map = vars = varObj instanceof Array ? null : (Map)varObj;
                if (vars != null) {
                    tp.getVariableScope().putAll(vars);
                }
                return tp;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    private static Object convertToQuery(Map s) {
        Object ret = s;
        Set keys = s.keySet();
        if (keys.size() == 2) {
            Object dataObj;
            Object columnsObj = s.get(QUERY_COLUMNS_STR);
            if (columnsObj != null && columnsObj instanceof Array && (dataObj = s.get(QUERY_DATA_STR)) != null && dataObj instanceof Array) {
                boolean validQuery = true;
                Array columnsArray = (Array)columnsObj;
                String[] columns = new String[columnsArray.size()];
                for (int i = 0; i < columnsArray.size(); ++i) {
                    try {
                        columns[i] = (String)columnsArray.get(i);
                        continue;
                    }
                    catch (ClassCastException e) {
                        validQuery = false;
                        break;
                    }
                }
                if (validQuery) {
                    Array data = (Array)dataObj;
                    JsonQuery jq = new JsonQuery(columns);
                    if (data.size() > 0) {
                        for (int i = 0; i < data.size(); ++i) {
                            Object rowObj = data.get(i);
                            if (!(rowObj instanceof Array)) {
                                validQuery = false;
                                break;
                            }
                            Object[] row = ((Array)rowObj).toArray();
                            jq.addDataRow(row);
                        }
                    }
                    if (validQuery) {
                        ret = jq;
                    }
                }
            }
        } else if (keys.size() == 3) {
            Object columnsObj;
            int rowCount = 0;
            Object rowCountObj = s.get(QUERY_ROWCOUNT_STR);
            if (rowCountObj != null && rowCountObj instanceof Number && (rowCount = ((Number)rowCountObj).intValue()) >= 0 && (columnsObj = s.get(QUERY_COLUMNS_STR)) != null && columnsObj instanceof Array) {
                Map data;
                Set dataKeys;
                Object dataObj;
                boolean validQuery = true;
                Array columnsArray = (Array)columnsObj;
                String[] columns = new String[columnsArray.size()];
                for (int i = 0; i < columnsArray.size(); ++i) {
                    try {
                        columns[i] = (String)columnsArray.get(i);
                        continue;
                    }
                    catch (ClassCastException e) {
                        validQuery = false;
                        break;
                    }
                }
                if (validQuery && (dataObj = s.get(QUERY_DATA_STR)) != null && dataObj instanceof Map && (dataKeys = (data = (Map)dataObj).keySet()).size() == columnsArray.size() && dataKeys.containsAll(columnsArray)) {
                    Collection dataValues = data.values();
                    for (Object dataValue : dataValues) {
                        if (!(dataValue instanceof Array)) {
                            validQuery = false;
                            break;
                        }
                        if (((Array)dataValue).size() == rowCount) continue;
                        validQuery = false;
                        break;
                    }
                    if (validQuery) {
                        JsonQuery jq = new JsonQuery(columns);
                        for (int i = 0; i < rowCount; ++i) {
                            Object[] row = new Object[columns.length];
                            for (int j = 0; j < columns.length; ++j) {
                                Array colData = (Array)data.get(columns[j]);
                                row[j] = colData.get(i);
                            }
                            jq.addDataRow(row);
                        }
                        ret = jq;
                    }
                }
            }
        }
        return ret;
    }

    private static Object convertToQuery(Array cfml, boolean caseSensitive) {
        Array array = cfml;
        HashSet keySet = new HashSet();
        for (Object obj : array) {
            if (!(obj instanceof Map)) {
                return cfml;
            }
            Map map = (Map)obj;
            if (caseSensitive) {
                keySet.addAll(map.keySet());
                continue;
            }
            map.keySet().stream().map(x -> x.toString().toUpperCase()).forEach(x -> keySet.add((String)x));
        }
        String[] columns = keySet.toArray(new String[0]);
        JsonQuery jsonQuery = new JsonQuery(columns);
        for (Object obj : array) {
            Map map = (Map)obj;
            Object[] arr = new Object[keySet.size()];
            int j = 0;
            for (String key : columns) {
                arr[j++] = map.getOrDefault(key, null);
            }
            jsonQuery.addDataRow(arr);
        }
        return jsonQuery;
    }

    public static SerializerProxyWrapper getSerializerProxy() {
        Map appSettings;
        if (FusionContext.getCurrent() == null) {
            return null;
        }
        ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
        String serializer = null;
        if (appScope != null && (appSettings = appScope.getApplicationSettingsMap()) != null) {
            serializer = (String)appSettings.get("CustomSerializer");
        }
        if (null != serializer && serializer.trim().length() > 0) {
            try {
                Map appSettings2;
                SerializerProxyWrapper serializerProxy = new SerializerProxyWrapper(TemplateProxyFactory.resolveName(serializer, FusionContext.getCurrent().pageContext));
                if (appScope != null && (appSettings2 = appScope.getApplicationSettingsMap()) != null) {
                    appSettings2.put("CustomSerializerInstance", serializerProxy);
                }
                return serializerProxy;
            }
            catch (Throwable e) {
                throw new InvalidSerializerException(serializer, e);
            }
        }
        return null;
    }

    private static boolean serializeUsingCustomSerializer(Object obj, StringBuilder json, SerializerState ss, List cfcSerialized, boolean useCustomSerializer) {
        SerializerProxyWrapper serializerProxy;
        if (useCustomSerializer && null != (serializerProxy = JSONUtils.getSerializerProxy())) {
            boolean canSerialize = false;
            try {
                canSerialize = serializerProxy.canSerialize("JSON");
            }
            catch (Throwable e1) {
                logger.error(e1);
            }
            if (canSerialize && JSONUtils.isDifferentObjectToBeSerialized(obj)) {
                FusionContext context = FusionContext.getCurrent();
                Object olddata = context.getCurrentSerializedData();
                String result = null;
                try {
                    context.setCurrentSerializedData(obj);
                    result = serializerProxy.serialize(obj, "JSON");
                }
                catch (Throwable e) {
                    throw new JSONSerializeException(e.getMessage());
                }
                finally {
                    context.setCurrentSerializedData(olddata);
                }
                json.append(result);
                return true;
            }
        }
        return false;
    }

    private static boolean isDifferentObjectToBeSerialized(Object obj) {
        Object currentSerializedData = FusionContext.getCurrent().getCurrentSerializedData();
        return null == currentSerializedData || false == currentSerializedData.equals(obj);
    }

    static {
        numberAsDouble = Boolean.getBoolean("json.numberasdouble");
        SPECIAL_CHAR_MAP = new HashMap<Integer, String>();
        SPECIAL_CHAR_MAP.put(new Integer(0), "\\u0000");
        SPECIAL_CHAR_MAP.put(new Integer(1), "\\u0001");
        SPECIAL_CHAR_MAP.put(new Integer(2), "\\u0002");
        SPECIAL_CHAR_MAP.put(new Integer(3), "\\u0003");
        SPECIAL_CHAR_MAP.put(new Integer(4), "\\u0004");
        SPECIAL_CHAR_MAP.put(new Integer(5), "\\u0005");
        SPECIAL_CHAR_MAP.put(new Integer(6), "\\u0006");
        SPECIAL_CHAR_MAP.put(new Integer(7), "\\u0007");
        SPECIAL_CHAR_MAP.put(new Integer(11), "\\u000b");
        SPECIAL_CHAR_MAP.put(new Integer(14), "\\u000e");
        SPECIAL_CHAR_MAP.put(new Integer(15), "\\u000f");
        SPECIAL_CHAR_MAP.put(new Integer(16), "\\u0010");
        SPECIAL_CHAR_MAP.put(new Integer(17), "\\u0011");
        SPECIAL_CHAR_MAP.put(new Integer(18), "\\u0012");
        SPECIAL_CHAR_MAP.put(new Integer(19), "\\u0013");
        SPECIAL_CHAR_MAP.put(new Integer(20), "\\u0014");
        SPECIAL_CHAR_MAP.put(new Integer(21), "\\u0015");
        SPECIAL_CHAR_MAP.put(new Integer(22), "\\u0016");
        SPECIAL_CHAR_MAP.put(new Integer(23), "\\u0017");
        SPECIAL_CHAR_MAP.put(new Integer(24), "\\u0018");
        SPECIAL_CHAR_MAP.put(new Integer(25), "\\u0019");
        SPECIAL_CHAR_MAP.put(new Integer(26), "\\u001a");
        SPECIAL_CHAR_MAP.put(new Integer(27), "\\u001b");
        SPECIAL_CHAR_MAP.put(new Integer(28), "\\u001c");
        SPECIAL_CHAR_MAP.put(new Integer(29), "\\u001d");
        SPECIAL_CHAR_MAP.put(new Integer(30), "\\u001e");
        SPECIAL_CHAR_MAP.put(new Integer(31), "\\u001f");
        SPECIAL_CHAR_MAP.put(new Integer(127), "\\u007f");
    }

    private static class SerializerState {
        boolean serializeTemplateProxyMetadata;
        String serializeQueryAs = "row";
        SimpleDateFormat dateFormatter;
        Stack<Map> structMetadata;
        Stack<Object> ArrayMetadata;

        private SerializerState() {
        }

        public SimpleDateFormat getDateFormatter() {
            if (this.dateFormatter == null) {
                this.dateFormatter = new SimpleDateFormat(JSONUtils.JS_DATE_FORMAT, Locale.ENGLISH);
            }
            return this.dateFormatter;
        }

        public void pushStructMetadata(Map metadata) {
            if (this.structMetadata == null) {
                this.structMetadata = new Stack();
            }
            this.structMetadata.push(metadata);
        }

        public Map popStructMetadata() {
            if (this.structMetadata != null && this.structMetadata.size() > 0) {
                return this.structMetadata.pop();
            }
            return null;
        }

        public void pushArrayMetadata(Object metadata) {
            if (this.ArrayMetadata == null) {
                this.ArrayMetadata = new Stack();
            }
            this.ArrayMetadata.push(metadata);
        }

        public Object popArrayMetadata() {
            if (this.ArrayMetadata != null && this.ArrayMetadata.size() > 0) {
                return this.ArrayMetadata.pop();
            }
            return null;
        }
    }

    public static class InvalidSerializeQueryTypeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidSerializeQueryObjectException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class JSONParseInvalidTypeException
    extends JSONParseException {
    }

    private static class ParserState {
        char[] json;
        int offset = 0;
        boolean construct;
        boolean strictTypes;
        boolean convertToQuery;
        boolean deserializeToTemplateProxy;
        ByteBuffer bb;
        boolean preserveCaseSensitive;

        ParserState(String s, boolean construct, boolean strictTypes) {
            this.json = s.toCharArray();
            this.construct = construct;
            this.strictTypes = strictTypes;
        }

        ParserState(String s, boolean construct, boolean strictTypes, boolean deserializeToTemplateProxy, boolean preserveCaseSensitive) {
            this.json = s.toCharArray();
            this.construct = construct;
            this.strictTypes = strictTypes;
            this.deserializeToTemplateProxy = deserializeToTemplateProxy;
            this.preserveCaseSensitive = preserveCaseSensitive;
        }

        public char currentChar() {
            if (this.offset >= this.json.length) {
                throw new JSONParseOverflowException();
            }
            return this.json[this.offset];
        }

        public char nextChar() {
            if (this.offset + 1 >= this.json.length) {
                throw new JSONParseOverflowException();
            }
            return this.json[this.offset + 1];
        }

        public char previousChar() {
            if (this.offset - 1 < 0) {
                throw new JSONParseOverflowException();
            }
            return this.json[this.offset - 1];
        }

        public boolean isComplete() {
            return this.offset >= this.json.length;
        }

        public void incrementOffset() {
            this.incrementOffset(1, true);
        }

        public void incrementOffset(int incr) {
            this.incrementOffset(incr, true);
        }

        public void incrementOffset(boolean throwOnOverflow) {
            this.incrementOffset(1, throwOnOverflow);
        }

        public void incrementOffset(int incr, boolean throwOnOverflow) {
            this.offset += incr;
            if (this.offset >= this.json.length && throwOnOverflow) {
                throw new JSONParseOverflowException();
            }
        }

        public ByteBuffer getByteBuffer() {
            if (this.bb == null) {
                this.bb = ByteBuffer.allocate(4);
            } else {
                this.bb.clear();
            }
            return this.bb;
        }
    }

    public static class JSONParseException
    extends ApplicationException {
        public String json;
        public int offset;
        public char character;

        protected JSONParseException() {
        }

        public JSONParseException(ParserState state) {
            this.json = new String(state.json);
            this.offset = state.offset + 1;
            this.character = state.currentChar();
        }

        public JSONParseException(ParserState state, Throwable e) {
            super(e);
            this.json = new String(state.json);
            this.offset = state.offset + 1;
            this.character = state.currentChar();
        }
    }

    public static class IllegalBooleanValueException
    extends ExpressionException {
        public String value;

        public IllegalBooleanValueException(String value) {
            this.value = value;
        }
    }

    public static class JSONSerializeComplexJavaException
    extends ApplicationException {
        public JSONSerializeComplexJavaException(Exception e) {
            super(e);
        }
    }

    public static class JSONSerializeBinaryException
    extends ApplicationException {
    }

    public static class JSONCyclicObjectException
    extends ApplicationException {
        public JSONCyclicObjectException(Throwable e) {
            super(e);
        }
    }

    public static class JSONParseInvalidCharException
    extends JSONParseException {
        public char expected;

        public JSONParseInvalidCharException(ParserState state, char expected) {
            super(state);
            this.expected = expected;
        }
    }

    public static class JSONParseInvalidCharsException
    extends JSONParseException {
        public char expectedOne;
        public char expectedTwo;

        public JSONParseInvalidCharsException(ParserState state, char expectedOne, char expectedTwo) {
            super(state);
            this.expectedOne = expectedOne;
            this.expectedTwo = expectedTwo;
        }
    }

    public static class JSONParseInvalidUnicodeSequenceException
    extends JSONParseException {
        public JSONParseInvalidUnicodeSequenceException(ParserState state, Throwable e) {
            super(state, e);
        }
    }

    private static class JsonQuery
    extends QueryTable {
        public JsonQuery(String[] cols) {
            super(0, cols);
        }

        public void addDataRow(Object[] data) {
            this.addRow(data);
        }
    }

    public static class JSONSerializeException
    extends ApplicationException {
        public final String message;

        public JSONSerializeException(String message) {
            this.message = message;
        }
    }

    public static class IllegalMetadataTypeException
    extends ExpressionException {
        public String value;

        public IllegalMetadataTypeException(String value) {
            this.value = value;
        }
    }

    public static class JSONParseOverflowException
    extends JSONParseException {
    }
}

