/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFComponent;
import coldfusion.runtime.ImplementationProcessor;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.implementation.exceptions.java.ImplementationException;
import coldfusion.runtime.java.CFCDynamicProxy;
import coldfusion.runtime.java.ClassUtility;
import coldfusion.runtime.util.TemplateProxyUtil;
import coldfusion.util.Key;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaImplementationProcessor
implements ImplementationProcessor {
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new HashMap();
    private static JavaImplementationProcessor instance;

    private JavaImplementationProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JavaImplementationProcessor getInstance() {
        if (instance != null) return instance;
        Class<JavaImplementationProcessor> clazz = JavaImplementationProcessor.class;
        synchronized (JavaImplementationProcessor.class) {
            if (instance != null) return instance;
            instance = new JavaImplementationProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public boolean isValidInterface(String s) {
        try {
            return CFCDynamicProxy.getJavaClass(s).isInterface();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public Set<String> getInterfaces(TemplateProxy cfc, boolean validate) throws Throwable {
        HashMap<String, Boolean> interfaces = new HashMap<String, Boolean>();
        this.findImplementationsRecursively(cfc, cfc, interfaces, "java", validate);
        return interfaces.keySet();
    }

    private void checkForValidInterface(List<String> javaExtends) throws Throwable {
        List notInterface;
        if (javaExtends != null && javaExtends.size() > 0 && !(notInterface = javaExtends.stream().filter(ImplementationProcessor.not(this::isValidInterface)).collect(Collectors.toList())).isEmpty()) {
            ImplementationException.throwInvalidJavaInterfaceException(String.join((CharSequence)",", notInterface));
        }
    }

    @Override
    public void validateImplementation(Map<String, Map<String, List<String>>> other, boolean implementingCFCIsInterface) throws Throwable {
        List javaImpls = (List)Optional.ofNullable(other.get("implements")).orElse(Collections.emptyMap()).get("java");
        List javaExtends = (List)Optional.ofNullable(other.get("extends")).orElse(Collections.emptyMap()).get("java");
        if (implementingCFCIsInterface) {
            if (javaImpls != null && javaImpls.size() > 0) {
                ImplementationException.throwInvalidInterfaceImplementationException(String.join((CharSequence)",", javaImpls));
            } else {
                this.checkForValidInterface(javaExtends);
            }
        } else if (javaExtends != null && javaExtends.size() > 0) {
            ImplementationException.throwExtendsJavaNotSupportedException();
        } else {
            this.checkForValidInterface(javaImpls);
        }
    }

    @Override
    public void verifyImplementation(Map<String, Boolean> javaImpls, boolean implementingCFCIsInterface, TemplateProxy proxy) throws Throwable {
        boolean onMissingMethodPresent;
        if (javaImpls == null) {
            return;
        }
        boolean bl = onMissingMethodPresent = proxy.resolveMethod("onMissingMethod", false) != null;
        if (proxy.page instanceof CFComponent && !TemplateProxyUtil.isAbstractComponent(proxy.page)) {
            for (String impl : javaImpls.keySet()) {
                Method[] javaMethods;
                if (javaImpls.get(impl).booleanValue()) continue;
                Class proxyClass = CFCDynamicProxy.getJavaClass(impl);
                if (!proxyClass.isInterface()) {
                    ImplementationException.throwNotAnInterfaceException(proxyClass);
                }
                for (Method m : javaMethods = CFCDynamicProxy.getJavaClass(impl).getDeclaredMethods()) {
                    if (!Modifier.isAbstract(m.getModifiers())) continue;
                    UDFMethod method = null;
                    method = proxy.resolveMethod(m.getName(), false);
                    if (method == null) {
                        if (onMissingMethodPresent) continue;
                        ImplementationException.throwMethodNotImplementedException(m.getName(), proxy.getName());
                    }
                    this.validateMethod(m, method, true);
                }
                javaImpls.put(impl, true);
            }
        }
    }

    private void validateMethod(Method javaMethod, UDFMethod udfMethod, boolean lenient) throws Throwable {
        this.checkParameterCount(javaMethod, udfMethod, lenient);
        this.checkReturnType(javaMethod, udfMethod, lenient);
        this.checkParameterType(javaMethod, udfMethod, lenient);
    }

    private void checkParameterCount(Method method, UDFMethod udfMethod, boolean lenient) throws Throwable {
        if (method.getParameterCount() > udfMethod.getParamList().length) {
            ImplementationException.throwDifferentNumberOfArgsException(method.getName(), method.getParameterTypes());
        }
    }

    private void checkReturnType(Method method, UDFMethod udfMethod, boolean lenient) throws Throwable {
        if (udfMethod.getReturnType().equalsIgnoreCase("any") && lenient) {
            return;
        }
        if (udfMethod.getReturnType() == null) {
            if (!method.getReturnType().toString().equalsIgnoreCase("void")) {
                ImplementationException.throwIncompatibleReturnTypeException(method.getName(), method.getReturnType().toString(), udfMethod.getReturnType());
            }
        } else if (!method.getReturnType().isAssignableFrom(ClassUtility.castCFtoJavaType(udfMethod.getReturnType())) && !this.equalUsingAdditionalLeniency(ClassUtility.castCFtoJavaType(udfMethod.getReturnType()), method.getReturnType())) {
            ImplementationException.throwIncompatibleReturnTypeException(method.getName(), method.getReturnType().toString(), udfMethod.getReturnType());
        }
    }

    private void checkParameterType(Method method, UDFMethod udfMethod, boolean lenient) throws Throwable {
        Class<?>[] paramType = method.getParameterTypes();
        String[] udfTypes = this.getType(udfMethod.getMethodAttributes());
        Class[] udfParamType = ClassUtility.castCFtoJavaType(udfTypes);
        for (int i = 0; i < paramType.length; ++i) {
            if (udfParamType[i].equals(Object.class) && lenient || udfParamType[i] == paramType[i] || this.equalUsingAdditionalLeniency(udfParamType[i], paramType[i])) continue;
            ImplementationException.throwArgumentTypeMismatchException(method.getName(), paramType[i], udfParamType[i]);
        }
    }

    private boolean equalUsingAdditionalLeniency(Class udfType, Class aClass) {
        if (aClass.isPrimitive()) {
            aClass = PRIMITIVES_TO_WRAPPERS.get(aClass);
        }
        return udfType.isAssignableFrom(aClass);
    }

    private String[] getType(AttributeCollection[] methodAttributes) {
        String[] types = new String[methodAttributes.length];
        for (int i = 0; i < methodAttributes.length; ++i) {
            types[i] = (String)methodAttributes[i].get(Key.TYPE);
        }
        return types;
    }

    @Override
    public Object getDynamicProxy(TemplateProxy cfc) {
        try {
            Set interfaces = (Set)Optional.ofNullable(cfc.getOtherImplementingInterfaces()).orElse(Collections.emptyMap()).get("java");
            if (!interfaces.isEmpty()) {
                return CFCDynamicProxy.createDynamicProxy(cfc, interfaces);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
        return null;
    }

    static {
        PRIMITIVES_TO_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES_TO_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVES_TO_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVES_TO_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVES_TO_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVES_TO_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVES_TO_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVES_TO_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVES_TO_WRAPPERS.put(Void.TYPE, Void.class);
    }
}

