/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.LockManager;
import coldfusion.runtime.LockStore;
import coldfusion.runtime.LockableScope;
import jakarta.servlet.jsp.PageContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class JavaLockStore
implements LockStore {
    private Map<String, ReadWriteLock> namedLocks = new HashMap<String, ReadWriteLock>();
    private ReentrantReadWriteLock serverLock = new ReentrantReadWriteLock(true);
    private Map<String, Semaphore> concurrentLocks = new HashMap<String, Semaphore>();
    private boolean fairness;

    JavaLockStore(boolean fairness) {
        this.fairness = fairness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestNamedLock(String key, boolean readonly, long timeout) throws InterruptedException {
        Lock loc;
        ReadWriteLock lock;
        key = key.toUpperCase();
        JavaLockStore javaLockStore = this;
        synchronized (javaLockStore) {
            lock = this.namedLocks.get(key);
            if (lock == null) {
                lock = new ReadWriteLock(this.fairness);
                this.namedLocks.put(key, lock);
            }
            lock.holdObject();
        }
        Lock lock2 = loc = readonly ? lock.readLock() : lock.writeLock();
        if (!loc.tryLock(timeout, TimeUnit.MILLISECONDS)) {
            lock.unholdObject();
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseNamedLock(String key, boolean readonly) {
        ReadWriteLock lock;
        key = key.toUpperCase();
        JavaLockStore javaLockStore = this;
        synchronized (javaLockStore) {
            lock = this.namedLocks.get(key);
            if (lock == null) {
                throw new LockManager.UnknownLockException(key);
            }
        }
        Lock loc = readonly ? lock.readLock() : lock.writeLock();
        loc.unlock();
        lock.unholdObject();
        JavaLockStore javaLockStore2 = this;
        synchronized (javaLockStore2) {
            lock = this.namedLocks.get(key);
            if (lock != null && lock.getHoldCount() == 0) {
                this.namedLocks.remove(key);
            }
        }
    }

    @Override
    public void requestScopedLock(String scopeName, PageContext page, boolean readonly, long timeout) throws InterruptedException {
        Lock lock = this.getScopedLock(scopeName, page, readonly);
        if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
            throw new InterruptedException();
        }
    }

    @Override
    public void releaseScopedLock(String scopeName, PageContext page, boolean readonly) {
        Lock lock = this.getScopedLock(scopeName, page, readonly);
        lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestConcurrentLock(String key, int count, long timeout) throws InterruptedException {
        Semaphore lock;
        key = key.toUpperCase();
        JavaLockStore javaLockStore = this;
        synchronized (javaLockStore) {
            lock = this.concurrentLocks.get(key);
            if (lock == null) {
                lock = new Semaphore(count, this.fairness);
                this.concurrentLocks.put(key, lock);
            }
        }
        if (!lock.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConcurrentLock(String key) {
        Semaphore lock;
        key = key.toUpperCase();
        JavaLockStore javaLockStore = this;
        synchronized (javaLockStore) {
            lock = this.concurrentLocks.get(key);
            if (lock == null) {
                throw new LockManager.UnknownLockException(key);
            }
        }
        lock.release();
        javaLockStore = this;
        synchronized (javaLockStore) {
            lock = this.concurrentLocks.get(key);
            if (lock != null && lock.availablePermits() == lock.getPermits()) {
                this.concurrentLocks.remove(key);
            }
        }
    }

    private Lock getScopedLock(String scopeName, PageContext page, boolean readonly) {
        ReentrantReadWriteLock scopedLock = this.getScopedLock(scopeName, page);
        return readonly ? scopedLock.readLock() : scopedLock.writeLock();
    }

    private ReentrantReadWriteLock getScopedLock(String scopeName, PageContext page) {
        ReentrantReadWriteLock result;
        if (scopeName.equalsIgnoreCase("SERVER")) {
            result = this.serverLock;
        } else {
            FusionContext context = FusionContext.getCurrent();
            Object candidateScope = context.hiddenScope.get(scopeName.toUpperCase());
            if (candidateScope != null && candidateScope instanceof LockableScope) {
                result = (ReentrantReadWriteLock)((LockableScope)candidateScope).getLock();
            } else {
                if (scopeName.equalsIgnoreCase("APPLICATION") || scopeName.equalsIgnoreCase("SESSION")) {
                    throw new LockManager.InvalidScopeStateException(scopeName);
                }
                throw new LockManager.UnknownLockScopeException(scopeName);
            }
        }
        return result;
    }

    @Override
    public Object requestNewLock() {
        return new ReentrantReadWriteLock(this.fairness);
    }

    private static class ReadWriteLock
    extends ReentrantReadWriteLock {
        private static final long serialVersionUID = 1L;
        private int n_LockHoldCount;

        public ReadWriteLock(boolean fairness) {
            super(fairness);
        }

        public synchronized int getHoldCount() {
            return this.n_LockHoldCount;
        }

        public synchronized void holdObject() {
            ++this.n_LockHoldCount;
        }

        public synchronized void unholdObject() {
            --this.n_LockHoldCount;
        }
    }

    private static class Semaphore
    extends java.util.concurrent.Semaphore {
        private static final long serialVersionUID = 1L;
        private int permits;

        public int getPermits() {
            return this.permits;
        }

        public Semaphore(int permits, boolean fair) {
            super(permits, fair);
            this.permits = permits;
        }
    }
}

