/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.NeoException;
import coldfusion.runtime.locale.CFLocaleCurrencyFormatException;
import coldfusion.runtime.locale.CFLocaleParseCurrencyException;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class LSCurrencyFunctions {
    public static LSCurrencyFunctions instance = null;
    private static Hashtable euro_zoneTbl = null;

    public static synchronized LSCurrencyFunctions getCurrencyFuncInstance() {
        if (instance == null) {
            instance = new LSCurrencyFunctions();
        }
        return instance;
    }

    public Locale isEuroZoneCountry(String locString) {
        String language = locString.substring(0, locString.indexOf(95));
        int idx = locString.indexOf(95) + 1;
        String country = locString.substring(idx);
        Enumeration e = euro_zoneTbl.keys();
        while (e.hasMoreElements()) {
            String keyStr = (String)e.nextElement();
            if (!locString.equalsIgnoreCase(keyStr)) continue;
            Object obj = euro_zoneTbl.get(keyStr);
            if (obj instanceof String) {
                Locale loc = new Locale(language, country, "EURO");
                euro_zoneTbl.put(keyStr, loc);
                return (Locale)euro_zoneTbl.get(keyStr);
            }
            if (!(obj instanceof Locale)) continue;
            return (Locale)obj;
        }
        return null;
    }

    private int findType(String type) {
        if ("local".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("international".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("none".equalsIgnoreCase(type)) {
            return 3;
        }
        return -1;
    }

    private String NegativeNumCurrencyFormat(Locale loc, double num, String type) throws CFLocaleCurrencyFormatException {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(loc);
        String localSymbol = dfs.getCurrencySymbol();
        String itnlSymbol = dfs.getInternationalCurrencySymbol();
        char sign = dfs.getMinusSign();
        NumberFormat nf = NumberFormat.getCurrencyInstance(loc);
        Object currOut = nf.format(num);
        int itype = this.findType(type);
        if (itype == -1) {
            throw new CFLocaleCurrencyFormatException(type);
        }
        switch (itype) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                int beginPos = ((String)currOut).indexOf(localSymbol);
                int sign_pos = ((String)currOut).indexOf(sign);
                if (beginPos == 0) {
                    currOut = ((String)currOut).substring(localSymbol.length());
                } else if (beginPos + localSymbol.length() == ((String)currOut).length()) {
                    currOut = ((String)currOut).substring(0, beginPos);
                } else {
                    currOut = ((String)currOut).substring(0, beginPos) + ((String)currOut).substring(beginPos + localSymbol.length(), ((String)currOut).length());
                    if (sign_pos != -1 && ((String)currOut).charAt(sign_pos + 1) == ' ') {
                        StringBuffer aTmp = new StringBuffer((String)currOut);
                        aTmp.deleteCharAt(sign_pos + 1);
                        currOut = aTmp.toString();
                    }
                }
                StringBuffer tmpBuf = new StringBuffer((String)currOut);
                if (tmpBuf.charAt(0) == ' ') {
                    tmpBuf.deleteCharAt(0);
                }
                if (tmpBuf.charAt(tmpBuf.length() - 1) == ' ') {
                    tmpBuf.deleteCharAt(tmpBuf.length() - 1);
                }
                if (itype != 2) break;
                sign_pos = tmpBuf.toString().indexOf(sign);
                if (sign_pos != -1 && sign_pos == tmpBuf.toString().length() - 1 && sign == '-') {
                    if ((tmpBuf = tmpBuf.deleteCharAt(sign_pos)).charAt(0) == ' ') {
                        tmpBuf.deleteCharAt(0);
                    }
                    tmpBuf = tmpBuf.insert(0, '-');
                }
                if (((String)(currOut = tmpBuf.toString())).indexOf(40) == 0 && ((String)currOut).indexOf(41) == ((String)currOut).length() - 1) {
                    currOut = ((String)currOut).substring(1, ((String)currOut).length() - 1);
                    currOut = "-" + (String)currOut;
                }
                currOut = itnlSymbol + (String)currOut;
            }
        }
        return currOut;
    }

    public final String LSCurrencyFormat(Locale loc, double num, String type) throws CFLocaleParseCurrencyException, LocaleNotSetException {
        Object currOut;
        if (loc == null) {
            throw new LocaleNotSetException();
        }
        if (num < 0.0) {
            currOut = this.NegativeNumCurrencyFormat(loc, num, type);
        } else {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(loc);
            String localSymbol = dfs.getCurrencySymbol();
            String itnlSymbol = dfs.getInternationalCurrencySymbol();
            NumberFormat nf = NumberFormat.getCurrencyInstance(loc);
            currOut = nf.format(num);
            int itype = this.findType(type);
            if (itype == -1) {
                throw new CFLocaleCurrencyFormatException(type);
            }
            boolean prefix = true;
            int idx = ((String)currOut).indexOf(localSymbol);
            if (idx > 0) {
                prefix = false;
            }
            switch (itype) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    currOut = prefix ? ((String)currOut).substring(localSymbol.length(), ((String)currOut).length()) : ((String)currOut).substring(0, ((String)currOut).length() - localSymbol.length() - 1);
                    StringBuffer cbuf = new StringBuffer((String)currOut);
                    if (cbuf.charAt(0) == ' ') {
                        cbuf.deleteCharAt(0);
                    }
                    if (cbuf.charAt(cbuf.length() - 1) == ' ') {
                        cbuf.deleteCharAt(cbuf.length() - 1);
                    }
                    currOut = cbuf.toString();
                    if (itype != 2) break;
                    currOut = itnlSymbol + (String)currOut;
                }
            }
        }
        if (currOut == null) {
            Double dbl = new Double(num);
            throw new CFLocaleParseCurrencyException(dbl.toString());
        }
        return currOut;
    }

    public StringBuffer makeJavaCurrencyForamt(Locale loc, String currStr) {
        int beginPos;
        StringBuffer sbuf;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(loc);
        String localSymbol = dfs.getCurrencySymbol();
        String itnlSymbol = dfs.getInternationalCurrencySymbol();
        currStr = currStr.trim();
        int len = currStr.length();
        Object str = currStr;
        boolean symbolpresent = false;
        boolean intnlType = false;
        if (((String)str).indexOf(localSymbol) != -1) {
            symbolpresent = true;
        } else if (((String)str).indexOf(itnlSymbol) != -1) {
            symbolpresent = true;
            intnlType = true;
        }
        if (symbolpresent && intnlType && len > itnlSymbol.length() || symbolpresent && !intnlType && len > localSymbol.length()) {
            if (((String)str).indexOf(itnlSymbol) != -1) {
                str = ((String)str).substring(itnlSymbol.length());
            } else {
                int symPos = ((String)str).indexOf(localSymbol);
                if (symPos == 0) {
                    str = ((String)str).substring(localSymbol.length());
                } else if (symPos > 0) {
                    str = ((String)str).substring(0, symPos) + ((String)str).substring(symPos + localSymbol.length(), ((String)str).length());
                }
                if (((String)str).length() == symPos || symPos == 0) {
                    str = ((String)str).trim();
                } else if (((String)str).length() >= symPos && ((String)str).charAt(symPos) == ' ') {
                    str = ((String)str).substring(0, symPos) + ((String)str).substring(symPos + 1, ((String)str).length());
                }
            }
        }
        if ((sbuf = new StringBuffer((String)str)).charAt(0) == ' ') {
            sbuf.deleteCharAt(0);
        }
        if (sbuf.charAt(sbuf.length() - 1) == ' ') {
            sbuf.deleteCharAt(sbuf.length() - 1);
        }
        double test = sbuf.toString().indexOf(40) != -1 || sbuf.toString().indexOf(41) != -1 || sbuf.toString().indexOf(45) != -1 ? -100.0 : 100.0;
        if (loc.getLanguage().equalsIgnoreCase("nl") && loc.getCountry().equalsIgnoreCase("NL") && intnlType && test < 0.0) {
            sbuf.insert(sbuf.length(), '-');
            sbuf.deleteCharAt(0);
        }
        NumberFormat testformat = NumberFormat.getCurrencyInstance(loc);
        String testCurr = testformat.format(test);
        boolean useMinorSign = true;
        if (testCurr.indexOf(45) == -1 && testCurr.indexOf(40) != -1 && testCurr.indexOf(41) != -1) {
            useMinorSign = false;
        }
        if ((beginPos = testCurr.indexOf(localSymbol)) == 0) {
            if (testCurr.charAt(localSymbol.length()) == ' ') {
                sbuf.insert(0, ' ');
                sbuf.insert(0, localSymbol);
            } else {
                sbuf.insert(0, localSymbol);
            }
        } else if (beginPos + localSymbol.length() == testCurr.length()) {
            int pos = testCurr.length() - localSymbol.length() - 1;
            if (testCurr.charAt(pos) == ' ') {
                sbuf.append(' ');
                sbuf.append(localSymbol);
            } else {
                sbuf.append(localSymbol);
            }
        } else {
            if (!useMinorSign && sbuf.toString().indexOf(45) != -1) {
                sbuf = sbuf.deleteCharAt(sbuf.toString().indexOf(45));
                sbuf = sbuf.insert(0, '(');
                sbuf = sbuf.insert(sbuf.toString().length(), ')');
            }
            if (loc.getLanguage().equalsIgnoreCase("fr") && loc.getCountry().equalsIgnoreCase("CA")) {
                sbuf.insert(sbuf.toString().length() - 1, localSymbol);
            } else {
                int index = beginPos + localSymbol.length();
                if (testCurr.charAt(index) == ' ') {
                    sbuf.insert(beginPos, ' ');
                    sbuf.insert(beginPos, localSymbol);
                } else {
                    sbuf.insert(beginPos, localSymbol);
                }
            }
        }
        return sbuf;
    }

    public final String LSParseCurrency(Locale loc, String currStr) throws CFLocaleParseCurrencyException {
        Double dbl;
        String formattedCurr;
        if (loc == null) {
            throw new LocaleNotSetException();
        }
        StringBuffer sbuf = this.makeJavaCurrencyForamt(loc, currStr);
        NumberFormat nf = NumberFormat.getCurrencyInstance(loc);
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = nf.parse(sbuf.toString(), parsePosition);
        if (parsePosition.getErrorIndex() != -1) {
            formattedCurr = null;
        } else {
            dbl = new Double(number.doubleValue());
            formattedCurr = dbl.toString();
        }
        if (formattedCurr == null && loc.getVariant().equalsIgnoreCase("EURO")) {
            loc = new Locale(loc.getLanguage(), loc.getCountry());
            sbuf = this.makeJavaCurrencyForamt(loc, currStr);
            nf = NumberFormat.getCurrencyInstance(loc);
            parsePosition = new ParsePosition(0);
            number = nf.parse(sbuf.toString(), parsePosition);
            if (parsePosition.getErrorIndex() == -1 && number != null) {
                dbl = new Double(number.doubleValue());
                formattedCurr = dbl.toString();
            }
        }
        if (formattedCurr == null) {
            throw new CFLocaleParseCurrencyException(currStr);
        }
        return formattedCurr;
    }

    public final boolean IsCurrency(Locale loc, String currStr) {
        if (loc == null) {
            throw new LocaleNotSetException();
        }
        boolean status = false;
        String locString = loc.getLanguage() + "_" + loc.getCountry();
        Locale currLocale = this.isEuroZoneCountry(locString);
        if (currLocale == null && currStr.indexOf(128) != -1) {
            return status;
        }
        StringBuffer sbuf = this.makeJavaCurrencyForamt(loc, currStr);
        NumberFormat nf = NumberFormat.getCurrencyInstance(loc);
        ParsePosition parsePosition = new ParsePosition(0);
        nf.parse(sbuf.toString(), parsePosition);
        status = parsePosition.getErrorIndex() == -1 && parsePosition.getIndex() == sbuf.length();
        return status;
    }

    static {
        euro_zoneTbl = new Hashtable();
        euro_zoneTbl.put("nl_BE", "");
        euro_zoneTbl.put("nl_NL", "");
        euro_zoneTbl.put("fr_BE", "");
        euro_zoneTbl.put("fr_FR", "");
        euro_zoneTbl.put("de_AT", "");
        euro_zoneTbl.put("de_DE", "");
        euro_zoneTbl.put("it_IT", "");
        euro_zoneTbl.put("pt_PT", "");
        euro_zoneTbl.put("es_ES", "");
    }

    public static class LocaleNotSetException
    extends NeoException {
    }
}

