/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.memory.MemoryTrackable;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Scope;
import coldfusion.runtime.ScopeSearchResult;
import coldfusion.runtime.Variable;
import coldfusion.util.Key;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

public class LocalScope
extends Scope {
    protected Map<Key, Variable> table;
    protected static int defaultInitialValue = Integer.valueOf(Optional.ofNullable(System.getProperty("coldfusion.initialScopeCapacity")).orElse("8"));

    public LocalScope(int initialValue) {
        this.table = new HashMap<Key, Variable>(initialValue);
    }

    public LocalScope() {
        this.table = new HashMap<Key, Variable>(defaultInitialValue);
    }

    public LocalScope(Scope src) {
        this.cloneScope(src);
    }

    private LocalScope(Map table) {
        this();
        this.table.putAll(table);
    }

    @Override
    public final void cloneScope(Scope src) {
        LocalScope localSrc = (LocalScope)src;
        this.table = new HashMap<Key, Variable>(localSrc.table.size());
        try {
            for (Map.Entry<Key, Variable> nextEntry : localSrc.table.entrySet()) {
                Key nextKey = nextEntry.getKey();
                Variable var = nextEntry.getValue();
                Object val = var != null ? var.getValue() : null;
                var = new Variable(nextKey.getKeyString());
                var.setContainer(this);
                var.setValue(val);
                this.table.put(nextKey, var);
            }
        }
        catch (Exception noFastPath) {
            super.cloneScope(src);
        }
    }

    public final Map<Key, Variable> getBacking() {
        return this.table;
    }

    public final synchronized void replaceBacking(Map map) {
        this.onReplaceBacking(map, this.table);
        this.table = map;
    }

    private void onReplaceBacking(Map newMap, Map oldMap) {
        Variable v2;
        MemoryTrackerProxy mtp = this.getMemoryTrackerProxy();
        if (oldMap != null) {
            Iterator oldEntryItr = oldMap.entrySet().iterator();
            while (oldEntryItr.hasNext()) {
                try {
                    v2 = (Variable)oldEntryItr.next().getValue();
                    if (mtp == null) continue;
                    mtp.onRemoveObject(v2.getValue());
                }
                catch (Exception v2) {}
            }
        }
        if (newMap != null) {
            Iterator newEntryItr = newMap.entrySet().iterator();
            while (newEntryItr.hasNext()) {
                try {
                    MemoryTrackerProxy oldMTProxy;
                    v2 = (Variable)newEntryItr.next().getValue();
                    MemoryTrackable vContainer = v2.getContainer();
                    if (vContainer != null && (oldMTProxy = vContainer.getMemoryTrackerProxy()) != null) {
                        oldMTProxy.onRemoveObject(v2.getValue());
                    }
                    v2.setContainer(this);
                    if (mtp == null) continue;
                    mtp.onAddObject(v2.getValue());
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Object clone() {
        LocalScope localScopeVariable = new LocalScope();
        localScopeVariable.cloneScope(this);
        return localScopeVariable;
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    public void clearVariables() {
        for (Variable variable : this.table.values()) {
            variable.reset();
        }
    }

    @Override
    public final Set entrySet() {
        return new LocalScopeSet();
    }

    public final Variable bind(String name) {
        Key keyObj = Key.getInstance(name);
        return this.bindVariable(keyObj, name);
    }

    public final Variable bind(Key keyObj) {
        return this.bindVariable(keyObj, keyObj.getKeyString());
    }

    public final Variable bind_Final(String name) {
        Key keyObj = Key.getInstance(name);
        return this.bindVariable_Final(keyObj, name);
    }

    public final synchronized Variable bindVariable_Final(Key key, String name) {
        Variable result = this.table.get(key);
        if (result == null) {
            result = this.createVariable(name, true);
            this.table.put(key, result);
        } else {
            result.isFinal = true;
        }
        return result;
    }

    public final synchronized Variable bindVariable(Key key, String name) {
        Variable result = this.table.get(key);
        if (result == null) {
            result = this.createVariable(name);
            this.table.put(key, result);
        }
        return result;
    }

    public final synchronized Variable createVariable(String name, Boolean isFinal) {
        Variable result = new Variable(name, isFinal);
        result.setContainer(this);
        return result;
    }

    public final synchronized Variable createVariable(String name) {
        Variable result = new Variable(name);
        result.setContainer(this);
        return result;
    }

    @Override
    public final synchronized boolean isEmpty() {
        if (!this.table.isEmpty()) {
            Iterator<Map.Entry<Key, Variable>> baseEnum = this.table.entrySet().iterator();
            while (baseEnum.hasNext()) {
                Variable v = baseEnum.next().getValue();
                if (!v.isDefined()) continue;
                return false;
            }
        }
        return true;
    }

    public final synchronized Variable bind(String name, Object value) {
        Variable var = this.bind(name);
        var.set(value);
        return var;
    }

    public final synchronized Variable bind_Final(String name, Object value) {
        Variable var = this.bind_Final(name);
        var.set(value);
        return var;
    }

    @Override
    protected final void bindName(String name, Object value) {
        this.bind(name, value);
    }

    @Override
    protected final void bindName_Final(String name, Object value) {
        this.bind_Final(name, value);
    }

    public void putAll(Map arg0) {
        super.putAll(arg0);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.putInternal(key.toString(), value);
    }

    public Object put(Key keyObj, Object value) {
        return this.putInternal(keyObj, value);
    }

    @Override
    public Object put_Final(Object key, Object value) {
        return this.putInternal_Final(key.toString(), value);
    }

    @Override
    public final Object putCanonicalKey(Object key, Object value) {
        return this.putInternal((String)key, value);
    }

    public synchronized Object putInternal(String key, Object value) {
        Variable variable = this.bind(key);
        Object result = variable.value;
        variable.set(value);
        return result;
    }

    public synchronized Object putInternal(Key keyObj, Object value) {
        Variable variable = this.bind(keyObj);
        Object result = variable.value;
        variable.set(value);
        return result;
    }

    public synchronized Object putInternal_Final(String key, Object value) {
        Variable variable = this.bind_Final(key);
        Object result = variable.value;
        variable.set(value);
        return result;
    }

    @Override
    public final Object getCanonicalKey(Object key) {
        return this.get(key);
    }

    @Override
    protected final void unbindName(String name) {
        this.remove(name);
    }

    @Override
    public synchronized Object remove(Object key) {
        Object result = null;
        Variable v = this.findVariable(key.toString());
        if (v != null) {
            result = v.value;
            v.set((String)null);
            v.defined = false;
        }
        return result;
    }

    @Override
    protected final Object resolveName(String name) {
        return this.get(name);
    }

    @Override
    public Object get(Object key) {
        Key keyObj = key instanceof Key ? (Key)key : Key.getInstance(key.toString());
        Variable var = this.table.get(keyObj);
        return var != null ? var.value : null;
    }

    public Object getVar(Object key) {
        Key keyObj = key instanceof Key ? (Key)key : Key.getInstance(key.toString());
        return this.table.get(keyObj);
    }

    @Override
    protected final boolean containsName(String name) {
        return this.containsKey(name);
    }

    @Override
    public boolean containsKey(Object key) {
        Key keyObj = key instanceof Key ? (Key)key : Key.getInstance(key.toString());
        Variable v = (Variable)this.getVar(keyObj);
        if (v != null) {
            if (v.value != null) {
                return true;
            }
            if (v.defined && FusionContext.isPreserveNullValues()) {
                return true;
            }
        }
        return false;
    }

    public boolean isDeclaredKey(String key) {
        Variable var = this.findVariable(key);
        return var != null;
    }

    public boolean isDeclaredKey(Key keyObj) {
        Variable var = this.findVariable(keyObj);
        return var != null;
    }

    @Override
    public int size() {
        return new LocalScopeSet().size();
    }

    public final Variable bindInternal(String key) {
        return this.bind(key);
    }

    public final Variable bindInternal_Final(String key) {
        return this.bind_Final(key);
    }

    public final Variable bindInternal(String key, Object value) {
        return this.bind(key, value);
    }

    public final Variable bindInternal(Key key, Object value) {
        Object varObj;
        String keyName = key.getKeyString();
        if (Key.THIS.getKeyString().equals(keyName) && value == null && FusionContext.isPreserveNullValues() && (varObj = FusionContext.getCurrent().pageContext.findAttributeVar(keyName, false)) != null) {
            return (Variable)varObj;
        }
        Variable var = new Variable(keyName);
        var.setContainer(this);
        var.set(value);
        this.table.put(key, var);
        return var;
    }

    public final Variable _bindInternal(Key key, Object value) {
        Variable var = new Variable(key.getKeyString());
        var.setContainer(this);
        var.set(value);
        this.table.put(key, var);
        return var;
    }

    protected Variable findVariable(String key) {
        return this.table.get(Key.getInstance(key));
    }

    protected Variable findVariable(Key keyObj) {
        return this.table.get(keyObj);
    }

    public final void putVariable(Variable var) {
        MemoryTrackerProxy mtp;
        this.table.put(Key.getInstance(var.name), var);
        MemoryTrackable varContainer = var.getContainer();
        if (varContainer != null) {
            MemoryTrackerProxy oldMTProxy = varContainer.getMemoryTrackerProxy();
            if (oldMTProxy != null) {
                oldMTProxy.onRemoveObject(var);
            }
            var.setContainer(this);
        }
        if ((mtp = this.getMemoryTrackerProxy()) != null) {
            mtp.onAddObject(var.getValue());
        }
    }

    @Override
    public void search(ScopeSearchResult searcher) {
        if (searcher.hasDottedReferences()) {
            Variable baseVar = this.findVariable(searcher.getBaseNameAsKeyObject());
            if (baseVar != null && baseVar.isDefined()) {
                searcher.searchForSubkeys(Cast._Map(baseVar.value));
            } else {
                this.searchForFlatKey(searcher);
            }
        } else {
            this.searchForFlatKey(searcher);
        }
    }

    public void search(ScopeSearchResult searcher, Key key) {
        if (searcher.hasDottedReferences()) {
            Variable baseVar = this.findVariable(searcher.getBaseNameAsKeyObject());
            if (baseVar != null && baseVar.isDefined()) {
                searcher.searchForSubkeys(Cast._Map(baseVar.value));
            } else {
                this.searchForFlatKey(key, searcher);
            }
        } else {
            this.searchForFlatKey(key, searcher);
        }
    }

    private void searchForFlatKey(Key canonicalKey, ScopeSearchResult searcher) {
        Variable flatVar = this.findVariable(canonicalKey);
        searcher.setFound(false);
        if (flatVar != null && flatVar.isDefined()) {
            searcher.setFound(true);
            searcher.setResult(flatVar.value);
            searcher.setVariable(flatVar);
        } else if (flatVar != null && flatVar.value != null && this.table.containsKey(canonicalKey)) {
            searcher.setFound(true);
            searcher.setResult(flatVar.value);
            searcher.setVariable(flatVar);
        }
    }

    private void searchForFlatKey(ScopeSearchResult searcher) {
        Key canonicalKey = searcher.getCanonicalUnifiedKeyAsKeyObject();
        Variable flatVar = this.findVariable(canonicalKey);
        searcher.setFound(false);
        if (flatVar != null && flatVar.isDefined()) {
            searcher.setFound(true);
            searcher.setResult(flatVar.value);
            searcher.setVariable(flatVar);
        } else if (flatVar != null && flatVar.value != null && this.table.containsKey(canonicalKey)) {
            searcher.setFound(true);
            searcher.setResult(flatVar.value);
            searcher.setVariable(flatVar);
        }
    }

    public final Iterator keys() {
        return this.getNames();
    }

    @Override
    protected final Iterator getNames() {
        return new Iterator(){
            final Iterator it;
            Variable nextVar;
            {
                this.it = LocalScope.this.table.values().iterator();
                this.nextVar = null;
            }

            @Override
            public boolean hasNext() {
                while (this.nextVar == null && this.it.hasNext()) {
                    Variable v = (Variable)this.it.next();
                    if (!v.isDefined()) continue;
                    this.nextVar = v;
                }
                return this.nextVar != null;
            }

            public Object next() {
                if (this.hasNext()) {
                    String result = this.nextVar.name;
                    this.nextVar = null;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    private final class LocalScopeSet
    extends HashSet {
        LocalScopeSet() {
            super(LocalScope.this.table.size());
            Iterator<Map.Entry<Key, Variable>> baseEnum = LocalScope.this.table.entrySet().iterator();
            while (baseEnum.hasNext()) {
                Variable v = baseEnum.next().getValue();
                if (!v.isDefined()) continue;
                this.add(v);
            }
        }
    }
}

