/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.CFLockStore;
import coldfusion.runtime.JavaLockStore;
import coldfusion.runtime.LockException;
import coldfusion.runtime.LockStore;
import jakarta.servlet.jsp.PageContext;

public final class LockManager
implements LockStore {
    private static LockManager the;
    private LockStore lockStore = DEFAULT_LOCK_FAIRNESS_POLICY ? new JavaLockStore(true) : new CFLockStore();
    public static final boolean DEFAULT_LOCK_FAIRNESS_POLICY;

    private LockManager() {
    }

    public static LockManager get() {
        return the;
    }

    @Override
    public void requestNamedLock(String key, boolean readonly, long timeout) throws InterruptedException {
        this.lockStore.requestNamedLock(key, readonly, timeout);
    }

    @Override
    public void releaseNamedLock(String key, boolean readonly) {
        this.lockStore.releaseNamedLock(key, readonly);
    }

    @Override
    public void requestScopedLock(String scopeName, PageContext page, boolean readonly, long timeout) throws InterruptedException {
        this.lockStore.requestScopedLock(scopeName, page, readonly, timeout);
    }

    @Override
    public void releaseScopedLock(String scopeName, PageContext page, boolean readonly) {
        this.lockStore.releaseScopedLock(scopeName, page, readonly);
    }

    @Override
    public void requestConcurrentLock(String key, int count, long timeout) throws InterruptedException {
        this.lockStore.requestConcurrentLock(key, count, timeout);
    }

    @Override
    public void releaseConcurrentLock(String key) {
        this.lockStore.releaseConcurrentLock(key);
    }

    @Override
    public Object requestNewLock() {
        return this.lockStore.requestNewLock();
    }

    static {
        DEFAULT_LOCK_FAIRNESS_POLICY = Boolean.getBoolean("coldfusion.locks.default.fair");
        the = new LockManager();
    }

    public static class UnknownLockException
    extends LockException {
        private static final long serialVersionUID = 1L;

        UnknownLockException(String lockName) {
            super(lockName);
        }
    }

    public static class InvalidScopeStateException
    extends LockException {
        private static final long serialVersionUID = 1L;
        public String scopeName;

        public InvalidScopeStateException(String scopeName) {
            super("");
            this.scopeName = scopeName;
        }
    }

    public static class UnknownLockScopeException
    extends LockException {
        private static final long serialVersionUID = 1L;

        UnknownLockScopeException(String lockName) {
            super(lockName);
        }
    }
}

