/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.Array;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.Metadata;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Key;
import java.io.File;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.util.Map;

public class MetadataUtils {
    public static Object getMetaData(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof TemplateProxy) {
            Object metadata = ((TemplateProxy)value).getRuntimeMetadata();
            if (metadata instanceof CaseInsensitiveMap) {
                CaseInsensitiveMap cfMetaData = new CaseInsensitiveMap();
                for (Object keyObj : ((Map)metadata).keySet()) {
                    String key;
                    if (keyObj instanceof String && ("Properties".equalsIgnoreCase(key = (String)keyObj) || "Functions".equalsIgnoreCase(key))) {
                        Object[] propertiesObjectArr = (Object[])((Map)metadata).get(keyObj = Key.getInstance((String)keyObj));
                        if (propertiesObjectArr != null) {
                            Array props = new Array();
                            for (Object property : propertiesObjectArr) {
                                props.add(property);
                            }
                            cfMetaData.put(keyObj, props);
                            continue;
                        }
                        cfMetaData.put(keyObj, propertiesObjectArr);
                        continue;
                    }
                    if (keyObj == null) {
                        keyObj = "null";
                    }
                    keyObj = Key.getInstance(keyObj.toString());
                    cfMetaData.put(keyObj, ((Map)metadata).get(keyObj));
                }
                return cfMetaData;
            }
            return metadata;
        }
        if (value instanceof Metadata) {
            return ((Metadata)value).getMetadata();
        }
        if (value instanceof ResultSet) {
            return QueryTableMetaData.getQueryMetaData((ResultSet)value);
        }
        return value.getClass();
    }

    public static Object getMetaData(Object value, boolean extendedInfo) {
        QueryTable qTable;
        QueryTableMetaData qMeta;
        Struct extMeta;
        Object result = MetadataUtils.getMetaData(value);
        if (extendedInfo && value != null && value instanceof QueryTable && (extMeta = (qMeta = (QueryTableMetaData)(qTable = (QueryTable)value).getMetaData()).getExtendedMetaData()) != null) {
            Struct rStruct = new Struct();
            rStruct.put("RESULTSETINFO", result);
            rStruct.putAll((Map)extMeta);
            result = rStruct;
        }
        return result;
    }

    public static Object getComponentMetadata(String componentName, NeoPageContext pageContext, String importList) throws Throwable {
        if (componentName == null) {
            return null;
        }
        Object[] objects = TemplateProxyFactory.getTemplateFileHelper(componentName, pageContext, importList);
        File cfcFile = (File)objects[0];
        String fullName = (String)objects[1];
        return MetadataUtils.getComponentMetadata(cfcFile, pageContext, fullName);
    }

    public static Object getComponentMetadata(File cfcFile, NeoPageContext pageContext, String fullName) throws Throwable {
        return MetadataUtils.getComponentMetadata(cfcFile, pageContext, fullName, false);
    }

    public static Object getComponentMetadata(File cfcFile, NeoPageContext pageContext, String fullName, boolean forcecheck) throws Throwable {
        AttributeCollection metaData;
        String path = cfcFile.getAbsolutePath();
        Class aClass = TemplateClassLoader.findClass(pageContext.getServletContext(), path);
        Field field = aClass.getField("metaData");
        Object metaDataObj = field.get(null);
        if (metaDataObj instanceof AttributeCollection && !forcecheck && (metaData = (AttributeCollection)metaDataObj).isMetaDataInitialized()) {
            return metaData;
        }
        TemplateProxy templateProxy = TemplateProxyFactory.resolveName(null, pageContext, cfcFile, fullName, true, null, null, false);
        if (templateProxy != null) {
            if (!templateProxy.isInterface()) {
                templateProxy.verifyInterfacesImpl(pageContext);
            }
            return templateProxy.getMetadata();
        }
        return null;
    }

    public static Object getBasicComponentMetadata(File cfcFile, NeoPageContext pageContext, String fullName) throws Throwable {
        String path = cfcFile.getAbsolutePath();
        Class aClass = TemplateClassLoader.findClass(pageContext.getServletContext(), path);
        Field field = aClass.getField("metaData");
        Object metaDataObj = field.get(null);
        if (metaDataObj instanceof AttributeCollection) {
            AttributeCollection metaData = (AttributeCollection)metaDataObj;
            if (metaData.isMetaDataInitialized()) {
                return metaData;
            }
            String string = fullName = fullName != null ? fullName : (String)metaData.get(Key.NAME);
            if (fullName == null || fullName.indexOf(46) == -1) {
                fullName = TemplateProxyFactory.getFullName(cfcFile, pageContext, false);
                metaData.put(Key.NAME, (Object)fullName);
            }
        }
        return metaDataObj;
    }

    public static Map getAllProperties(AttributeCollection cfcMetadata) {
        Map propertyMap = (Map)cfcMetadata.get(Key.PROPERTY_STRUCT);
        if (propertyMap != null) {
            return propertyMap;
        }
        propertyMap = new AttributeCollection();
        Object[] props = (Object[])cfcMetadata.get(Key.PROPERTIES);
        AttributeCollection parentMetadata = (AttributeCollection)cfcMetadata.get(Key.EXTENDS);
        if (parentMetadata != null && !parentMetadata.get(Key.NAME).equals("WEB-INF.cftags.component")) {
            Map parentPropertyMap = MetadataUtils.getAllProperties(parentMetadata);
            propertyMap.putAll(parentPropertyMap);
        }
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                AttributeCollection property = (AttributeCollection)props[i];
                propertyMap.put(property.get(Key.NAME), property);
            }
        }
        cfcMetadata.put(Key.PROPERTY_STRUCT, (Object)propertyMap);
        return propertyMap;
    }
}

