/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.CFOutput;
import coldfusion.runtime.CharBuffer;
import coldfusion.util.RuntimeWrapper;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class NeoBodyContent
extends BodyContent
implements CFOutput {
    public static final char[] NEWLINE = new char[]{'\r', '\n'};
    protected NeoBodyContent next;
    CharBuffer buffer;
    private int nLogicalMark;
    private int nStartLoc;
    private int outputCount = 0;
    private int disableCount = 0;
    private boolean isWhitespaceTerminated = false;
    private boolean bIsTopBuffer = true;
    private CharArrayWriter otherBuf;
    boolean isjava = false;

    public NeoBodyContent(JspWriter jspWriter) {
        super(jspWriter);
        CFOutput temp = (CFOutput)jspWriter;
        this.outputCount = temp.getOutputCount();
        this.disableCount = temp.getDisableCount();
        this.buffer = temp.getBuffer();
        this.nStartLoc = this.nLogicalMark = temp.getLogicalMark();
    }

    public void reset() {
        this.outputCount = 0;
        this.disableCount = 0;
        this.otherBuf = null;
    }

    public void reset(CFOutput b) {
        this.outputCount = b.getOutputCount();
        this.disableCount = b.getDisableCount();
        this.buffer = b.getBuffer();
        this.nLogicalMark = this.nStartLoc = b.getLogicalMark();
        this.otherBuf = null;
    }

    public NeoBodyContent pushBody() {
        if (this.next == null) {
            this.next = new NeoBodyContent((JspWriter)this);
        } else {
            this.next.setIsTopBuffer(true);
            this.next.reset(this);
        }
        return this.next;
    }

    private boolean isOutputEnabled() {
        return this.outputCount > 0 || this.disableCount == 0;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    @Override
    public int getDisableCount() {
        return this.disableCount;
    }

    @Override
    public void cfoutput(boolean onoff) {
        this.outputCount = onoff ? this.outputCount + 1 : (this.outputCount > 0 ? this.outputCount - 1 : 0);
        JspWriter enc = this.getEnclosingWriter();
        if (enc instanceof CFOutput) {
            ((CFOutput)enc).cfoutput(onoff);
        }
    }

    @Override
    public void enablecfoutputonly(boolean onoff) {
        this.disableCount = onoff ? this.disableCount + 1 : (this.disableCount > 0 ? this.disableCount - 1 : 0);
        JspWriter enc = this.getEnclosingWriter();
        if (enc instanceof CFOutput) {
            ((CFOutput)enc).enablecfoutputonly(onoff);
        }
    }

    public void write(int c) throws IOException {
        if (this.isOutputEnabled()) {
            if (this.bIsTopBuffer) {
                if (this.buffer != null) {
                    this.buffer.setCharAt(this.nLogicalMark, (char)c);
                    ++this.nLogicalMark;
                }
            } else {
                this.initOtherWriter();
                this.otherBuf.write(c);
            }
            this.isWhitespaceTerminated = Character.isWhitespace((char)c);
        }
    }

    public void write(char[] cb) throws IOException {
        this.write(cb, 0, cb.length);
    }

    private void initOtherWriter() {
        if (this.otherBuf == null) {
            String temp = this.getString();
            this.otherBuf = new CharArrayWriter(1024);
            try {
                this.otherBuf.write(temp);
            }
            catch (IOException ex) {
                throw new RuntimeWrapper(ex);
            }
        }
    }

    public void write(char[] s, int start, int length) throws IOException {
        if (this.isOutputEnabled()) {
            if (this.bIsTopBuffer) {
                if (this.buffer != null) {
                    this.buffer.replace(this.nLogicalMark, start, length, s);
                    this.nLogicalMark += length;
                }
            } else {
                this.initOtherWriter();
                this.otherBuf.write(s, start, length);
            }
            if (length > 0) {
                this.isWhitespaceTerminated = Character.isWhitespace(s[length - 1]);
            }
        }
    }

    public void write(String str, int off, int len) {
        if (this.isOutputEnabled()) {
            if (this.bIsTopBuffer) {
                if (this.buffer != null) {
                    this.buffer.replace(this.nLogicalMark, str.substring(off, len));
                    this.nLogicalMark += len;
                }
            } else {
                this.initOtherWriter();
                this.otherBuf.write(str, off, len);
            }
            if (off + len > 0) {
                this.isWhitespaceTerminated = Character.isWhitespace(str.charAt(off + len - 1));
            }
        }
    }

    public void write(String str) {
        if (this.isOutputEnabled() || this.isjava) {
            if (str == null) {
                return;
            }
            int sLength = str.length();
            if (this.bIsTopBuffer) {
                if (this.buffer != null) {
                    this.buffer.replace(this.nLogicalMark, str);
                    this.nLogicalMark += sLength;
                }
            } else {
                this.initOtherWriter();
                try {
                    this.otherBuf.write(str);
                }
                catch (IOException ex) {
                    throw new RuntimeWrapper(ex);
                }
            }
            if (sLength > 0) {
                this.isWhitespaceTerminated = Character.isWhitespace(str.charAt(sLength - 1));
            }
        }
    }

    public void writeOut(Writer outWriter) {
        try {
            if (outWriter instanceof CFOutput) {
                ((CFOutput)((Object)outWriter)).setLogicalMark(this.nLogicalMark);
                this.nStartLoc = this.nLogicalMark;
            } else {
                outWriter.write(this.getString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public CharBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int getLogicalMark() {
        return this.nLogicalMark;
    }

    @Override
    public void setLogicalMark(int newMark) {
        if (this.otherBuf == null) {
            this.nLogicalMark = newMark;
            this.isWhitespaceTerminated = this.nLogicalMark == 0 || Character.isWhitespace(this.buffer.getCharAt(this.nLogicalMark - 1));
        } else {
            try {
                this.otherBuf.write(this.buffer.substring(this.nLogicalMark, newMark));
            }
            catch (IOException ex) {
                throw new RuntimeWrapper(ex);
            }
        }
    }

    public String getString() {
        if (this.bIsTopBuffer || this.otherBuf == null) {
            this.buffer.setCount(this.nLogicalMark);
            return this.buffer.substring(this.nStartLoc, this.nLogicalMark);
        }
        return new String(this.otherBuf.toCharArray());
    }

    public void clear() {
        if (this.bIsTopBuffer) {
            this.nLogicalMark = this.nStartLoc;
            this.isWhitespaceTerminated = this.nLogicalMark == 0 || Character.isWhitespace(this.buffer.getCharAt(this.nLogicalMark - 1));
        } else {
            this.initOtherWriter();
            this.otherBuf.reset();
        }
    }

    public void clearBuffer() {
        this.clear();
    }

    public Reader getReader() {
        return new CharArrayReader(this.buffer.toCharArray());
    }

    public int getRemaining() {
        return Integer.MAX_VALUE;
    }

    public void print(String s) throws IOException {
        this.write(s == null ? "null" : s);
    }

    public void print(boolean b) throws IOException {
        this.print(String.valueOf(b));
    }

    public void print(char c) throws IOException {
        this.print(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.print(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public void print(char[] c) throws IOException {
        if (c == null) {
            this.write("null");
        } else {
            this.write(c);
        }
    }

    public void print(Object o) throws IOException {
        this.print(o == null ? "null" : o.toString());
    }

    public void newLine() throws IOException {
        this.print(NEWLINE);
    }

    public void println() throws IOException {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(b);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int i) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(i);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(d);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] s) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(s);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(s);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object o) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(o);
            this.newLine();
        }
    }

    public void flush() throws IOException {
    }

    public void close() {
    }

    @Override
    public void whitespaceTerminated() throws IOException {
        if (!this.isWhitespaceTerminated) {
            this.write(32);
        }
    }

    @Override
    public void isJava() throws IOException {
        this.isjava = true;
    }

    @Override
    public void clearAll() {
        this.setLogicalMark(0);
        this.nStartLoc = this.nLogicalMark;
        JspWriter temp = this.getEnclosingWriter();
        if (temp instanceof CFOutput) {
            ((CFOutput)temp).clearAll();
        } else {
            try {
                temp.clear();
            }
            catch (IOException ex) {
                throw new RuntimeWrapper(ex);
            }
        }
    }

    @Override
    public void setIsTopBuffer(boolean isTop) {
        this.bIsTopBuffer = isTop;
        if (isTop && this.otherBuf != null) {
            char[] temp = this.otherBuf.toCharArray();
            this.clear();
            try {
                this.write(temp);
            }
            catch (IOException ex) {
                throw new RuntimeWrapper(ex);
            }
            this.otherBuf = null;
        }
    }

    @Override
    public JspWriter getWriter() {
        return this;
    }

    @Override
    public void clearHeaderBuffers() {
    }
}

