/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.CFOutput;
import coldfusion.runtime.CharBuffer;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RuntimeWrapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.jsp.JspWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class NeoJspWriter
extends JspWriter
implements CFOutput {
    public static final char[] NEWLINE = new char[]{'\r', '\n'};
    private ServletResponse response;
    protected PrintWriter jrunPrintWriter;
    private CharBuffer buffer;
    private int nLogicalMark;
    private CharArrayWriter appendHeaderBuffer;
    private CharArrayWriter prependHeaderBuffer;
    private boolean headerWritten = false;
    private int flushThreshold = -1;
    private int charsAvail = 0;
    private int outputCount = 0;
    private int disableCount = 0;
    private boolean isWhitespaceTerminated = true;
    private boolean bIsTopBuffer = true;
    private CharBuffer otherBuf;
    private int maxBufferSize = -1;
    boolean isjava = false;

    public NeoJspWriter(ServletResponse response, int bufferSize, boolean autoFlush) {
        super(bufferSize, autoFlush);
        this.init(response, bufferSize, autoFlush);
        this.nLogicalMark = 0;
        this.buffer = new CharBuffer(bufferSize);
        if (ServiceFactory.isRuntimeServiceInitialized()) {
            this.maxBufferSize = ServiceFactory.getRuntimeService().getMaxOutputBufferSize() * 1024;
        }
    }

    void init(ServletResponse response, int bufferSize, boolean autoFlush) {
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
        this.response = response;
        this.jrunPrintWriter = null;
        this.init();
    }

    private void init() {
        this.nLogicalMark = 0;
        this.flushThreshold = -1;
        this.charsAvail = 0;
        this.outputCount = 0;
        this.disableCount = 0;
        this.initHeaderBuffer();
        this.otherBuf = null;
        this.bIsTopBuffer = true;
    }

    void init(int bufferSize, boolean autoFlush) {
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
        this.setBufferSize(bufferSize);
        this.init();
    }

    protected void initWriter() throws IOException {
        this.jrunPrintWriter = this.response.getWriter();
        this.setBufferSize(this.bufferSize);
    }

    protected void setBufferSize(int bufferSize) {
        try {
            this.response.setBufferSize(bufferSize);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void print(String s) throws IOException {
        if (this.isOutputEnabled() || this.isjava) {
            int sLength;
            if (s == null) {
                s = "null";
                sLength = 4;
                this.isWhitespaceTerminated = false;
            } else {
                sLength = s.length();
                if (sLength > 0) {
                    this.isWhitespaceTerminated = Character.isWhitespace(s.charAt(sLength - 1));
                }
            }
            if (this.bIsTopBuffer) {
                if (this.buffer != null) {
                    this.buffer.replace(this.nLogicalMark, s);
                    this.nLogicalMark += sLength;
                }
            } else {
                this.initOtherWriter();
                this.otherBuf.write(s, 0, sLength);
            }
            this.addChars(sLength);
        }
    }

    public void print(char[] c) throws IOException {
        if (this.isOutputEnabled()) {
            if (c.length > 0) {
                this.isWhitespaceTerminated = Character.isWhitespace(c[c.length - 1]);
            }
            if (this.bIsTopBuffer) {
                if (this.buffer != null) {
                    this.buffer.replace(this.nLogicalMark, 0, c.length, c);
                    this.nLogicalMark += c.length;
                }
            } else {
                this.initOtherWriter();
                this.otherBuf.write(c, 0, c.length);
            }
            this.addChars(c.length);
        }
    }

    private void initOtherWriter() {
        if (this.otherBuf == null) {
            String temp = this.getString();
            this.otherBuf = new CharBuffer(1024);
            try {
                this.otherBuf.write(temp);
            }
            catch (IOException ex) {
                throw new RuntimeWrapper(ex);
            }
        }
    }

    private CharBuffer writeOutput(Writer writer, boolean resetBuffer) throws IOException {
        boolean prependHeaderTextAvailable;
        int headLoc = -1;
        int headEnd = -1;
        this.buffer.setCount(this.nLogicalMark);
        CharBuffer temp = this.buffer;
        if (this.otherBuf != null) {
            temp = this.otherBuf;
        }
        boolean appendHeaderTextAvailable = this.appendHeaderBuffer != null && this.appendHeaderBuffer.size() > 0;
        boolean bl = prependHeaderTextAvailable = this.prependHeaderBuffer != null && this.prependHeaderBuffer.size() > 0;
        if (appendHeaderTextAvailable || prependHeaderTextAvailable) {
            headLoc = temp.findStringNoCase("<head");
            if (headLoc != -1) {
                headEnd = temp.findStringNoCase("</head>", headLoc);
            }
            int doctypeStart = temp.findStringNoCase("<!doctype");
            if (headLoc != -1 && headEnd != -1) {
                int headStart = temp.findStringNoCase(">", headLoc) + 1;
                String t = temp.toString().toLowerCase().substring(headLoc, headEnd);
                if (t.contains("http-equiv=\"x-ua-compatible\"") || t.contains("http-equiv='x-ua-compatible'")) {
                    int metaEnd = temp.findStringNoCase(">", temp.findStringNoCase("x-ua-compatible")) + 1;
                    if (metaEnd > 1) {
                        temp.writeTo(writer, 0, metaEnd);
                        headStart = metaEnd;
                    } else {
                        temp.writeTo(writer, 0, headStart);
                    }
                } else {
                    temp.writeTo(writer, 0, headStart);
                }
                if (prependHeaderTextAvailable) {
                    this.prependHeaderBuffer.writeTo(writer);
                }
                temp.writeTo(writer, headStart, headEnd);
                if (appendHeaderTextAvailable) {
                    this.appendHeaderBuffer.writeTo(writer);
                }
                temp.writeTo(writer, headEnd, temp.size());
            } else if (doctypeStart != -1) {
                int doctypeEnd = temp.findStringNoCase(">", doctypeStart) + 1;
                temp.writeTo(writer, 0, doctypeEnd);
                if (prependHeaderTextAvailable) {
                    this.prependHeaderBuffer.writeTo(writer);
                }
                if (appendHeaderTextAvailable) {
                    this.appendHeaderBuffer.writeTo(writer);
                }
                temp.writeTo(writer, doctypeEnd, temp.size());
            } else {
                if (prependHeaderTextAvailable) {
                    this.prependHeaderBuffer.writeTo(writer);
                }
                if (appendHeaderTextAvailable) {
                    this.appendHeaderBuffer.writeTo(writer);
                }
                temp.writeTo(writer);
            }
            if (resetBuffer) {
                if (this.appendHeaderBuffer != null) {
                    this.appendHeaderBuffer.reset();
                }
                if (this.prependHeaderBuffer != null) {
                    this.prependHeaderBuffer.reset();
                }
            }
        } else {
            temp.writeTo(writer);
        }
        return temp;
    }

    String getOutput() throws IOException {
        StringWriter writer = new StringWriter();
        this.writeOutput(writer, false);
        return writer.toString();
    }

    public void flush() throws IOException {
        if (this.jrunPrintWriter == null) {
            this.initWriter();
        }
        CharBuffer temp = this.writeOutput(this.jrunPrintWriter, true);
        this.jrunPrintWriter.flush();
        this.nLogicalMark = 0;
        temp.reset();
        this.headerWritten = true;
    }

    public void close() throws IOException {
        if (this.jrunPrintWriter == null) {
            return;
        }
        this.jrunPrintWriter.close();
    }

    public void setFlushThreshold(int nThreshold) {
        this.flushThreshold = nThreshold;
        this.charsAvail = 0;
    }

    private void addChars(int newChars) throws IOException {
        if (this.flushThreshold != -1) {
            this.charsAvail += newChars;
            if (this.charsAvail > this.flushThreshold) {
                this.charsAvail = 0;
                this.flush();
                return;
            }
        }
        if (this.maxBufferSize != -1) {
            this.charsAvail += newChars;
            if (this.charsAvail > this.maxBufferSize) {
                this.charsAvail = 0;
                this.flush();
            }
        }
    }

    private boolean isOutputEnabled() {
        return this.outputCount > 0 || this.disableCount == 0;
    }

    @Override
    public void cfoutput(boolean onoff) {
        this.outputCount = onoff ? this.outputCount + 1 : (this.outputCount > 0 ? this.outputCount - 1 : 0);
    }

    @Override
    public void enablecfoutputonly(boolean onoff) {
        this.disableCount = onoff ? this.disableCount + 1 : (this.disableCount > 0 ? this.disableCount - 1 : 0);
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    @Override
    public int getDisableCount() {
        return this.disableCount;
    }

    @Override
    public CharBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int getLogicalMark() {
        return this.nLogicalMark;
    }

    @Override
    public void setLogicalMark(int newMark) {
        int newChars = newMark - this.nLogicalMark;
        if (this.otherBuf == null) {
            this.nLogicalMark = newMark;
            this.isWhitespaceTerminated = this.nLogicalMark == 0 || Character.isWhitespace(this.buffer.getCharAt(this.nLogicalMark - 1));
        } else {
            try {
                this.otherBuf.write(this.buffer.substring(this.nLogicalMark, newMark));
            }
            catch (IOException ex) {
                throw new RuntimeWrapper(ex);
            }
        }
        try {
            this.addChars(newChars);
        }
        catch (IOException e) {
            throw new RuntimeWrapper(e);
        }
    }

    public String getString() {
        String str = "";
        try {
            str = this.getOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return str;
    }

    public void clear() {
        this.nLogicalMark = 0;
        this.isWhitespaceTerminated = true;
        if (this.bIsTopBuffer) {
            this.buffer.reset();
            if (this.appendHeaderBuffer != null) {
                this.appendHeaderBuffer.reset();
            }
        } else {
            this.initOtherWriter();
            this.otherBuf.reset();
        }
    }

    @Override
    public void clearHeaderBuffers() {
        if (this.appendHeaderBuffer != null) {
            this.appendHeaderBuffer.reset();
        }
        if (this.prependHeaderBuffer != null) {
            this.prependHeaderBuffer.reset();
        }
    }

    public void clearBuffer() {
        this.clear();
    }

    public void deleteBuffer() {
        if (this.buffer != null) {
            this.buffer.deleteBuffer();
        }
        this.buffer = null;
        if (this.otherBuf != null) {
            this.otherBuf.deleteBuffer();
        }
        this.otherBuf = null;
        this.appendHeaderBuffer = null;
        this.prependHeaderBuffer = null;
    }

    public int getRemaining() {
        return -2;
    }

    public void print(boolean b) throws IOException {
        this.print(String.valueOf(b));
    }

    public void print(char c) throws IOException {
        char[] cArray = new char[]{c};
        this.print(cArray);
    }

    public void print(int i) throws IOException {
        this.print(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public void print(Object o) throws IOException {
        this.print(o == null ? "null" : o.toString());
    }

    public void newLine() throws IOException {
        this.print(NEWLINE);
    }

    public void println() throws IOException {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(b);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int i) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(i);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(d);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] s) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(s);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(s);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object o) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(o);
            this.newLine();
        }
    }

    public void write(char[] c) throws IOException {
        this.print(c);
    }

    public void write(int c) throws IOException {
        char[] a = new char[]{(char)c};
        this.write(a);
    }

    public void write(String s) throws IOException {
        if (s != null) {
            this.print(s);
        }
    }

    public void write(char[] c, int start, int length) throws IOException {
        this.print(String.copyValueOf(c, start, length));
    }

    private void initHeaderBuffer() {
        if (this.appendHeaderBuffer != null) {
            this.appendHeaderBuffer.reset();
        }
        if (this.prependHeaderBuffer != null) {
            this.prependHeaderBuffer.reset();
        }
        this.headerWritten = false;
    }

    public boolean writeHeader(String text) throws IOException {
        return this.writeHeader(text, false);
    }

    public boolean writeHeader(String text, boolean prepend) throws IOException {
        if (!this.headerWritten) {
            if (prepend) {
                if (this.prependHeaderBuffer == null) {
                    this.prependHeaderBuffer = new CharArrayWriter(512);
                }
                this.prependHeaderBuffer.write(text);
            } else {
                if (this.appendHeaderBuffer == null) {
                    this.appendHeaderBuffer = new CharArrayWriter(512);
                }
                this.appendHeaderBuffer.write(text);
            }
            return true;
        }
        return false;
    }

    @Override
    public void whitespaceTerminated() throws IOException {
        if (!this.isWhitespaceTerminated) {
            this.print(" ");
        }
    }

    @Override
    public void isJava() throws IOException {
        this.isjava = true;
    }

    @Override
    public void clearAll() {
        this.clear();
    }

    @Override
    public void setIsTopBuffer(boolean isTop) {
        this.bIsTopBuffer = isTop;
        if (isTop && this.otherBuf != null) {
            char[] temp = this.otherBuf.toCharArray();
            this.clear();
            try {
                this.write(temp);
            }
            catch (IOException ex) {
                throw new RuntimeWrapper(ex);
            }
            this.otherBuf = null;
        }
    }

    @Override
    public JspWriter getWriter() {
        return this;
    }
}

