/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.SessionScope;
import coldfusion.runtime.SessionTracker;
import coldfusion.util.EnumerationIterator;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class NoNameJ2eeSessionScope
extends SessionScope {
    private static final long serialVersionUID = 1L;
    private HttpSession mHttpServletSession;

    NoNameJ2eeSessionScope(HttpSession session) {
        super("");
        this.mHttpServletSession = session;
    }

    @Override
    public void CleanUp() {
        try {
            this.clearCSRFMap();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public boolean IsJ2eeSession() {
        return true;
    }

    @Override
    public String getSessionId() {
        return this.mHttpServletSession.getId();
    }

    @Override
    protected void bind(String name, Object value) {
        this.mLastAccess = System.currentTimeMillis();
        this.mHttpServletSession.setAttribute(name, value);
    }

    @Override
    protected void unbind(String name) {
        this.mLastAccess = System.currentTimeMillis();
        this.mHttpServletSession.removeAttribute(name);
    }

    @Override
    protected Object resolve(String name) {
        this.mLastAccess = System.currentTimeMillis();
        return this.mHttpServletSession.getAttribute(name);
    }

    @Override
    public Iterator getNames() {
        return new EnumerationIterator(this.mHttpServletSession.getAttributeNames());
    }

    @Override
    public void SetMaxInactiveInterval(long max) {
        super.SetMaxInactiveInterval(max);
        if (this.mHttpServletSession != null && max > (long)this.mHttpServletSession.getMaxInactiveInterval()) {
            this.mHttpServletSession.setMaxInactiveInterval((int)(max + (long)(SessionTracker.mSweepInterval / 1000)));
        }
    }

    @Override
    protected HashMap<String, Object> getSessionData() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Iterator iter = this.getNames();
        while (iter.hasNext()) {
            String attrKey = (String)iter.next();
            Object attrValue = this.mHttpServletSession.getAttribute(attrKey);
            attributes.put(attrKey, attrValue);
        }
        return attributes;
    }

    @Override
    protected void setSessionData(HttpSession session, HashMap<String, Object> attributes) {
        this.mHttpServletSession = session;
        Set<String> keys = attributes.keySet();
        for (String string : keys) {
            this.mHttpServletSession.setAttribute(string, attributes.get(string));
        }
    }

    public void setHttpServletSession(HttpSession httpServletSession) {
        this.mHttpServletSession = httpServletSession;
    }
}

