/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.osgi.services.PDFService;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.CaseSensitiveStruct;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.Invokable;
import coldfusion.runtime.OrderedCaseSensitiveStruct;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructOrdered;
import coldfusion.runtime.StructSorted;
import coldfusion.runtime.StructUtils;
import coldfusion.runtime.TemplateProxy;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryColumn;
import coldfusion.sql.QueryTable;
import coldfusion.util.FastHashtable;
import coldfusion.xml.XmlNodeList;
import com.allaire.cfx.Query;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ObjectDuplicator {
    public static Object duplicate(Object obj) throws IllegalAccessException {
        return ObjectDuplicator.duplicate(obj, null);
    }

    public static Object duplicate(Object obj, IdentityHashMap refCache) throws IllegalAccessException {
        Object newObj;
        PDFService pdfService = ServiceFactory.getPDFService();
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number || obj instanceof Boolean || obj instanceof String || obj.getClass().isPrimitive()) {
            return obj;
        }
        if (obj instanceof Throwable) {
            return Cast._Map(obj);
        }
        if (ServiceFactory.getImageService(false) != null && ServiceFactory.getImageService().isImage(obj)) {
            return ServiceFactory.getImageService().newImage(obj, null);
        }
        if (pdfService != null && pdfService.isPDFCoreObject(obj)) {
            return pdfService.deepCopy(obj);
        }
        if (refCache == null) {
            refCache = new IdentityHashMap();
        }
        if ((newObj = refCache.get(obj)) == null) {
            newObj = ObjectDuplicator._duplicate(obj, refCache);
            refCache.put(obj, newObj);
        }
        return newObj;
    }

    private static Object _duplicate(Object obj, IdentityHashMap refCache) throws IllegalAccessException {
        if (obj instanceof Date) {
            return ObjectDuplicator.duplicateDate(obj);
        }
        if (obj instanceof FastArray) {
            return ArrayUtil.Duplicate((FastArray)obj, refCache);
        }
        if (obj.getClass().isArray()) {
            return ObjectDuplicator.duplicateJavaArray(obj, refCache);
        }
        if (obj instanceof QueryColumn) {
            return ((QueryColumn)obj).duplicate();
        }
        if (obj instanceof List) {
            return ObjectDuplicator.duplicateList((List)obj, refCache);
        }
        if (obj instanceof FastHashtable) {
            return ((FastHashtable)obj).duplicate(refCache);
        }
        if (CFPage.IsQuery(obj)) {
            try {
                if (obj instanceof QueryTable) {
                    return ObjectDuplicator.duplicateQueryTable((QueryTable)obj);
                }
                return new QueryTable((Query)obj);
            }
            catch (SQLException sqlExp) {
                throw new IllegalAccessException("Due to SQL Exception");
            }
        }
        if (obj instanceof XmlNodeList) {
            return ((XmlNodeList)obj).Duplicate();
        }
        if (CFPage.IsCustomFunction(obj)) {
            return obj;
        }
        if (obj instanceof TemplateProxy) {
            return ((TemplateProxy)obj).duplicate(refCache);
        }
        if (obj instanceof Invokable) {
            return obj;
        }
        if (obj instanceof Map) {
            Map scopeObj = (Map)obj;
            Map structCopy = null;
            structCopy = scopeObj instanceof StructOrdered ? StructUtils.StructNewOrdered() : (scopeObj instanceof StructSorted ? StructUtils.StructNewSorted() : (scopeObj instanceof OrderedCaseSensitiveStruct ? new OrderedCaseSensitiveStruct() : (scopeObj instanceof CaseSensitiveStruct ? new CaseSensitiveStruct() : StructUtils.StructNew())));
            refCache.put(obj, structCopy);
            if (scopeObj instanceof Struct) {
                ((Struct)structCopy).setMetaData(((Struct)scopeObj).getMetaData());
            }
            for (Map.Entry e : scopeObj.entrySet()) {
                String key = (String)e.getKey();
                Object value = e.getValue();
                structCopy.put(key, ObjectDuplicator.duplicate(value, refCache));
            }
            return structCopy;
        }
        return obj;
    }

    static QueryTable duplicateQueryTable(QueryTable obj) throws SQLException, IllegalAccessException {
        QueryTable rs = obj;
        QueryTable head = null;
        QueryTable prev = null;
        while (rs != null) {
            QueryTable curr = new QueryTable(rs);
            if (head == null) {
                head = curr;
            } else {
                curr.setPreviousTable(prev);
                prev.setNextTable(curr);
            }
            prev = curr;
            rs = rs.nextTable() != null ? (QueryTable)rs.nextTable() : null;
        }
        return head;
    }

    private static List duplicateList(List original, IdentityHashMap refCache) throws IllegalAccessException {
        ArrayList<Object> copy = new ArrayList<Object>(original.size());
        refCache.put(original, copy);
        ListIterator e = original.listIterator();
        while (e.hasNext()) {
            Object curObj = e.next();
            copy.add(ObjectDuplicator.duplicate(curObj, refCache));
        }
        return copy;
    }

    private static Object duplicateJavaArray(Object obj, IdentityHashMap refCache) throws IllegalAccessException {
        int len = Array.getLength(obj);
        Object dst = Array.newInstance(obj.getClass().getComponentType(), len);
        refCache.put(obj, dst);
        if (obj.getClass().getComponentType().isPrimitive()) {
            System.arraycopy(obj, 0, dst, 0, len);
        } else {
            for (int i = 0; i < len; ++i) {
                Object src = Array.get(obj, i);
                Array.set(dst, i, ObjectDuplicator.duplicate(src, refCache));
            }
        }
        return dst;
    }

    public static Object duplicateDate(Object obj) {
        return ((Date)obj).clone();
    }

    public static class UnableToDuplicateCFCException
    extends ExpressionException {
        public UnableToDuplicateCFCException(Throwable th) {
            super(th);
        }
    }
}

