/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.ColumnDoesNotExistInQueryFeedGeneratorException;
import coldfusion.runtime.QueryVectorWrapper;
import coldfusion.runtime.Scope;
import coldfusion.sql.QueryTable;
import coldfusion.sql.imq.OrderByColumnList;
import coldfusion.sql.imq.rttExprOrderedcolumnref;
import coldfusion.util.Utils;
import coldfusion.wddx.RecordSet;
import com.allaire.cfx.Query;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class QueryVector
extends Scope
implements Query,
RecordSet {
    protected String name;
    protected QueryTable table;

    public QueryVector(String n, String[] columnNames) {
        this.table = new QueryTable(0, columnNames);
        this.name = n;
    }

    public QueryVector(QueryTable t) {
        this("", t);
    }

    public QueryVector(String n, QueryTable t) {
        this.table = t;
        this.name = n;
    }

    public QueryVector(QueryVectorWrapper qvWrapper) {
        this.initQueryVectorFromWrapper(qvWrapper);
    }

    private void initQueryVectorFromWrapper(QueryVectorWrapper qvWrapper) {
        this.name = qvWrapper.getName();
        this.table = (QueryTable)qvWrapper.getTable();
    }

    public QueryTable getQuery() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getRowCount() {
        return this.table.getRowCount();
    }

    public int getColumnIndex(String n) {
        return this.table.findColumn(n);
    }

    public String[] getColumns() {
        return this.table.getColumnNames();
    }

    public String getData(int row, int col) {
        Object obj = this.table.getField(row, col);
        if (obj != null) {
            if (obj instanceof char[]) {
                return new String((char[])obj);
            }
            return obj.toString();
        }
        return null;
    }

    public int addRow() {
        return this.table.addRows(1);
    }

    public void setData(int row, int col, String data) {
        this.table.setField(row, col, data);
    }

    @Override
    public Iterator getNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object resolveName(String name) {
        if ("recordcount".equalsIgnoreCase(name)) {
            return new Integer(this.table.getRecordCount());
        }
        if ("currentrow".equalsIgnoreCase(name)) {
            int r = this.table.getCurrentRow();
            if (r == 0) {
                r = 1;
                try {
                    this.table.next();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new Integer(r);
        }
        if ("columnlist".equalsIgnoreCase(name)) {
            return Utils.arrayToString(this.table.getColumnNames(), ",", true, true);
        }
        if ("columnnames".equalsIgnoreCase(name)) {
            Object[] colNames = this.table.getColumnNames();
            Arrays.sort(colNames);
            return colNames;
        }
        int index = this.table.findColumn(name);
        if (index != 0) {
            return this.table.getColumn(index);
        }
        return null;
    }

    @Override
    public boolean containsName(String name) {
        return this.resolveName(name) != null;
    }

    @Override
    public void bindName_Final(String name, Object value) {
        this.bindName(name, value);
    }

    @Override
    public void bindName(String name, Object value) {
        if (this.table.findColumn(name) == 0) {
            throw new ColumnDoesNotExistInQueryFeedGeneratorException(name);
        }
        int index = this.table.findColumn(name);
        if (index != 0) {
            int r = this.table.getCurrentRow();
            if (r == 0) {
                this.table.next();
            }
            if ((r = this.table.getCurrentRow()) != 0) {
                this.table.setField(r, index, value);
            }
        }
    }

    @Override
    public void unbindName(String name) {
        this.bindName(name, null);
    }

    @Override
    public String getRecordsetType() {
        if (this.name != null && this.name.length() != 0) {
            return this.name;
        }
        return "CFX_QUERY";
    }

    @Override
    public int addColumn(String columnName) {
        return this.table.addColumn(columnName);
    }

    @Override
    public int addRows(int rows) {
        return this.table.addRows(rows);
    }

    @Override
    public int findColumn(String columnName) {
        return this.table.findColumn(columnName);
    }

    @Override
    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    @Override
    public String[] getColumnNames() {
        return this.table.getColumnNames();
    }

    @Override
    public Object getField(int row, int col) {
        return this.table.getField(row, col);
    }

    @Override
    public void setField(int row, int col, Object value) {
        this.table.setField(row, col, value);
    }

    @Override
    public int addColumn(String columnName, Vector values) {
        return this.table.addColumn(columnName, values);
    }

    public void sort(int iCol, String sort_order) {
        boolean bDir = true;
        bDir = sort_order.compareToIgnoreCase("ASC") == 0;
        this.table.sort(iCol, bDir, false);
    }

    public static OrderByColumnList parseSortString(String str) {
        StringTokenizer tok = new StringTokenizer(str, ",");
        rttExprOrderedcolumnref pcol = null;
        OrderByColumnList colList = new OrderByColumnList();
        while (tok.hasMoreTokens()) {
            String phrase = tok.nextToken();
            StringTokenizer tok2 = new StringTokenizer(phrase);
            String column = tok2.nextToken();
            String order = null;
            if (tok2.hasMoreTokens()) {
                order = tok2.nextToken();
            }
            int col = 0;
            if (column.equalsIgnoreCase("ENTRY")) {
                col = 0;
            } else if (column.equalsIgnoreCase("TYPE")) {
                col = 1;
            } else if (column.equalsIgnoreCase("VALUE")) {
                col = 2;
            }
            boolean ord = false;
            if (order != null && order.equalsIgnoreCase("ASC")) {
                ord = false;
            } else if (order != null && order.equalsIgnoreCase("DESC")) {
                ord = true;
            }
            pcol = new rttExprOrderedcolumnref(col, ord);
            colList.addColumn(pcol);
        }
        return colList;
    }

    public void sort(String criteria) {
        OrderByColumnList ordlist = QueryVector.parseSortString(criteria);
        this.table.sort(ordlist, false);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Object writeReplace() {
        QueryVectorWrapper qvWrapper = new QueryVectorWrapper();
        qvWrapper.setName(this.name);
        qvWrapper.setTable((Object)this.table);
        return qvWrapper;
    }

    @Override
    public List getColumn(int index) {
        return this.table.getColumn(index);
    }
}

