/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.Utils;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class RealPathCache {
    private static final Map<String, Map<String, String>> siteRealPathCache = new HashMap<String, Map<String, String>>();
    private static final Map<String, String> webrootRealPathCache = new HashMap<String, String>();
    private static final Set<String> webrootRealPathCacheMiss = new HashSet<String>();
    private static boolean resolveSymLink = Boolean.valueOf(Optional.ofNullable(System.getProperty("coldfusion.resolveSymLink")).orElse("false"));
    private static ThreadLocal<?> currentAjpProcessorThreadLocal;
    private static Method ajpProcessorRealPathMethod;
    private static String webRoot;
    private static boolean _isStandalone;
    private static final String[] welcomeFileList;

    static void setWebRoot(String webRoot) {
        RealPathCache.webRoot = webRoot;
    }

    public static String getRealPath(ServletContext servletContext, String path) {
        if (path.length() == 0) {
            return webRoot;
        }
        if (path.equals("/")) {
            return RealPathCache.getWebrootPath(servletContext);
        }
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        if (runtimeService.isCachePaths()) {
            if (path.startsWith("/WEB-INF")) {
                return RealPathCache.getRealPathFromContext(servletContext, path);
            }
            String lpath = path.toLowerCase();
            if (lpath.endsWith(".cfm") || lpath.endsWith(".cfc")) {
                String realPath = RealPathCache.getWebRootRealPathCache(servletContext, path, lpath.startsWith("/cfide/"));
                if (realPath != null) {
                    return realPath;
                }
                Boolean isAJPRequest = RealPathCache.isAJPRequest();
                if (isAJPRequest == Boolean.FALSE) {
                    return null;
                }
                if (isAJPRequest == Boolean.TRUE) {
                    String siteName = FusionContext.getSiteName();
                    if (siteName != null) {
                        Map<String, String> cache = RealPathCache.getCacheForSite(siteName);
                        return RealPathCache.getRealPathFromAJP(servletContext, cache, path);
                    }
                    return RealPathCache.getRealPathFromAJP(servletContext, path);
                }
            }
        }
        return RealPathCache.resolveRealPath(servletContext, path);
    }

    private static String resolveRealPath(ServletContext servletContext, String path) {
        String realPath = servletContext.getRealPath(path);
        if (realPath == null && resolveSymLink) {
            realPath = RealPathCache.resolveSymlink(servletContext, path);
        }
        return realPath;
    }

    private static final String getWebrootPath(ServletContext servletContext) {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        if (RealPathCache.isAJPRequest() == Boolean.TRUE) {
            String siteName;
            if (runtimeService.isCachePaths() && (siteName = FusionContext.getSiteName()) != null) {
                Map<String, String> cache = RealPathCache.getCacheForSite(siteName);
                return RealPathCache.getRealPathFromAJP(servletContext, cache, "/", true);
            }
            return RealPathCache.getRealPathFromAJP(servletContext, "/", true);
        }
        return servletContext.getRealPath("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getCacheForSite(String siteName) {
        Map<String, String> cache = siteRealPathCache.get(siteName);
        if (cache == null) {
            Map<String, Map<String, String>> map = siteRealPathCache;
            synchronized (map) {
                cache = siteRealPathCache.get(siteName);
                if (cache == null) {
                    cache = new HashMap<String, String>();
                    siteRealPathCache.put(siteName, cache);
                }
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getWebRootRealPathCache(ServletContext sContext, String path, boolean useContext) {
        if (webRoot == null) {
            return RealPathCache.resolveRealPath(sContext, (String)path);
        }
        if (!((String)path).startsWith(File.separator) && !((String)path).startsWith("/")) {
            path = File.separator + (String)path;
        }
        if (webrootRealPathCacheMiss.contains(path)) {
            return null;
        }
        String realPath = webrootRealPathCache.get(path);
        if (realPath == null) {
            Map<String, String> map = webrootRealPathCache;
            synchronized (map) {
                realPath = webrootRealPathCache.get(path);
                if (realPath == null) {
                    if (webrootRealPathCacheMiss.contains(path)) {
                        return null;
                    }
                    if (useContext) {
                        realPath = sContext.getRealPath((String)path);
                    } else {
                        File file = new File(webRoot, (String)path);
                        if (file.canRead()) {
                            realPath = file.getAbsolutePath();
                        }
                    }
                    if (realPath == null && resolveSymLink) {
                        realPath = RealPathCache.resolveSymlink(sContext, (String)path);
                    }
                    if (realPath != null) {
                        webrootRealPathCache.put((String)path, realPath);
                    } else {
                        webrootRealPathCacheMiss.add((String)path);
                    }
                }
            }
        }
        return realPath;
    }

    private static String resolveSymlink(ServletContext sContext, String path) {
        Path p;
        Path parent;
        Object completePath = sContext.getRealPath("/");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        completePath = (String)completePath + path;
        File f = new File((String)completePath);
        boolean found = false;
        for (parent = p = f.toPath(); parent != null && !(found |= Files.isSymbolicLink(parent)); parent = parent.getParent()) {
        }
        if (found) {
            String parentPath = parent.toString();
            String updatedPath = Utils.getCanonicalPath(parentPath);
            if (updatedPath == null) {
                return null;
            }
            return ((String)completePath).replace(parentPath, updatedPath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRealPathFromContext(ServletContext sContext, String path) {
        if (webrootRealPathCacheMiss.contains(path)) {
            return null;
        }
        String realPath = webrootRealPathCache.get(path);
        if (realPath == null) {
            Map<String, String> map = webrootRealPathCache;
            synchronized (map) {
                realPath = webrootRealPathCache.get(path);
                if (realPath == null) {
                    if (webrootRealPathCacheMiss.contains(path)) {
                        return null;
                    }
                    realPath = sContext.getRealPath(path);
                    if (realPath != null) {
                        webrootRealPathCache.put(path, realPath);
                    } else {
                        webrootRealPathCacheMiss.add(path);
                    }
                }
            }
        }
        return realPath;
    }

    private static String getRealPathFromAJP(ServletContext servletContext, Map<String, String> cache, String path) {
        return RealPathCache.getRealPathFromAJP(servletContext, cache, path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRealPathFromAJP(ServletContext servletContext, Map<String, String> cache, String path, boolean isWebroot) {
        String realPath = cache.get(path);
        if (realPath == null) {
            Map<String, String> map = cache;
            synchronized (map) {
                realPath = cache.get(path);
                if (realPath == null) {
                    realPath = RealPathCache.getRealPathFromAJP(servletContext, path, isWebroot);
                }
            }
            if (realPath != null) {
                cache.put(path, realPath);
            }
        }
        return realPath;
    }

    private static String getRealPathFromAJP(ServletContext servletContext, String path) {
        return RealPathCache.getRealPathFromAJP(servletContext, path, false);
    }

    private static String getRealPathFromAJP(ServletContext servletContext, String path, boolean isWebroot) {
        Object ajpProcessor;
        if (currentAjpProcessorThreadLocal != null && (ajpProcessor = currentAjpProcessorThreadLocal.get()) != null && ajpProcessorRealPathMethod != null) {
            try {
                String rPath = (String)ajpProcessorRealPathMethod.invoke(ajpProcessor, path);
                if (isWebroot) {
                    return RealPathCache.removeWelcomeFileFromEnd(rPath);
                }
                return rPath;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return null;
            }
        }
        return servletContext.getRealPath(path);
    }

    private static String removeWelcomeFileFromEnd(String rPath) {
        if (rPath != null) {
            File file = new File(rPath);
            String fileName = file.getName();
            if (fileName != null && fileName.length() > 0 && fileName.contains(".")) {
                String lFileName = fileName.toLowerCase();
                for (String welcomeFile : welcomeFileList) {
                    if (!lFileName.equals(welcomeFile) && !lFileName.startsWith(welcomeFile + ".")) continue;
                    return file.getParent();
                }
            }
            return rPath;
        }
        return null;
    }

    private static Boolean isAJPRequest() {
        if (currentAjpProcessorThreadLocal == null || ajpProcessorRealPathMethod == null) {
            return null;
        }
        return currentAjpProcessorThreadLocal != null && currentAjpProcessorThreadLocal.get() != null;
    }

    public static void clearAll() {
        RealPathCache.clearAllSitesRealPathCache();
        RealPathCache.clearWebRootPathCache();
    }

    static void clearAllSitesRealPathCache() {
        siteRealPathCache.clear();
    }

    static void clearSiteRealPathCache(String sitename) {
        siteRealPathCache.remove(sitename);
    }

    static void clearWebRootPathCache() {
        webrootRealPathCache.clear();
        webrootRealPathCacheMiss.clear();
    }

    static {
        welcomeFileList = new String[]{"index.cfm", "index.htm", "index.html"};
        try {
            try {
                Class.forName("com.adobe.coldfusion.launcher.Launcher");
                _isStandalone = true;
            }
            catch (ClassNotFoundException cnfe) {
                _isStandalone = false;
            }
        }
        catch (Throwable cnfe) {
            // empty catch block
        }
        if (_isStandalone) {
            try {
                Class<?> cls = Class.forName("org.apache.catalina.connector.CoyoteAdapter");
                Field field = cls.getField("local");
                if (field.getType() == ThreadLocal.class) {
                    currentAjpProcessorThreadLocal = (ThreadLocal)field.get(null);
                }
                cls = Class.forName("org.apache.coyote.ajp.AjpProcessor");
                ajpProcessorRealPathMethod = cls.getMethod("getRealPath", String.class);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
    }
}

