/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.RequestInfo;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;

public final class RequestMonitor {
    private static RuntimeService _runtimeService = ServiceFactory.getRuntimeService();
    private static ThreadLocal currentRequestInfo = new ThreadLocal();

    private RequestMonitor() {
    }

    public static void beginRequestMonitor(String request) {
        RequestInfo reqInfo = RequestMonitor.getRequestInfo();
        if (reqInfo != null) {
            reqInfo.initialize(request, System.currentTimeMillis());
        } else {
            reqInfo = new RequestInfo(request, System.currentTimeMillis());
            currentRequestInfo.set(reqInfo);
        }
    }

    public static void endRequestMonitor() {
        RequestInfo reqInfo = RequestMonitor.getRequestInfo();
        if (reqInfo != null) {
            reqInfo.reset();
        }
        currentRequestInfo.remove();
    }

    public static void checkSlowRequest(FusionContext context) {
        RequestInfo reqInfo;
        if (_runtimeService.logSlowRequests() && (reqInfo = RequestMonitor.getRequestInfo()) != null && RequestMonitor.hasRequestExceededTimeLimit(_runtimeService.getSlowRequestLimit() * 1000L, reqInfo)) {
            String realPath = context.getPagePath();
            long totalTime = (System.currentTimeMillis() - reqInfo.getStartTime()) / 1000L;
            if (realPath == null) {
                realPath = reqInfo.getRequest();
            }
            Thread curThread = Thread.currentThread();
            CFLogs.SERVER_LOG.warn(RB.getString(RequestMonitor.class, "RequestMonitor.SlowRequest", (Object)curThread.getName(), (Object)realPath, (Object)new Long(totalTime), (Object)new Long(_runtimeService.getSlowRequestLimit())));
        }
    }

    public static void overrideRequestTimeout(long timeLimit) {
        RequestInfo reqInfo = RequestMonitor.getRequestInfo();
        if (reqInfo != null) {
            reqInfo.setTimeoutOverride(timeLimit);
        }
    }

    public static boolean isRequestTimedOut() {
        if (_runtimeService.timeoutRequests()) {
            long timeLimit = _runtimeService.getRequestTimeoutLimit() * 1000L;
            RequestInfo reqInfo = RequestMonitor.getRequestInfo();
            if (reqInfo != null) {
                long override = reqInfo.getTimeoutOverride();
                if (override == 0L) {
                    return false;
                }
                if (override != -1L) {
                    timeLimit = override * 1000L;
                }
                return RequestMonitor.hasRequestExceededTimeLimit(timeLimit, reqInfo);
            }
        }
        return false;
    }

    public static long getRequestTimeout() {
        if (_runtimeService.timeoutRequests()) {
            long override;
            long timeLimit = _runtimeService.getRequestTimeoutLimit();
            RequestInfo reqInfo = RequestMonitor.getRequestInfo();
            if (reqInfo != null && (override = reqInfo.getTimeoutOverride()) != -1L) {
                timeLimit = override;
            }
            return timeLimit;
        }
        return 0L;
    }

    private static RequestInfo getRequestInfo() {
        return (RequestInfo)currentRequestInfo.get();
    }

    private static boolean hasRequestExceededTimeLimit(long timeLimitMillis, RequestInfo reqInfo) {
        long reqStartTime = reqInfo.getStartTime();
        if (reqStartTime != -1L) {
            if (System.currentTimeMillis() - reqStartTime > timeLimitMillis) {
                return true;
            }
        } else if (CFLogs.SERVER_LOG.isDebugEnabled()) {
            Thread curThread = Thread.currentThread();
            CFLogs.SERVER_LOG.debug(RB.getString(RequestMonitor.class, "RequestMonitor.UninitializedRequest", (Object)curThread.getName()));
        }
        return false;
    }
}

