/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.monitor.memory.MemoryTrackableRoot;
import coldfusion.monitor.memory.MemoryTracker;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.AbstractScope;
import coldfusion.runtime.LockManager;
import coldfusion.runtime.LockableScope;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public final class RequestScope
extends AbstractScope
implements MemoryTrackableRoot,
LockableScope {
    private HttpServletRequest request;
    private transient Object requestLock = LockManager.get().requestNewLock();

    public RequestScope() {
    }

    public RequestScope(HttpServletRequest request) {
        this.request = request;
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null) {
            rmd.setRequestScope(this);
        }
    }

    @Override
    public MemoryTracker getMemoryTracker() {
        MemoryTracker mt = null;
        MemoryTrackerProxy mtp = this.getMemoryTrackerProxy();
        if (mtp != null) {
            mt = this.getMemoryTrackerProxy().getBuiltInMemoryTracker();
        }
        return mt;
    }

    public void clearRequest() {
        this.request = null;
        this.setMemoryTrackerProxy(null);
    }

    @Override
    protected void bind(String name, Object value) {
        if (this.request == null) {
            FusionContext.getCurrent().getRequest().setAttribute(name, value);
        } else {
            this.request.setAttribute(name, value);
        }
    }

    @Override
    protected void bind_Final(String name, Object value) {
        this.bind(name, value);
    }

    @Override
    protected void unbind(String name) {
        if (this.request == null) {
            FusionContext.getCurrent().getRequest().removeAttribute(name);
        } else {
            this.request.removeAttribute(name);
        }
    }

    @Override
    protected Object resolve(String name) {
        if (this.request == null) {
            return FusionContext.getCurrent().getRequest().getAttribute(name);
        }
        return this.request.getAttribute(name);
    }

    @Override
    public int size() {
        Iterator e = this.getNames();
        int x = 0;
        while (e.hasNext()) {
            e.next();
            ++x;
        }
        return x;
    }

    @Override
    protected Iterator getNames() {
        Vector<String> v = new Vector<String>();
        HttpServletRequest requestTemp = this.getRequest();
        Enumeration e = requestTemp.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (requestTemp.getAttribute(name) == null || name.startsWith("jakarta.servlet.") || name.startsWith("coldfusion.")) continue;
            v.addElement(name);
        }
        return v.iterator();
    }

    private HttpServletRequest getRequest() {
        HttpServletRequest requestTemp = null;
        requestTemp = this.request == null ? FusionContext.getCurrent().getRequest() : this.request;
        return requestTemp;
    }

    @Override
    public void clear() {
        Iterator itr = this.getNames();
        while (itr.hasNext()) {
            HttpServletRequest requestTemp = this.getRequest();
            requestTemp.removeAttribute((String)itr.next());
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.cloneAsStruct();
    }

    @Override
    public Object getLock() {
        return this.requestLock;
    }
}

