/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.monitor.memory.MemoryTrackable;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.CloneableMap;
import coldfusion.runtime.ScopeSearchResult;
import coldfusion.runtime.Struct;
import coldfusion.runtime.java.JavaProxy;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Scope
extends AbstractMap
implements CloneableMap,
MemoryTrackable {
    private Set entrySet = null;
    private MemoryTrackerProxy mtProxy;
    private int scopeType = -1;

    @Override
    public abstract Object clone() throws CloneNotSupportedException;

    protected Object cloneAsStruct() {
        Struct clonedScope = new Struct();
        Iterator namesEnum = this.getNames();
        while (namesEnum.hasNext()) {
            String key = (String)namesEnum.next();
            Object val = this.resolveName(key);
            clonedScope.put(key, val);
        }
        return clonedScope;
    }

    public Set entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new ScopeSet(this));
    }

    public Object get(Object key) {
        return this.resolveName((String)key);
    }

    public Object getCanonicalKey(Object key) {
        return this.get(key);
    }

    public Object put(Object key, Object value) {
        boolean keyExists = this.containsKey(key);
        Object old = this.resolveName((String)key);
        this.bindName((String)key, value);
        if (this.mtProxy != null) {
            this.mtProxy.onPut(key, value, old, keyExists);
        }
        return old;
    }

    public Object put_Final(Object key, Object value) {
        boolean keyExists = this.containsKey(key);
        Object old = this.resolveName((String)key);
        this.bindName_Final((String)key, value);
        if (this.mtProxy != null) {
            this.mtProxy.onPut(key, value, old, keyExists);
        }
        return old;
    }

    public Object putCanonicalKey(Object key, Object value) {
        return this.put(key, value);
    }

    public Object remove(Object key) {
        boolean keyExists = this.containsKey(key);
        Object old = this.resolveName((String)key);
        this.unbindName((String)key);
        if (this.mtProxy != null) {
            this.mtProxy.onRemove(key, old, keyExists);
        }
        return old;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsName((String)key);
    }

    @Override
    public int size() {
        int size = 0;
        Iterator t = this.getNames();
        while (t.hasNext()) {
            ++size;
            t.next();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return !this.getNames().hasNext();
    }

    public void setupMemoryTracking() {
        MemoryTrackerProxy.checkEnabled(this);
    }

    @Override
    public MemoryTrackerProxy getMemoryTrackerProxy() {
        return this.mtProxy;
    }

    @Override
    public void setMemoryTrackerProxy(MemoryTrackerProxy mtp) {
        this.mtProxy = mtp;
    }

    @Override
    public Iterator valuesIterator() {
        final Iterator entrySetItr = this.entrySet().iterator();
        Iterator valuesItr = null;
        if (entrySetItr != null) {
            valuesItr = new Iterator(){
                private Iterator setItr;
                {
                    this.setItr = entrySetItr;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return this.setItr.hasNext();
                }

                public Object next() {
                    return ((Map.Entry)this.setItr.next()).getValue();
                }
            };
        }
        return valuesItr;
    }

    public void setScopeType(int scopeType) {
        this.scopeType = scopeType;
        this.setupMemoryTracking();
    }

    public void setScopeType(int scopeType, boolean memoryTracking) {
        this.scopeType = scopeType;
        if (memoryTracking) {
            this.setupMemoryTracking();
        }
    }

    @Override
    public int getScopeType() {
        return this.scopeType;
    }

    protected abstract void bindName(String var1, Object var2);

    protected abstract void bindName_Final(String var1, Object var2);

    protected abstract void unbindName(String var1);

    protected abstract Object resolveName(String var1);

    protected abstract boolean containsName(String var1);

    protected abstract Iterator getNames();

    public void cloneScope(Scope src) {
        this.putAll(src);
    }

    public void search(ScopeSearchResult searcher) {
        searcher.search(this, true);
    }

    private class ScopeSet
    extends AbstractSet
    implements Serializable {
        private Scope map;

        ScopeSet(Scope map) {
            this.map = map;
        }

        @Override
        public Iterator iterator() {
            Iterator namesIter = Scope.this.getNames();
            return namesIter == null ? null : new ScopeIterator(namesIter);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        private class ScopeIterator
        implements Iterator {
            private Iterator iter;

            ScopeIterator(Iterator iter) {
                this.iter = iter;
            }

            @Override
            public void remove() {
                this.iter.remove();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return new ScopeEntry(this.iter.next());
            }

            private class ScopeEntry
            implements Map.Entry,
            Serializable {
                private Object key;

                ScopeEntry(Object key) {
                    this.key = key;
                }

                public Object getValue() {
                    if (this.key instanceof JavaProxy) {
                        return this.key;
                    }
                    return ScopeSet.this.map.get(this.key);
                }

                public Object setValue(Object value) {
                    if (this.key instanceof JavaProxy) {
                        return null;
                    }
                    return ScopeSet.this.map.put(this.key, value);
                }

                public Object getKey() {
                    return this.key;
                }
            }
        }
    }
}

