/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.Encryptor;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class SecureRandomGenerator {
    public static final String DEFAULT_RAND_ALGO = "SHA1PRNG";
    private static ThreadLocal<SecureRandom> randRef = new ThreadLocal();

    public static SecureRandom getRandomNumberGenerator(String algorithm) {
        SecureRandom ins = randRef.get();
        if (ins == null) {
            try {
                ins = SecureRandom.getInstance(algorithm);
                randRef.set(ins);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new Encryptor.InvalidAlgorithmException(algorithm);
            }
        }
        return ins;
    }

    public static SecureRandom getRandomNumberGenerator(String algorithm, int seed) {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Encryptor.InvalidAlgorithmException(algorithm);
        }
        random.setSeed(seed);
        randRef.set(random);
        return random;
    }
}

