/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.bootstrap.AppServerUtils;
import coldfusion.runtime.RealPathCache;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import coldfusion.thread.ThreadScope;
import coldfusion.util.Utils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;

public class ServletContextWrapper
implements ServletContext {
    private ServletContext context;

    public ServletContextWrapper(ServletContext c) {
        this.context = c;
    }

    public Object getAttribute(String s) {
        return this.context.getAttribute(s);
    }

    public Enumeration getAttributeNames() {
        return this.context.getAttributeNames();
    }

    public ServletContext getContext(String s) {
        return this.context.getContext(s);
    }

    public String getInitParameter(String s) {
        return this.context.getInitParameter(s);
    }

    public Enumeration getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public String getMimeType(String s) {
        return this.context.getMimeType(s);
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        return this.context.getNamedDispatcher(s);
    }

    public String getRealPath(final String uriPath) {
        if (System.getSecurityManager() != null) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ServletContextWrapper.this._doGetRealPath(uriPath);
                }
            });
        }
        return this._doGetRealPath(uriPath);
    }

    private String _doGetRealPath(String uriPath) {
        ThreadScope threadScope = ThreadScope.getCurrent();
        WebSocketService websocketService = ServiceFactory.getWebsocketService();
        Object webSocketContext = null;
        if (websocketService != null) {
            webSocketContext = websocketService.getWSThreadContext();
        }
        if (threadScope == null && webSocketContext == null || uriPath.startsWith("/WEB-INF/") || uriPath.equals("/WEB-INF")) {
            return this.doGetRealPath(uriPath);
        }
        Object path = null;
        if (threadScope != null) {
            if (uriPath.startsWith("/")) {
                uriPath = uriPath.substring(1);
                path = threadScope.getWebRootPath() + uriPath;
            } else {
                path = threadScope.getBaseTemplatePath() + uriPath;
            }
        } else if (webSocketContext != null) {
            if (uriPath.startsWith("/")) {
                uriPath = uriPath.substring(1);
                path = websocketService.getWebRootPath(webSocketContext) + uriPath;
            } else {
                path = websocketService.getBaseTemplatePath(webSocketContext) + uriPath;
            }
        }
        if (File.separatorChar == '\\') {
            path = ((String)path).replace('/', '\\');
        }
        return path;
    }

    private String doGetRealPath(String uriPath) {
        String path;
        block8: {
            path = null;
            if (AppServerUtils.getAppServerType() == 3 && AppServerUtils.getAppServerVersion() == 8) {
                try {
                    URL url = this.getResource(uriPath);
                    if (url == null) break block8;
                    path = url.getFile();
                    if (File.separatorChar == '\\') {
                        path = path.replace('/', '\\');
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            } else if ((AppServerUtils.getAppServerType() == 1 || AppServerUtils.getAppServerType() == 5) && "/".equals(uriPath)) {
                path = RealPathCache.getRealPath(this.context, uriPath);
            } else {
                path = RealPathCache.getRealPath(this.context, uriPath);
                if (AppServerUtils.getAppServerType() != 1 && AppServerUtils.getAppServerType() != 5) {
                    path = Utils.getCanonicalPath(path);
                }
            }
        }
        return path;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.context.getRequestDispatcher(s);
    }

    public URL getResource(String s) throws MalformedURLException {
        URL u = this.context.getResource(s);
        return u;
    }

    public InputStream getResourceAsStream(String s) {
        InputStream in = this.context.getResourceAsStream(s);
        return in;
    }

    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    public void log(Exception exception, String s) {
        this.context.log(s, (Throwable)exception);
    }

    public void log(String s) {
        this.context.log(s);
    }

    public void log(String s, Throwable throwable) {
        this.context.log(s, throwable);
    }

    public void removeAttribute(String s) {
        this.context.removeAttribute(s);
    }

    public void setAttribute(String s, Object obj) {
        this.context.setAttribute(s, obj);
    }

    public Set getResourcePaths(String s) {
        return this.context.getResourcePaths(s);
    }

    public String getServletContextName() {
        return this.context.getServletContextName();
    }

    public String getContextPath() {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String arg0, String arg1) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String arg0, Filter arg1) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String arg0, Class<? extends Filter> arg1) {
        return null;
    }

    public void addListener(String arg0) {
    }

    public <T extends EventListener> void addListener(T arg0) {
    }

    public void addListener(Class<? extends EventListener> arg0) {
    }

    public ServletRegistration.Dynamic addServlet(String arg0, String arg1) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String arg0, Servlet arg1) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String arg0, Class<? extends Servlet> arg1) {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> arg0) throws ServletException {
        return null;
    }

    public <T extends EventListener> T createListener(Class<T> arg0) throws ServletException {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> arg0) throws ServletException {
        return null;
    }

    public void declareRoles(String ... arg0) {
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public int getEffectiveMajorVersion() {
        return 0;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public FilterRegistration getFilterRegistration(String arg0) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ServletRegistration getServletRegistration(String arg0) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public String getVirtualServerName() {
        return null;
    }

    public boolean setInitParameter(String arg0, String arg1) {
        return false;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> arg0) {
    }

    public ServletRegistration.Dynamic addJspFile(String jspName, String jspFile) {
        return null;
    }

    public int getSessionTimeout() {
        return -1;
    }

    public void setSessionTimeout(int sessionTimeout) {
    }

    public String getRequestCharacterEncoding() {
        return null;
    }

    public void setRequestCharacterEncoding(String encoding) {
    }

    public String getResponseCharacterEncoding() {
        return null;
    }

    public void setResponseCharacterEncoding(String encoding) {
    }
}

