/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.AppEventInvoker;
import coldfusion.runtime.AppSessionCollection;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.EventHandlerException;
import coldfusion.runtime.EventSessionScope;
import coldfusion.runtime.J2eeSessionScope;
import coldfusion.runtime.J2eeSessionScopeStub;
import coldfusion.runtime.MemorySessionScope;
import coldfusion.runtime.NoNameJ2eeSessionScope;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SessionKeyObject;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.session.InMemorySessionStorage;
import coldfusion.runtime.session.SessionEndEventInvoker;
import coldfusion.runtime.session.SessionStorage;
import coldfusion.security.SecurityUtils;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import com.google.common.collect.Sets;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SessionTracker {
    private static final String CFADMIN_APPLICATION = "cfadmin";
    private static final String CFTOKEN = "cftoken";
    private static final String CFID = "cfid";
    private static final String SESSIONID = "sessionid";
    private static final String URLTOKEN = "urltoken";
    private static final String EQUAL = "=";
    private static final String AMP = "&";
    private static final char UNDERSCORE = '_';
    private static SessionCleanUpAgent mSessionCleanUpAgent;
    private static SchedulerService mScheduler;
    public static int mSweepInterval;
    private static SessionStorage sessionStorage;
    public static boolean isExternalSessionStorage;
    private static InMemorySessionStorage cfAdminSessionStorage;

    static void initSessionStorage(SessionStorage sessionStorage) {
        SessionTracker.sessionStorage = sessionStorage;
        isExternalSessionStorage = !(sessionStorage instanceof InMemorySessionStorage);
        cfAdminSessionStorage = isExternalSessionStorage ? new InMemorySessionStorage() : null;
        mSessionCleanUpAgent = new SessionCleanUpAgent();
        mScheduler = ServiceFactory.getSchedulerService();
        String cleanUpInterval = System.getProperty("sessionCleanUpInterval");
        if (cleanUpInterval != null) {
            mSweepInterval = Integer.parseInt(cleanUpInterval);
        }
        mScheduler.schedule(mSessionCleanUpAgent, System.currentTimeMillis() + (long)mSweepInterval);
    }

    public static final String getSessionKey(String cfid, String cftoken) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(cfid);
        buffer.append('_');
        buffer.append(cftoken);
        return buffer.toString();
    }

    protected static final String getSessionTrackerId(String appName, String cfid, String cftoken) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(appName);
        buffer.append('_');
        buffer.append(cfid);
        buffer.append('_');
        buffer.append(cftoken);
        return buffer.toString();
    }

    protected static final String getSessionTrackerId(String appName, String sessionid) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(appName);
        buffer.append('_');
        buffer.append(sessionid);
        return buffer.toString();
    }

    public static SessionScope getSession(String appName, String cfid, String cftoken) {
        String key = SessionTracker.getSessionKey(cfid, cftoken);
        SessionScope retval = SessionTracker.getSessionScope(appName, key);
        if (retval != null) {
            retval.setIsNew(false);
        }
        return retval;
    }

    public static SessionScope createSession(String appName, String cfid, String cftoken) {
        String trackerId = SessionTracker.getSessionTrackerId(appName, cfid, cftoken);
        MemorySessionScope s = new MemorySessionScope(appName);
        s.setTrackerSessionId(trackerId);
        s.setIsNew(true);
        return s;
    }

    public static SessionScope getSession(HttpSession session, String appName) {
        String key = session.getId();
        String trackerId = SessionTracker.getSessionTrackerId(appName, key);
        SessionScope sScope = SessionTracker.getSessionScope(appName, key);
        if (appName.length() != 0) {
            J2eeSessionScopeStub scopeStub = (J2eeSessionScopeStub)session.getAttribute(appName);
            if (scopeStub != null) {
                sScope = (SessionScope)scopeStub.getJ2eeSessionScope();
                ((J2eeSessionScope)sScope).setJ2eeSessionScopeStub(scopeStub);
                sScope.setTrackerSessionId(trackerId);
                ((J2eeSessionScope)sScope).setHttpServletSession(session);
                SessionTracker.setSessionScope(appName, key, sScope);
            }
        } else {
            sScope = new NoNameJ2eeSessionScope(session);
            sScope.setTrackerSessionId(trackerId);
            SessionTracker.setSessionScope(appName, key, sScope);
        }
        if (sScope != null) {
            sScope.setIsNew(false);
        }
        return sScope;
    }

    public static SessionScope createSession(HttpSession session, String appName) {
        SessionScope s = null;
        s = appName.length() != 0 ? new J2eeSessionScope(session, appName) : new NoNameJ2eeSessionScope(session);
        s.setIsNew(true);
        String key = session.getId();
        String trackerId = SessionTracker.getSessionTrackerId(appName, session.getId());
        s.setTrackerSessionId(trackerId);
        SessionTracker.setSessionScope(appName, key, s);
        return s;
    }

    public static SessionScope getSession(String appName, String sessionid) {
        SessionScope retval = SessionTracker.getSessionScope(appName, sessionid);
        if (retval != null) {
            retval.setIsNew(false);
        }
        return retval;
    }

    public static SessionScope createSession(String appName, String sessionid) {
        String trackerId = SessionTracker.getSessionTrackerId(appName, sessionid);
        EventSessionScope s = new EventSessionScope(appName);
        s.setIsNew(true);
        s.setSessionId(sessionid);
        s.setTrackerSessionId(trackerId);
        SessionTracker.setSessionScope(appName, sessionid, s);
        return s;
    }

    public static AppSessionCollection getSessionCollection(String appName) {
        return new AppSessionCollection(appName, SessionTracker.getAppSessions(appName));
    }

    private static void cleanUp() {
        List<SessionEndEventInvoker> endEvents = null;
        try {
            if (sessionStorage != null) {
                endEvents = sessionStorage.cleanUp();
            }
            if (cfAdminSessionStorage != null) {
                List<SessionEndEventInvoker> adminEndEvents = cfAdminSessionStorage.cleanUp();
                if (adminEndEvents != null && endEvents != null) {
                    endEvents.addAll(adminEndEvents);
                } else if (adminEndEvents != null && endEvents == null) {
                    endEvents = adminEndEvents;
                }
            }
        }
        finally {
            mScheduler.schedule(mSessionCleanUpAgent, System.currentTimeMillis() + (long)mSweepInterval);
        }
        if (endEvents != null) {
            for (SessionEndEventInvoker eArgs : endEvents) {
                SessionTracker.invokeOnSessinEnd(eArgs);
            }
        }
    }

    private static void invokeOnSessinEnd(SessionEndEventInvoker eArgs) {
        try {
            try {
                eArgs.invoker.onSessionEnd(new Object[]{eArgs.sessionScope, eArgs.appScope});
            }
            catch (EventHandlerException ex) {
                eArgs.invoker.onError(new Object[]{ex, ex.name});
            }
            catch (Throwable te) {
                eArgs.invoker.onError(new Object[]{te});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sessionInvalidate() {
        Scope s = (Scope)FusionContext.getCurrent().hiddenScope.get("SESSION");
        if (s == null || s != null && !(s instanceof SessionScope)) {
            CFLogs.APPLICATION_LOG.warn(RB.getString(SessionTracker.class, "NoSession"));
            throw new SecurityUtils.SessionManipulationException();
        }
        SessionScope session = (SessionScope)s;
        if (session != null) {
            String appName = session.getAppName();
            String trackerIdKey = session.getTrackerSessionId();
            String key = SessionTracker.getKeyPartFromTracker(appName, trackerIdKey);
            SessionTracker.cleanUp(appName, key, session);
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
            AppEventInvoker invoker = null;
            if (appScope != null && appScope instanceof ApplicationScope) {
                invoker = appScope.getEventInvoker();
            }
            if (session != null && invoker != null) {
                SessionTracker.invokeOnSessinEnd(new SessionEndEventInvoker(session, invoker, appScope));
            }
            session.mTable.clear();
        }
    }

    protected static void cleanUp(String appName, String cfid, String cftoken) {
        String key = SessionTracker.getSessionKey(cfid, cftoken);
        SessionTracker.cleanUpInternal(appName, key);
    }

    protected static void cleanUp(HttpSession httpSession, String appName) {
        String key = httpSession.getId();
        SessionTracker.cleanUpInternal(appName, key);
    }

    protected static void cleanUp(String appName, String sessionId) {
        String key = sessionId;
        SessionTracker.cleanUpInternal(appName, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUp(String appName, String key, SessionScope session) {
        String sessionId = session.getSessionId();
        session.CleanUp();
        SessionStorage sessionStorage = SessionTracker.getSessionStorage(appName);
        try {
            ConcurrentMap<String, Object> sessions = sessionStorage.getApplicationSessionMap(key);
            if (sessions != null) {
                ConcurrentMap<String, Object> concurrentMap = sessions;
                synchronized (concurrentMap) {
                    sessions.remove(appName);
                }
                if (sessions.isEmpty()) {
                    sessionStorage.remove(key, appName);
                }
            }
            if (sessionStorage.isMomoryTrackingSupported()) {
                sessionStorage.getSessionMemoryMonitor().onSessionExpired(appName, sessionId);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpInternal(String appName, String key) {
        block8: {
            SessionStorage sessionStorage = SessionTracker.getSessionStorage(appName);
            try {
                ConcurrentMap<String, Object> keySessions = sessionStorage.getApplicationSessionMap(key);
                if (keySessions == null) break block8;
                SessionScope session = (SessionScope)keySessions.get(appName);
                if (session != null) {
                    String sessionId = session.getSessionId();
                    session.CleanUp();
                    if (sessionStorage.isMomoryTrackingSupported()) {
                        sessionStorage.getSessionMemoryMonitor().onSessionExpired(appName, sessionId);
                    }
                }
                ConcurrentMap<String, Object> concurrentMap = keySessions;
                synchronized (concurrentMap) {
                    keySessions.remove(appName);
                }
                if (keySessions.isEmpty()) {
                    sessionStorage.remove(key, appName);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static void setSessionScope(String appName, String key, SessionScope s) {
        try {
            SessionTracker.getSessionStorage(appName).setSession(appName, key, s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static SessionScope getSessionScope(String appName, String key) {
        try {
            return SessionTracker.getSessionStorage(appName).getSession(appName, key);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static void updateSessionScope(String appName, String oldTrackerKey, String newTrackerKey, String m_cfid, String m_cftoken, SessionScope scopeObj) {
        String oldKeyPartFromTracker = SessionTracker.getKeyPartFromTracker(appName, oldTrackerKey);
        String newKeyPartFromTracker = SessionTracker.getKeyPartFromTracker(appName, newTrackerKey);
        SessionStorage sessionStorage = SessionTracker.getSessionStorage(appName);
        try {
            ConcurrentMap<String, Object> keySessions = sessionStorage.getApplicationSessionMap(oldKeyPartFromTracker);
            if (keySessions == null) {
                keySessions = new ConcurrentHashMap<String, Object>();
            }
            keySessions.put(appName, scopeObj);
            Set keys = keySessions.keySet();
            for (String key : keys) {
                Object urltoken;
                String oldsessid;
                Object scope = keySessions.get(key);
                if (scope == null || !(scope instanceof SessionScope)) continue;
                SessionScope s = (SessionScope)scope;
                s.setTrackerSessionId(s.getAppName() + "_" + newKeyPartFromTracker);
                String oldid = (String)s.get(CFID);
                String oldtoken = (String)s.get(CFTOKEN);
                if (oldid != null && oldtoken != null) {
                    s.put(CFID, m_cfid);
                    s.put(CFTOKEN, m_cftoken);
                }
                if ((oldsessid = (String)s.get(SESSIONID)) != null && oldsessid.contains(oldKeyPartFromTracker)) {
                    oldsessid = oldsessid.replace(oldKeyPartFromTracker, newKeyPartFromTracker);
                    s.put(SESSIONID, oldsessid);
                }
                if ((urltoken = (String)s.get(URLTOKEN)) != null) {
                    String[] tokens = ((String)urltoken).split(AMP, 3);
                    if (tokens != null && tokens[0] != null && tokens[1] != null) {
                        String[] idt = tokens[0].split(EQUAL);
                        idt[1] = m_cfid;
                        tokens[0] = idt[0] + EQUAL + idt[1];
                        String[] tokt = tokens[1].split(EQUAL);
                        tokt[1] = m_cftoken;
                        tokens[1] = tokt[0] + EQUAL + tokt[1];
                        urltoken = tokens[0] + AMP + tokens[1];
                        if (tokens.length > 2 && tokens[2] != null && tokens[2].length() > 0) {
                            urltoken = (String)urltoken + AMP + tokens[2];
                        }
                    }
                    s.put(URLTOKEN, urltoken);
                }
                keySessions.put(s.getAppName(), s);
            }
            sessionStorage.remove(oldKeyPartFromTracker, appName);
            sessionStorage.setAppSession(newKeyPartFromTracker, keySessions);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getKeyPartFromTracker(String appName, String trackerId) {
        String prefix = appName + "_";
        return trackerId.substring(prefix.length());
    }

    public static String extractSessionId(String appName, String sessionId) {
        String appNamelowerString;
        String sessionIdLowerCase = sessionId.toLowerCase();
        if (appName == null) {
            appName = "";
        }
        if (sessionIdLowerCase.startsWith((appNamelowerString = appName.toLowerCase()) + "_")) {
            sessionId = SessionTracker.getKeyPartFromTracker(appName, sessionId);
        }
        return sessionId;
    }

    protected static final boolean sessionExists(String m_ApplicationName, String m_cfid, String m_cftoken) {
        if (cfAdminSessionStorage != null && CFADMIN_APPLICATION.equalsIgnoreCase(m_ApplicationName)) {
            return cfAdminSessionStorage.sessionExists(m_cfid, m_cftoken);
        }
        return sessionStorage.sessionExists(m_cfid, m_cftoken);
    }

    private static ConcurrentMap<String, Object> getAppSessions(String appName) {
        try {
            ConcurrentMap<String, Object> sessionMap = SessionTracker.getSessionStorage(appName).getAppSessions(appName);
            if (sessionMap != null) {
                return sessionMap;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ConcurrentHashMap<String, Object>();
    }

    public static Iterator<String> getSessionKeys() {
        Set<String> sessionKeys = sessionStorage.getSessionKeys();
        if (cfAdminSessionStorage != null) {
            Set<String> cfAdminSessionKeys = cfAdminSessionStorage.getSessionKeys();
            if (sessionKeys != null && cfAdminSessionKeys != null) {
                return Sets.union(cfAdminSessionKeys, sessionKeys).iterator();
            }
            if (sessionKeys == null && cfAdminSessionKeys != null) {
                return cfAdminSessionKeys.iterator();
            }
        }
        if (sessionKeys != null) {
            return sessionKeys.iterator();
        }
        return null;
    }

    public static void updateLastAccess(SessionScope session) throws IOException {
        SessionTracker.getSessionStorage(session).updateLastAccess(session);
    }

    public static ConcurrentMap<String, Object> getAppSessionMap(String key) {
        try {
            ConcurrentMap<String, Object> applicationSessionMap = sessionStorage.getApplicationSessionMap(key);
            if (cfAdminSessionStorage != null) {
                ConcurrentMap<String, Object> adminAppSessionMap = cfAdminSessionStorage.getApplicationSessionMap(key);
                if (adminAppSessionMap != null && adminAppSessionMap.size() > 0 && applicationSessionMap != null && applicationSessionMap.size() > 0) {
                    ConcurrentHashMap<String, Object> allSessions = new ConcurrentHashMap<String, Object>(applicationSessionMap);
                    allSessions.putAll(adminAppSessionMap);
                    return allSessions;
                }
                if (adminAppSessionMap != null && adminAppSessionMap.size() > 0 && (applicationSessionMap == null || applicationSessionMap.size() == 0)) {
                    return adminAppSessionMap;
                }
            }
            return applicationSessionMap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Iterator<SessionKeyObject> getSessionKeyObjects() {
        Set<SessionKeyObject> sessionKeyObjects = sessionStorage.getSessionKeyObjects();
        if (sessionKeyObjects == null) {
            sessionKeyObjects = new HashSet<SessionKeyObject>();
        }
        Set<SessionKeyObject> cfAdminSessionKeyObjects = null;
        if (cfAdminSessionStorage != null && (cfAdminSessionKeyObjects = cfAdminSessionStorage.getSessionKeyObjects()) != null) {
            sessionKeyObjects.addAll(cfAdminSessionKeyObjects);
        }
        return sessionKeyObjects.iterator();
    }

    public static int getSessionCount() {
        try {
            return (sessionStorage != null ? sessionStorage.getSessionCount() : 0) + (cfAdminSessionStorage != null ? cfAdminSessionStorage.getSessionCount() : 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getActiveSessionCount(String appName) {
        try {
            return SessionTracker.getSessionStorage(appName).getActiveSessionCount(appName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getExpiredSessionCount() {
        try {
            if (sessionStorage != null) {
                return sessionStorage.getExpiredSessionCount();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void clearExpiredSessionCount() {
        if (sessionStorage != null) {
            sessionStorage.clearExpiredSessionCount();
        }
    }

    public static void store(SessionScope currentSession) throws IOException {
        if (currentSession != null) {
            SessionTracker.getSessionStorage(currentSession).updateLastAccess(currentSession);
        }
    }

    private static SessionStorage getSessionStorage(SessionScope session) {
        return SessionTracker.getSessionStorage(session.getAppName());
    }

    private static SessionStorage getSessionStorage(String appName) {
        if (cfAdminSessionStorage != null && CFADMIN_APPLICATION.equalsIgnoreCase(appName)) {
            return cfAdminSessionStorage;
        }
        return sessionStorage;
    }

    static {
        mSweepInterval = 10000;
    }

    static final class SessionCleanUpAgent
    implements Runnable {
        @Override
        public void run() {
            SessionTracker.cleanUp();
        }
    }

    static class EndEventArgs {
        SessionScope sessionScope;
        AppEventInvoker invoker;
        Scope appScope;

        EndEventArgs(SessionScope s, AppEventInvoker i, Scope p) {
            this.sessionScope = s;
            this.invoker = i;
            this.appScope = p;
        }
    }
}

