/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.compiler.AccessModifier;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.Variable;
import coldfusion.util.Key;
import java.io.Serializable;

public class StaticScope
extends LocalScope
implements Serializable {
    String pagePath;
    StaticScope parent;

    public void setParent(StaticScope par) {
        this.parent = par;
    }

    public StaticScope getContainer(String key) {
        StaticScope scope;
        Object ret = super.get(key);
        if (ret == null && this.parent != null && (scope = this.parent.getContainer(key)) != null) {
            return scope;
        }
        return ret == null ? null : this;
    }

    public Container getStaticContainer(Object key) {
        Key keyObj = key instanceof Key ? (Key)key : Key.getInstance(key.toString());
        Variable ret = super.findVariable(keyObj);
        Container cont = new Container(ret, this);
        boolean inParent = false;
        if ((ret == null || ret.getValue() == null) && this.parent != null) {
            cont = this.parent.getStaticContainer(keyObj);
            inParent = true;
        }
        this.checkVariablePrivateAccess(ret, inParent);
        return cont;
    }

    @Override
    public Object get(Object key) {
        Key keyObj = key instanceof Key ? (Key)key : Key.getInstance(key.toString());
        Variable var = this.findVariable(keyObj);
        return var != null ? var.value : null;
    }

    public Object getStrictVar(Object key) {
        Object ret = super.getVar(key);
        return ret;
    }

    public Object getUDF(Object key) {
        Object ret = super.get(key);
        if (ret != null && !(ret instanceof UDFMethod) || ret == null && this.parent != null) {
            return this.parent.get(key);
        }
        return ret;
    }

    @Override
    public Object getVar(Object key) {
        Variable ret = (Variable)super.getVar(key);
        boolean inParent = false;
        if (ret == null && this.parent != null) {
            ret = (Variable)this.parent.getVar(key);
            inParent = true;
        }
        this.checkVariablePrivateAccess(ret, inParent);
        return ret;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean ret = super.containsKey(key);
        if (!ret && this.parent != null) {
            return this.parent.containsKey(key);
        }
        return ret;
    }

    @Override
    protected Variable findVariable(String key) {
        Variable ret = super.findVariable(key);
        boolean inParent = false;
        if ((ret == null || ret.getValue() == null) && this.parent != null) {
            ret = this.parent.findVariable(key);
            inParent = true;
        }
        this.checkVariablePrivateAccess(ret, inParent);
        return ret;
    }

    private void checkVariablePrivateAccess(Variable ret, boolean inParent) {
        if (ret != null && AccessModifier.isPrivate(ret.getAccessModifier()) && inParent) {
            throw new PrivateVariableAccessException(ret.getKey().toString());
        }
    }

    @Override
    protected Variable findVariable(Key keyObj) {
        Variable ret = super.findVariable(keyObj);
        boolean inParent = false;
        if ((ret == null || ret.getValue() == null) && this.parent != null) {
            ret = this.parent.findVariable(keyObj);
            inParent = true;
        }
        this.checkVariablePrivateAccess(ret, inParent);
        return ret;
    }

    public StaticScope deepClone() {
        StaticScope s = new StaticScope();
        s.cloneScope(this);
        return s;
    }

    @Override
    public void clear() {
        super.clear();
    }

    protected void setPagePath(String pagePath) {
        this.pagePath = pagePath;
    }

    protected String getPagePath() {
        return this.pagePath;
    }

    class Container {
        Variable variable;
        StaticScope scope;

        Container(Variable var, StaticScope scope) {
            this.variable = var;
            this.scope = scope;
        }
    }

    public static class PrivateVariableAccessException
    extends ApplicationException {
        public String variable;

        PrivateVariableAccessException(String variable) {
            this.variable = variable;
        }
    }

    public static class InvalidPackageVariableAccessException
    extends ApplicationException {
        public String variable;
        public String templatePath;

        InvalidPackageVariableAccessException(String variable, String templatePath) {
            this.variable = variable;
            this.templatePath = templatePath;
        }
    }

    public static class InvalidPrivateVariableAccessException
    extends ApplicationException {
        public String variable;
        public String templatePath;

        InvalidPrivateVariableAccessException(String variable, String templatePath) {
            this.variable = variable;
            this.templatePath = templatePath;
        }
    }

    public static class InvalidRemoteAccessException
    extends ApplicationException {
        public String variable;
        public String templatePath;

        InvalidRemoteAccessException(String variable, String templatePath) {
            this.variable = variable;
            this.templatePath = templatePath;
        }
    }
}

