/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.IntegerOutOfBoundsException;
import coldfusion.runtime.InvalidFunctionArgException;
import coldfusion.runtime.InvalidFunctionArgValueEmptyException;
import coldfusion.runtime.InvalidFunctionArgValueException;
import coldfusion.runtime.ListFunc;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.UDFMethodSubstitution;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import coldfusion.util.RuntimeWrapper;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public final class StringFunc {
    private static final String[] dayOfWeek = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String spaces = "                                     ";
    private static final ConcurrentMap<String, Pattern> patterns = new ConcurrentHashMap<String, Pattern>();
    private static final ConcurrentMap<String, java.util.regex.Pattern> patternsJava = new ConcurrentHashMap<String, java.util.regex.Pattern>();
    private static final String EOL = System.getProperty("line.separator");
    static Pattern escPattern;
    static Pattern backrefPattern;
    static java.util.regex.Pattern escPatternJava;
    static final String escSubstitution = "$1\\\\";
    static final String backrefSubstitution = "$1\\$";
    private static final java.util.regex.Pattern ESCAPE_REGEX_PATTERN;

    public static String Cjustify(String str, int flen) {
        int i;
        if (flen <= 0) {
            throw new InvalidFunctionArgException("CJustify", 2, flen, "positive integer");
        }
        int strlen = str.length();
        if (strlen >= flen) {
            return str;
        }
        int fstart = (flen - strlen) / 2;
        char[] s = new char[flen];
        for (i = 0; i < flen; ++i) {
            s[i] = 32;
        }
        for (i = 0; i < strlen; ++i) {
            s[i + fstart] = str.charAt(i);
        }
        return new String(s);
    }

    public static String Ljustify(String str, int flen) {
        if (flen <= 0) {
            throw new InvalidFunctionArgException("LJustify", 2, flen, "positive integer");
        }
        int strlen = str.length();
        if (strlen >= flen) {
            return str;
        }
        StringBuilder out = new StringBuilder(flen);
        out.append(str);
        do {
            int remain;
            if ((remain = flen - out.length()) > spaces.length()) {
                out.append(spaces);
                continue;
            }
            out.append(spaces.substring(0, remain));
        } while (out.length() < flen);
        return out.toString();
    }

    public static String Rjustify(String str, int flen) {
        int strlen = str.length();
        if (flen <= 0) {
            throw new InvalidFunctionArgException("RJustify", 2, flen, "positive integer");
        }
        if (strlen >= flen) {
            return str;
        }
        StringBuilder out = new StringBuilder(flen);
        do {
            int remain;
            if ((remain = flen - strlen - out.length()) > spaces.length()) {
                out.append(spaces);
                continue;
            }
            out.append(spaces.substring(0, remain));
        } while (out.length() < flen - strlen);
        out.append(str);
        return out.toString();
    }

    public static int compare(String s1, String s2, boolean nocase) {
        int i;
        int n = i = nocase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
        if (i == 0) {
            return 0;
        }
        if (i < 0) {
            return -1;
        }
        return 1;
    }

    public static String DayOfWeekAsString(int num) {
        if (num < 1 || num > 7) {
            return "Invalid DayOfWeek";
        }
        return dayOfWeek[num - 1];
    }

    public static int Find(String sub, String str, int start) {
        if (sub.length() == 0) {
            return start;
        }
        return str.indexOf(sub, start - 1) + 1;
    }

    public static int FindNoCase(String sub, String str, int start) {
        String y;
        if (sub.length() == 0) {
            return start;
        }
        String x = str.toLowerCase();
        int subLen = sub.length();
        int strLen = str.length();
        if (x.length() == strLen && (y = sub.toLowerCase()).length() == subLen) {
            int idx = x.indexOf(y, start - 1);
            return idx + 1;
        }
        int i = start - 1;
        while (i + subLen <= strLen) {
            if (str.substring(i, i + subLen).equalsIgnoreCase(sub)) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    public static int FindOneOf(String set, String str, int start) {
        char ch;
        int idx;
        int length = set.length();
        if (length == 0) {
            return 0;
        }
        int startpos = start - 1;
        int min = str.length();
        for (int i = 0; i < length && ((idx = str.indexOf(ch = set.charAt(i), startpos)) >= min || idx == -1 || (min = idx) != startpos); ++i) {
        }
        return min < str.length() ? min + 1 : 0;
    }

    public static String GetToken(String str, int index, String delimiter) {
        if (index <= 0) {
            throw new InvalidFunctionArgException("GetToken", 2, index, "positive integer");
        }
        StringTokenizer t = new StringTokenizer(str, delimiter);
        int tokenCount = t.countTokens();
        if (tokenCount < index || index < 1) {
            return "";
        }
        for (int i = index - 1; i > 0; --i) {
            t.nextToken();
        }
        return t.nextToken();
    }

    public static String Insert(String sub, String str, int pos) {
        if (pos < 0) {
            throw new InsertParamsNegativeIndexException();
        }
        int p = pos - 1;
        if (p == -1) {
            return sub + str;
        }
        if (p > str.length() - 1) {
            throw new InsertParamsException(str, pos);
        }
        if (p == str.length() - 1) {
            return str + sub;
        }
        return str.substring(0, p + 1) + sub + str.substring(p + 1);
    }

    public static String LTrim(String s) {
        char ch;
        int i;
        if (s.length() == 0) {
            return "";
        }
        int length = s.length();
        for (i = 0; i < length && ((ch = s.charAt(i)) == ' ' || ch == '\t' || ch == '\r' || ch == '\n'); ++i) {
        }
        return s.substring(i);
    }

    public static String RTrim(String s) {
        char ch;
        int i;
        if (s.length() == 0) {
            return "";
        }
        for (i = s.length() - 1; i >= 0 && ((ch = s.charAt(i)) == ' ' || ch == '\t' || ch == '\r' || ch == '\n'); --i) {
        }
        return s.substring(0, i + 1);
    }

    public static String RemoveChars(String str, int start, int count) {
        if (start < 1) {
            throw new InvalidFunctionArgException("RemoveChars", 2, start, "positive integer");
        }
        if (count < 0) {
            throw new InvalidFunctionArgException("RemoveChars", 3, count, "non-negative integer");
        }
        if (start > str.length()) {
            throw new RemoveCharsParamsException(str, start);
        }
        int p = start - 1;
        int c = count - 1;
        Object retstr = p < 0 || p >= str.length() ? str : (p + c >= str.length() ? str.substring(0, p) : str.substring(0, p) + str.substring(p + c + 1));
        return retstr;
    }

    public static String RepeatString(String str, int count) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new InvalidFunctionArgException("RepeatString", 2, count, "non-negative integer");
        }
        StringBuilder finalstr = new StringBuilder(count * str.length());
        for (int i = 0; i < count; ++i) {
            finalstr.append(str);
        }
        return finalstr.toString();
    }

    public static String Replace(String input_orig, String search_orig, Object strOrCallbackUDF, String scope, boolean casesensitive) {
        String search;
        String input;
        int searchlength = search_orig.length();
        boolean isCallBackDefined = false;
        String replace = null;
        if (strOrCallbackUDF instanceof UDFMethod) {
            isCallBackDefined = true;
        } else {
            replace = Cast._String(strOrCallbackUDF);
        }
        if (searchlength == 0) {
            return input_orig;
        }
        if (casesensitive) {
            input = input_orig;
            search = search_orig;
        } else {
            input = StringFunc.converToUpper(input_orig);
            search = StringFunc.converToUpper(search_orig);
        }
        int index = input.indexOf(search);
        if (index == -1) {
            return input_orig;
        }
        StringBuilder output = new StringBuilder(input.length());
        int lastindex = 0;
        if (scope.equalsIgnoreCase("ALL")) {
            int count = 1;
            while (index != -1) {
                if (isCallBackDefined) {
                    replace = StringFunc.invokeCallback_replace((UDFMethod)strOrCallbackUDF, new Object[]{search, index, input_orig, count++});
                }
                output.append(input_orig.substring(lastindex, index)).append(replace);
                lastindex = index + searchlength;
                index = input.indexOf(search, lastindex);
            }
        } else {
            if (isCallBackDefined) {
                replace = StringFunc.invokeCallback_replace((UDFMethod)strOrCallbackUDF, new Object[]{search, index, input_orig, 1});
            }
            output.append(input_orig.substring(0, index)).append(replace);
            lastindex = index + searchlength;
        }
        if (lastindex < input.length()) {
            output.append(input_orig.substring(lastindex));
        }
        return output.toString();
    }

    private static String converToUpper(String orig) {
        char[] carraySearchOrig = orig.toCharArray();
        for (int i = 0; i < carraySearchOrig.length; ++i) {
            carraySearchOrig[i] = Character.toUpperCase(carraySearchOrig[i]);
        }
        return new String(carraySearchOrig);
    }

    private static String invokeCallback_replace(UDFMethod callBackFunc, Object[] params) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        try {
            Object retVal = CFPage._invokeUDF((Object)callBackFunc, callBackFunc.getName(), cfpage, params);
            return retVal.toString();
        }
        catch (Throwable throwable) {
            throw new RuntimeWrapper(throwable);
        }
    }

    public static String Replace(String input, String search, String replace, String scope) {
        return StringFunc.Replace(input, search, (Object)replace, scope, true);
    }

    public static String ReplaceNoCase(String input, String search, String replace, String scope) {
        return StringFunc.Replace(input, search, (Object)replace, scope, false);
    }

    public static String Replace(String input, String search, Object strOrCallbackUDF, String scope, int start) {
        if (start < 1 || start > input.length()) {
            throw new IllegalArgumentException(RB.getString(CFPage.class, "CFPage.replace.start", start));
        }
        String result = StringFunc.Replace(input.substring(start - 1), search, strOrCallbackUDF, scope, true);
        if (start == 1) {
            return result;
        }
        return input.substring(0, start - 1) + result;
    }

    public static String ReplaceNoCase(String input, String search, Object strOrCallbackUDF, String scope, int start) {
        if (start < 1 || start > input.length()) {
            throw new IllegalArgumentException(RB.getString(CFPage.class, "CFPage.replace.start", start));
        }
        String result = StringFunc.Replace(input.substring(start - 1), search, strOrCallbackUDF, scope, false);
        if (start == 1) {
            return result;
        }
        return input.substring(0, start - 1) + result;
    }

    public static String ReplaceList(String s, String s1s, String s2s, String s1sDelim, String s2sDelim, boolean includeEmptyFields, boolean casesensitive) {
        String s1sEscapedDelim = ListFunc.escapeDelim(s1sDelim, false);
        String s2sEscapedDelim = ListFunc.escapeDelim(s2sDelim, false);
        String[] tokens1 = s1s.split(s1sEscapedDelim, -1);
        String[] tokens2 = s2s.split(s2sEscapedDelim, -1);
        int i = 0;
        int j = 0;
        while (i < tokens1.length) {
            String t;
            String r = tokens1[i];
            if ("".equals(r)) {
                ++i;
                continue;
            }
            if (j < tokens2.length) {
                t = tokens2[j];
            } else {
                t = "";
                includeEmptyFields = true;
            }
            if (!includeEmptyFields && "".equals(t)) {
                ++j;
                continue;
            }
            ++i;
            ++j;
            if (casesensitive) {
                s = StringFunc.Replace(s, r, t, "ALL");
                continue;
            }
            s = StringFunc.ReplaceNoCase(s, r, t, "ALL");
        }
        return s;
    }

    public static String Wrap(String str, int limit, boolean strip) {
        if (str == null || str.length() < limit || limit <= 0) {
            return str;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder(length + (length / limit + 10) * EOL.length());
        if (strip) {
            str = str.replace('\r', ' ');
            str = str.replace('\n', ' ');
        }
        int start = 0;
        boolean backtrack = false;
        while (start < str.length()) {
            int end = start + limit;
            if (end > str.length()) {
                end = str.length();
            }
            while (end > 0 && end < str.length() && !Character.isWhitespace(str.charAt(end))) {
                --end;
            }
            backtrack = false;
            if (end <= start) {
                end = start + limit;
                backtrack = true;
            }
            sb.append(str.substring(start, end).trim());
            sb.append(EOL);
            if (backtrack) {
                start = end;
                continue;
            }
            start = end + 1;
        }
        return sb.toString();
    }

    public static String SpanExcluding(String str, String set) {
        StringTokenizer t = new StringTokenizer(str, set);
        if (t.hasMoreTokens()) {
            String token = t.nextToken();
            int idx = str.indexOf(token);
            if (idx != 0) {
                return "";
            }
            return token;
        }
        return "";
    }

    public static String SpanIncluding(String str, String set) {
        int i;
        int len = str.length();
        for (i = 0; i < len && set.indexOf(str.charAt(i)) != -1; ++i) {
        }
        if (i == len) {
            return str;
        }
        if (i > 0) {
            return str.substring(0, i);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Object _REFind(String regexpr, String str, int start, boolean returnsub, String scope, boolean casesensitive) {
        Pattern pattern = StringFunc.getPattern(regexpr, casesensitive);
        if (start < 1) {
            start = 1;
        }
        PatternMatcherInput input = new PatternMatcherInput(str);
        if (start <= str.length()) {
            input.setCurrentOffset(start - 1);
        }
        Array returnVal = new Array(1);
        Perl5Matcher matcher = new Perl5Matcher();
        if (start <= str.length() && matcher.contains(input, pattern)) {
            MatchResult result = matcher.getMatch();
            if (scope.equalsIgnoreCase("ONE")) {
                if (!returnsub) return new Integer(result.beginOffset(0) + 1);
                return StringFunc.parseREFindResult(result, returnsub);
            }
            if (!scope.equalsIgnoreCase("ALL")) {
                if (!casesensitive) throw new InvalidFunctionArgValueException("scope", "REFindNoCase", scope, "ONE, ALL");
                throw new InvalidFunctionArgValueException("scope", "REFind", scope, "ONE, ALL");
            }
            if (returnsub) {
                returnVal.add(StringFunc.parseREFindResult(result, returnsub));
                while (matcher.contains(input, pattern)) {
                    result = matcher.getMatch();
                    returnVal.add(StringFunc.parseREFindResult(result, returnsub));
                }
                return returnVal;
            }
            returnVal.add(new Integer(result.beginOffset(0) + 1));
            while (matcher.contains(input, pattern)) {
                result = matcher.getMatch();
                returnVal.add(new Integer(result.beginOffset(0) + 1));
            }
            return returnVal;
        }
        if (!returnsub) return new Integer(0);
        Struct subexp = new Struct();
        Array match = new Array();
        match.addElement("");
        subexp.put("MATCH", (Object)match);
        Array a = new Array();
        a.addElement(new Integer(0));
        subexp.put("POS", (Object)a);
        subexp.put("LEN", a.clone());
        if (scope.equalsIgnoreCase("ONE")) {
            return subexp;
        }
        returnVal.add(subexp);
        return returnVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Object _REFindJava(String regexpr, String str, int start, boolean returnsub, String scope, boolean casesensitive) {
        java.util.regex.Pattern pattern = StringFunc.getPatternJava(regexpr, casesensitive);
        if (start < 1) {
            start = 1;
        }
        Matcher matcher = pattern.matcher(str);
        int stringLen = str.length();
        if (start <= stringLen) {
            matcher = matcher.region(start - 1 >= 0 ? start - 1 : 1, stringLen);
        }
        Array returnVal = new Array(1);
        if (start <= stringLen && matcher.find()) {
            if (scope.equalsIgnoreCase("ONE")) {
                if (!returnsub) return new Integer(matcher.start(0) + 1);
                return StringFunc.parseREFindResultJava(matcher, returnsub);
            }
            if (!scope.equalsIgnoreCase("ALL")) {
                if (!casesensitive) throw new InvalidFunctionArgValueException("scope", "REFindNoCase", scope, "ONE, ALL");
                throw new InvalidFunctionArgValueException("scope", "REFind", scope, "ONE, ALL");
            }
            if (returnsub) {
                returnVal.add(StringFunc.parseREFindResultJava(matcher, returnsub));
                while (matcher.find()) {
                    returnVal.add(StringFunc.parseREFindResultJava(matcher, returnsub));
                }
                return returnVal;
            }
            returnVal.add(new Integer(matcher.start(0) + 1));
            while (matcher.find()) {
                returnVal.add(new Integer(matcher.start(0) + 1));
            }
            return returnVal;
        }
        if (!returnsub) return new Integer(0);
        Struct subexp = new Struct();
        Array match = new Array();
        match.addElement("");
        subexp.put("MATCH", (Object)match);
        Array a = new Array();
        a.addElement(new Integer(0));
        subexp.put("POS", (Object)a);
        subexp.put("LEN", a.clone());
        if (scope.equalsIgnoreCase("ONE")) {
            return subexp;
        }
        returnVal.add(subexp);
        return returnVal;
    }

    public static Object REFind(String regexpr, String str, int start, boolean returnsub, String scope, boolean casesensitive) {
        boolean useJavaRegexEngine = ServiceFactory.getRuntimeService().isJavaRegexEngineEnabled();
        if (!useJavaRegexEngine) {
            return StringFunc._REFind(regexpr, str, start, returnsub, scope, casesensitive);
        }
        return StringFunc._REFindJava(regexpr, str, start, returnsub, scope, casesensitive);
    }

    static Struct parseREFindResult(MatchResult result, boolean returnsub) {
        Struct subexp = new Struct();
        if (returnsub) {
            int groups = result.groups();
            ArrayList<String> match = new ArrayList<String>(10);
            ArrayList<Integer> pos = new ArrayList<Integer>(10);
            ArrayList<Integer> len = new ArrayList<Integer>(10);
            for (int i = 0; i < groups; ++i) {
                int beginOffset = result.beginOffset(i);
                match.add(result.group(i));
                pos.add(beginOffset + 1);
                len.add(result.endOffset(i) - beginOffset);
            }
            subexp.put("MATCH", (Object)match);
            subexp.put("POS", (Object)pos);
            subexp.put("LEN", (Object)len);
        }
        return subexp;
    }

    private static Struct parseREFindResultJava(Matcher matcher, boolean returnsub) {
        Struct subexp = new Struct();
        if (returnsub) {
            int groups = matcher.groupCount();
            ArrayList<String> match = new ArrayList<String>(10);
            ArrayList<Integer> pos = new ArrayList<Integer>(10);
            ArrayList<Integer> len = new ArrayList<Integer>(10);
            int beginOffset = 0;
            for (int i = 0; i <= groups; ++i) {
                beginOffset = matcher.start(i);
                pos.add(beginOffset + 1);
                match.add(matcher.group(i));
                len.add(matcher.end(i) - beginOffset);
            }
            subexp.put("MATCH", (Object)match);
            subexp.put("POS", (Object)pos);
            subexp.put("LEN", (Object)len);
        }
        return subexp;
    }

    private static String _REReplace(String str, String regexpr, Object strOrCallBackFunc, String scope, boolean casesensitive) {
        int subs;
        if (regexpr.length() == 0) {
            throw new InvalidFunctionArgValueEmptyException("2", "REReplace");
        }
        Pattern pattern = StringFunc.getPattern(regexpr, casesensitive);
        if (scope.equalsIgnoreCase("ONE")) {
            subs = 1;
        } else if (scope.equalsIgnoreCase("ALL")) {
            subs = -1;
        } else {
            throw new InvalidFunctionArgValueException("scope", "REReplace", scope, "ONE, ALL");
        }
        if (strOrCallBackFunc instanceof UDFMethod) {
            return Util.substitute((PatternMatcher)new Perl5Matcher(), (Pattern)pattern, (Substitution)new UDFMethodSubstitution((UDFMethod)strOrCallBackFunc), (String)str, (int)subs);
        }
        String strVal = Cast._String(strOrCallBackFunc);
        strVal = Util.substitute((PatternMatcher)new Perl5Matcher(), (Pattern)escPattern, (Substitution)new Perl5Substitution(escSubstitution, 0), (String)strVal, (int)-1);
        strVal = Util.substitute((PatternMatcher)new Perl5Matcher(), (Pattern)backrefPattern, (Substitution)new Perl5Substitution(backrefSubstitution, 0), (String)strVal, (int)-1);
        return Util.substitute((PatternMatcher)new Perl5Matcher(), (Pattern)pattern, (Substitution)new Perl5Substitution(strVal, 0), (String)str, (int)subs);
    }

    private static String _REReplaceJava(String str, String regexpr, Object strOrCallBackFunc, String scope, boolean casesensitive) {
        if (regexpr.length() == 0) {
            throw new InvalidFunctionArgValueEmptyException("2", "REReplace");
        }
        boolean isCallBackFuncDefined = false;
        String replace = null;
        if (strOrCallBackFunc instanceof UDFMethod) {
            isCallBackFuncDefined = true;
        } else {
            replace = Cast._String(strOrCallBackFunc);
        }
        StringBuffer sb = new StringBuffer();
        java.util.regex.Pattern pattern = StringFunc.getPatternJava(regexpr, casesensitive);
        Matcher matcher = pattern.matcher(str);
        int count = 1;
        while (matcher.find()) {
            Struct match;
            if (scope.equalsIgnoreCase("ONE")) {
                if (isCallBackFuncDefined) {
                    match = StringFunc.parseREFindResultJava(matcher, true);
                    match.put("matches", (Object)str.substring(matcher.start(), matcher.end()));
                    replace = StringFunc.invokeCallback_replace((UDFMethod)strOrCallBackFunc, new Object[]{match, matcher.start(), str, count});
                }
                matcher.appendReplacement(sb, replace);
                break;
            }
            if (scope.equalsIgnoreCase("ALL")) {
                if (isCallBackFuncDefined) {
                    match = StringFunc.parseREFindResultJava(matcher, true);
                    match.put("matches", (Object)str.substring(matcher.start(), matcher.end()));
                    replace = StringFunc.invokeCallback_replace((UDFMethod)strOrCallBackFunc, new Object[]{match, matcher.start(), str, count++});
                }
                matcher.appendReplacement(sb, replace);
                continue;
            }
            throw new InvalidFunctionArgValueException("scope", "REReplace", scope, "ONE, ALL");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String Filter(String string, UDFMethod filterFunc) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        StringBuilder result_list = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            Character token = Character.valueOf(string.charAt(i));
            try {
                Object[] args = new Object[]{token, i + 1, string};
                Object retVal = CFPage._invokeUDF((Object)filterFunc, filterFunc.getName(), cfpage, args);
                if (retVal == null) {
                    throw new ListFunc.InvalidReturnTypeForListFilterException();
                }
                if (!Cast._boolean(retVal)) continue;
                result_list.append(token);
                continue;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new ListFunc.InvalidReturnTypeForListFilterException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new ListFunc.InvalidReturnTypeForListFilterException();
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return result_list.toString();
    }

    public static void StringEach(String string, UDFMethod closureFunc) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (int i = 0; i < string.length(); ++i) {
            Character item = Character.valueOf(string.charAt(i));
            try {
                CFPage._invokeUDF((Object)closureFunc, closureFunc.getName(), cfpage, new Object[]{item, i + 1, string});
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
    }

    public static String StringMap(String string, UDFMethod callbackFunc) {
        FusionContext fusionContext = FusionContext.getCurrent();
        StringBuilder result = new StringBuilder();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (int i = 0; i < string.length(); ++i) {
            Character item = Character.valueOf(string.charAt(i));
            try {
                Object[] args = new Object[]{item, i + 1, string};
                Object retVal = CFPage._invokeUDF((Object)callbackFunc, callbackFunc.getName(), cfpage, args);
                result.append(Cast._String(retVal));
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return result.toString();
    }

    public static Object StringReduce(String string, UDFMethod reduceFunc, Object initialValue, boolean reverseOrder) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Object result = initialValue;
        int begin = reverseOrder ? string.length() - 1 : 0;
        int end = reverseOrder ? -1 : string.length();
        int increment = reverseOrder ? -1 : 1;
        for (int i = begin; i != end; i += increment) {
            Character item = Character.valueOf(string.charAt(i));
            try {
                Object[] args = new Object[]{result, item, i + 1, string};
                result = CFPage._invokeUDF((Object)reduceFunc, reduceFunc.getName(), cfpage, args);
                continue;
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return result;
    }

    public static boolean some(String string, UDFMethod someClosure) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (int i = 0; i < string.length(); ++i) {
            Character item = Character.valueOf(string.charAt(i));
            try {
                int arrayIndex = i + 1;
                Object retVal = CFPage._invokeUDF((Object)someClosure, someClosure.getName(), cfpage, new Object[]{item, arrayIndex, string});
                if (!Cast._boolean(retVal)) continue;
                return true;
            }
            catch (Throwable throwable) {
                if (throwable instanceof NeoException) {
                    throw (NeoException)throwable;
                }
                throw new RuntimeWrapper(throwable);
            }
        }
        return false;
    }

    public static boolean every(String string, UDFMethod everyClosure) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (int i = 0; i < string.length(); ++i) {
            Character item = Character.valueOf(string.charAt(i));
            try {
                int arrayIndex = i + 1;
                Object retVal = CFPage._invokeUDF((Object)everyClosure, everyClosure.getName(), cfpage, new Object[]{item, arrayIndex, string});
                if (Cast._boolean(retVal)) continue;
                return false;
            }
            catch (Throwable throwable) {
                if (throwable instanceof NeoException) {
                    throw (NeoException)throwable;
                }
                throw new RuntimeWrapper(throwable);
            }
        }
        return true;
    }

    public static String REReplace(String str, String regexpr, Object strOrCallBackFunc, String scope, boolean casesensitive) {
        boolean useJavaRegexEngine = ServiceFactory.getRuntimeService().isJavaRegexEngineEnabled();
        if (useJavaRegexEngine) {
            return StringFunc._REReplaceJava(str, regexpr, strOrCallBackFunc, scope, casesensitive);
        }
        return StringFunc._REReplace(str, regexpr, strOrCallBackFunc, scope, casesensitive);
    }

    public static String REEscape(String regexpr) {
        return ESCAPE_REGEX_PATTERN.matcher(regexpr).replaceAll("\\\\$1");
    }

    public static boolean isAllASCII(CharSequence dest) {
        int length = dest.length();
        for (int i = 0; i < length; ++i) {
            if (dest.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private static Array _REMatch2(String strinput, String regexpr, boolean casesensitive) {
        Pattern pattern = StringFunc.getPattern(regexpr, casesensitive);
        Perl5Matcher matcher = new Perl5Matcher();
        Array retval = new Array(1);
        PatternMatcherInput input = new PatternMatcherInput(strinput);
        while (matcher.contains(input, pattern)) {
            MatchResult result = matcher.getMatch();
            retval.add(result.toString());
        }
        return retval;
    }

    private static Array _REMatch2Java(String strinput, String regexpr, boolean casesensitive) {
        java.util.regex.Pattern pattern = StringFunc.getPatternJava(regexpr, casesensitive);
        Array retval = new Array(1);
        Matcher matcher = pattern.matcher(strinput);
        while (matcher.find()) {
            retval.add(matcher.group(0));
        }
        return retval;
    }

    public static Array REMatch2(String strinput, String regexpr, boolean casesensitive) {
        boolean useJavaRegexEngine = ServiceFactory.getRuntimeService().isJavaRegexEngineEnabled();
        if (useJavaRegexEngine) {
            return StringFunc._REMatch2Java(strinput, regexpr, casesensitive);
        }
        return StringFunc._REMatch2(strinput, regexpr, casesensitive);
    }

    private static boolean _REMatch(String input, String regexpr) {
        return new Perl5Matcher().matches(input, StringFunc.getPattern(regexpr));
    }

    private static boolean _REMatchJava(String input, String regexpr) {
        java.util.regex.Pattern pattern = StringFunc.getPatternJava(regexpr);
        Matcher matcher = pattern.matcher(input);
        return matcher.find();
    }

    public static boolean REMatch(String input, String regexpr) {
        boolean useJavaRegexEngine = ServiceFactory.getRuntimeService().isJavaRegexEngineEnabled();
        if (useJavaRegexEngine) {
            return StringFunc._REMatchJava(input, regexpr);
        }
        return StringFunc._REMatch(input, regexpr);
    }

    public static Pattern getPattern(String strPattern) {
        Pattern pattern = (Pattern)patterns.get(strPattern);
        if (pattern == null) {
            try {
                pattern = new Perl5Compiler().compile(strPattern);
            }
            catch (MalformedPatternException e) {
                throw new RuntimeWrapper(e);
            }
            patterns.putIfAbsent(strPattern, pattern);
        }
        return pattern;
    }

    public static Pattern getPattern(String strPattern, boolean casesensitive) {
        Pattern pattern = (Pattern)patterns.get(strPattern + (casesensitive ? 16 : 17));
        if (pattern == null) {
            try {
                pattern = new Perl5Compiler().compile(strPattern, casesensitive ? 16 : 17);
            }
            catch (MalformedPatternException e) {
                throw new MalformedRegularExpressionException(e.getMessage(), strPattern);
            }
            patterns.putIfAbsent(strPattern + (casesensitive ? 16 : 17), pattern);
        }
        return pattern;
    }

    public static java.util.regex.Pattern getPatternJava(String strPattern) {
        int caseSensitive = 16;
        java.util.regex.Pattern pattern = (java.util.regex.Pattern)patternsJava.get(strPattern + caseSensitive);
        if (pattern == null) {
            try {
                pattern = java.util.regex.Pattern.compile(strPattern);
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeWrapper(e);
            }
            patternsJava.putIfAbsent(strPattern + caseSensitive, pattern);
        }
        return pattern;
    }

    public static java.util.regex.Pattern getPatternJava(String strPattern, boolean casesensitive) {
        java.util.regex.Pattern pattern = (java.util.regex.Pattern)patternsJava.get(strPattern + (casesensitive ? 16 : 17));
        if (pattern == null) {
            try {
                pattern = !casesensitive ? java.util.regex.Pattern.compile(strPattern, 2) : java.util.regex.Pattern.compile(strPattern);
            }
            catch (PatternSyntaxException e) {
                throw new MalformedRegularExpressionException(e.getMessage(), strPattern);
            }
            patternsJava.putIfAbsent(strPattern + (casesensitive ? 16 : 17), pattern);
        }
        return pattern;
    }

    public static String Left(String str, int count) {
        int len = str.length();
        if (count == 0) {
            throw new InvalidFunctionArgException(RB.getString(CFPage.class, "CFPage.func.Left"), 2, count, RB.getString(CFPage.class, "CFPage.NonZeroInteger"));
        }
        if (count > Integer.MAX_VALUE) {
            throw new IntegerOutOfBoundsException(RB.getString(CFPage.class, "CFPage.func.Left"), 2, count, RB.getString(CFPage.class, "CFPage.op.LT"), Integer.MAX_VALUE);
        }
        if (count <= Integer.MIN_VALUE) {
            throw new IntegerOutOfBoundsException(RB.getString(CFPage.class, "CFPage.func.Left"), 2, count, RB.getString(CFPage.class, "CFPage.op.GT"), Integer.MIN_VALUE);
        }
        if (count < 0) {
            int modCount = Math.abs(count);
            return str.substring(0, len > modCount ? len - modCount : len);
        }
        return str.substring(0, count < len ? count : len);
    }

    public static String Right(String str, int count) {
        int len = str.length();
        if (count == 0) {
            throw new InvalidFunctionArgException("Right", 2, count, RB.getString(CFPage.class, "CFPage.NonZeroInteger"));
        }
        if (count > Integer.MAX_VALUE) {
            throw new IntegerOutOfBoundsException(RB.getString(CFPage.class, "CFPage.func.Right"), 2, count, RB.getString(CFPage.class, "CFPage.op.LT"), Integer.MAX_VALUE);
        }
        if (count <= Integer.MIN_VALUE) {
            throw new IntegerOutOfBoundsException(RB.getString(CFPage.class, "CFPage.func.Right"), 2, count, RB.getString(CFPage.class, "CFPage.op.GT"), Integer.MIN_VALUE);
        }
        if (count < 0) {
            int modCount = Math.abs(count);
            return str.substring(len > modCount ? modCount : 0);
        }
        return str.substring(len > count ? len - count : 0);
    }

    public static String Mid(String str, int s, int c) {
        int len = str.length();
        if (s <= 0) {
            throw new InvalidFunctionArgException("Mid", 2, s, RB.getString(CFPage.class, "CFPage.NonNegInteger"));
        }
        if (c < 0) {
            throw new InvalidFunctionArgException("Mid", 3, c, RB.getString(CFPage.class, "CFPage.NonNegInteger"));
        }
        if (--s >= len || c <= 0) {
            return "";
        }
        if (s + c > len) {
            return str.substring(s);
        }
        return str.substring(s, s + c);
    }

    static {
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            escPattern = compiler.compile("(\\A|.)(?=\\$|\\\\(?!\\\\*[\\dUuLlE]))", 32768);
            backrefPattern = compiler.compile("(\\A|[^\\\\]|(\\A|[^\\\\])\\\\\\\\)\\\\(?=\\d+)", 32768);
            String regExSpecialChars = "<([{\\^-=$!|]})?*+.>";
            String regExSpecialCharsRE = regExSpecialChars.replaceAll(".", "\\\\$0");
            escPatternJava = java.util.regex.Pattern.compile("[" + regExSpecialCharsRE + "]");
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
        }
        catch (PatternSyntaxException ex) {
            ex.printStackTrace();
        }
        ESCAPE_REGEX_PATTERN = java.util.regex.Pattern.compile("([\\|\\$\\^\\+\\?\\{\\}\\*\\.\\[\\]\\(\\)\\\\\\&\\-])");
    }

    public static class InsertParamsNegativeIndexException
    extends ExpressionException {
    }

    public static class InsertParamsException
    extends ExpressionException {
        public String inp_str;
        public int length;
        public int start;

        public InsertParamsException(String str, int i) {
            this.inp_str = str;
            this.start = i;
            this.length = this.inp_str.length();
        }
    }

    public static class RemoveCharsParamsException
    extends ExpressionException {
        public String inp_str;
        public int length;
        public int start;

        public RemoveCharsParamsException(String str, int i) {
            this.inp_str = str;
            this.start = i;
            this.length = this.inp_str.length();
        }
    }

    public static class MalformedRegularExpressionException
    extends ExpressionException {
        public String e_regex;
        public String e_rootcause;

        public MalformedRegularExpressionException(String m, String r) {
            this.e_regex = r;
            this.e_rootcause = m;
        }
    }
}

