/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructOrdered;
import coldfusion.runtime.StructWrapper;
import coldfusion.runtime.UDFMethod;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.Key;
import coldfusion.util.SortedStructMap;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class StructSorted
extends StructOrdered {
    private static final String STRUCT_COMPARATOR = "STRUCT_COMPARATOR";
    private final Comparator comparator;
    private static final String SORTED = "sorted";
    private String sortType = null;
    private String sortOrder = null;
    private Boolean localeSensitive = null;

    public StructSorted() {
        this.map = Collections.synchronizedMap(new SortedStructMap());
        this.comparator = null;
    }

    public StructSorted(UDFMethod method) {
        this.comparator = new ArrayUtil.FunctionBasedComparator(method, STRUCT_COMPARATOR);
        this.map = Collections.synchronizedMap(new SortedStructMap(this.comparator));
    }

    public StructSorted(String sortType, String sortOrder, boolean localeSensitive) {
        boolean isNumericCompare = false;
        boolean isDescendingCompare = false;
        if (sortType == null || sortType.length() == 0) {
            sortType = "text";
        }
        switch (sortType) {
            case "numeric": {
                isNumericCompare = true;
            }
        }
        if (sortOrder == null || sortOrder.length() == 0) {
            sortOrder = "asc";
        }
        switch (sortOrder) {
            case "desc": {
                isDescendingCompare = true;
                break;
            }
            case "asc": {
                isDescendingCompare = false;
            }
        }
        this.sortOrder = sortOrder;
        this.sortType = sortType;
        this.localeSensitive = localeSensitive;
        if (isDescendingCompare) {
            if (isNumericCompare) {
                this.comparator = new ComparatorWrapper(new ArrayUtil.ReverseNumberCompare());
            } else if (localeSensitive) {
                collator = Collator.getInstance();
                collator.setStrength(3);
                collator.setDecomposition(1);
                this.comparator = new ComparatorWrapper(new CollatorComparator(collator, true));
            } else {
                this.comparator = new ComparatorWrapper(new ArrayUtil.MyReverseStringCompare(false));
            }
        } else if (isNumericCompare) {
            this.comparator = new ComparatorWrapper(new ArrayUtil.NumberCompare());
        } else if (localeSensitive) {
            collator = Collator.getInstance();
            collator.setStrength(3);
            collator.setDecomposition(1);
            this.comparator = new ComparatorWrapper(new CollatorComparator(collator, false));
        } else {
            this.comparator = new ComparatorWrapper(new ArrayUtil.MyStringCompare(false));
        }
        this.map = Collections.synchronizedMap(new SortedStructMap(this.comparator));
    }

    private StructSorted(Comparator comparator) {
        this.comparator = comparator;
        this.map = Collections.synchronizedMap(new SortedStructMap(comparator));
    }

    @Override
    public Struct getNewStructObject() {
        if (this.comparator != null) {
            return new StructSorted(this.comparator);
        }
        return new StructSorted();
    }

    @Override
    public Struct getNewStructObject(int capacity) {
        return this.getNewStructObject();
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Boolean getLocaleSensitive() {
        return this.localeSensitive;
    }

    public void setLocaleSensitive(Boolean localeSensitive) {
        this.localeSensitive = localeSensitive;
    }

    @Override
    public Map getAdditionalMetadata() {
        CaseInsensitiveMap metadata = new CaseInsensitiveMap();
        metadata.put("ordered", SORTED);
        metadata.put("casesensistive", false);
        return metadata;
    }

    @Override
    public Map getNewMapObject() {
        if (this.comparator != null) {
            return new SortedStructMap(this.comparator);
        }
        return new SortedStructMap();
    }

    public StructSorted(StructWrapper structWrapper) {
        this(((SortedStructMap)structWrapper.getMap()).getComparator());
        this.initialized = false;
        this.initFromWrapper(structWrapper);
    }

    private class ComparatorWrapper
    implements Comparator<SortedStructMap.Entry<Object, Object>> {
        Comparator c;

        public ComparatorWrapper(Comparator c) {
            this.c = c;
        }

        @Override
        public int compare(SortedStructMap.Entry<Object, Object> o1, SortedStructMap.Entry<Object, Object> o2) {
            return this.c.compare(o1.getKey(), o2.getKey());
        }
    }

    private class CollatorComparator
    implements Comparator {
        private Collator collator;
        private boolean reverse;

        public CollatorComparator(Collator collator, boolean reverse) {
            this.collator = collator;
            this.reverse = reverse;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Key && o2 instanceof Key) {
                if (((Key)o1).equals((Key)o2)) {
                    return 0;
                }
                String o1Str = ((Key)o1).getUCasedString();
                String o2Str = ((Key)o2).getUCasedString();
                if (this.reverse) {
                    return this.collator.compare(o2Str, o1Str);
                }
                return this.collator.compare(o1Str, o2Str);
            }
            return 0;
        }
    }

    public static class InvalidReturnTypeForSortedStructComparatorException
    extends ApplicationException {
    }
}

