/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.compiler.CFMLParserBase;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.CaseSensitiveStruct;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CgiScope;
import coldfusion.runtime.Cloner;
import coldfusion.runtime.IllegalStructAccessException;
import coldfusion.runtime.InvalidOrderTypeException;
import coldfusion.runtime.InvalidSearchScopeException;
import coldfusion.runtime.InvalidStructSortTypeException;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.OrderedCaseSensitiveStruct;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructInsertException;
import coldfusion.runtime.StructOrdered;
import coldfusion.runtime.StructSortValueNotSimpleException;
import coldfusion.runtime.StructSorted;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.UnsupportedStructFunctionException;
import coldfusion.runtime.Variable;
import coldfusion.runtime.async.CallableCompletionService;
import coldfusion.runtime.async.CallableResult;
import coldfusion.runtime.async.ColdfusionFuture;
import coldfusion.runtime.parallel.ParallelCallUtil;
import coldfusion.util.RuntimeWrapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;

public class StructUtils {
    public static boolean IsStruct(Object variable) {
        return variable instanceof Map;
    }

    public static Map StructAppend(Map m, Map n) {
        if (m != null) {
            m.putAll(n);
        }
        return m;
    }

    public static Map StructAppend(Map struct1, Map struct2, boolean overWriteFlag) {
        if (struct1 != null) {
            for (Map.Entry entry : struct2.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if ((overWriteFlag || struct1.containsKey(key)) && !overWriteFlag) continue;
                struct1.put(key, value);
            }
        }
        return struct1;
    }

    public static Map StructClear(Map m) {
        if (m instanceof LocalScope) {
            ((LocalScope)m).clearVariables();
        } else {
            if (m instanceof CgiScope) {
                return m;
            }
            m.clear();
        }
        return m;
    }

    public static Map StructCopy(Map struct) throws Throwable {
        if (struct instanceof Cloneable) {
            try {
                return (Map)Cloner.clone((Cloneable)((Object)struct));
            }
            catch (CloneNotSupportedException e) {
                String className = struct.getClass().getName();
                throw new UnsupportedStructFunctionException("StructCopy", className);
            }
        }
        throw new NoSuchMethodException("clone");
    }

    public static int StructCount(Map m) {
        return m.size();
    }

    public static boolean StructDelete(Map s, String key, boolean indicateNotExisting) {
        return s.remove(key) != null || !indicateNotExisting;
    }

    public static Map StructDelete(Map struct, String key) {
        struct.remove(key);
        return struct;
    }

    public static void StructEach(Map s, UDFMethod closureFunc) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (Map.Entry e : s.entrySet()) {
            String keyname = (String)e.getKey();
            Object value = e.getValue();
            try {
                CFPage._invokeUDF((Object)closureFunc, closureFunc.getName(), cfpage, new Object[]{keyname, value, s});
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
    }

    public static void StructEach(Map s, UDFMethod closureFunc, int maxThreads) {
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            CallableCompletionService completionService = new CallableCompletionService(executor);
            ParallelCallUtil.submitCallablesForStruct(s, closureFunc, completionService);
            for (int index = 0; index < s.size(); ++index) {
                ColdfusionFuture resFut = (ColdfusionFuture)completionService.take();
                Object res = resFut.get();
                CallableResult result = (CallableResult)res;
                ParallelCallUtil.printOutput(result.getOutput());
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof NeoException) {
                throw (NeoException)throwable;
            }
            throw new RuntimeWrapper(throwable);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    public static Map StructMap(Map struct, UDFMethod mapFunc) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Struct result = new Struct();
        if (struct instanceof Struct) {
            result = ((Struct)struct).getNewStructObject();
        }
        for (Map.Entry e : struct.entrySet()) {
            String keyname = (String)e.getKey();
            Object value = e.getValue();
            try {
                Object retVal = CFPage._invokeUDF((Object)mapFunc, mapFunc.getName(), cfpage, new Object[]{keyname, value, struct});
                result.put(keyname, retVal);
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return result;
    }

    public static Map StructMap(Map s, UDFMethod mapFunc, int maxThreads) {
        Struct resMap = new Struct();
        if (s instanceof Struct) {
            resMap = ((Struct)s).getNewStructObject();
        }
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            CallableCompletionService completionService = new CallableCompletionService(executor);
            ParallelCallUtil.submitCallablesForStruct(s, mapFunc, completionService);
            for (int index = 0; index < s.size(); ++index) {
                ColdfusionFuture resFut = (ColdfusionFuture)completionService.take();
                Object res = resFut.get();
                CallableResult result = (CallableResult)res;
                ParallelCallUtil.printOutput(result.getOutput());
                resMap.put(result.getKey(), result.getResult());
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof NeoException) {
                throw (NeoException)throwable;
            }
            throw new RuntimeWrapper(throwable);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
        return resMap;
    }

    public static Object StructReduce(Map struct, UDFMethod reduceFunc, Object initialValue) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        Object result = initialValue;
        for (Map.Entry e : struct.entrySet()) {
            String keyname = (String)e.getKey();
            Object value = e.getValue();
            try {
                result = CFPage._invokeUDF((Object)reduceFunc, reduceFunc.getName(), cfpage, new Object[]{result, keyname, value, struct});
            }
            catch (Throwable throwable) {
                throw new RuntimeWrapper(throwable);
            }
        }
        return result;
    }

    public static Map StructFilter(Map s, UDFMethod closureFunc) {
        FusionContext fusionContext = FusionContext.getCurrent();
        Struct result_Struct = new Struct();
        if (s instanceof Struct) {
            result_Struct = ((Struct)s).getNewStructObject();
        }
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (Map.Entry e : s.entrySet()) {
            String keyname = (String)e.getKey();
            Object value = e.getValue();
            try {
                Object retVal = CFPage._invokeUDF((Object)closureFunc, closureFunc.getName(), cfpage, new Object[]{keyname, value, s});
                if (retVal == null) {
                    throw new Struct.InvalidReturnTypeForStructFilterException();
                }
                if (!Cast._boolean(retVal)) continue;
                result_Struct.put(keyname, value);
            }
            catch (Cast.BooleanConversionException ex) {
                throw new Struct.InvalidReturnTypeForStructFilterException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new Struct.InvalidReturnTypeForStructFilterException();
            }
            catch (Throwable throwable) {
                if (throwable instanceof NeoException) {
                    throw (NeoException)throwable;
                }
                throw new RuntimeWrapper(throwable);
            }
        }
        return result_Struct;
    }

    public static Map StructFilter(Map s, UDFMethod closureFunc, int maxThreads) {
        Struct result_Struct = new Struct();
        if (s instanceof Struct) {
            result_Struct = ((Struct)s).getNewStructObject();
        }
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            CallableCompletionService completionService = new CallableCompletionService(executor);
            ParallelCallUtil.submitCallablesForStruct(s, closureFunc, completionService);
            for (int index = 0; index < s.size(); ++index) {
                ColdfusionFuture resFut = (ColdfusionFuture)completionService.take();
                Object res = resFut.get();
                CallableResult result = (CallableResult)res;
                try {
                    if (result.getResult() == null) {
                        throw new Struct.InvalidReturnTypeForStructFilterException();
                    }
                    ParallelCallUtil.printOutput(result.getOutput());
                    if (!Cast._boolean(result.getResult())) continue;
                    result_Struct.put(result.getKey(), result.getValue());
                    continue;
                }
                catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException ex) {
                    throw new Struct.InvalidReturnTypeForStructFilterException();
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof NeoException) {
                throw (NeoException)throwable;
            }
            throw new RuntimeWrapper(throwable);
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
        return result_Struct;
    }

    public static Object StructFind(Map s, String key) {
        Object val = s.get(key);
        if (val == null) {
            throw new IllegalStructAccessException(key);
        }
        return val;
    }

    public static Object StructFind(Map s, UDFMethod findClosure) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (Map.Entry entry : s.entrySet()) {
            try {
                Object retVal = CFPage._invokeUDF((Object)findClosure, findClosure.getName(), cfpage, new Object[]{(String)entry.getKey(), entry.getValue()});
                if (retVal == null) {
                    throw new Struct.InvalidReturnTypeForStructFilterException();
                }
                if (!Cast._boolean(retVal)) continue;
                return entry.getValue();
            }
            catch (Cast.BooleanConversionException ex) {
                throw new Struct.InvalidReturnTypeForStructFilterException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new Struct.InvalidReturnTypeForStructFilterException();
            }
            catch (Throwable throwable) {
                if (throwable instanceof NeoException) {
                    throw (NeoException)throwable;
                }
                throw new RuntimeWrapper(throwable);
            }
        }
        return null;
    }

    public static Object StructFind(Map s, UDFMethod findClosure, int maxThreads) {
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            CallableCompletionService completionService = new CallableCompletionService(executor);
            ParallelCallUtil.submitCallablesForStruct(s, findClosure, completionService);
            for (int index = 0; index < s.size(); ++index) {
                ColdfusionFuture resFut = (ColdfusionFuture)completionService.take();
                Object res = resFut.get();
                CallableResult result = (CallableResult)res;
                try {
                    if (result.getResult() == null) {
                        throw new InvalidReturnTypeForStructSomeException();
                    }
                    ParallelCallUtil.printOutput(result.getOutput());
                    if (!Cast._boolean(result.getResult())) continue;
                    Object object = result.getValue();
                    return object;
                }
                catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException ex) {
                    throw new InvalidReturnTypeForStructFindException();
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof NeoException) {
                throw (NeoException)throwable;
            }
            throw new RuntimeWrapper(throwable);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
        return null;
    }

    public static boolean StructSome(Map s, UDFMethod someClosure) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (Map.Entry entry : s.entrySet()) {
            try {
                Object retVal = CFPage._invokeUDF((Object)someClosure, someClosure.getName(), cfpage, new Object[]{(String)entry.getKey(), entry.getValue(), s});
                if (retVal == null) {
                    throw new InvalidReturnTypeForStructSomeException();
                }
                if (!Cast._boolean(retVal)) continue;
                return true;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new InvalidReturnTypeForStructSomeException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new InvalidReturnTypeForStructSomeException();
            }
            catch (Throwable throwable) {
                if (throwable instanceof NeoException) {
                    throw (NeoException)throwable;
                }
                throw new RuntimeWrapper(throwable);
            }
        }
        return false;
    }

    public static boolean StructSome(Map s, UDFMethod someClosure, int maxThreads) {
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            CallableCompletionService completionService = new CallableCompletionService(executor);
            ParallelCallUtil.submitCallablesForStruct(s, someClosure, completionService);
            for (int index = 0; index < s.size(); ++index) {
                ColdfusionFuture resFut = (ColdfusionFuture)completionService.take();
                Object res = resFut.get();
                CallableResult result = (CallableResult)res;
                try {
                    if (result.getResult() == null) {
                        throw new InvalidReturnTypeForStructSomeException();
                    }
                    ParallelCallUtil.printOutput(result.getOutput());
                    if (!Cast._boolean(result.getResult())) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException ex) {
                    throw new InvalidReturnTypeForStructSomeException();
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof NeoException) {
                throw (NeoException)throwable;
            }
            throw new RuntimeWrapper(throwable);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
        return false;
    }

    public static boolean StructEvery(Map s, UDFMethod everyClosure) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        for (Map.Entry entry : s.entrySet()) {
            try {
                Object retVal = CFPage._invokeUDF((Object)everyClosure, everyClosure.getName(), cfpage, new Object[]{(String)entry.getKey(), entry.getValue(), s});
                if (retVal == null) {
                    throw new InvalidReturnTypeForStructEveryException();
                }
                if (Cast._boolean(retVal)) continue;
                return false;
            }
            catch (Cast.BooleanConversionException ex) {
                throw new InvalidReturnTypeForStructEveryException();
            }
            catch (Cast.BooleanStringConversionException ex) {
                throw new InvalidReturnTypeForStructEveryException();
            }
            catch (Throwable throwable) {
                if (throwable instanceof NeoException) {
                    throw (NeoException)throwable;
                }
                throw new RuntimeWrapper(throwable);
            }
        }
        return true;
    }

    public static boolean StructEvery(Map s, UDFMethod everyClosure, int maxThreads) {
        ExecutorService executor = null;
        try {
            executor = ParallelCallUtil.createThreadPool(maxThreads);
            CallableCompletionService completionService = new CallableCompletionService(executor);
            ParallelCallUtil.submitCallablesForStruct(s, everyClosure, completionService);
            for (int index = 0; index < s.size(); ++index) {
                ColdfusionFuture resFut = (ColdfusionFuture)completionService.take();
                Object res = resFut.get();
                CallableResult result = (CallableResult)res;
                try {
                    if (result.getResult() == null) {
                        throw new InvalidReturnTypeForStructEveryException();
                    }
                    ParallelCallUtil.printOutput(result.getOutput());
                    if (Cast._boolean(result.getResult())) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (Cast.BooleanConversionException | Cast.BooleanStringConversionException ex) {
                    throw new InvalidReturnTypeForStructEveryException();
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof NeoException) {
                throw (NeoException)throwable;
            }
            throw new RuntimeWrapper(throwable);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
        return true;
    }

    public static Array StructFindKey(Map s, String key, String scope) {
        return StructUtils.StructFindKeyRecursive(s, key, scope, "");
    }

    private static Array StructFindKeyRecursive(Map s, String key, String scope, String path) {
        Array array = new Array();
        boolean stopAtFirstFind = false;
        if (scope.equalsIgnoreCase("ONE")) {
            stopAtFirstFind = true;
        } else if (!scope.equalsIgnoreCase("ALL")) {
            throw new InvalidSearchScopeException(scope);
        }
        Object tvalue = s.get(key);
        if (tvalue != null) {
            Map m = StructUtils.StructNew();
            m.put("value", tvalue);
            if (!CFMLParserBase.isValidSimpleIdentifier(key)) {
                m.put("path", path + "[\"" + key + "\"]");
            } else {
                m.put("path", path + "." + key);
            }
            m.put("owner", s);
            array.addElement(m);
            if (stopAtFirstFind) {
                return array;
            }
        }
        for (Map.Entry e : s.entrySet()) {
            String keyname = (String)e.getKey();
            Object value = e.getValue();
            if (CFPage.IsArray(value)) {
                int aLen = CFPage.ArrayLen(value);
                for (int x = 0; x < aLen; ++x) {
                    Object aVal = value instanceof List ? ((List)value).get(x) : java.lang.reflect.Array.get(value, x);
                    if (!StructUtils.IsStruct(aVal)) continue;
                    String recursePath = !CFMLParserBase.isValidSimpleIdentifier(keyname) ? path + "[\"" + keyname + "\"][" + (x + 1) + "]" : path + "." + keyname + "[" + (x + 1) + "]";
                    Array deeper = StructUtils.StructFindKeyRecursive((Map)aVal, key, scope, recursePath);
                    int size = deeper.size();
                    for (int xx = 0; xx < size; ++xx) {
                        array.addElement(deeper.get(xx));
                        if (!stopAtFirstFind) continue;
                        return array;
                    }
                }
            }
            if (!StructUtils.IsStruct(value)) continue;
            String recursePath = !CFMLParserBase.isValidSimpleIdentifier(keyname) ? path + "[\"" + keyname + "\"]" : path + "." + keyname;
            Array deeper = StructUtils.StructFindKeyRecursive((Map)value, key, scope, recursePath);
            int size = deeper.size();
            for (int x = 0; x < size; ++x) {
                array.addElement(deeper.get(x));
                if (!stopAtFirstFind) continue;
                return array;
            }
        }
        return array;
    }

    public static Array StructFindValue(Map s, String val, String scope) {
        return StructUtils.StructFindValueRecursive(s, val, scope, "");
    }

    private static Array StructFindValueRecursive(Map s, String val, String scope, String path) {
        Array array = new Array();
        boolean stopAtFirstFind = false;
        if (scope.equalsIgnoreCase("ONE")) {
            stopAtFirstFind = true;
        } else if (!scope.equalsIgnoreCase("ALL")) {
            throw new InvalidSearchScopeException(scope);
        }
        for (Map.Entry e : s.entrySet()) {
            String keyname = (String)e.getKey();
            Object value = e.getValue();
            if (CFPage.IsSimpleValue(value) && value.toString().equalsIgnoreCase(val)) {
                Map m = StructUtils.StructNew();
                m.put("key", keyname);
                m.put("path", path + "." + keyname);
                m.put("owner", s);
                array.addElement(m);
                if (stopAtFirstFind) {
                    return array;
                }
            }
            if (CFPage.IsArray(value)) {
                int aLen = 0;
                aLen = value.getClass().isArray() ? ((Object[])value).length : CFPage.ArrayLen(value);
                for (int x = 0; x < aLen; ++x) {
                    Object aVal = null;
                    aVal = value.getClass().isArray() ? ((Object[])value)[x] : ((List)value).get(x);
                    if (!StructUtils.IsStruct(aVal)) continue;
                    Array deeper = StructUtils.StructFindValueRecursive((Map)aVal, val, scope, path + "." + keyname + "[" + (x + 1) + "]");
                    int size = deeper.size();
                    for (int xx = 0; xx < size; ++xx) {
                        array.addElement(deeper.get(xx));
                        if (!stopAtFirstFind) continue;
                        return array;
                    }
                }
            }
            if (!StructUtils.IsStruct(value)) continue;
            Array deeper = StructUtils.StructFindValueRecursive((Map)value, val, scope, path + "." + keyname);
            int size = deeper.size();
            for (int x = 0; x < size; ++x) {
                array.addElement(deeper.get(x));
                if (!stopAtFirstFind) continue;
                return array;
            }
        }
        return array;
    }

    public static Map StructInsert(Map s, String key, Object value, boolean allowOverwrite) {
        if (!allowOverwrite && s.containsKey(key)) {
            throw new StructInsertException(key);
        }
        s.put(key, value);
        return s;
    }

    public static boolean StructIsEmpty(Map s) {
        if (s != null) {
            return s.isEmpty();
        }
        return true;
    }

    public static Array StructKeyArray(Map struct) {
        Iterator i = struct.keySet().iterator();
        Array array = new Array(1, struct.size());
        while (i.hasNext()) {
            array.addElement(i.next());
        }
        return array;
    }

    public static Array StructValueArray(Map struct) {
        Iterator i = struct.values().iterator();
        Array array = new Array(1, struct.size());
        while (i.hasNext()) {
            array.addElement(i.next());
        }
        return array;
    }

    static boolean StructKeyExists(Map struct, String key) {
        if (struct == null) {
            return false;
        }
        Object o = struct.get(key);
        if (o == null) {
            if (FusionContext.isPreserveNullValues()) {
                boolean hasKey = struct.containsKey(key);
                if (hasKey && struct instanceof LocalScope) {
                    Variable v = (Variable)((LocalScope)struct).getVar(key);
                    return v.defined;
                }
                return hasKey;
            }
            return false;
        }
        if ("".equals(o)) {
            return struct.containsKey(key);
        }
        return true;
    }

    public static String StructKeyList(Map struct) {
        return ArrayUtil.ArrayToList(struct.keySet(), ",");
    }

    public static String StructKeyList(Map struct, String delimiter) {
        return ArrayUtil.ArrayToList(struct.keySet(), delimiter);
    }

    public static Map StructNew() {
        return new Struct();
    }

    public static Map OrderedCaseSensitiveStructNew() {
        return new OrderedCaseSensitiveStruct();
    }

    public static Map CaseSensitiveStructNew() {
        return new CaseSensitiveStruct();
    }

    public static Map StructNewOrdered() {
        return new StructOrdered();
    }

    public static Map StructNewSorted() {
        return new StructSorted();
    }

    public static Map StructNewSorted(UDFMethod method) {
        return new StructSorted(method);
    }

    public static Map StructNewSorted(String sortType, String sortOrder, boolean localeSensitive) {
        if (sortType == null || sortType.length() == 0) {
            sortType = "text";
        }
        if ("text".equalsIgnoreCase(sortType) || "numeric".equalsIgnoreCase(sortType)) {
            if (sortOrder == null || sortOrder.length() == 0) {
                sortOrder = "asc";
            }
            if ("asc".equalsIgnoreCase(sortOrder) || "desc".equalsIgnoreCase(sortOrder)) {
                return new StructSorted(sortType, sortOrder, localeSensitive);
            }
            throw new InvalidOrderTypeException(sortOrder);
        }
        throw new InvalidStructSortTypeException(sortType);
    }

    public static Array StructSort(Map struct, String sortType, String sortOrder, String path, boolean localeSensitive) {
        if (struct.isEmpty()) {
            return new Array();
        }
        Array value_arr = new Array();
        HashMap value_map = new HashMap();
        boolean blankPath = path.length() == 0;
        StringTokenizer tPath = null;
        for (Map.Entry e : struct.entrySet()) {
            Array arr;
            String keyname = (String)e.getKey();
            Object value = e.getValue();
            if (blankPath) {
                if (!CFPage.IsSimpleValue(value)) {
                    throw new StructSortValueNotSimpleException(keyname);
                }
            } else {
                Map pointer = (Map)value;
                tPath = new StringTokenizer(path, ".");
                while (tPath.hasMoreTokens()) {
                    String token = tPath.nextToken();
                    Object newValue = pointer.get(token);
                    if (newValue == null) {
                        throw new IllegalStructAccessException(token);
                    }
                    if (tPath.hasMoreTokens()) {
                        pointer = (Map)newValue;
                        continue;
                    }
                    if (!CFPage.IsSimpleValue(newValue)) {
                        throw new StructSortValueNotSimpleException(keyname);
                    }
                    value = newValue.toString();
                }
            }
            if (sortType.equalsIgnoreCase("numeric")) {
                double pointer = Cast._double(value);
            }
            if ((arr = (Array)value_map.get(value)) == null) {
                arr = new Array(1, 1);
                value_arr.addElement(value);
                value_map.put(value, arr);
            }
            arr.addElement(keyname);
        }
        ArrayUtil.ArraySort(value_arr, sortType, sortOrder, localeSensitive);
        Array result_arr = new Array();
        int size = value_arr.size();
        for (int x = 0; x < size; ++x) {
            Array m = (Array)value_map.get(value_arr.get(x));
            int msize = m.size();
            for (int j = 0; j < msize; ++j) {
                result_arr.addElement(m.get(j));
            }
        }
        return result_arr;
    }

    public static Array StructSort(Map struct, UDFMethod sortFunc) {
        Array value_arr = new Array();
        HashMap value_map = new HashMap();
        for (Map.Entry e : struct.entrySet()) {
            String keyname = (String)e.getKey();
            Object value = e.getValue();
            Array arr = (Array)value_map.get(value);
            if (arr == null) {
                arr = new Array(1, 1);
                value_arr.addElement(value);
                value_map.put(value, arr);
            }
            arr.addElement(keyname);
        }
        ArrayUtil.ArraySort(value_arr, sortFunc);
        Array result_arr = new Array();
        int size = value_arr.size();
        for (int x = 0; x < size; ++x) {
            Array m = (Array)value_map.get(value_arr.get(x));
            int msize = m.size();
            for (int j = 0; j < msize; ++j) {
                result_arr.addElement(m.get(j));
            }
        }
        return result_arr;
    }

    static Map StructUpdate(Map struct, String key, Object value) {
        if (!struct.containsKey(key)) {
            throw new IllegalStructAccessException(key);
        }
        struct.put(key, value);
        return struct;
    }

    public static class InvalidReturnTypeForStructSomeException
    extends ApplicationException {
    }

    public static class InvalidReturnTypeForStructFindException
    extends ApplicationException {
    }

    public static class InvalidReturnTypeForStructEveryException
    extends ApplicationException {
    }
}

