/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.runtime.HashMapBasedDependencyCache;
import coldfusion.runtime.SoftCacheBasedDependencyCache;
import coldfusion.runtime.TemplateProxyDependencyType;
import java.util.HashMap;
import java.util.Iterator;

public class TemplateProxyDependencyCache {
    private static TemplateProxyDependencyCache theCache = new TemplateProxyDependencyCache();
    private TemplateProxyDependencyType dependenyCache = null;

    private TemplateProxyDependencyCache() {
        String proxyType = System.getProperty("IProxyCacheType");
        this.dependenyCache = proxyType != null && proxyType.equals("2") ? new HashMapBasedDependencyCache() : new SoftCacheBasedDependencyCache();
    }

    public static TemplateProxyDependencyCache getInstance() {
        return theCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDependencyInfo(String pagePath, String superPath, long superLastVerifiedTime) {
        HashMap<String, Long> depencencyInfo = this.dependenyCache.getDependency(pagePath);
        if (depencencyInfo == null) {
            depencencyInfo = new HashMap<String, Long>();
            this.dependenyCache.putDependency(pagePath, depencencyInfo);
        }
        HashMap<String, Long> hashMap = depencencyInfo;
        synchronized (hashMap) {
            depencencyInfo.put(superPath, superLastVerifiedTime);
        }
    }

    public long getSuperLastVerifiedTime(String pagePath, String superPath) {
        Long lastVerifiedTime;
        HashMap depencencyInfo = this.dependenyCache.getDependency(pagePath);
        if (depencencyInfo != null && (lastVerifiedTime = (Long)depencencyInfo.get(superPath)) != null) {
            return lastVerifiedTime;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDepedencyInfo(String pagePath, String superPath) {
        HashMap depencencyInfo = this.dependenyCache.getDependency(pagePath);
        if (depencencyInfo != null) {
            HashMap hashMap = depencencyInfo;
            synchronized (hashMap) {
                if (depencencyInfo.containsKey(superPath)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void clearCache() {
        this.dependenyCache.clearAllDependencies();
    }

    public void clearCache(String pagePath) {
        if (this.dependenyCache.getDependency(pagePath) != null) {
            this.dependenyCache.removeDependency(pagePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDependencyVerified(String pagePath) {
        long verifiedTime = System.currentTimeMillis();
        HashMap depencencyInfo = this.dependenyCache.getDependency(pagePath);
        if (depencencyInfo != null) {
            HashMap hashMap = depencencyInfo;
            synchronized (hashMap) {
                Iterator it = depencencyInfo.keySet().iterator();
                while (it.hasNext()) {
                    String path = it.next().toString();
                    depencencyInfo.put(path, new Long(verifiedTime));
                }
            }
        }
    }
}

