/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFMethod;
import coldfusion.runtime.CFNumber;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ComponentTemplateProxyCache;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TypedArrayValidationResult;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.util.TemplateProxyUtil;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.validation.CFTypeValidatorFactory;
import coldfusion.util.Key;
import coldfusion.util.RB;
import com.allaire.cfx.Query;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class TypedCollectionUtil {
    private static final String classNameDelimiter = "\\.";
    private static Map<String, String> supportedDataTypes = new HashMap<String, String>();
    private static Map<String, List<String>> dataTypeMapping;

    public static TypedArrayValidationResult isValidDataType(String type) {
        TypedArrayValidationResult res = new TypedArrayValidationResult();
        res.setCFComponent(false);
        res.setTypeName(type);
        res.setValid(false);
        if (type != null) {
            String typeLower = type.toLowerCase();
            if (supportedDataTypes.get(typeLower) != null) {
                res.setValid(true);
            } else {
                TemplateProxy cfcTemplate = null;
                try {
                    cfcTemplate = TypedCollectionUtil.getTemplateProxyFromCache(type, FusionContext.getCurrent().pageContext);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (cfcTemplate != null) {
                    String cfcFullName = cfcTemplate.cfcFullyQualifiedName;
                    res.setCFComponent(true);
                    res.setCfcFullyQualiFiedName(cfcFullName);
                    res.setValid(true);
                    if (cfcFullName != null && (cfcFullName.startsWith("com.adobe") || cfcFullName.startsWith("WEB-INF.cfusion.CustomTags.com.adobe"))) {
                        res.setValid(false);
                    }
                }
            }
        }
        return res;
    }

    private static boolean isDouble(Object o) {
        boolean isDouble = false;
        if (o != null) {
            try {
                if (o instanceof String) {
                    String strVal = (String)o;
                    try {
                        Double.parseDouble(strVal);
                        isDouble = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (o instanceof Double) {
                    isDouble = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isDouble;
    }

    private static boolean isFloat(Object o) {
        boolean isFloat = false;
        if (o != null) {
            try {
                if (o instanceof String) {
                    String strVal = (String)o;
                    try {
                        Float.parseFloat(strVal);
                        isFloat = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (o instanceof Float) {
                    isFloat = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isFloat;
    }

    private static boolean isInteger(Object o) {
        boolean isInteger = false;
        if (o != null) {
            try {
                if (o instanceof String) {
                    String strVal = (String)o;
                    try {
                        Integer.parseInt(strVal);
                        isInteger = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (o instanceof Integer) {
                    isInteger = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isInteger;
    }

    private static boolean isLong(Object o) {
        boolean isLong = false;
        if (o != null) {
            try {
                if (o instanceof String) {
                    String strVal = (String)o;
                    try {
                        Long.parseLong(strVal);
                        isLong = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (o instanceof Long) {
                    isLong = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isLong;
    }

    private static boolean isBoolean(Object o) {
        boolean isBoolean = false;
        if (o != null) {
            if (o instanceof String) {
                String strVal = (String)o;
                if (strVal.equalsIgnoreCase("yes") || strVal.equalsIgnoreCase("no") || strVal.equalsIgnoreCase("true") || strVal.equalsIgnoreCase("false")) {
                    isBoolean = true;
                }
            } else if (o instanceof Boolean) {
                isBoolean = true;
            }
        }
        return isBoolean;
    }

    public static String getObjectDataType(Object o) {
        String dataType = null;
        if (TypedCollectionUtil.isBoolean(o)) {
            dataType = "boolean";
        } else if (TypedCollectionUtil.isDouble(o)) {
            dataType = "double";
        } else if (TypedCollectionUtil.isFloat(o)) {
            dataType = "float";
        } else if (TypedCollectionUtil.isLong(o)) {
            dataType = "long";
        } else if (TypedCollectionUtil.isInteger(o)) {
            dataType = "integer";
        } else if (TypedCollectionUtil.isInteger(o)) {
            dataType = "integer";
        }
        return dataType;
    }

    private static boolean isBaseComponentOrInterface(String comp) {
        boolean isBaseComponentOrInterface = false;
        if (comp != null && !comp.isEmpty() && (comp.equalsIgnoreCase("/WEB-INF/cftags/component.cfc") || comp.equalsIgnoreCase("WEB-INF.cftags.component") || comp.equalsIgnoreCase("WEB-INF.cftags.interface") || comp.equalsIgnoreCase("/WEB-INF/cftags/interface.cfc"))) {
            return true;
        }
        return isBaseComponentOrInterface;
    }

    private static boolean isCovariantTypeRecursive(TemplateProxy templateProxy, String typeName) throws Throwable {
        block22: {
            boolean isCovariant;
            TemplateProxy cfcTemplate;
            String fullName;
            AttributeCollection attrs;
            Map extendsMap;
            String typeNameLower;
            if (templateProxy.cfcFullyQualifiedName.equalsIgnoreCase(typeName)) {
                return true;
            }
            String cfcNameLower = TemplateProxyUtil.getLastWord(templateProxy.cfcFullyQualifiedName).toLowerCase();
            if (cfcNameLower.equals(typeNameLower = TemplateProxyUtil.getLastWord(typeName).toLowerCase())) {
                return true;
            }
            Map metaData = (Map)templateProxy.page.getMetadata();
            if (metaData == null) break block22;
            if (metaData.get(Key.EXTENDS) != null) {
                if (metaData.get(Key.EXTENDS) instanceof Map) {
                    extendsMap = (Map)metaData.get(Key.EXTENDS);
                    for (Map.Entry mapEntry : extendsMap.entrySet()) {
                        String parent = null;
                        if (mapEntry.getValue() instanceof String) {
                            if (mapEntry.getKey() == null || !Key.NAME.getKeyString().equals(mapEntry.getKey())) continue;
                            parent = (String)mapEntry.getValue();
                        } else if (mapEntry.getValue() instanceof AttributeCollection) {
                            attrs = (AttributeCollection)mapEntry.getValue();
                            parent = (String)attrs.get(Key.NAME);
                        }
                        if (parent == null || TypedCollectionUtil.isBaseComponentOrInterface(parent)) continue;
                        fullName = (String)metaData.get(Key.NAME);
                        cfcTemplate = ComponentTemplateProxyCache.getInstance().getTemplateProxyFromChildPath(templateProxy, parent, fullName, FusionContext.getCurrent().pageContext, null);
                        if (cfcTemplate == null || !(isCovariant = TypedCollectionUtil.isCovariantTypeRecursive(cfcTemplate, typeName))) continue;
                        return true;
                    }
                } else if (metaData.get(Key.EXTENDS) instanceof String) {
                    boolean isCovariant2;
                    String parent = (String)metaData.get(Key.EXTENDS);
                    String fullName2 = (String)metaData.get(Key.NAME);
                    TemplateProxy cfcTemplate2 = ComponentTemplateProxyCache.getInstance().getTemplateProxyFromChildPath(templateProxy, parent, fullName2, FusionContext.getCurrent().pageContext, null);
                    if (cfcTemplate2 != null && (isCovariant2 = TypedCollectionUtil.isCovariantTypeRecursive(cfcTemplate2, typeName))) {
                        return true;
                    }
                }
            }
            if (metaData.get(Key.IMPLEMENTS) != null) {
                if (metaData.get(Key.IMPLEMENTS) instanceof Map) {
                    extendsMap = (Map)metaData.get(Key.IMPLEMENTS);
                    for (Map.Entry mapEntry : extendsMap.entrySet()) {
                        String parent = null;
                        if (mapEntry.getValue() instanceof String) {
                            if (mapEntry.getKey() == null || !Key.NAME.getKeyString().equals(mapEntry.getKey())) continue;
                            parent = (String)mapEntry.getValue();
                        } else if (mapEntry.getValue() instanceof AttributeCollection) {
                            attrs = (AttributeCollection)mapEntry.getValue();
                            parent = (String)attrs.get(Key.NAME);
                        }
                        if (parent == null || TypedCollectionUtil.isBaseComponentOrInterface(parent)) continue;
                        fullName = (String)metaData.get(Key.NAME);
                        cfcTemplate = ComponentTemplateProxyCache.getInstance().getTemplateProxyFromChildPath(templateProxy, parent, fullName, FusionContext.getCurrent().pageContext, null);
                        if (cfcTemplate == null || !(isCovariant = TypedCollectionUtil.isCovariantTypeRecursive(cfcTemplate, typeName))) continue;
                        return true;
                    }
                } else if (metaData.get(Key.IMPLEMENTS) instanceof String) {
                    String parentStr = (String)metaData.get(Key.IMPLEMENTS);
                    String[] parents = null;
                    if (parentStr != null) {
                        parents = parentStr.trim().split(",");
                    }
                    for (String parent : parents) {
                        boolean isCovariant3;
                        if (parent == null || parent.isEmpty() || TypedCollectionUtil.isBaseComponentOrInterface(parent)) continue;
                        if (parent.startsWith("\n")) {
                            parent = parent.substring(1);
                        }
                        parent = parent.trim();
                        String fullName3 = (String)metaData.get(Key.NAME);
                        TemplateProxy cfcTemplate3 = ComponentTemplateProxyCache.getInstance().getTemplateProxyFromChildPath(templateProxy, parent, fullName3, FusionContext.getCurrent().pageContext, null);
                        if (cfcTemplate3 == null || !(isCovariant3 = TypedCollectionUtil.isCovariantTypeRecursive(cfcTemplate3, typeName))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static TemplateProxy getTemplateProxyFromCache(String path, NeoPageContext pageContext) throws Throwable {
        TemplateProxy instance = null;
        if (path != null) {
            instance = ComponentTemplateProxyCache.getInstance().getTemplateProxyFromPath(path, pageContext, null);
        }
        return instance;
    }

    private static Object castTemplateProxy(TemplateProxy o, String typeName) throws Throwable {
        TemplateProxy castedObject = null;
        if ("component".equals(typeName)) {
            castedObject = o;
        } else if (TypedCollectionUtil.isCovariantTypeRecursive(o, typeName)) {
            castedObject = o;
        }
        return castedObject;
    }

    public static Object castToDeclaredType(Object o, String typeName) {
        Object castedObject = null;
        if (typeName != null && !typeName.isEmpty()) {
            try {
                if ("any".equalsIgnoreCase(typeName)) {
                    castedObject = o;
                } else if (o instanceof TemplateProxy) {
                    castedObject = TypedCollectionUtil.castTemplateProxy((TemplateProxy)o, typeName);
                } else {
                    switch (typeName = typeName.toLowerCase()) {
                        case "string": {
                            castedObject = Cast._String(o);
                            break;
                        }
                        case "numeric": {
                            if (o instanceof CFNumber) {
                                castedObject = o;
                                break;
                            }
                            castedObject = Cast._BigDecimal(o);
                            break;
                        }
                        case "date": 
                        case "datetime": {
                            castedObject = Cast._Date(o);
                            break;
                        }
                        case "boolean": {
                            castedObject = Cast._boolean(o);
                            break;
                        }
                        case "array": {
                            if (o instanceof FastArray) {
                                castedObject = o;
                                break;
                            }
                            castedObject = null;
                            break;
                        }
                        case "struct": {
                            if (o instanceof Struct || o instanceof Map) {
                                castedObject = o;
                                break;
                            }
                            castedObject = null;
                            break;
                        }
                        case "query": {
                            if (o instanceof Query || o instanceof QueryTable) {
                                castedObject = o;
                                break;
                            }
                            castedObject = null;
                            break;
                        }
                        case "function": 
                        case "cfpagemethod": 
                        case "cfmethod": {
                            if (!(o instanceof UDFMethod) && !(o instanceof CFMethod)) break;
                            castedObject = o;
                            break;
                        }
                        case "binary": {
                            CFTypeValidatorFactory.getValidator("binary").validate(o);
                            castedObject = Cast._Binary(o);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return castedObject;
    }

    public static String getObjectType(Object obj) {
        String type = "";
        if (obj != null) {
            type = obj instanceof TemplateProxy ? RB.getString(TypedCollectionUtil.class, "TypedArray.Component") : TypedCollectionUtil.getUnPrefixedClassName(obj.getClass().getSimpleName());
        }
        return type;
    }

    public static boolean isAllowedType(Object o, String typeName) {
        boolean isAllowed = false;
        if (o == null) {
            return true;
        }
        if (typeName == null || typeName.isEmpty()) {
            return true;
        }
        String objClassName = null;
        typeName = TypedCollectionUtil.getUnPrefixedClassName(typeName);
        typeName = typeName.toLowerCase();
        if (o instanceof TemplateProxy) {
            objClassName = TypedCollectionUtil.getUnPrefixedClassName(((TemplateProxy)o).getCfcFullyQualifiedName());
            if ((objClassName = objClassName.toLowerCase()).equalsIgnoreCase(typeName)) {
                isAllowed = true;
            }
        } else {
            objClassName = TypedCollectionUtil.getObjectDataType(o);
            if (objClassName == null) {
                objClassName = TypedCollectionUtil.getUnPrefixedClassName(o.getClass().getSimpleName());
            }
            if (objClassName != null && !objClassName.isEmpty() && dataTypeMapping.get(objClassName = objClassName.toLowerCase()) != null && dataTypeMapping.get(objClassName).contains(typeName)) {
                isAllowed = true;
            }
        }
        return isAllowed;
    }

    public static boolean checkForQueryColumnType(String colType, String typeName) {
        boolean isAllowed = false;
        if (colType != null && !colType.isEmpty()) {
            if ("object".equalsIgnoreCase(colType)) {
                isAllowed = true;
            } else if ("Integer".equalsIgnoreCase(colType) || "BigInt".equalsIgnoreCase(colType)) {
                if (TypedCollectionUtil.isNumber(typeName)) {
                    isAllowed = true;
                }
            } else if ("decimal".equalsIgnoreCase(colType) || "double".equalsIgnoreCase(colType)) {
                if (TypedCollectionUtil.isNumber(typeName)) {
                    isAllowed = true;
                }
            } else if ("Varchar".equalsIgnoreCase(colType)) {
                if ("string".equalsIgnoreCase(typeName)) {
                    isAllowed = true;
                }
            } else if ("time".equalsIgnoreCase(colType) || "date".equalsIgnoreCase(colType) || "timestamp".equalsIgnoreCase(colType)) {
                if ("date".equalsIgnoreCase(typeName) || "datetime".equalsIgnoreCase(typeName) || "time".equalsIgnoreCase(typeName)) {
                    isAllowed = true;
                }
            } else if ("bit".equalsIgnoreCase(colType)) {
                if ("boolean".equalsIgnoreCase(typeName)) {
                    isAllowed = true;
                }
            } else if ("binary".equalsIgnoreCase(colType)) {
                if ("Binary".equalsIgnoreCase(typeName)) {
                    isAllowed = true;
                }
            } else {
                isAllowed = false;
            }
        }
        return isAllowed;
    }

    private static boolean isNumber(String typeName) {
        return "numeric".equalsIgnoreCase(typeName);
    }

    private static String getUnPrefixedClassName(String longName) {
        String[] parts;
        String unPrefixedName = longName;
        if (longName != null && !longName.isEmpty() && (parts = longName.split(classNameDelimiter)).length - 1 >= 0) {
            unPrefixedName = parts[parts.length - 1];
        }
        return unPrefixedName;
    }

    private static String[] tokenize(String commaSepStr) {
        if (commaSepStr == null || commaSepStr.trim().length() == 0) {
            return null;
        }
        StringTokenizer tk = new StringTokenizer(commaSepStr, ",");
        int numTokens = tk.countTokens();
        String[] stringArray = new String[numTokens];
        int i = 0;
        while (tk.hasMoreTokens()) {
            stringArray[i++] = tk.nextToken().trim();
        }
        return stringArray;
    }

    public static String getDataType(FastArray array) {
        String dataType = null;
        if (array != null) {
            return array.typeName;
        }
        return dataType;
    }

    static {
        supportedDataTypes.put("string", "string");
        supportedDataTypes.put("numeric", "numeric");
        supportedDataTypes.put("date", "date");
        supportedDataTypes.put("boolean", "boolean");
        supportedDataTypes.put("array", "array");
        supportedDataTypes.put("struct", "struct");
        supportedDataTypes.put("query", "query");
        supportedDataTypes.put("function", "function");
        supportedDataTypes.put("cfmethod", "cfmethod");
        supportedDataTypes.put("cfpagemethod", "cfpagemethod");
        supportedDataTypes.put("component", "component");
        supportedDataTypes.put("binary", "binary");
        supportedDataTypes.put("datetime", "datetime");
        supportedDataTypes.put("any", "any");
        dataTypeMapping = new HashMap<String, List<String>>();
        dataTypeMapping.put("numeric", Arrays.asList("integer", "long", "double", "float", "numeric", "number", "int"));
        dataTypeMapping.put("number", Arrays.asList("integer", "long", "double", "float", "numeric", "number", "int"));
        dataTypeMapping.put("integer", Arrays.asList("integer", "long", "double", "float", "numeric", "number", "int"));
        dataTypeMapping.put("long", Arrays.asList("integer", "long", "double", "float", "numeric", "number", "int"));
        dataTypeMapping.put("double", Arrays.asList("integer", "long", "double", "float", "numeric", "number", "int"));
        dataTypeMapping.put("float", Arrays.asList("integer", "long", "double", "float", "numeric", "number", "int"));
        dataTypeMapping.put("string", Arrays.asList("string"));
        dataTypeMapping.put("date", Arrays.asList("date", "oledatetime"));
        dataTypeMapping.put("oledatetime", Arrays.asList("date", "oledatetime"));
        dataTypeMapping.put("object", Arrays.asList("object"));
        dataTypeMapping.put("boolean", Arrays.asList("boolean"));
    }

    public static class TypedArrayInvalidDataTypeException
    extends ExpressionException {
        public String type;

        public TypedArrayInvalidDataTypeException(String type) {
            this.type = type;
        }
    }
}

