/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UDFMethod;
import coldfusion.tagext.io.DirFileUtils;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Date;

public class UDFFileFilter
implements FileFilter {
    private UDFMethod fileFilterMethod = null;

    public UDFFileFilter(UDFMethod fileFilterMethod) {
        if (fileFilterMethod == null) {
            throw new IllegalArgumentException("File Filter method should not be null");
        }
        this.setFileFilterMethod(fileFilterMethod);
    }

    private Object[] getUdFFilterArgs(File file, int paramSize) {
        String fileType;
        String fileExtension = "";
        String canonicalPath = "";
        try {
            canonicalPath = file.getCanonicalPath();
            fileExtension = Utils.getExtension(canonicalPath);
        }
        catch (IOException e) {
            throw new RuntimeWrapper(e);
        }
        String string = fileType = file.isDirectory() ? "dir" : "file";
        if (paramSize == 3) {
            return new Object[]{canonicalPath, fileType, fileExtension};
        }
        Struct struct = new Struct();
        struct.put("path", (Object)canonicalPath);
        struct.put("type", (Object)fileType);
        struct.put("extension", (Object)fileExtension);
        struct.put("attributes", (Object)DirFileUtils.getFileAttribString(file));
        long fileModifiedDate = file.lastModified();
        Object dateVal = fileModifiedDate > 0L ? new Date(fileModifiedDate) : "";
        struct.put("lastmodifieddate", dateVal);
        struct.put("parent", (Object)file.getParent());
        struct.put("link", (Object)Files.isSymbolicLink(file.toPath()));
        struct.put("name", (Object)file.getName());
        struct.put("size", (Object)file.length());
        return new Object[]{struct};
    }

    @Override
    public boolean accept(File file) {
        FusionContext fusionContext = FusionContext.getCurrent();
        CFPage cfpage = (CFPage)fusionContext.pageContext.getPage();
        try {
            Object returnValue = CFPage._invokeUDF((Object)this.fileFilterMethod, this.fileFilterMethod.getName(), cfpage, this.getUdFFilterArgs(file, this.fileFilterMethod.paramNames.length));
            if (returnValue == null) {
                throw new MissingFilterReturnTypeException();
            }
            return Cast._boolean(returnValue);
        }
        catch (Throwable e) {
            throw new RuntimeWrapper(e);
        }
    }

    public UDFMethod getFileFilterMethod() {
        return this.fileFilterMethod;
    }

    public void setFileFilterMethod(UDFMethod fileFilterMethod) {
        if (fileFilterMethod == null) {
            throw new IllegalArgumentException("File Filter method should not be null");
        }
        this.fileFilterMethod = fileFilterMethod;
    }

    public static class MissingFilterReturnTypeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }
}

