/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.cfc.ComponentProxyFactory;
import coldfusion.filter.FunctionAccessFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.filter.SilentFilter;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Array;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFIterable;
import coldfusion.runtime.CFMethod;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.ImplicitUDFMethod;
import coldfusion.runtime.InterfaceRuntimeExceptions;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.Metadata;
import coldfusion.runtime.MetadataUtils;
import coldfusion.runtime.MissingArgumentException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Scope;
import coldfusion.runtime.StaticScope;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.runtime.Variable;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.validation.CFCTypeValidationException;
import coldfusion.tagext.validation.CFCTypeValidator;
import coldfusion.tagext.validation.CFStringValidator;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidator;
import coldfusion.tagext.validation.CFTypeValidatorFactory;
import coldfusion.tagext.validation.CFTypedArrayValidator;
import coldfusion.util.Key;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;

public abstract class UDFMethod
extends FusionFilter
implements Metadata,
CFMethod {
    public static final int PUBLIC = 0;
    public static final int PACKAGE = 1;
    public static final int PRIVATE = 2;
    public static final int REMOTE = 3;
    private static final String INTERFACE = "interface";
    private static final String COMPONENT = "component";
    protected String[] paramNames;
    protected FusionFilter filterChain;
    protected Scope superScope;
    protected StaticScope staticScope;
    boolean iscfthread;
    private Key key;
    private String pagePath;
    private boolean hasRestOp;

    public UDFMethod() {
        super(null);
        this.init();
    }

    public boolean isStatic() {
        return false;
    }

    protected UDFMethod(String dummy) {
        super(null);
    }

    protected void init() {
        Object[] params;
        this.paramNames = this.getParamList();
        AttributeCollection funcMetada = (AttributeCollection)this.getMetadata();
        Object parameterMetadata = funcMetada.get("Parameters");
        if (parameterMetadata instanceof Object[] && (params = (Object[])parameterMetadata).length > 0) {
            String lastParam = (String)((AttributeCollection)params[params.length - 1]).get("type");
            this.hasRestOp = lastParam != null && lastParam.equals("restOp");
        }
        this.filterChain = this;
        this.filterChain = SilentFilter.add(this.filterChain, this.getOutput());
        this.filterChain = ReturnTypeFilter.add(this.filterChain, this.getReturnType(), this.getName(), this.getPagePath(), this);
        this.filterChain = ArgumentCollectionFilter.add(this.filterChain);
        this.filterChain = FunctionAccessFilter.add(this.filterChain, this.getRoles());
    }

    protected abstract Object runFunction(LocalScope var1, Object var2, CFPage var3, ArgumentCollection var4) throws Throwable;

    @Override
    public abstract String getName();

    public Key getFunctionNameKey() {
        if (this.key == null) {
            this.key = Key.getInstance(this.getName());
        }
        return this.key;
    }

    protected abstract String[] getParamList();

    protected String getReturnType() {
        return null;
    }

    protected String getRoles() {
        return "";
    }

    public int getAccess() {
        return 0;
    }

    protected String getOutput() {
        return null;
    }

    public Scope getSuperScope() {
        return this.superScope;
    }

    public void setSuperScope(Scope scope) {
        this.superScope = scope;
    }

    private static void validateValueType(String type, Object value, String refPath, UDFMethod udf) throws CFTypeValidationException, CFCTypeValidationException {
        CFTypeValidator validator;
        if (value == null && "any".equalsIgnoreCase(type) && FusionContext.isPreserveNullValues()) {
            return;
        }
        if (type.startsWith("query[")) {
            type = "query";
        }
        if ((validator = CFTypeValidatorFactory.getValidator(type, value)) != null) {
            if (validator instanceof CFTypedArrayValidator) {
                ((CFTypedArrayValidator)validator).validateWithType(value, type, udf.getName(), null, false);
            } else {
                validator.validate(value);
            }
        } else if (ServiceFactory.getRuntimeService().isCFCTypeCheckEnabled()) {
            CFCTypeValidator.validate(type, value, refPath, udf);
        }
    }

    public void invokeCFThread(String functionName, Object parent, Map args) throws Throwable {
        this.iscfthread = true;
        this.invoke(null, functionName, parent, new Object[]{args});
    }

    public Object invoke(Object instance, String calledName, Object parent, Object[] args, FusionContext fusionContext) throws Throwable {
        Object obj = null;
        if (!this.iscfthread) {
            RequestMonitorEventProcessor.onFunctionStart(calledName, parent, args);
        }
        try {
            obj = this.runFilterChain(instance, parent, new ArgumentCollection((Object[])this.paramNames, args), calledName, fusionContext);
        }
        catch (MissingArgumentException ex) {
            if (ex.internal) {
                throw new MissingArgumentException(ex.paramName, calledName, false);
            }
            throw ex;
        }
        if (!this.iscfthread) {
            RequestMonitorEventProcessor.onFunctionEnd(calledName, parent, args);
        }
        return obj;
    }

    @Override
    public Object invoke(Object instance, String calledName, Object parent, Object[] args) throws Throwable {
        Object obj = null;
        if (!this.iscfthread) {
            RequestMonitorEventProcessor.onFunctionStart(calledName, parent, args);
        }
        try {
            if (this.hasRestOp && this.paramNames.length < args.length) {
                ArrayList<Object> restParam = new ArrayList<Object>();
                for (int i = this.paramNames.length - 1; i < args.length; ++i) {
                    restParam.add(args[i]);
                }
                Object[] finalArgs = new Object[this.paramNames.length];
                for (int i = 0; i < this.paramNames.length; ++i) {
                    finalArgs[i] = args[i];
                }
                finalArgs[this.paramNames.length - 1] = restParam;
                args = finalArgs;
            }
            obj = this.runFilterChain(instance, parent, new ArgumentCollection((Object[])this.paramNames, args), calledName);
        }
        catch (MissingArgumentException ex) {
            if (ex.internal) {
                throw new MissingArgumentException(ex.paramName, calledName, false);
            }
            throw ex;
        }
        if (!this.iscfthread) {
            RequestMonitorEventProcessor.onFunctionEnd(calledName, parent, args);
        }
        return obj;
    }

    public Object invoke(Object instance, String calledName, Object parent, Object[] args, Map argsMap) throws Throwable {
        Object obj = null;
        if (!this.iscfthread) {
            RequestMonitorEventProcessor.onFunctionStart(calledName, parent, args);
        }
        try {
            if (this.hasRestOp && this.paramNames.length < args.length) {
                ArrayList<Object> restParam = new ArrayList<Object>();
                for (int i = this.paramNames.length - 1; i < args.length; ++i) {
                    restParam.add(args[i]);
                }
                Object[] finalArgs = new Object[this.paramNames.length];
                for (int i = 0; i < this.paramNames.length; ++i) {
                    finalArgs[i] = args[i];
                }
                finalArgs[this.paramNames.length - 1] = restParam;
                args = finalArgs;
            }
            ArgumentCollection argumentCollection = new ArgumentCollection((Object[])this.paramNames, args);
            if (argsMap != null) {
                for (int i = 0; i < this.paramNames.length; ++i) {
                    if (!argsMap.containsKey(this.paramNames[i])) continue;
                    argumentCollection.put(this.paramNames[i], argsMap.get(this.paramNames[i]));
                }
            }
            obj = this.runFilterChain(instance, parent, argumentCollection, calledName);
        }
        catch (MissingArgumentException ex) {
            if (ex.internal) {
                throw new MissingArgumentException(ex.paramName, calledName, false);
            }
            throw ex;
        }
        if (!this.iscfthread) {
            RequestMonitorEventProcessor.onFunctionEnd(calledName, parent, args);
        }
        return obj;
    }

    public Object invoke(Object instance, String calledName, Object parent, ArgumentCollection args) throws Throwable {
        return this.invoke(instance, calledName, parent, args, null);
    }

    public Object invoke(Object instance, String calledName, Object parent, ArgumentCollection args, String missingmethodName) throws Throwable {
        Object obj = null;
        RequestMonitorEventProcessor.onFunctionStart(calledName, parent, args);
        missingmethodName = missingmethodName == null ? calledName : missingmethodName;
        try {
            obj = this.runFilterChain(instance, parent, args, missingmethodName);
        }
        catch (MissingArgumentException ex) {
            if (ex.internal) {
                throw new MissingArgumentException(ex.paramName, calledName, false);
            }
            throw ex;
        }
        RequestMonitorEventProcessor.onFunctionEnd(calledName, parent, args);
        return obj;
    }

    private Object runFilterChain(Object instance, Object parent, ArgumentCollection args, String calledName) throws Throwable {
        return this.runFilterChain(instance, parent, args, calledName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object runFilterChain(Object instance, Object parent, ArgumentCollection args, String calledName, FusionContext fusionContext) throws Throwable {
        FusionContext context = FusionContext.getCurrent();
        if (context == null) {
            context = fusionContext;
        }
        Object oldInstance = context.instance;
        CFPage oldParent = context.parent;
        ArgumentCollection oldArgs = context.args;
        Object oldReturnValue = context.returnValue;
        String oldmethodname = context.methodCalledName;
        context.instance = instance;
        context.parent = (CFPage)parent;
        context.args = args;
        context.methodCalledName = calledName;
        String importList = context.parent.importList;
        try {
            this.filterChain.invoke(context);
            Object object = context.returnValue;
            return object;
        }
        finally {
            if (context.parent != null) {
                context.parent.importList = importList;
            }
            context.instance = oldInstance;
            context.parent = oldParent;
            context.args = oldArgs;
            context.returnValue = oldReturnValue;
            context.methodCalledName = oldmethodname;
        }
    }

    public void setStaticScope(StaticScope scope) {
        this.staticScope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(FusionContext context) throws Throwable {
        CFPage createdPage = context.parent;
        NeoPageContext pageContext = createdPage.pageContext;
        if (pageContext != context.pageContext) {
            pageContext.initializeWith(context.pageContext);
        }
        LocalScope localScope = this.iscfthread ? pageContext.setupThreadLocalScope() : pageContext.pushNewFunctionLocalScope();
        if (this.superScope != null) {
            pageContext.pushSuperScope(this.superScope);
        }
        String oldPagePath = context.getPagePath();
        context.setPagePath(this.getPagePath());
        NeoPageContext oldPageContext = context.pageContext;
        context.pageContext = pageContext;
        try {
            context.returnValue = this.runFunction(localScope, context.instance, context.parent, context.args);
        }
        finally {
            RequestMonitorData rmd;
            if (Configuration.INSTANCE.isCodeProfilerOn() && Configuration.INSTANCE.getMonitorSettings().isCfMemoryMonitoringEnabled() && (rmd = RequestMonitorData.getCurrent()) != null) {
                rmd.removeVariableStat("THIS", 0);
                rmd.removeVariableStat("ARGUMENTS", 0);
            }
            if (oldPagePath != null) {
                context.setPagePath(oldPagePath);
            }
            pageContext.popFunctionLocalScope();
            if (this.superScope != null) {
                pageContext.popSuperScope();
            }
            context.pageContext = oldPageContext;
        }
    }

    public Object invoke(Object instance, String calledName, Object parent, Map namedArgs) throws Throwable {
        Object obj = null;
        RequestMonitorEventProcessor.onFunctionStart(calledName, parent, namedArgs);
        try {
            ArgumentCollection args = null;
            for (Map.Entry entry : namedArgs.entrySet()) {
                Object value = entry.getValue();
                Object key = entry.getKey();
                if (key != null && key.toString().equalsIgnoreCase("argumentCollection") && value instanceof Array) {
                    args = new ArgumentCollection((Object[])this.paramNames, ((Array)value).toArray());
                    break;
                }
                if (!(value instanceof CFIterable)) continue;
                namedArgs.put(entry.getKey(), CfJspPage._expandSpreadArgs(new Object[]{entry.getValue()}));
            }
            if (args == null) {
                args = new ArgumentCollection((Object[])this.paramNames, namedArgs);
            }
            obj = this.runFilterChain(instance, parent, args, calledName);
        }
        catch (MissingArgumentException ex) {
            if (ex.internal) {
                throw new MissingArgumentException(ex.paramName, calledName, false);
            }
            throw ex;
        }
        RequestMonitorEventProcessor.onFunctionEnd(calledName, parent, namedArgs);
        return obj;
    }

    public void verifyInterfaceMethodImpl(UDFMethod interfaceMethod, String cfcName, String cfiName) throws Throwable {
        this.verifyMethodImplementation(interfaceMethod, cfcName, cfiName, INTERFACE);
    }

    public void verifyAsbstractMethodImpl(UDFMethod abstractMethod, String implCfcName, String absCompName) throws Throwable {
        this.verifyMethodImplementation(abstractMethod, implCfcName, absCompName, COMPONENT);
    }

    private void verifyMethodImplementation(UDFMethod udfMethod, String implCfcName, String cfiOrAbsCompName, String compType) throws Throwable {
        int access = this.getAccess();
        int compAccess = udfMethod.getAccess();
        if (access != 0 && access != 3) {
            if (compType.equals(COMPONENT)) {
                if (compAccess < access) {
                    InterfaceRuntimeExceptions.throwAccessRightsDoNotMatchComponentException(this.getName(), implCfcName, cfiOrAbsCompName);
                }
            } else {
                InterfaceRuntimeExceptions.throwAccessRightsDoNotMatchInterfaceException(this.getName(), implCfcName, cfiOrAbsCompName);
            }
        }
        String returnType = udfMethod.getReturnType();
        String compReturnType = this.getReturnType();
        boolean returnTypeMismatch = false;
        if (compReturnType == null && "any".equalsIgnoreCase(returnType)) {
            returnTypeMismatch = false;
        } else if (returnType == null && "any".equalsIgnoreCase(compReturnType)) {
            returnTypeMismatch = false;
        } else if (!this.compareUDFAttributes(compReturnType, returnType, false)) {
            returnTypeMismatch = true;
        }
        if (returnTypeMismatch) {
            if (compType.equals(COMPONENT)) {
                InterfaceRuntimeExceptions.throwReturnTypesDoNotMatchComponentException(this.getName(), implCfcName, cfiOrAbsCompName, returnType, compReturnType);
            } else {
                InterfaceRuntimeExceptions.throwReturnTypesDoNotMatchInterfaceException(this.getName(), implCfcName, cfiOrAbsCompName, returnType, compReturnType);
            }
        }
        AttributeCollection[] cfcAttribArray = this.getMethodAttributes();
        AttributeCollection[] cfiAttribArray = udfMethod.getMethodAttributes();
        if (cfcAttribArray == null && cfiAttribArray != null || cfcAttribArray != null && cfiAttribArray == null) {
            if (compType.equals(COMPONENT)) {
                InterfaceRuntimeExceptions.throwArgumentsMistmatchComponentException(this.getName(), implCfcName, cfiOrAbsCompName);
            } else {
                InterfaceRuntimeExceptions.throwArgumentsMistmatchInterfaceException(this.getName(), implCfcName, cfiOrAbsCompName);
            }
        }
        if (cfiAttribArray != null && cfcAttribArray.length != cfiAttribArray.length) {
            if (compType.equals(COMPONENT)) {
                InterfaceRuntimeExceptions.throwArgumentsMistmatchComponentException(this.getName(), implCfcName, cfiOrAbsCompName);
            } else {
                InterfaceRuntimeExceptions.throwArgumentsMistmatchInterfaceException(this.getName(), implCfcName, cfiOrAbsCompName);
            }
        }
        this.compareArguments(cfcAttribArray, cfiAttribArray, implCfcName, cfiOrAbsCompName, compType);
    }

    public AttributeCollection[] getMethodAttributes() throws Throwable {
        AttributeCollection metaData = (AttributeCollection)this.getMetadata();
        Object paramObj = metaData.get(Key.PARAMETERS);
        if (paramObj == null) {
            return null;
        }
        Object[] paramArray = null;
        try {
            paramArray = (Object[])paramObj;
        }
        catch (ClassCastException ce) {
            return null;
        }
        if (paramArray == null) {
            return null;
        }
        AttributeCollection[] attribArray = new AttributeCollection[paramArray.length];
        for (int i = 0; i < paramArray.length; ++i) {
            attribArray[i] = (AttributeCollection)paramArray[i];
        }
        return attribArray;
    }

    public void compareArguments(AttributeCollection[] cfcArguments, AttributeCollection[] cfiArguments, String cfcName, String cfiName, String compType) throws Throwable {
        for (int i = 0; i < cfcArguments.length; ++i) {
            String cfiDefaultValue;
            String name = (String)cfcArguments[i].get(Key.NAME);
            AttributeCollection cfiArg = cfiArguments[i];
            String cfcType = (String)cfcArguments[i].get(Key.TYPE);
            String cfiType = (String)cfiArg.get(Key.TYPE);
            boolean argTypeMismatch = false;
            if (cfcType == null && "any".equalsIgnoreCase(cfiType)) {
                argTypeMismatch = false;
            } else if (cfiType == null && "any".equalsIgnoreCase(cfcType)) {
                argTypeMismatch = false;
            } else if (!this.compareUDFAttributesObj(cfcType, cfiType, null)) {
                argTypeMismatch = true;
            }
            if (argTypeMismatch) {
                if (compType.equals(COMPONENT)) {
                    InterfaceRuntimeExceptions.throwArgumentsDataTypeMistmatchComponentException(name, this.getName(), cfcName, cfiName, cfiType, cfcType);
                } else {
                    InterfaceRuntimeExceptions.throwArgumentsDataTypeMistmatchInterfaceException(name, this.getName(), cfcName, cfiName, cfiType, cfcType);
                }
            }
            if (!(this instanceof ImplicitUDFMethod)) {
                Object cfcRequedObj = cfcArguments[i].get(Key.REQUIRED);
                Object cfiRequedObj = cfiArg.get(Key.REQUIRED);
                boolean cfcRequed = false;
                boolean cfiRequed = false;
                if (cfcRequedObj != null) {
                    cfcRequed = Cast._boolean(cfcRequedObj);
                }
                if (cfiRequedObj != null) {
                    cfiRequed = Cast._boolean(cfiRequedObj);
                }
                if (cfcRequed != cfiRequed) {
                    if (compType.equals(COMPONENT)) {
                        InterfaceRuntimeExceptions.throwRequiredArgumentsMistmatchComponentException(name, this.getName(), cfcName, cfiName);
                    } else {
                        InterfaceRuntimeExceptions.throwRequiredArgumentsMistmatchInterfaceException(name, this.getName(), cfcName, cfiName);
                    }
                }
            }
            Object cfcDefaultValueObj = cfcArguments[i].get(Key.DEFAULT);
            Object cfiDefaultValueObj = cfiArg.get(Key.DEFAULT);
            boolean defaultValueMatch = false;
            if (cfiDefaultValueObj == null || cfcDefaultValueObj == null) continue;
            String cfcDefaultValue = cfcDefaultValueObj.toString();
            if (!cfcDefaultValue.equalsIgnoreCase(cfiDefaultValue = cfiDefaultValueObj.toString())) {
                String dataType;
                String string = dataType = cfcType == null ? "any" : cfcType.toString();
                if (dataType.equalsIgnoreCase("numeric") || dataType.equalsIgnoreCase("boolean") || dataType.equalsIgnoreCase("date") || dataType.equalsIgnoreCase("any")) {
                    try {
                        if (Cast._double(cfcDefaultValue) == Cast._double(cfiDefaultValue)) {
                            defaultValueMatch = true;
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                defaultValueMatch = true;
            }
            if (defaultValueMatch) continue;
            if (compType.equals(COMPONENT)) {
                InterfaceRuntimeExceptions.throwDefaultValuesDoNotMatchComponentException(name, this.getName(), cfcName, cfiName);
                continue;
            }
            InterfaceRuntimeExceptions.throwDefaultValuesDoNotMatchInterfaceException(name, this.getName(), cfcName, cfiName);
        }
    }

    private boolean compareUDFAttributesObj(Object cfcAttrib, Object cfiAttrib, String attribName) {
        if (cfcAttrib != null && cfiAttrib == null) {
            return false;
        }
        if (cfcAttrib == null && cfiAttrib != null) {
            return false;
        }
        return cfcAttrib == null || this.compareUDFAttributes(cfcAttrib.toString(), cfiAttrib.toString(), true);
    }

    private boolean isCovariantReturnType(String cfcUDFAttribute, String interfaceUDFAttribute, boolean isArg) {
        FusionContext fusionContext = FusionContext.getCurrent();
        ComponentProxyFactory.MetaInfo cfcUDFAttrTemplate = null;
        ComponentProxyFactory.MetaInfo interfaceUDFAttrTemplate = null;
        try {
            if (cfcUDFAttribute != null && !cfcUDFAttribute.equalsIgnoreCase("void") && !cfcUDFAttribute.equalsIgnoreCase("any")) {
                cfcUDFAttrTemplate = ComponentProxyFactory.getMetaInfo(cfcUDFAttribute, fusionContext.pageContext, null);
            }
            if (interfaceUDFAttribute != null && !interfaceUDFAttribute.equalsIgnoreCase("void") && !interfaceUDFAttribute.equalsIgnoreCase("any")) {
                interfaceUDFAttrTemplate = ComponentProxyFactory.getMetaInfo(interfaceUDFAttribute, fusionContext.pageContext, null);
            }
            return this.isCovariantReturnTypeRecursive(cfcUDFAttrTemplate, interfaceUDFAttrTemplate.getFullyClassifiedName());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return true;
        }
    }

    private boolean isCovariantReturnTypeRecursive(ComponentProxyFactory.MetaInfo cfcUDFAttrTemplate, String interfaceUDFAttrFullyQualName) throws Throwable {
        if (interfaceUDFAttrFullyQualName != null && cfcUDFAttrTemplate != null) {
            if (interfaceUDFAttrFullyQualName.equalsIgnoreCase(cfcUDFAttrTemplate.getFullyClassifiedName())) {
                return true;
            }
            Map metaData = cfcUDFAttrTemplate.getMetadata();
            Object implementsMap = metaData.get(Key.IMPLEMENTS);
            Object extendsMap = metaData.get(Key.EXTENDS);
            return this.directlyContains(interfaceUDFAttrFullyQualName, implementsMap) || this.directlyContains(interfaceUDFAttrFullyQualName, extendsMap) || this.resolveCovariance(interfaceUDFAttrFullyQualName, implementsMap) || this.resolveCovariance(interfaceUDFAttrFullyQualName, extendsMap);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean directlyContains(String interfaceUDFAttrFullyQualName, Object implementsMap) {
        if (implementsMap == null) return false;
        if (implementsMap instanceof Map) {
            if (((Map)implementsMap).containsValue(interfaceUDFAttrFullyQualName)) return true;
        }
        if (!(implementsMap instanceof String)) return false;
        if (!Stream.of(((String)implementsMap).split(",")).anyMatch(interfaceUDFAttrFullyQualName::equalsIgnoreCase)) return false;
        return true;
    }

    private boolean resolveCovariance(String interfaceUDFAttrFullyQualName, Object implorExtMap) throws Throwable {
        block7: {
            block6: {
                if (!(implorExtMap instanceof Map)) break block6;
                for (Map.Entry mapEntry : ((Map)implorExtMap).entrySet()) {
                    boolean isCovariant;
                    ComponentProxyFactory.MetaInfo cfcTemplate;
                    String cfcName = null;
                    if (mapEntry.getValue() instanceof String) {
                        if (mapEntry.getKey() == null || !Key.NAME.getKeyString().equals(mapEntry.getKey())) continue;
                        cfcName = (String)mapEntry.getValue();
                    } else if (mapEntry.getValue() instanceof AttributeCollection) {
                        AttributeCollection attrs = (AttributeCollection)mapEntry.getValue();
                        cfcName = (String)attrs.get(Key.NAME);
                    }
                    if (cfcName == null || cfcName.isEmpty() || (cfcTemplate = ComponentProxyFactory.getMetaInfo(cfcName, FusionContext.getCurrent().pageContext, null)) == null || !(isCovariant = this.isCovariantReturnTypeRecursive(cfcTemplate, interfaceUDFAttrFullyQualName))) continue;
                    return true;
                }
                break block7;
            }
            if (!(implorExtMap instanceof String)) break block7;
            String parentStr = (String)implorExtMap;
            String[] parents = null;
            if (parentStr != null) {
                parents = parentStr.trim().split(",");
            }
            for (String cfcName : parents) {
                boolean isCovariant;
                ComponentProxyFactory.MetaInfo cfcTemplate;
                if ((cfcName = cfcName.trim()) == null || cfcName.isEmpty() || (cfcTemplate = ComponentProxyFactory.getMetaInfo(cfcName, FusionContext.getCurrent().pageContext, null)) == null || !(isCovariant = this.isCovariantReturnTypeRecursive(cfcTemplate, interfaceUDFAttrFullyQualName))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compareUDFAttributes(String cfcUDFAttribute, String interfaceUDFAttribute, boolean isArg) {
        if (cfcUDFAttribute != null && cfcUDFAttribute.equalsIgnoreCase(interfaceUDFAttribute)) {
            return true;
        }
        if (cfcUDFAttribute == null && interfaceUDFAttribute != null) {
            return false;
        }
        if (cfcUDFAttribute == null && interfaceUDFAttribute == null) {
            return true;
        }
        if (interfaceUDFAttribute != null && "any".equalsIgnoreCase(interfaceUDFAttribute)) {
            return true;
        }
        if (!isArg && CFTypeValidatorFactory.getValidator(cfcUDFAttribute) == null && CFTypeValidatorFactory.getValidator(interfaceUDFAttribute) == null) {
            return this.isCovariantReturnType(cfcUDFAttribute, interfaceUDFAttribute, isArg);
        }
        if (CFTypeValidatorFactory.getValidator(cfcUDFAttribute) == null && CFTypeValidatorFactory.getValidator(interfaceUDFAttribute) != null) {
            return false;
        }
        if (CFTypeValidatorFactory.getValidator(cfcUDFAttribute) != null && CFTypeValidatorFactory.getValidator(interfaceUDFAttribute) == null) {
            return false;
        }
        return !isArg ? this.checkSuperMetadata(null, cfcUDFAttribute, interfaceUDFAttribute) : this.checkSuperMetadata(null, interfaceUDFAttribute, cfcUDFAttribute);
    }

    private boolean checkSuperMetadata(String resolvedToUDFAttribute, String fromUDFAttribute, String toUDFAttribute) {
        Map metadata;
        String toFilePath = resolvedToUDFAttribute;
        try {
            Object[] objects2;
            File cfcFile1;
            FusionContext context = FusionContext.getCurrent();
            String importList = null;
            if (context.parent != null) {
                importList = context.parent.importList;
            }
            Object[] objects1 = TemplateProxyFactory.getTemplateFileHelper(fromUDFAttribute, context.pageContext, importList);
            File cfcFile = (File)objects1[0];
            String fullName = (String)objects1[1];
            metadata = (Map)MetadataUtils.getBasicComponentMetadata(cfcFile, FusionContext.getCurrent().pageContext, fullName);
            if (resolvedToUDFAttribute == null && (cfcFile1 = (File)(objects2 = TemplateProxyFactory.getTemplateFileHelper(toUDFAttribute, context.pageContext, importList))[0]) != null) {
                toFilePath = cfcFile1.getPath();
            }
        }
        catch (Throwable throwable) {
            metadata = null;
        }
        if (metadata != null) {
            Object extendsObj = metadata.get("EXTENDS");
            Object implObj = metadata.get("IMPLEMENTS");
            if (extendsObj instanceof String) {
                return this.checkSuperMetadataString(toFilePath, toUDFAttribute, (String)extendsObj, (String)implObj);
            }
            return this.checkSuperMetadataMap(toFilePath, toUDFAttribute, (Map)extendsObj, (Map)implObj);
        }
        return false;
    }

    private boolean checkSuperMetadataMap(String resolvedToUDFAttribute, String toUDFAttribute, Map extendsComp, Map implComp) {
        String compName;
        Object compName2;
        if (extendsComp != null) {
            String compFullName;
            compName2 = null;
            Object tempExtendObj = extendsComp.get("NAME");
            if (tempExtendObj instanceof String) {
                compName2 = (String)tempExtendObj;
            }
            if (compName2 == null) {
                for (Object o : extendsComp.keySet()) {
                    String compFullName2;
                    Map extCompMap = (Map)extendsComp.get(o);
                    if ("WEB-INF.cftags.interface".equalsIgnoreCase((String)extCompMap.get("NAME")) || !resolvedToUDFAttribute.equalsIgnoreCase(compFullName2 = (String)extCompMap.get("PATH"))) continue;
                    return true;
                }
            } else if (!"WEB-INF.cftags.component".equalsIgnoreCase((String)compName2) && resolvedToUDFAttribute.equalsIgnoreCase(compFullName = (String)extendsComp.get("PATH"))) {
                return true;
            }
        }
        if (implComp != null) {
            for (Object o : implComp.keySet()) {
                compName = (String)o;
                String compFullName = this.getCompFullPath(compName);
                if (!resolvedToUDFAttribute.equalsIgnoreCase(compFullName)) continue;
                return true;
            }
        }
        if (extendsComp == null && implComp == null) {
            return false;
        }
        if (extendsComp != null) {
            compName2 = (String)extendsComp.get("NAME");
            if (compName2 == null) {
                for (Object o : extendsComp.keySet()) {
                    String compName1 = (String)o;
                    if (!this.checkSuperMetadata(resolvedToUDFAttribute, compName1, toUDFAttribute)) continue;
                    return true;
                }
            } else if (this.checkSuperMetadata(resolvedToUDFAttribute, (String)compName2, toUDFAttribute)) {
                return true;
            }
        }
        if (implComp != null) {
            for (Object o : implComp.keySet()) {
                compName = (String)o;
                if ("WEB-INF.cftags.component".equalsIgnoreCase(compName) || !this.checkSuperMetadata(resolvedToUDFAttribute, compName, toUDFAttribute)) continue;
                return true;
            }
        }
        return false;
    }

    private String getCompFullPath(String compName) {
        String toFilePath = compName;
        try {
            FusionContext context = FusionContext.getCurrent();
            String importList = null;
            if (context.parent != null) {
                importList = context.parent.importList;
            }
            Object[] objects = TemplateProxyFactory.getTemplateFileHelper(compName, context.pageContext, importList);
            File cfcFile = (File)objects[0];
            toFilePath = cfcFile.getPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return toFilePath;
    }

    private boolean checkSuperMetadataString(String resolvedToUDFAttribute, String toUDFAttribute, String extendsList, String implList) {
        try {
            String[] implArray;
            String compFullName;
            String[] extendsArray;
            if (extendsList != null) {
                for (String compName : extendsArray = extendsList.split(",")) {
                    if ("WEB-INF.cftags.component".equalsIgnoreCase(compName) || !resolvedToUDFAttribute.equalsIgnoreCase(compFullName = this.getCompFullPath(compName))) continue;
                    return true;
                }
            }
            if (implList != null) {
                for (String compName : implArray = implList.split(",")) {
                    compFullName = this.getCompFullPath(compName);
                    if (!resolvedToUDFAttribute.equalsIgnoreCase(compFullName)) continue;
                    return true;
                }
            }
            if (extendsList == null && implList == null) {
                return false;
            }
            if (extendsList != null) {
                for (String compName : extendsArray = extendsList.split(",")) {
                    if (!this.checkSuperMetadata(resolvedToUDFAttribute, compName, toUDFAttribute)) continue;
                    return true;
                }
            }
            if (implList != null) {
                for (String compName : implArray = implList.split(",")) {
                    if ("WEB-INF.cftags.component".equalsIgnoreCase(compName) || !this.checkSuperMetadata(resolvedToUDFAttribute, compName, toUDFAttribute)) continue;
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public abstract Object getMetadata();

    public static void throwUnSupportedException(String functionName) {
        throw new UnSupportedOperationException(functionName);
    }

    private CFTypeValidator getValidator(String type) {
        if (type == null) {
            return null;
        }
        if (type.endsWith("[]")) {
            return CFTypeValidatorFactory.getValidator("typed_array");
        }
        return CFTypeValidatorFactory.getValidator(type);
    }

    protected Object _validateArg(String paramName, boolean required, String type, Object value) {
        Object val = null;
        if (value instanceof Variable) {
            Object object = val = value == null ? null : ((Variable)value).value;
            if (required && (value == null || !((Variable)value).isDefined() || ((Variable)value).value == null && !FusionContext.isPreserveNullValues())) {
                throw new MissingArgumentException(paramName, this.getName(), true);
            }
        } else {
            if (required && value == null) {
                throw new MissingArgumentException(paramName, this.getName(), true);
            }
            val = value;
        }
        return this._validateArgWithValidator(paramName, type, val, this.getValidator(type), false);
    }

    protected Variable _validateRequiredArg(String paramName, String type, Variable value, CFTypeValidator validator) {
        Object val;
        Object object = val = value == null ? null : value.value;
        if (value == null || !value.isDefined() || value.value == null && !FusionContext.isPreserveNullValues()) {
            throw new MissingArgumentException(paramName, this.getName(), true);
        }
        if (validator != null || type != null && !type.equalsIgnoreCase("any")) {
            this._validateArgWithValidator(paramName, type, val, validator, false);
        }
        return value;
    }

    protected Variable _validateArgWithValidator(String paramName, String type, Variable value, CFTypeValidator validator, boolean isJava) {
        this._validateArgWithValidator(paramName, type, value == null ? null : value.value, validator, isJava);
        return value;
    }

    protected Object _validateArgWithValidator(String paramName, String type, Object value, CFTypeValidator validator, boolean isJava) {
        if (isJava) {
            boolean isValid = true;
            try {
                Class.forName(type);
                if (type.equals("java.lang.Double") && value.getClass().getName().equals("coldfusion.runtime.CFDouble")) {
                    return value;
                }
                if (Class.forName(type).isAssignableFrom(value.getClass())) {
                    return value;
                }
                isValid = false;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!isValid) {
                throw new InvalidJavaArgumentTypeException(type, value.getClass().getName());
            }
        }
        if (type != null && value != null) {
            try {
                if (validator != null) {
                    if (validator instanceof CFTypedArrayValidator) {
                        ((CFTypedArrayValidator)validator).validateWithType(value, type, this.getName(), paramName, true);
                    } else {
                        if (validator instanceof CFStringValidator && value instanceof UDFMethod) {
                            throw new InvalidArgumentTypeException(paramName, this.getName(), type);
                        }
                        validator.validate(value);
                    }
                } else if (ServiceFactory.getRuntimeService().isCFCTypeCheckEnabled() && !type.equals("restOp")) {
                    CFCTypeValidator.validate(type, value, null, this);
                }
            }
            catch (CFTypeValidationException ex) {
                throw new InvalidArgumentTypeException(paramName, this.getName(), type);
            }
            catch (CFCTypeValidationException ex) {
                throw new InvalidArgumentTypeException(paramName, this.getName(), type);
            }
        }
        return value;
    }

    protected Variable _validateArg(String paramName, boolean required, String type, Variable value) {
        this._validateArg(paramName, required, type, (Object)value);
        return value;
    }

    public String getPagePath() {
        if (this.pagePath == null) {
            this.pagePath = ((TemplateClassLoader)this.getClass().getClassLoader()).getPagePath();
        }
        return this.pagePath;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    static class ReturnTypeFilter
    extends FusionFilter {
        String returnType;
        String funcName;
        String pagePath;
        UDFMethod udf;

        static FusionFilter add(FusionFilter next, String returnType, String funcName, String pagePath, UDFMethod udf) {
            if (returnType != null) {
                return new ReturnTypeFilter(next, returnType, funcName, pagePath, udf);
            }
            return next;
        }

        ReturnTypeFilter(FusionFilter next, String returnType, String funcName, String pagePath, UDFMethod udf) {
            super(next);
            this.returnType = returnType;
            this.funcName = funcName;
            this.pagePath = pagePath;
            this.udf = udf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(FusionContext tc) throws Throwable {
            block9: {
                this.next.invoke(tc);
                String oldPagePath = tc.getPagePath();
                try {
                    tc.setPagePath(this.udf.getPagePath());
                    if (this.returnType == null) {
                        break block9;
                    }
                    if (this.returnType.equalsIgnoreCase("VOID")) {
                        if (tc.returnValue != null) {
                            throw new IllegalReturnException(this.funcName);
                        }
                        break block9;
                    }
                    try {
                        UDFMethod.validateValueType(this.returnType, tc.returnValue, this.pagePath, this.udf);
                    }
                    catch (CFTypeValidationException ex) {
                        throw new InvalidReturnTypeException(this.funcName, this.returnType);
                    }
                    catch (CFCTypeValidationException ex) {
                        throw new InvalidReturnTypeException(this.funcName, this.returnType);
                    }
                }
                finally {
                    tc.setPagePath(oldPagePath);
                }
            }
        }
    }

    static class ArgumentCollectionFilter
    extends FusionFilter {
        static FusionFilter add(FusionFilter next) {
            return new ArgumentCollectionFilter(next);
        }

        ArgumentCollectionFilter(FusionFilter next) {
            super(next);
        }

        @Override
        public void invoke(FusionContext tc) throws Throwable {
            Map argumentCollection = (Map)tc.args.get(Key.ARGUMENTCOLLECTION);
            if (argumentCollection != null) {
                tc.args.remove(Key.ARGUMENTCOLLECTION);
                tc.args.putAll(argumentCollection);
            }
            this.next.invoke(tc);
        }
    }

    public static class UnSupportedOperationException
    extends ApplicationException {
        public String arg;
        public String functionName;
        public String type;

        UnSupportedOperationException(String functionName) {
            this.functionName = functionName;
        }
    }

    public static class InvalidJavaArgumentTypeException
    extends ApplicationException {
        public String type;
        public String valueType;

        InvalidJavaArgumentTypeException(String type, String valueType) {
            this.type = type;
            this.valueType = valueType;
        }
    }

    public static class InvalidArgumentTypeException
    extends ApplicationException {
        public String arg;
        public String functionName;
        public String expectedType;

        InvalidArgumentTypeException(String arg, String functionName, String type) {
            this.arg = arg;
            this.functionName = functionName;
            this.expectedType = type;
        }
    }

    public static class IllegalReturnException
    extends ApplicationException {
        public String functionName;

        IllegalReturnException(String functionName) {
            this.functionName = functionName;
        }
    }

    public static class InvalidReturnTypeException
    extends ApplicationException {
        public String functionName;
        public String type;

        InvalidReturnTypeException(String functionName, String type) {
            this.functionName = functionName;
            this.type = type;
        }
    }
}

