/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.compiler.AccessModifier;
import coldfusion.compiler.FinalVariableMutationException;
import coldfusion.filter.FusionContext;
import coldfusion.monitor.memory.MemoryTrackable;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.ObjectDuplicator;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.java.JavaProxy;
import java.util.Map;

public final class Variable
implements Map.Entry {
    Object value;
    String name;
    boolean isFinal = false;
    private boolean isStatic = false;
    boolean isInitialized = false;
    public static final int STATIC_IMPLICIT = 1;
    public static final int STATIC_FINAL = 2;
    private int accessModifier = 16;
    boolean inScope = true;
    boolean defined = false;
    private MemoryTrackable container;

    public void setAccessModifier(int accessModifier) {
        if (!AccessModifier.isValidAccessModifier(accessModifier)) {
            throw new RuntimeException("Invalid Access Modifier");
        }
        this.accessModifier = accessModifier;
    }

    public int getAccessModifier() {
        return this.accessModifier;
    }

    public static boolean isStaticImplicit(int mod) {
        return (mod & 1) != 0;
    }

    public static boolean isStaticFinal(int mod) {
        return (mod & 2) != 0;
    }

    public Variable(String name, Boolean isFinal, boolean isInitialized) {
        this.name = name;
        this.isFinal = isFinal;
        this.isInitialized = isInitialized;
    }

    public Variable(String name, boolean isFinal) {
        this.name = name;
        this.isFinal = isFinal;
        if (this.checkNullKey(name)) {
            this.defined = true;
        }
    }

    public Variable(String name) {
        this.name = name;
        if (this.checkNullKey(name)) {
            this.setValue((Object)null);
        }
    }

    boolean checkNullKey(String key) {
        if (key.length() != 4) {
            return false;
        }
        char first = key.charAt(0);
        char second = key.charAt(1);
        char third = key.charAt(2);
        char fourth = key.charAt(3);
        return !(key.length() != 4 || first != 'N' && first != 'n' || second != 'U' && second != 'u' || third != 'L' && third != 'l' || fourth != 'L' && fourth != 'l');
    }

    public void set(Object v) {
        if (v instanceof FastArray) {
            this.set((FastArray)v);
        } else if (v instanceof OleDateTime) {
            this.setInternal(ObjectDuplicator.duplicateDate(v));
        } else {
            this.setInternal(v);
        }
    }

    public void set(UDFMethod udf) {
        this.setInternal(udf);
    }

    public void set(Map map) {
        this.setInternal(map);
    }

    public void set(String str) {
        this.setInternal(str);
    }

    public void set(Number num) {
        this.setInternal(num);
    }

    public void set(FastArray ar) {
        if (ar == null) {
            this.setInternal(ar);
        } else if (FusionContext.getCurrent().isPassArrayByReference()) {
            this.setInternal(ar);
        } else {
            this.setInternal(ArrayUtil.copy(ar));
        }
    }

    public void setArray(FastArray ar) {
        this.setInternal(ar);
    }

    public void set(double d) {
        this.setInternal(d);
    }

    public void set(int i) {
        this.setInternal(i);
    }

    public void set(long l) {
        this.setInternal(l);
    }

    public void set(boolean b) {
        this.setInternal(b ? Boolean.TRUE : Boolean.FALSE);
    }

    private boolean isPreserveNullValues() {
        try {
            return FusionContext.isPreserveNullValues();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void setInternal(Object o) {
        MemoryTrackerProxy mtp;
        if (this.isStatic && this.value != null && this.value instanceof UDFMethod) {
            throw new CfJspPage.DuplicateVariableNameException(this.name);
        }
        this.defined = o != null ? true : o != null || this.isPreserveNullValues();
        if (this.isFinal) {
            if (this.isInitialized) {
                throw new FinalVariableMutationException(this.name);
            }
            this.isInitialized = true;
        }
        if (o == this.value) {
            return;
        }
        if (this.container != null && MemoryTrackerProxy.checkEnabled(this.container) && (mtp = this.container.getMemoryTrackerProxy()) != null) {
            if (o instanceof JavaProxy) {
                ((JavaProxy)o).setMemoryTrackerProxy(mtp);
                ((JavaProxy)o).setName(this.name);
            } else {
                RequestMonitorData current = RequestMonitorData.getCurrent();
                if (current != null && current.shouldProfile() && current.isProfileMemory() && !current.isTagFunctionLimitExceeded()) {
                    mtp.onReplace(this.name, o, this.value);
                }
            }
        }
        this.value = o;
    }

    public boolean isDefined() {
        if (this.value == null) {
            return (this.defined || this.checkNullKey(this.name)) && this.isPreserveNullValues();
        }
        return true;
    }

    public void reset() {
        MemoryTrackerProxy mtp;
        if (this.container != null && (mtp = this.container.getMemoryTrackerProxy()) != null) {
            mtp.onRemoveObject(this.value);
        }
        this.value = null;
        this.defined = false;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getKey() {
        return this.name;
    }

    public Object setValue(Object newValue) {
        Object oldValue = this.value;
        this.set(newValue);
        return oldValue;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        return this.name.equals(e.getKey()) && (this.value == null ? e.getValue() == null : CfJspPage._compare(this.value, e.getValue()) != 0.0);
    }

    public MemoryTrackable getContainer() {
        return this.container;
    }

    public void setContainer(MemoryTrackable m) {
        this.container = m;
    }

    public String toString() {
        return "{" + this.name + ", " + this.value + "}";
    }

    public boolean getIsFinal() {
        return this.isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void markStatic() {
        this.isStatic = true;
    }

    public void markFinal() {
        this.isFinal = true;
    }

    public boolean getIsInitialized() {
        return this.isInitialized;
    }
}

